/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import java.util.ArrayList;
import java.util.List;
import org.nustaq.serialization.util.FSTUtil;

public class FSTIdentity2IdMap {
    private static final int RESERVE = 4;
    private static final int MAX_DEPTH = 4;
    static int[] prim = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 37, 67, 97, 139, 211, 331, 641, 1097, 1531, 2207, 3121, 5059, 7607, 10891, 15901, 19993, 30223, 50077, 74231, 99991, 150001, 300017, 1000033, 1500041, 200033, 3000077, 5000077, 10000019};
    private static final int GROFAC = 2;
    private int mask;
    public Object[] mKeys;
    private int klen;
    private int[] mValues;
    private int mNumberOfElements;
    private FSTIdentity2IdMap next;
    private List<Object> linearScanList;
    private List<Integer> linearScanVals;

    static int adjustSize(int n) {
        int n2 = 0;
        while (n2 < prim.length - 1) {
            if (n < prim[n2]) {
                return prim[n2] + 4;
            }
            ++n2;
        }
        return n + 4;
    }

    public FSTIdentity2IdMap(int n) {
        if (n < 2) {
            n = 2;
        }
        n = FSTIdentity2IdMap.adjustSize(n * 2);
        this.mKeys = new Object[n];
        this.mValues = new int[n];
        this.mNumberOfElements = 0;
        this.mask = (Integer.highestOneBit(n) << 1) - 1;
        this.klen = n - 4;
    }

    public int size() {
        if (this.linearScanList != null) {
            return this.linearScanList.size();
        }
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final int putOrGet(Object object, int n) {
        int n2 = FSTIdentity2IdMap.calcHash(object);
        return this.putOrGetHash(object, n, n2, this, 0);
    }

    final int putOrGetHash(Object object, int n, int n2, FSTIdentity2IdMap fSTIdentity2IdMap, int n3) {
        int n4;
        Object[] objectArray;
        Object object2;
        if (this.linearScanList != null) {
            int n5 = 0;
            while (n5 < this.linearScanList.size()) {
                Object object3 = this.linearScanList.get(n5);
                if (object3 == object) {
                    return this.linearScanVals.get(n5);
                }
                ++n5;
            }
            this.linearScanList.add(object);
            this.linearScanVals.add(n);
            return Integer.MIN_VALUE;
        }
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (fSTIdentity2IdMap != null && (fSTIdentity2IdMap.mNumberOfElements + this.mNumberOfElements) * 2 > fSTIdentity2IdMap.mKeys.length) {
                fSTIdentity2IdMap.resize(fSTIdentity2IdMap.mKeys.length * 2);
                return fSTIdentity2IdMap.putOrGet(object, n);
            }
            this.resize(this.mKeys.length * 2);
        }
        if ((object2 = (objectArray = this.mKeys)[n4 = this.calcIndexFromHash(n2, objectArray)]) == null) {
            ++this.mNumberOfElements;
            this.mValues[n4] = n;
            objectArray[n4] = object;
            return Integer.MIN_VALUE;
        }
        if (object2 == object) {
            return this.mValues[n4];
        }
        Object object4 = objectArray[n4 + 1];
        if (object4 == null) {
            ++this.mNumberOfElements;
            this.mValues[n4 + 1] = n;
            objectArray[n4 + 1] = object;
            return Integer.MIN_VALUE;
        }
        if (object4 == object) {
            return this.mValues[n4 + 1];
        }
        Object object5 = objectArray[n4 + 2];
        if (object5 == null) {
            ++this.mNumberOfElements;
            this.mValues[n4 + 2] = n;
            objectArray[n4 + 2] = object;
            return Integer.MIN_VALUE;
        }
        if (object5 == object) {
            return this.mValues[n4 + 2];
        }
        return this.putOrGetNext(n2, object, n, n3 + 1);
    }

    final int putOrGetNext(int n, Object object, int n2, int n3) {
        if (this.next == null) {
            int n4 = this.mKeys.length / 10;
            this.next = new FSTIdentity2IdMap(n4);
            if (n3 > 4) {
                this.next.linearScanVals = new ArrayList<Integer>(3);
                this.next.linearScanList = new ArrayList<Object>(3);
            }
            this.next.putHash(object, n2, n, this, n3);
            return Integer.MIN_VALUE;
        }
        return this.next.putOrGetHash(object, n2, n, this, n3 + 1);
    }

    public final void put(Object object, int n) {
        int n2 = FSTIdentity2IdMap.calcHash(object);
        this.putHash(object, n, n2, this, 0);
    }

    final void putHash(Object object, int n, int n2, FSTIdentity2IdMap fSTIdentity2IdMap, int n3) {
        int n4;
        Object[] objectArray;
        if (this.linearScanList != null) {
            int n5 = 0;
            while (n5 < this.linearScanList.size()) {
                Object object2 = this.linearScanList.get(n5);
                if (object2 == object) {
                    this.linearScanVals.set(n5, n);
                    return;
                }
                ++n5;
            }
            this.linearScanList.add(object);
            this.linearScanVals.add(n);
            return;
        }
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (fSTIdentity2IdMap != null && (fSTIdentity2IdMap.mNumberOfElements + this.mNumberOfElements) * 2 > fSTIdentity2IdMap.mKeys.length) {
                fSTIdentity2IdMap.resize(fSTIdentity2IdMap.mKeys.length * 2);
                fSTIdentity2IdMap.put(object, n);
                return;
            }
            this.resize(this.mKeys.length * 2);
        }
        if ((objectArray = this.mKeys)[n4 = this.calcIndexFromHash(n2, objectArray)] == null) {
            ++this.mNumberOfElements;
            this.mValues[n4] = n;
            objectArray[n4] = object;
        } else if (objectArray[n4] == object) {
            this.mValues[n4] = n;
        } else if (objectArray[n4 + 1] == null) {
            ++this.mNumberOfElements;
            this.mValues[n4 + 1] = n;
            objectArray[n4 + 1] = object;
        } else if (objectArray[n4 + 1] == object) {
            this.mValues[n4 + 1] = n;
        } else if (objectArray[n4 + 2] == null) {
            ++this.mNumberOfElements;
            this.mValues[n4 + 2] = n;
            objectArray[n4 + 2] = object;
        } else if (objectArray[n4 + 2] == object) {
            this.mValues[n4 + 2] = n;
        } else {
            this.putNext(n2, object, n, n3 + 1);
        }
    }

    final void putNext(int n, Object object, int n2, int n3) {
        if (this.next == null) {
            int n4 = this.mKeys.length / 10;
            this.next = new FSTIdentity2IdMap(n4);
            if (n3 > 4) {
                this.next.linearScanVals = new ArrayList<Integer>(3);
                this.next.linearScanList = new ArrayList<Object>(3);
            }
        }
        this.next.putHash(object, n2, n, this, n3 + 1);
    }

    public final int get(Object object) {
        int n = FSTIdentity2IdMap.calcHash(object);
        return this.getHash(object, n);
    }

    final int getHash(Object object, int n) {
        if (this.linearScanList != null) {
            int n2 = 0;
            while (n2 < this.linearScanList.size()) {
                Object object2 = this.linearScanList.get(n2);
                if (object2 == object) {
                    return this.linearScanVals.get(n2);
                }
                ++n2;
            }
            return Integer.MIN_VALUE;
        }
        int n3 = this.calcIndexFromHash(n, this.mKeys);
        Object object3 = this.mKeys[n3];
        if (object3 == null) {
            return Integer.MIN_VALUE;
        }
        if (object3 == object) {
            return this.mValues[n3];
        }
        object3 = this.mKeys[n3 + 1];
        if (object3 == null) {
            return Integer.MIN_VALUE;
        }
        if (object3 == object) {
            return this.mValues[n3 + 1];
        }
        object3 = this.mKeys[n3 + 2];
        if (object3 == null) {
            return Integer.MIN_VALUE;
        }
        if (object3 == object) {
            return this.mValues[n3 + 2];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        return this.next.getHash(object, n);
    }

    final void resize(int n) {
        n = FSTIdentity2IdMap.adjustSize(n);
        Object[] objectArray = this.mKeys;
        int[] nArray = this.mValues;
        this.mKeys = new Object[n];
        this.mValues = new int[n];
        this.mNumberOfElements = 0;
        this.mask = (Integer.highestOneBit(n) << 1) - 1;
        this.klen = n - 4;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                this.put(objectArray[n2], nArray[n2]);
            }
            ++n2;
        }
        if (this.next != null) {
            FSTIdentity2IdMap fSTIdentity2IdMap = this.next;
            this.next = null;
            fSTIdentity2IdMap.rePut(this);
        }
    }

    private void rePut(FSTIdentity2IdMap fSTIdentity2IdMap) {
        if (this.linearScanList != null) {
            int n = this.linearScanList.size();
            int n2 = 0;
            while (n2 < n) {
                Object object = this.linearScanList.get(n2);
                int n3 = this.linearScanVals.get(n2);
                fSTIdentity2IdMap.put(object, n3);
                ++n2;
            }
            return;
        }
        int n = 0;
        while (n < this.mKeys.length) {
            Object object = this.mKeys[n];
            if (object != null) {
                fSTIdentity2IdMap.put(object, this.mValues[n]);
            }
            ++n;
        }
        if (this.next != null) {
            this.next.rePut(fSTIdentity2IdMap);
        }
    }

    final int calcIndexFromHash(int n, Object[] objectArray) {
        int n2 = n & this.mask;
        while (n2 >= this.klen) {
            n2 >>>= 1;
        }
        return n2;
    }

    private static int calcHash(Object object) {
        int n = System.identityHashCode(object);
        return (n << 1) - (n << 8) & Integer.MAX_VALUE;
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        if (this.linearScanList != null) {
            this.linearScanList.clear();
            this.linearScanVals.clear();
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }

    public void dump() {
        int n = 0;
        while (n < this.mKeys.length) {
            Object object = this.mKeys[n];
            if (object != null) {
                System.out.println(String.valueOf(object) + " => " + this.mValues[n]);
            }
            ++n;
        }
        if (this.next != null) {
            this.next.dump();
        }
    }

    public int keysLength() {
        return this.mKeys.length;
    }
}

