/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.gaml.types.IType;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectRegistry;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerialisationListener;
import org.nustaq.serialization.util.FSTUtil;

public class FSTObjectOutput
implements ObjectOutput {
    public static Object NULL_PLACEHOLDER = new Object(){

        public String toString() {
            return "NULL_PLACEHOLDER";
        }
    };
    public static final byte SPECIAL_COMPATIBILITY_OBJECT_TAG = -19;
    public static final byte ONE_OF = -18;
    public static final byte BIG_BOOLEAN_FALSE = -17;
    public static final byte BIG_BOOLEAN_TRUE = -16;
    public static final byte BIG_LONG = -10;
    public static final byte BIG_INT = -9;
    public static final byte DIRECT_ARRAY_OBJECT = -8;
    public static final byte HANDLE = -7;
    public static final byte ENUM = -6;
    public static final byte ARRAY = -5;
    public static final byte STRING = -4;
    public static final byte TYPED = -3;
    public static final byte DIRECT_OBJECT = -2;
    public static final byte NULL = -1;
    public static final byte OBJECT = 0;
    protected FSTEncoder codec;
    protected FSTConfiguration conf;
    protected FSTObjectRegistry objects;
    protected int curDepth = 0;
    protected int writeExternalWriteAhead = 8000;
    protected FSTSerialisationListener listener;
    protected boolean dontShare;
    protected final FSTClazzInfo stringInfo;
    protected boolean isCrossPlatform;
    protected ThreadLocal<FSTClazzInfo.FSTFieldInfo[]> refsLocal = new ThreadLocal<FSTClazzInfo.FSTFieldInfo[]>(){

        @Override
        protected FSTClazzInfo.FSTFieldInfo[] initialValue() {
            return new FSTClazzInfo.FSTFieldInfo[20];
        }
    };
    FSTClazzInfo.FSTFieldInfo[] refs;
    protected static ByteArrayOutputStream empty = new ByteArrayOutputStream(0);
    protected boolean closed = false;
    protected int[] tmp = new int[1];

    public FSTObjectOutput(OutputStream outputStream, FSTConfiguration fSTConfiguration) {
        this.conf = fSTConfiguration;
        this.setCodec(fSTConfiguration.createStreamEncoder());
        this.getCodec().setOutstream(outputStream);
        this.isCrossPlatform = fSTConfiguration.isCrossPlatform();
        this.objects = (FSTObjectRegistry)fSTConfiguration.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(fSTConfiguration);
            this.objects.disabled = !fSTConfiguration.isShareReferences();
        } else {
            this.objects.clearForWrite(fSTConfiguration);
        }
        this.dontShare = this.objects.disabled;
        this.stringInfo = this.getClassInfoRegistry().getCLInfo(String.class, fSTConfiguration);
    }

    public FSTObjectOutput(FSTConfiguration fSTConfiguration) {
        this(null, fSTConfiguration);
        this.getCodec().setOutstream(null);
    }

    @Override
    public void flush() throws IOException {
        this.getCodec().flush();
        this.resetAndClearRefs();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed = true;
        this.getCodec().close();
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects);
    }

    public int getWriteExternalWriteAhead() {
        return this.writeExternalWriteAhead;
    }

    public void setWriteExternalWriteAhead(int n) {
        this.writeExternalWriteAhead = n;
    }

    public void ensureFree(int n) throws IOException {
        this.getCodec().ensureFree(n);
    }

    @Override
    public void writeObject(Object object) throws IOException {
        this.writeObject(object, null);
    }

    @Override
    public void write(int n) throws IOException {
        this.getCodec().writeFByte(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.getCodec().writePrimitiveArray(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.getCodec().writePrimitiveArray(byArray, n, n2);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.getCodec().writeFByte(bl ? 1 : 0);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.getCodec().writeFByte(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.getCodec().writeFShort((short)n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.getCodec().writeFChar((char)n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.getCodec().writeFInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.getCodec().writeFLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.getCodec().writeFFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.getCodec().writeFDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.getCodec().writePrimitiveArray(byArray, 0, byArray.length);
    }

    @Override
    public void writeChars(String string) throws IOException {
        char[] cArray = string.toCharArray();
        this.getCodec().writePrimitiveArray(cArray, 0, cArray.length);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.getCodec().writeStringUTF(string);
    }

    public void writeObject(Object object, Class ... classArray) throws IOException {
        if (this.isCrossPlatform) {
            this.writeObjectInternal(object, null, null);
            return;
        }
        if (classArray != null && classArray.length > 1) {
            Class[] classArray2 = classArray;
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray2[n2];
                this.getCodec().registerClass(clazz);
                ++n2;
            }
        }
        this.writeObjectInternal(object, null, classArray);
    }

    protected FSTClazzInfo.FSTFieldInfo getCachedFI(Class ... classArray) {
        if (this.refs == null) {
            this.refs = this.refsLocal.get();
        }
        if (this.curDepth >= this.refs.length) {
            return new FSTClazzInfo.FSTFieldInfo(classArray, null, true);
        }
        FSTClazzInfo.FSTFieldInfo fSTFieldInfo = this.refs[this.curDepth];
        if (fSTFieldInfo == null) {
            this.refs[this.curDepth] = fSTFieldInfo = new FSTClazzInfo.FSTFieldInfo(classArray, null, true);
            return fSTFieldInfo;
        }
        fSTFieldInfo.setPossibleClasses(classArray);
        return fSTFieldInfo;
    }

    public FSTClazzInfo writeObjectInternal(Object object, FSTClazzInfo fSTClazzInfo, Class ... classArray) throws IOException {
        FSTClazzInfo.FSTFieldInfo fSTFieldInfo = this.getCachedFI(classArray);
        ++this.curDepth;
        FSTClazzInfo fSTClazzInfo2 = this.writeObjectWithContext(fSTFieldInfo, object, fSTClazzInfo);
        --this.curDepth;
        if (fSTClazzInfo2 == null) {
            return null;
        }
        return fSTClazzInfo2.useCompatibleMode() ? null : fSTClazzInfo2;
    }

    public FSTSerialisationListener getListener() {
        return this.listener;
    }

    public void setListener(FSTSerialisationListener fSTSerialisationListener) {
        this.listener = fSTSerialisationListener;
    }

    protected void objectWillBeWritten(Object object, int n) {
        if (this.listener != null) {
            this.listener.objectWillBeWritten(object, n);
        }
    }

    protected void objectHasBeenWritten(Object object, int n, int n2) {
        if (this.listener != null) {
            this.listener.objectHasBeenWritten(object, n, n2);
        }
    }

    protected FSTClazzInfo writeObjectWithContext(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object) throws IOException {
        return this.writeObjectWithContext(fSTFieldInfo, object, null);
    }

    protected FSTClazzInfo writeObjectWithContext(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object, FSTClazzInfo fSTClazzInfo) throws IOException {
        int n = 0;
        try {
            if (object == null) {
                this.getCodec().writeTag((byte)-1, null, 0L, object, this);
                return null;
            }
            n = this.getCodec().getWritten();
            this.objectWillBeWritten(object, n);
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                String[] stringArray = fSTFieldInfo.getOneOf();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2];
                        if (string.equals(object)) {
                            this.getCodec().writeTag((byte)-18, stringArray, n2, object, this);
                            this.getCodec().writeFByte(n2);
                            return null;
                        }
                        ++n2;
                    }
                }
                if (!this.dontShare && this.writeHandleIfApplicable(object, this.stringInfo)) {
                    FSTClazzInfo fSTClazzInfo2 = this.stringInfo;
                    return fSTClazzInfo2;
                }
                this.getCodec().writeTag((byte)-4, object, 0L, object, this);
                this.getCodec().writeStringUTF((String)object);
                return null;
            }
            if (clazz == Integer.class) {
                this.getCodec().writeTag((byte)-9, null, 0L, object, this);
                this.getCodec().writeFInt((Integer)object);
                return null;
            }
            if (clazz == Long.class) {
                this.getCodec().writeTag((byte)-10, null, 0L, object, this);
                this.getCodec().writeFLong((Long)object);
                return null;
            }
            if (clazz == Boolean.class) {
                this.getCodec().writeTag((Boolean)object != false ? (byte)-16 : -17, null, 0L, object, this);
                return null;
            }
            if (fSTFieldInfo.getType() != null && fSTFieldInfo.getType().isEnum() || object instanceof Enum) {
                FSTClazzInfo fSTClazzInfo3 = this.writeEnum(fSTFieldInfo, object);
                return fSTClazzInfo3;
            }
            FSTClazzInfo fSTClazzInfo4 = fSTClazzInfo == null ? this.getFstClazzInfo(fSTFieldInfo, clazz) : fSTClazzInfo;
            FSTObjectSerializer fSTObjectSerializer = fSTClazzInfo4.getSer();
            if (!(this.dontShare || fSTFieldInfo.isFlat() || fSTClazzInfo4.isFlat() || fSTObjectSerializer != null && fSTObjectSerializer.alwaysCopy() || !this.writeHandleIfApplicable(object, fSTClazzInfo4))) {
                FSTClazzInfo fSTClazzInfo5 = fSTClazzInfo4;
                return fSTClazzInfo5;
            }
            if (clazz.isArray()) {
                if (this.getCodec().writeTag((byte)-5, object, 0L, object, this)) {
                    FSTClazzInfo fSTClazzInfo6 = fSTClazzInfo4;
                    return fSTClazzInfo6;
                }
                this.writeArray(fSTFieldInfo, object);
                this.getCodec().writeArrayEnd();
            } else {
                if (fSTObjectSerializer == null) {
                    FSTClazzInfo fSTClazzInfo7 = fSTClazzInfo4;
                    if (fSTClazzInfo4.getWriteReplaceMethod() != null) {
                        Object object2 = null;
                        try {
                            object2 = fSTClazzInfo4.getWriteReplaceMethod().invoke(object, new Object[0]);
                        }
                        catch (Exception exception) {
                            FSTUtil.rethrow(exception);
                        }
                        if (object2 != object) {
                            object = object2;
                            fSTClazzInfo4 = this.getClassInfoRegistry().getCLInfo(object.getClass(), this.conf);
                        }
                    }
                    if (fSTClazzInfo4.useCompatibleMode() && !fSTClazzInfo4.isExternalizable()) {
                        this.writeObjectCompatible(fSTFieldInfo, object, fSTClazzInfo4);
                        FSTClazzInfo fSTClazzInfo8 = fSTClazzInfo7;
                        return fSTClazzInfo8;
                    }
                    if (!this.writeObjectHeader(fSTClazzInfo4, fSTFieldInfo, object)) {
                        fSTObjectSerializer = fSTClazzInfo4.getSer();
                        if (fSTObjectSerializer == null) {
                            this.defaultWriteObject(object, fSTClazzInfo4);
                            if (fSTClazzInfo4.isExternalizable()) {
                                this.getCodec().externalEnd(fSTClazzInfo4);
                            }
                        } else {
                            int n3 = this.getCodec().getWritten();
                            fSTObjectSerializer.writeObject(this, object, fSTClazzInfo4, fSTFieldInfo, n3);
                            this.getCodec().externalEnd(fSTClazzInfo4);
                        }
                    }
                    FSTClazzInfo fSTClazzInfo9 = fSTClazzInfo7;
                    return fSTClazzInfo9;
                }
                if (!this.writeObjectHeader(fSTClazzInfo4, fSTFieldInfo, object)) {
                    int n4 = this.getCodec().getWritten();
                    fSTObjectSerializer.writeObject(this, object, fSTClazzInfo4, fSTFieldInfo, n4);
                    this.getCodec().externalEnd(fSTClazzInfo4);
                }
            }
            FSTClazzInfo fSTClazzInfo10 = fSTClazzInfo4;
            return fSTClazzInfo10;
        }
        finally {
            this.objectHasBeenWritten(object, n, this.getCodec().getWritten());
        }
    }

    protected FSTClazzInfo writeEnum(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object) throws IOException {
        if (!this.getCodec().writeTag((byte)-6, object, 0L, object, this)) {
            boolean bl = object.getClass().isEnum();
            if (bl) {
                FSTClazzInfo fSTClazzInfo = this.getFstClazzInfo(fSTFieldInfo, object.getClass());
                this.getCodec().writeClass(fSTClazzInfo);
                this.getCodec().writeFInt(((Enum)object).ordinal());
                return fSTClazzInfo;
            }
            Class<?> clazz = object.getClass();
            clazz = object.getClass().getSuperclass();
            if (clazz == null) {
                throw new RuntimeException("Can't handle this enum: " + String.valueOf(object.getClass()));
            }
            this.getCodec().writeClass(clazz);
            this.getCodec().writeFInt(((Enum)object).ordinal());
        }
        return null;
    }

    protected boolean writeHandleIfApplicable(Object object, FSTClazzInfo fSTClazzInfo) throws IOException {
        if (object instanceof IAgent || object instanceof IShape || object instanceof IList || object instanceof IType || object instanceof GamaGeometryFactory) {
            return false;
        }
        int n = this.getCodec().getWritten();
        int n2 = this.objects.registerObjectForWrite(object, n, fSTClazzInfo, this.tmp);
        if (n2 >= 0) {
            boolean bl;
            boolean bl2 = bl = this.tmp[0] == 0;
            if (bl) {
                if (!this.getCodec().writeTag((byte)-7, null, n2, object, this)) {
                    this.getCodec().writeFInt(n2);
                }
                return true;
            }
        }
        return false;
    }

    protected FSTClazzInfo getFstClazzInfo(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Class clazz) {
        FSTClazzInfo fSTClazzInfo = null;
        FSTClazzInfo fSTClazzInfo2 = fSTFieldInfo.lastInfo;
        if (fSTClazzInfo2 != null && fSTClazzInfo2.getClazz() == clazz && fSTClazzInfo2.conf == this.conf) {
            fSTClazzInfo = fSTClazzInfo2;
        } else {
            fSTFieldInfo.lastInfo = fSTClazzInfo = this.getClassInfoRegistry().getCLInfo(clazz, this.conf);
        }
        return fSTClazzInfo;
    }

    public void defaultWriteObject(Object object, FSTClazzInfo fSTClazzInfo) throws IOException {
        if (fSTClazzInfo.isExternalizable()) {
            this.getCodec().ensureFree(this.writeExternalWriteAhead);
            ((Externalizable)object).writeExternal(this);
        } else {
            FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray = fSTClazzInfo.getFieldInfo();
            this.writeObjectFields(object, fSTClazzInfo, fSTFieldInfoArray, 0, 0);
        }
    }

    protected void writeObjectCompatible(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object, FSTClazzInfo fSTClazzInfo) throws IOException {
        this.writeObjectHeader(fSTClazzInfo, fSTFieldInfo, object);
        Class clazz = fSTClazzInfo.getClazz();
        this.writeObjectCompatibleRecursive(fSTFieldInfo, object, fSTClazzInfo, clazz);
    }

    protected void writeObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object, FSTClazzInfo fSTClazzInfo, Class clazz) throws IOException {
        FSTClazzInfo.FSTCompatibilityInfo fSTCompatibilityInfo = fSTClazzInfo.getCompInfo().get(clazz);
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return;
        }
        this.writeObjectCompatibleRecursive(fSTFieldInfo, object, fSTClazzInfo, clazz.getSuperclass());
        if (fSTCompatibilityInfo != null && fSTCompatibilityInfo.getWriteMethod() != null) {
            try {
                this.writeByte(55);
                fSTCompatibilityInfo.getWriteMethod().invoke(object, this.getObjectOutputStream(clazz, fSTClazzInfo, fSTFieldInfo, object));
            }
            catch (Exception exception) {
                if (exception instanceof InvocationTargetException && ((InvocationTargetException)exception).getTargetException() != null) {
                    FSTUtil.rethrow(((InvocationTargetException)exception).getTargetException());
                }
                FSTUtil.rethrow(exception);
            }
        } else if (fSTCompatibilityInfo != null) {
            this.writeByte(66);
            this.writeObjectFields(object, fSTClazzInfo, fSTCompatibilityInfo.getFieldArray(), 0, 0);
        }
    }

    protected void writeObjectFields(Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray, int n, int n2) throws IOException {
        try {
            int n3 = 0;
            int n4 = 0;
            int n5 = fSTFieldInfoArray.length;
            int n6 = n;
            if (!this.getCodec().isWritingAttributes()) {
                while (true) {
                    if (n6 == n5 || fSTFieldInfoArray[n6].getVersion() != n2) {
                        if (n4 <= 0) break;
                        this.getCodec().writeFByte(n3 << 8 - n4);
                        break;
                    }
                    FSTClazzInfo.FSTFieldInfo fSTFieldInfo = fSTFieldInfoArray[n6];
                    if (fSTFieldInfo.getIntegralType() != 1) {
                        if (n4 <= 0) break;
                        this.getCodec().writeFByte(n3 << 8 - n4);
                        break;
                    }
                    if (n4 == 8) {
                        this.getCodec().writeFByte(n3 << 8 - n4);
                        n4 = 0;
                        n3 = 0;
                    }
                    boolean bl = fSTFieldInfo.getBooleanValue(object);
                    n3 <<= 1;
                    n3 |= bl ? 1 : 0;
                    ++n4;
                    ++n6;
                }
            }
            int n7 = n6;
            while (n7 < n5) {
                FSTClazzInfo.FSTFieldInfo fSTFieldInfo = fSTFieldInfoArray[n7];
                if (fSTFieldInfo.getVersion() != n2) {
                    this.getCodec().writeVersionTag(fSTFieldInfo.getVersion());
                    this.writeObjectFields(object, fSTClazzInfo, fSTFieldInfoArray, n7, fSTFieldInfo.getVersion());
                    return;
                }
                if (!this.getCodec().writeAttributeName(fSTFieldInfo, object)) {
                    if (fSTFieldInfo.isPrimitive()) {
                        int n8 = fSTFieldInfo.getIntegralType();
                        switch (n8) {
                            case 1: {
                                this.getCodec().writeFByte(fSTFieldInfo.getBooleanValue(object) ? 1 : 0);
                                break;
                            }
                            case 2: {
                                this.getCodec().writeFByte(fSTFieldInfo.getByteValue(object));
                                break;
                            }
                            case 3: {
                                this.getCodec().writeFChar((char)fSTFieldInfo.getCharValue(object));
                                break;
                            }
                            case 4: {
                                this.getCodec().writeFShort((short)fSTFieldInfo.getShortValue(object));
                                break;
                            }
                            case 5: {
                                this.getCodec().writeFInt(fSTFieldInfo.getIntValue(object));
                                break;
                            }
                            case 6: {
                                this.getCodec().writeFLong(fSTFieldInfo.getLongValue(object));
                                break;
                            }
                            case 7: {
                                this.getCodec().writeFFloat(fSTFieldInfo.getFloatValue(object));
                                break;
                            }
                            case 8: {
                                this.getCodec().writeFDouble(fSTFieldInfo.getDoubleValue(object));
                            }
                        }
                    } else if (fSTFieldInfo.isConditional()) {
                        int n9 = this.getCodec().getWritten();
                        this.getCodec().skip(4);
                        Object object2 = fSTFieldInfo.getObjectValue(object);
                        if (object2 == null) {
                            this.getCodec().writeTag((byte)-1, null, 0L, object, this);
                        } else {
                            this.writeObjectWithContext(fSTFieldInfo, object2);
                        }
                        int n10 = this.getCodec().getWritten();
                        this.getCodec().writeInt32At(n9, n10);
                    } else {
                        Object object3 = fSTFieldInfo.getObjectValue(object);
                        if (object3 == null) {
                            this.getCodec().writeTag((byte)-1, null, 0L, object, this);
                        } else {
                            this.writeObjectWithContext(fSTFieldInfo, object3);
                        }
                    }
                }
                ++n7;
            }
            this.getCodec().writeVersionTag(0);
            this.getCodec().writeFieldsEnd(fSTClazzInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            FSTUtil.rethrow(illegalAccessException);
        }
    }

    protected void writeCompatibleObjectFields(Object object, Map map, FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray) throws IOException {
        int n = 0;
        int n2 = 0;
        FSTClazzInfo.FSTFieldInfo[] fSTFieldInfoArray2 = fSTFieldInfoArray;
        int n3 = fSTFieldInfoArray.length;
        int n4 = 0;
        while (n4 < n3) {
            FSTClazzInfo.FSTFieldInfo fSTFieldInfo = fSTFieldInfoArray2[n4];
            try {
                boolean bl = fSTFieldInfo.isArray();
                Class clazz = fSTFieldInfo.getType();
                if ((clazz != Boolean.TYPE || bl) && n2 > 0) {
                    this.getCodec().writeFByte(n << 8 - n2);
                    n2 = 0;
                    n = 0;
                }
                if (fSTFieldInfo.isIntegral() && !bl) {
                    if (clazz == Boolean.TYPE) {
                        if (n2 == 8) {
                            this.getCodec().writeFByte(n << 8 - n2);
                            n2 = 0;
                            n = 0;
                        }
                        boolean bl2 = (Boolean)map.get(fSTFieldInfo.getName());
                        n <<= 1;
                        n |= bl2 ? 1 : 0;
                        ++n2;
                    } else if (clazz == Integer.TYPE) {
                        this.getCodec().writeFInt(((Number)map.get(fSTFieldInfo.getName())).intValue());
                    } else if (clazz == Long.TYPE) {
                        this.getCodec().writeFLong(((Number)map.get(fSTFieldInfo.getName())).longValue());
                    } else if (clazz == Byte.TYPE) {
                        this.getCodec().writeFByte(((Number)map.get(fSTFieldInfo.getName())).byteValue());
                    } else if (clazz == Character.TYPE) {
                        this.getCodec().writeFChar((char)((Number)map.get(fSTFieldInfo.getName())).intValue());
                    } else if (clazz == Short.TYPE) {
                        this.getCodec().writeFShort(((Number)map.get(fSTFieldInfo.getName())).shortValue());
                    } else if (clazz == Float.TYPE) {
                        this.getCodec().writeFFloat(((Number)map.get(fSTFieldInfo.getName())).floatValue());
                    } else if (clazz == Double.TYPE) {
                        this.getCodec().writeFDouble(((Number)map.get(fSTFieldInfo.getName())).doubleValue());
                    }
                } else {
                    Object v = map.get(fSTFieldInfo.getName());
                    this.writeObjectWithContext(fSTFieldInfo, v);
                }
            }
            catch (Exception exception) {
                FSTUtil.rethrow(exception);
            }
            ++n4;
        }
        if (n2 > 0) {
            this.getCodec().writeFByte(n << 8 - n2);
        }
    }

    protected boolean writeObjectHeader(FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object) throws IOException {
        if (object.getClass() == fSTFieldInfo.getType() && !fSTClazzInfo.useCompatibleMode()) {
            return this.getCodec().writeTag((byte)-3, fSTClazzInfo, 0L, object, this);
        }
        Class[] classArray = fSTFieldInfo.getPossibleClasses();
        if (classArray != null) {
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                if (clazz == object.getClass()) {
                    this.getCodec().writeFByte(n2 + 1);
                    return false;
                }
                ++n2;
            }
        }
        if (!this.getCodec().writeTag((byte)0, fSTClazzInfo, 0L, object, this)) {
            this.getCodec().writeClass(fSTClazzInfo);
            return false;
        }
        return true;
    }

    protected void writeArray(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object) throws IOException {
        if (object == null) {
            this.getCodec().writeClass(Object.class);
            this.getCodec().writeFInt(-1);
            return;
        }
        int n = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        this.getCodec().writeClass(object.getClass());
        this.getCodec().writeFInt(n);
        if (!clazz.isArray()) {
            if (this.getCodec().isPrimitiveArray(object, clazz)) {
                this.getCodec().writePrimitiveArray(object, 0, n);
            } else {
                Object[] objectArray = (Object[])object;
                Class<?> clazz2 = null;
                FSTClazzInfo fSTClazzInfo = null;
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = objectArray[n2];
                    if (object2 != null) {
                        fSTClazzInfo = this.writeObjectWithContext(fSTFieldInfo, object2, clazz2 == object2.getClass() ? fSTClazzInfo : null);
                        clazz2 = object2.getClass();
                    } else {
                        this.writeObjectWithContext(fSTFieldInfo, object2, null);
                    }
                    ++n2;
                }
            }
        } else {
            Object[] objectArray = (Object[])object;
            FSTClazzInfo.FSTFieldInfo fSTFieldInfo2 = new FSTClazzInfo.FSTFieldInfo(fSTFieldInfo.getPossibleClasses(), null, this.conf.getCLInfoRegistry().isIgnoreAnnotations());
            int n3 = 0;
            while (n3 < n) {
                Object object3 = objectArray[n3];
                boolean bl = true;
                if (this.getCodec().isTagMultiDimSubArrays()) {
                    if (object3 == null) {
                        bl = !this.getCodec().writeTag((byte)-1, null, 0L, null, this);
                    } else {
                        boolean bl2 = bl = !this.getCodec().writeTag((byte)-5, object3, 0L, object3, this);
                    }
                }
                if (bl) {
                    this.writeArray(fSTFieldInfo2, object3);
                    this.getCodec().writeArrayEnd();
                }
                ++n3;
            }
        }
    }

    public void writeStringUTF(String string) throws IOException {
        this.getCodec().writeStringUTF(string);
    }

    protected void resetAndClearRefs() {
        this.getCodec().reset(null);
        this.objects.clearForWrite(this.conf);
    }

    public void resetForReUse(OutputStream outputStream) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.getCodec().reset(null);
        if (outputStream != null) {
            this.getCodec().setOutstream(outputStream);
        }
        this.objects.clearForWrite(this.conf);
    }

    public void resetForReUse() {
        this.resetForReUse((byte[])null);
    }

    public void resetForReUse(byte[] byArray) {
        if (this.closed) {
            throw new RuntimeException("Can't reuse closed stream");
        }
        this.getCodec().reset(byArray);
        this.objects.clearForWrite(this.conf);
    }

    public FSTClazzInfoRegistry getClassInfoRegistry() {
        return this.conf.getCLInfoRegistry();
    }

    public ObjectOutputStream getObjectOutputStream(final Class clazz, final FSTClazzInfo fSTClazzInfo, final FSTClazzInfo.FSTFieldInfo fSTFieldInfo, final Object object) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(){
            ObjectOutputStream.PutField pf;
            HashMap<String, Object> fields = new HashMap();

            @Override
            public void useProtocolVersion(int n) throws IOException {
            }

            @Override
            protected void writeObjectOverride(Object object2) throws IOException {
                FSTObjectOutput.this.getCodec().writeFByte(-19);
                FSTObjectOutput.this.writeObjectInternal(object2, null, fSTFieldInfo.getPossibleClasses());
            }

            @Override
            public void writeUnshared(Object object2) throws IOException {
                this.writeObjectOverride(object2);
            }

            @Override
            public void defaultWriteObject() throws IOException {
                this.writeByte(99);
                FSTClazzInfo fSTClazzInfo2 = fSTClazzInfo;
                Object object3 = object;
                if (fSTClazzInfo2.getWriteReplaceMethod() != null) {
                    DEBUG.OUT((Object)"WRITE REPLACE NOT FULLY SUPPORTED");
                    try {
                        Object object2 = fSTClazzInfo2.getWriteReplaceMethod().invoke(object3, new Object[0]);
                        if (object2 != null && object2 != object) {
                            object3 = object2;
                            fSTClazzInfo2 = FSTObjectOutput.this.getClassInfoRegistry().getCLInfo(object3.getClass(), FSTObjectOutput.this.conf);
                        }
                    }
                    catch (Exception exception) {
                        FSTUtil.rethrow(exception);
                    }
                }
                FSTObjectOutput.this.writeObjectFields(object3, fSTClazzInfo2, fSTClazzInfo2.getCompInfo().get(clazz).getFieldArray(), 0, 0);
            }

            @Override
            public ObjectOutputStream.PutField putFields() throws IOException {
                if (this.pf == null) {
                    this.pf = new ObjectOutputStream.PutField(){

                        @Override
                        public void put(String string, boolean bl) {
                            fields.put(string, bl);
                        }

                        @Override
                        public void put(String string, byte by) {
                            fields.put(string, by);
                        }

                        @Override
                        public void put(String string, char c) {
                            fields.put(string, Character.valueOf(c));
                        }

                        @Override
                        public void put(String string, short s) {
                            fields.put(string, s);
                        }

                        @Override
                        public void put(String string, int n) {
                            fields.put(string, n);
                        }

                        @Override
                        public void put(String string, long l) {
                            fields.put(string, l);
                        }

                        @Override
                        public void put(String string, float f) {
                            fields.put(string, Float.valueOf(f));
                        }

                        @Override
                        public void put(String string, double d) {
                            fields.put(string, d);
                        }

                        @Override
                        public void put(String string, Object object) {
                            fields.put(string, object);
                        }

                        @Override
                        public void write(ObjectOutput objectOutput) throws IOException {
                            throw new IOException("cannot act compatible, use a custom serializer for this class");
                        }
                    };
                }
                return this.pf;
            }

            @Override
            public void writeFields() throws IOException {
                this.writeByte(77);
                FSTObjectOutput.this.writeObjectInternal(this.fields, null, HashMap.class);
            }

            @Override
            public void reset() throws IOException {
                throw new IOException("cannot act compatible, use a custom serializer for this class");
            }

            @Override
            public void write(int n) throws IOException {
                FSTObjectOutput.this.getCodec().writeFByte(n);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                FSTObjectOutput.this.write(byArray);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                FSTObjectOutput.this.write(byArray, n, n2);
            }

            @Override
            public void flush() throws IOException {
                FSTObjectOutput.this.flush();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void writeBoolean(boolean bl) throws IOException {
                FSTObjectOutput.this.writeBoolean(bl);
            }

            @Override
            public void writeByte(int n) throws IOException {
                FSTObjectOutput.this.getCodec().writeFByte(n);
            }

            @Override
            public void writeShort(int n) throws IOException {
                FSTObjectOutput.this.getCodec().writeFShort((short)n);
            }

            @Override
            public void writeChar(int n) throws IOException {
                FSTObjectOutput.this.getCodec().writeFChar((char)n);
            }

            @Override
            public void writeInt(int n) throws IOException {
                FSTObjectOutput.this.getCodec().writeFInt(n);
            }

            @Override
            public void writeLong(long l) throws IOException {
                FSTObjectOutput.this.getCodec().writeFLong(l);
            }

            @Override
            public void writeFloat(float f) throws IOException {
                FSTObjectOutput.this.getCodec().writeFFloat(f);
            }

            @Override
            public void writeDouble(double d) throws IOException {
                FSTObjectOutput.this.getCodec().writeFDouble(d);
            }

            @Override
            public void writeBytes(String string) throws IOException {
                FSTObjectOutput.this.writeBytes(string);
            }

            @Override
            public void writeChars(String string) throws IOException {
                FSTObjectOutput.this.writeChars(string);
            }

            @Override
            public void writeUTF(String string) throws IOException {
                FSTObjectOutput.this.getCodec().writeStringUTF(string);
            }
        };
        return objectOutputStream;
    }

    public FSTObjectRegistry getObjectMap() {
        return this.objects;
    }

    public byte[] getBuffer() {
        return this.getCodec().getBuffer();
    }

    public byte[] getCopyOfWrittenBuffer() {
        if (!this.getCodec().isByteArrayBased()) {
            return this.getBuffer();
        }
        byte[] byArray = new byte[this.getCodec().getWritten()];
        byte[] byArray2 = this.getBuffer();
        System.arraycopy(byArray2, 0, byArray, 0, this.getCodec().getWritten());
        return byArray;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }

    public int getWritten() {
        return this.getCodec().getWritten();
    }

    public void writeClassTag(Class clazz) {
        this.getCodec().writeClass(clazz);
    }

    public FSTEncoder getCodec() {
        return this.codec;
    }

    protected void setCodec(FSTEncoder fSTEncoder) {
        this.codec = fSTEncoder;
    }
}

