/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FSTClazzLineageInfo {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final LineageInfo OBJECT_LINEAGE_INFO = new LineageInfo(new LinkedHashSet(Collections.singletonList(Object.class)), 0);
    private static final ConcurrentMap<Class<?>, LineageInfo> lineageInfos = new ConcurrentHashMap();
    public static final Comparator<Class> SPECIFICITY_CLASS_COMPARATOR = new Comparator<Class>(){

        @Override
        public int compare(Class clazz, Class clazz2) {
            return FSTClazzLineageInfo.getLineageInfo(clazz2).specificity - FSTClazzLineageInfo.getLineageInfo(clazz).specificity;
        }
    };

    private FSTClazzLineageInfo() {
    }

    public static int getSpecificity(Class<?> clazz) {
        if (clazz == null) {
            return 0;
        }
        LineageInfo lineageInfo = FSTClazzLineageInfo.getLineageInfo(clazz);
        return lineageInfo == null ? 0 : lineageInfo.specificity;
    }

    public static Class<?>[] getLineage(Class<?> clazz) {
        LineageInfo lineageInfo = FSTClazzLineageInfo.getLineageInfo(clazz);
        return lineageInfo == null ? EMPTY_CLASS_ARRAY : lineageInfo.lineage.toArray(new Class[lineageInfo.lineage.size()]);
    }

    private static LineageInfo getLineageInfo(Class<?> clazz) {
        Class[] classArray;
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(Object.class)) {
            return OBJECT_LINEAGE_INFO;
        }
        LineageInfo lineageInfo = (LineageInfo)lineageInfos.get(clazz);
        if (lineageInfo != null) {
            return lineageInfo;
        }
        int n = 1;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Class<?> clazz2 = FSTClazzLineageInfo.getSuperclass(clazz);
        LineageInfo lineageInfo2 = FSTClazzLineageInfo.getLineageInfo(clazz2);
        if (lineageInfo2 != null) {
            linkedHashSet.addAll(lineageInfo2.lineage);
            n += lineageInfo2.specificity;
        }
        Class<?>[] classArray2 = FSTClazzLineageInfo.getInterfaces(clazz);
        int n2 = classArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            classArray = classArray2[n3];
            LineageInfo lineageInfo3 = FSTClazzLineageInfo.getLineageInfo(classArray);
            if (lineageInfo3 != null) {
                linkedHashSet.removeAll(lineageInfo3.lineage);
                linkedHashSet.addAll(lineageInfo3.lineage);
                n += lineageInfo3.specificity;
            }
            ++n3;
        }
        classArray = linkedHashSet.toArray(new Class[linkedHashSet.size()]);
        Arrays.sort(classArray, SPECIFICITY_CLASS_COMPARATOR);
        LinkedHashSet linkedHashSet2 = new LinkedHashSet(classArray.length + 1);
        linkedHashSet2.add(clazz);
        Collections.addAll(linkedHashSet2, classArray);
        LineageInfo lineageInfo4 = new LineageInfo(linkedHashSet2, n);
        lineageInfos.putIfAbsent(clazz, lineageInfo4);
        return lineageInfo4;
    }

    private static Class<?> getSuperclass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getSuperclass();
    }

    private static Class<?>[] getInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getInterfaces();
    }

    private static final class LineageInfo {
        private final LinkedHashSet<Class<?>> lineage;
        private final int specificity;

        private LineageInfo(LinkedHashSet<Class<?>> linkedHashSet, int n) {
            this.lineage = linkedHashSet;
            this.specificity = n;
        }
    }
}

