/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import java.io.IOException;
import java.io.OutputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTOutputStream;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStreamEncoder
implements FSTEncoder {
    private FSTConfiguration conf;
    private FSTClazzNameRegistry clnames;
    private FSTOutputStream buffout;
    private byte[] ascStringCache;

    public FSTStreamEncoder(FSTConfiguration fSTConfiguration) {
        this.conf = fSTConfiguration;
        this.clnames = (FSTClazzNameRegistry)fSTConfiguration.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(fSTConfiguration.getClassRegistry());
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public void setConf(FSTConfiguration fSTConfiguration) {
        this.conf = fSTConfiguration;
        this.clnames = (FSTClazzNameRegistry)fSTConfiguration.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(fSTConfiguration.getClassRegistry());
        } else {
            this.clnames.clear();
        }
    }

    void writeFBooleanArr(boolean[] blArray, int n, int n2) throws IOException {
        this.buffout.ensureFree(n2);
        int n3 = n;
        while (n3 < n + n2) {
            this.buffout.buf[this.buffout.pos++] = (byte)(blArray[n3] ? 1 : 0);
            ++n3;
        }
    }

    public void writeFFloatArr(float[] fArray, int n, int n2) throws IOException {
        int n3 = fArray.length * 4;
        this.buffout.ensureFree(n3);
        byte[] byArray = this.buffout.buf;
        int n4 = this.buffout.pos;
        int n5 = n + n2;
        int n6 = n;
        while (n6 < n5) {
            long l = Float.floatToIntBits(fArray[n6]);
            byArray[n4] = (byte)(l >>> 0);
            byArray[n4 + 1] = (byte)(l >>> 8);
            byArray[n4 + 2] = (byte)(l >>> 16);
            byArray[n4 + 3] = (byte)(l >>> 24);
            n4 += 4;
            ++n6;
        }
        this.buffout.pos += n3;
    }

    public void writeFDoubleArr(double[] dArray, int n, int n2) throws IOException {
        int n3 = dArray.length * 8;
        this.buffout.ensureFree(n3);
        byte[] byArray = this.buffout.buf;
        int n4 = this.buffout.pos;
        int n5 = n + n2;
        int n6 = n;
        while (n6 < n5) {
            long l = Double.doubleToLongBits(dArray[n6]);
            byArray[n4] = (byte)(l >>> 0);
            byArray[n4 + 1] = (byte)(l >>> 8);
            byArray[n4 + 2] = (byte)(l >>> 16);
            byArray[n4 + 3] = (byte)(l >>> 24);
            byArray[n4 + 4] = (byte)(l >>> 32);
            byArray[n4 + 5] = (byte)(l >>> 40);
            byArray[n4 + 6] = (byte)(l >>> 48);
            byArray[n4 + 7] = (byte)(l >>> 56);
            n4 += 8;
            ++n6;
        }
        this.buffout.pos += n3;
    }

    public void writeFShortArr(short[] sArray, int n, int n2) throws IOException {
        this.buffout.ensureFree(n2 * 3);
        int n3 = n;
        while (n3 < n + n2) {
            short s = sArray[n3];
            if (s < 255 && s >= 0) {
                this.buffout.buf[this.buffout.pos++] = (byte)s;
            } else {
                this.buffout.buf[this.buffout.pos] = -1;
                this.buffout.buf[this.buffout.pos + 1] = (byte)(s >>> 0);
                this.buffout.buf[this.buffout.pos + 2] = (byte)(s >>> 8);
                this.buffout.pos += 3;
            }
            ++n3;
        }
    }

    public void writeFCharArr(char[] cArray, int n, int n2) throws IOException {
        this.buffout.ensureFree(n2 * 3);
        int n3 = n;
        while (n3 < n + n2) {
            char c = cArray[n3];
            if (c < '\u00ff' && c >= '\u0000') {
                this.buffout.buf[this.buffout.pos++] = (byte)c;
            } else {
                byte[] byArray = this.buffout.buf;
                int n4 = this.buffout.pos;
                byArray[n4] = -1;
                byArray[n4 + 1] = (byte)(c >>> 0);
                byArray[n4 + 2] = (byte)(c >>> 8);
                this.buffout.pos += 3;
            }
            ++n3;
        }
    }

    public void writeFIntArr(int[] nArray, int n, int n2) throws IOException {
        int n3 = nArray.length * 4;
        this.buffout.ensureFree(n3);
        byte[] byArray = this.buffout.buf;
        int n4 = this.buffout.pos;
        int n5 = n + n2;
        int n6 = n;
        while (n6 < n5) {
            long l = nArray[n6];
            byArray[n4] = (byte)(l >>> 0);
            byArray[n4 + 1] = (byte)(l >>> 8);
            byArray[n4 + 2] = (byte)(l >>> 16);
            byArray[n4 + 3] = (byte)(l >>> 24);
            n4 += 4;
            ++n6;
        }
        this.buffout.pos += n3;
    }

    public void _writeFIntArr(int[] nArray, int n, int n2) throws IOException {
        int n3 = 5 * n2;
        this.buffout.ensureFree(n3);
        byte[] byArray = this.buffout.buf;
        int n4 = this.buffout.pos;
        int n5 = n;
        while (n5 < n + n2) {
            int n6 = nArray[n5];
            if (n6 > -127 && n6 <= 127) {
                this.buffout.buf[n4++] = (byte)n6;
            } else if (n6 >= Short.MIN_VALUE && n6 <= Short.MAX_VALUE) {
                byArray[n4++] = -128;
                byArray[n4++] = (byte)(n6 >>> 0 & 0xFF);
                byArray[n4++] = (byte)(n6 >>> 8 & 0xFF);
            } else {
                byArray[n4++] = -127;
                byArray[n4++] = (byte)(n6 >>> 0 & 0xFF);
                byArray[n4++] = (byte)(n6 >>> 8 & 0xFF);
                byArray[n4++] = (byte)(n6 >>> 16 & 0xFF);
                byArray[n4++] = (byte)(n6 >>> 24 & 0xFF);
            }
            ++n5;
        }
        this.buffout.pos = n4;
    }

    void writeFLongArr(long[] lArray, int n, int n2) throws IOException {
        int n3 = lArray.length * 8;
        this.buffout.ensureFree(n3);
        byte[] byArray = this.buffout.buf;
        int n4 = this.buffout.pos;
        int n5 = n;
        while (n5 < n + n2) {
            long l = lArray[n5];
            byArray[n4] = (byte)(l >>> 0);
            byArray[n4 + 1] = (byte)(l >>> 8);
            byArray[n4 + 2] = (byte)(l >>> 16);
            byArray[n4 + 3] = (byte)(l >>> 24);
            byArray[n4 + 4] = (byte)(l >>> 32);
            byArray[n4 + 5] = (byte)(l >>> 40);
            byArray[n4 + 6] = (byte)(l >>> 48);
            byArray[n4 + 7] = (byte)(l >>> 56);
            n4 += 8;
            ++n5;
        }
        this.buffout.pos += n3;
    }

    @Override
    public void writePrimitiveArray(Object object, int n, int n2) throws IOException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Byte.TYPE) {
            this.writeRawBytes((byte[])object, n, n2);
        } else if (clazz == Character.TYPE) {
            this.writeFCharArr((char[])object, n, n2);
        } else if (clazz == Short.TYPE) {
            this.writeFShortArr((short[])object, n, n2);
        } else if (clazz == Integer.TYPE) {
            this.writeFIntArr((int[])object, n, n2);
        } else if (clazz == Double.TYPE) {
            this.writeFDoubleArr((double[])object, n, n2);
        } else if (clazz == Float.TYPE) {
            this.writeFFloatArr((float[])object, n, n2);
        } else if (clazz == Long.TYPE) {
            this.writeFLongArr((long[])object, n, n2);
        } else if (clazz == Boolean.TYPE) {
            this.writeFBooleanArr((boolean[])object, n, n2);
        } else {
            throw new RuntimeException("expected primitive array");
        }
    }

    @Override
    public void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        this.buffout.ensureFree(n2);
        System.arraycopy(byArray, n, this.buffout.buf, this.buffout.pos, n2);
        this.buffout.pos += n2;
    }

    @Override
    public void writeStringUTF(String string) throws IOException {
        int n = string.length();
        this.writeFInt(n);
        this.buffout.ensureFree(n * 3);
        byte[] byArray = this.buffout.buf;
        int n2 = this.buffout.pos;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            byArray[n2++] = (byte)c;
            if (c >= '\u00ff') {
                byArray[n2 - 1] = -1;
                byArray[n2++] = (byte)(c >>> 0 & 0xFF);
                byArray[n2++] = (byte)(c >>> 8 & 0xFF);
            }
            ++n3;
        }
        this.buffout.pos = n2;
    }

    void writeStringAsc(String string) throws IOException {
        int n = string.length();
        if (n >= 127) {
            throw new RuntimeException("Ascii String too long");
        }
        this.writeFByte((byte)n);
        this.buffout.ensureFree(n);
        if (this.ascStringCache == null || this.ascStringCache.length < n) {
            this.ascStringCache = new byte[n];
        }
        string.getBytes(0, n, this.ascStringCache, 0);
        this.writeRawBytes(this.ascStringCache, 0, n);
    }

    @Override
    public void writeFShort(short s) throws IOException {
        if (s < 255 && s >= 0) {
            this.writeFByte(s);
        } else {
            this.writeFByte(255);
            this.writePlainShort(s);
        }
    }

    @Override
    public boolean writeAttributeName(FSTClazzInfo.FSTFieldInfo fSTFieldInfo, Object object) {
        return false;
    }

    @Override
    public boolean writeTag(byte by, Object object, long l, Object object2, FSTObjectOutput fSTObjectOutput) throws IOException {
        this.writeFByte(by);
        return false;
    }

    @Override
    public void writeFChar(char c) throws IOException {
        if (c < '\u00ff' && c >= '\u0000') {
            this.buffout.ensureFree(1);
            this.buffout.buf[this.buffout.pos++] = (byte)c;
        } else {
            this.buffout.ensureFree(3);
            byte[] byArray = this.buffout.buf;
            int n = this.buffout.pos;
            byArray[n++] = -1;
            byArray[n++] = (byte)(c >>> 0);
            byArray[n++] = (byte)(c >>> 8);
            this.buffout.pos += 3;
        }
    }

    @Override
    public final void writeFByte(int n) throws IOException {
        this.buffout.ensureFree(1);
        this.buffout.buf[this.buffout.pos++] = (byte)n;
    }

    @Override
    public void writeFInt(int n) throws IOException {
        if (n > -127 && n <= 127) {
            if (this.buffout.buf.length <= this.buffout.pos + 1) {
                this.buffout.ensureFree(1);
            }
            this.buffout.buf[this.buffout.pos++] = (byte)n;
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            this.ensureFree(3);
            byte[] byArray = this.buffout.buf;
            int n2 = this.buffout.pos;
            byArray[n2++] = -128;
            byArray[n2++] = (byte)(n >>> 0);
            byArray[n2++] = (byte)(n >>> 8);
            this.buffout.pos = n2;
        } else {
            this.buffout.ensureFree(5);
            byte[] byArray = this.buffout.buf;
            int n3 = this.buffout.pos;
            byArray[n3++] = -127;
            byArray[n3++] = (byte)(n >>> 0 & 0xFF);
            byArray[n3++] = (byte)(n >>> 8 & 0xFF);
            byArray[n3++] = (byte)(n >>> 16 & 0xFF);
            byArray[n3++] = (byte)(n >>> 24 & 0xFF);
            this.buffout.pos = n3;
        }
    }

    @Override
    public void writeFLong(long l) throws IOException {
        if (l > -126L && l <= 127L) {
            this.writeFByte((int)l);
        } else if (l >= -32768L && l <= 32767L) {
            this.ensureFree(3);
            byte[] byArray = this.buffout.buf;
            int n = this.buffout.pos;
            byArray[n++] = -128;
            byArray[n++] = (byte)(l >>> 0);
            byArray[n++] = (byte)(l >>> 8);
            this.buffout.pos = n;
        } else if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            this.buffout.ensureFree(5);
            byte[] byArray = this.buffout.buf;
            int n = this.buffout.pos;
            byArray[n++] = -127;
            byArray[n++] = (byte)(l >>> 0 & 0xFFL);
            byArray[n++] = (byte)(l >>> 8 & 0xFFL);
            byArray[n++] = (byte)(l >>> 16 & 0xFFL);
            byArray[n++] = (byte)(l >>> 24 & 0xFFL);
            this.buffout.pos = n;
        } else {
            this.buffout.ensureFree(9);
            byte[] byArray = this.buffout.buf;
            int n = this.buffout.pos;
            byArray[n++] = -126;
            byArray[n++] = (byte)(l >>> 0);
            byArray[n++] = (byte)(l >>> 8);
            byArray[n++] = (byte)(l >>> 16);
            byArray[n++] = (byte)(l >>> 24);
            byArray[n++] = (byte)(l >>> 32);
            byArray[n++] = (byte)(l >>> 40);
            byArray[n++] = (byte)(l >>> 48);
            byArray[n++] = (byte)(l >>> 56);
            this.buffout.pos = n;
        }
    }

    @Override
    public void writeFFloat(float f) throws IOException {
        this.writePlainInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeFDouble(double d) throws IOException {
        this.writePlainLong(Double.doubleToLongBits(d));
    }

    @Override
    public int getWritten() {
        return this.buffout.pos - this.buffout.getOff();
    }

    @Override
    public void close() throws IOException {
        this.buffout.close();
        this.conf.returnObject(this.clnames);
    }

    @Override
    public void reset(byte[] byArray) {
        if (byArray == null) {
            this.buffout.reset();
        } else {
            this.buffout.reset(byArray);
        }
        this.clnames.clear();
    }

    @Override
    public void skip(int n) {
        this.buffout.pos += n;
    }

    @Override
    public void writeInt32At(int n, int n2) {
        this.buffout.buf[n] = (byte)(n2 >>> 0);
        this.buffout.buf[n + 1] = (byte)(n2 >>> 8);
        this.buffout.buf[n + 2] = (byte)(n2 >>> 16);
        this.buffout.buf[n + 3] = (byte)(n2 >>> 24);
    }

    @Override
    public void setOutstream(OutputStream outputStream) {
        if (this.buffout == null) {
            this.buffout = (FSTOutputStream)this.conf.getCachedObject(FSTOutputStream.class);
            if (this.buffout == null) {
                this.buffout = new FSTOutputStream(1000, outputStream);
            } else {
                this.buffout.reset();
            }
        }
        if (outputStream == null) {
            this.buffout.setOutstream(this.buffout);
        } else {
            this.buffout.setOutstream(outputStream);
        }
    }

    public OutputStream getOutstream() {
        return this.buffout;
    }

    @Override
    public void flush() throws IOException {
        this.buffout.flush();
    }

    @Override
    public void ensureFree(int n) throws IOException {
        this.buffout.ensureFree(n);
    }

    @Override
    public byte[] getBuffer() {
        return this.buffout.buf;
    }

    @Override
    public void registerClass(Class clazz) {
        this.clnames.registerClass(clazz, this.conf);
    }

    @Override
    public final void writeClass(Class clazz) {
        try {
            this.clnames.encodeClass((FSTEncoder)this, clazz);
        }
        catch (IOException iOException) {
            FSTUtil.rethrow(iOException);
        }
    }

    @Override
    public final void writeClass(FSTClazzInfo fSTClazzInfo) {
        try {
            this.clnames.encodeClass((FSTEncoder)this, fSTClazzInfo);
        }
        catch (IOException iOException) {
            FSTUtil.rethrow(iOException);
        }
    }

    private void writePlainLong(long l) throws IOException {
        this.buffout.ensureFree(8);
        byte[] byArray = this.buffout.buf;
        int n = this.buffout.pos;
        byArray[n++] = (byte)(l >>> 0);
        byArray[n++] = (byte)(l >>> 8);
        byArray[n++] = (byte)(l >>> 16);
        byArray[n++] = (byte)(l >>> 24);
        byArray[n++] = (byte)(l >>> 32);
        byArray[n++] = (byte)(l >>> 40);
        byArray[n++] = (byte)(l >>> 48);
        byArray[n++] = (byte)(l >>> 56);
        this.buffout.pos += 8;
    }

    private void writePlainShort(int n) throws IOException {
        this.buffout.ensureFree(2);
        byte[] byArray = this.buffout.buf;
        int n2 = this.buffout.pos;
        byArray[n2++] = (byte)(n >>> 0);
        byArray[n2++] = (byte)(n >>> 8);
        this.buffout.pos += 2;
    }

    private void writePlainChar(int n) throws IOException {
        this.buffout.ensureFree(2);
        byte[] byArray = this.buffout.buf;
        int n2 = this.buffout.pos;
        byArray[n2++] = (byte)(n >>> 0);
        byArray[n2++] = (byte)(n >>> 8);
        this.buffout.pos += 2;
    }

    private void writePlainInt(int n) throws IOException {
        this.buffout.ensureFree(4);
        byte[] byArray = this.buffout.buf;
        int n2 = this.buffout.pos;
        byArray[n2++] = (byte)(n >>> 0 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        this.buffout.pos = n2;
    }

    @Override
    public void externalEnd(FSTClazzInfo fSTClazzInfo) {
    }

    @Override
    public boolean isWritingAttributes() {
        return false;
    }

    @Override
    public boolean isPrimitiveArray(Object object, Class<?> clazz) {
        return clazz.isPrimitive();
    }

    @Override
    public boolean isTagMultiDimSubArrays() {
        return false;
    }

    @Override
    public void writeVersionTag(int n) throws IOException {
        this.writeFByte(n);
    }

    @Override
    public boolean isByteArrayBased() {
        return true;
    }

    @Override
    public void writeArrayEnd() {
    }

    @Override
    public void writeFieldsEnd(FSTClazzInfo fSTClazzInfo) {
    }

    @Override
    public FSTConfiguration getConf() {
        return this.conf;
    }
}

