/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTUtil;

public class FSTEnumSetSerializer
extends FSTBasicObjectSerializer {
    Field elemType;

    @Override
    public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
        EnumSet enumSet = (EnumSet)object;
        int n2 = 0;
        fSTObjectOutput.writeInt(enumSet.size());
        if (enumSet.isEmpty()) {
            EnumSet enumSet2 = EnumSet.complementOf(enumSet);
            fSTObjectOutput.writeClassTag(FSTUtil.getRealEnumClass(enumSet2.iterator().next().getClass()));
        } else {
            for (Object e : enumSet) {
                if (n2 == 0) {
                    fSTObjectOutput.writeClassTag(FSTUtil.getRealEnumClass(e.getClass()));
                }
                fSTObjectOutput.writeObjectInternal(e, null, Enum.class);
                ++n2;
            }
        }
    }

    @Override
    public boolean alwaysCopy() {
        return false;
    }

    @Override
    public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        int n2 = fSTObjectInput.readInt();
        Class<?> clazz2 = FSTUtil.getRealEnumClass(fSTObjectInput.readClass().getClazz());
        EnumSet<?> enumSet = EnumSet.noneOf(clazz2);
        fSTObjectInput.registerObject(enumSet, n, fSTClazzInfo, fSTFieldInfo);
        int n3 = 0;
        while (n3 < n2) {
            enumSet.add(fSTObjectInput.readObjectInternal(Enum.class));
            ++n3;
        }
        return enumSet;
    }
}

