/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTThrowableSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
        Throwable throwable = (Throwable)object;
        fSTObjectOutput.writeStringUTF(throwable.getMessage());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        fSTObjectOutput.writeObject(stackTraceElementArray);
        fSTObjectOutput.writeObject(throwable.getCause());
        fSTObjectOutput.writeObject(throwable.getSuppressed());
    }

    @Override
    public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        Throwable[] throwableArray;
        Constructor constructor = clazz.getConstructor(String.class);
        Throwable throwable = (Throwable)constructor.newInstance(fSTObjectInput.readStringUTF());
        StackTraceElement[] stackTraceElementArray = (StackTraceElement[])fSTObjectInput.readObject();
        if (stackTraceElementArray != null) {
            throwable.setStackTrace(stackTraceElementArray);
        }
        throwable.initCause((Throwable)fSTObjectInput.readObject());
        Throwable[] throwableArray2 = throwableArray = (Throwable[])fSTObjectInput.readObject();
        int n2 = throwableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Throwable throwable2 = throwableArray2[n3];
            throwable.addSuppressed(throwable2);
            ++n3;
        }
        return throwable;
    }
}

