/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.serialize.gaml;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.WriterConfig;
import gama.dev.DEBUG;
import gama.extension.serialize.binary.BinarySerialisation;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Strings;
import gama.gaml.statements.save.GeoJSonSaver;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class SerialisationOperators {
    static {
        DEBUG.OFF();
    }

    @GamlAnnotations.operator(value={"to_gaml"}, can_be_const=true, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.doc(value="Returns the literal description of an expression in gaml, in a format suitable to be reinterpreted and return a similar object", examples={@GamlAnnotations.example(value="to_gaml(0)", equals="'0'"), @GamlAnnotations.example(value="to_gaml(3.78)", equals="'3.78'"), @GamlAnnotations.example(value="to_gaml({23, 4.0})", equals="'{23.0,4.0,0.0}'"), @GamlAnnotations.example(value="to_gaml(rgb(255,0,125))", equals="'rgb (255, 0, 125,255)'"), @GamlAnnotations.example(value="to_gaml('hello')", equals="\"'hello'\""), @GamlAnnotations.example(value="to_gaml(a_graph)", equals="([((1 as node)::(3 as node))::(5 as edge),((0 as node)::(3 as node))::(3 as edge),((1 as node)::(2 as node))::(1 as edge),((0 as node)::(2 as node))::(2 as edge),((0 as node)::(1 as node))::(0 as edge),((2 as node)::(3 as node))::(4 as edge)] as map ) as graph", isExecutable=false), @GamlAnnotations.example(value="to_gaml(node1)", equals=" 1 as node", isExecutable=false)}, see={})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="to_gaml(true) = 'true'"), @GamlAnnotations.test(value="to_gaml(5::34) = '5::34'"), @GamlAnnotations.test(value="to_gaml([1,5,9,3]) = '[1,5,9,3]'"), @GamlAnnotations.test(value="to_gaml(['a'::345, 'b'::13, 'c'::12]) = \"map(['a'::345,'b'::13,'c'::12])\""), @GamlAnnotations.test(value="to_gaml([[3,5,7,9],[2,4,6,8]]) = '[[3,5,7,9],[2,4,6,8]]'")})
    public static String toGaml(Object object) {
        return StringUtils.toGaml((Object)object, (boolean)false);
    }

    @GamlAnnotations.operator(value={"to_geojson"}, can_be_const=true, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.doc(value="Returns a geojson representation of a population, a list of agents/geometries or an agent/geometry, provided with a CRS and a list of attributes to save", examples={@GamlAnnotations.example(value="to_geojson(boat,\"EPSG:4326\",[\"color\"])", equals="{\"type\":\"FeatureCollection\",\"features\":[{\"type\":\"Feature\",\"geometry\":{\"type\":\"Point\",\"coordinates\":[100.51155642068785,3.514781609095577E-4,0.0]},\"properties\":{},\"id\":\"0\"}]}")}, see={})
    public static String toGeoJSon(IScope iScope, IExpression iExpression, String string, IExpression iExpression2) {
        GeoJSonSaver geoJSonSaver = new GeoJSonSaver();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            geoJSonSaver.save(iScope, iExpression, (OutputStream)byteArrayOutputStream, string, (Object)iExpression2);
            return byteArrayOutputStream.toString(StandardCharsets.UTF_8);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw gamaRuntimeException;
        }
        catch (Throwable throwable) {
            throw GamaRuntimeException.create((Throwable)throwable, (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"to_json"}, can_be_const=true, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="to_json(1) = '1'"), @GamlAnnotations.test(value="to_json(1.24) = '1.24'"), @GamlAnnotations.test(value="to_json('a string') = '\"a string\"'"), @GamlAnnotations.test(value="to_json(#blue) = '{\"gaml_type\":\"rgb\",\"red\":0,\"green\":0,\"blue\":255,\"alpha\":255}'"), @GamlAnnotations.test(value="to_json(font('Helvetica')) = '{\"gaml_type\":\"font\",\"name\":\"Helvetica\",\"style\":0,\"size\":12}'"), @GamlAnnotations.test(value="to_json(point(20,10)) = '{\"gaml_type\":\"point\",\"x\":20.0,\"y\":10.0,\"z\":0.0}'")})
    @GamlAnnotations.doc(value="Serializes any object/agent/simulation into a string, using the json format. A flag can be passed to enable/disable pretty printing (`false` by default).\nThe format used by GAMA follows simple rules. `int`, `float`, `bool`, `string` values are outputted as they are. `nil` is outputted as `null`. A list is outputted as a json array. Any other object or agent is outputted as a json object. If this object possesses the attribute `gaml_type`, it is an instance of the corresponding type, and the members that follow contain the attributes and the values necessary to reconstruct it. If it has the `agent_reference` attribute, its value represents the reference to an agent. If any reference to an agent is found, the json string returned will be an object with two attributes: `gama_object`, the object containing the references, and `reference_table` a dictionary mapping the references to the json description of the agents (their `species`, `name`, `index`, and list of attributes). This choice allows to manage cross references between agents", see={"serialize", "to_gaml"})
    public static String toJson(IScope iScope, Object object, boolean bl) {
        return Json.getNew().valueOf(object).toString(bl ? WriterConfig.PRETTY_PRINT : WriterConfig.MINIMAL);
    }

    @GamlAnnotations.operator(value={"to_json"}, can_be_const=true, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.doc(value="Serializes any object/agent/simulation into a string, using the json format and no pretty printing.\nThe format used by GAMA follows simple rules. `int`, `float`, `bool`, `string` values are outputted as they are. `nil` is outputted as `null`. A `list` is outputted as a json array. Any other object or agent is outputted as a json object. If this object possesses the \"gaml_type\" attribute, it is an instance of the corresponding type, and the members that follow contain the attributes and the values necessary to reconstruct it. If it has the \"agent_reference\" attribute, its value represent the reference to an agent. If any reference to an agent is found, the json string returned will be an object with two attributes: \"gama_object\", the object containing the references, and \"reference_table\" a dictionary mapping the references to the json description of the agents (their species, name, index, and list of attributes). This choice allows to manage cross references between agents", see={"serialize", "to_gaml"})
    public static String toJson(IScope iScope, Object object) {
        return SerialisationOperators.toJson(iScope, object, false);
    }

    @GamlAnnotations.operator(value={"serialize", "to_binary"}, can_be_const=true, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.doc(value="Serializes any object/agent/simulation into a string, using the `binary` format\nThe result of this operator can be then used in the `from` facet of `restore` or `create` statements in case of agents, or using `deserialize` for other items", see={"to_json", "to_gaml"})
    public static String serialize(IScope iScope, Object object) {
        return BinarySerialisation.saveToString(iScope, object);
    }

    @GamlAnnotations.operator(value={"deserialize", "from_binary"}, can_be_const=true, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="from_binary(to_binary(25+5)) = 30"), @GamlAnnotations.test(value="from_binary(to_binary([1,2,4])) = [1,2,4]")})
    @GamlAnnotations.doc(value="Deserializes an object precedently serialized using `serialize` or `to_binary`.It is safer to deserialize agents or simulations with the 'restore' or 'create' statements rather than with this operator.", see={"from_gaml", "from_json"})
    public static Object unserialize(IScope iScope, String string) {
        return BinarySerialisation.createFromString(iScope, string);
    }

    @GamlAnnotations.operator(value={"from_json"}, can_be_const=true, type=-348, category={"Casting operators"}, concept={"serialize"})
    @GamlAnnotations.doc(value="Deserializes an object precedently serialized using 'to_json' (or an arbitrary json string obtained elsewhere). Agents and populations are not supported yet (i.e. they will return maps)", see={"from_gaml", "from_binary"})
    public static Object fromJson(IScope iScope, String string) {
        return Json.getNew().parse(string).toGamlValue(iScope);
    }

    @GamlAnnotations.operator(value={"from_gaml", "eval_gaml"}, can_be_const=false, category={"System", "Casting operators"}, concept={"system", "serialize"})
    @GamlAnnotations.doc(value="Evaluates/deserialises the given GAML string into a value.", examples={@GamlAnnotations.example(value="eval_gaml(\"2+3\")", equals="5")})
    public static Object opEvalGaml(IScope iScope, String string) {
        IAgent iAgent = iScope.getAgent();
        SpeciesDescription speciesDescription = iAgent.getSpecies().getDescription();
        try {
            IExpression iExpression = GAML.getExpressionFactory().createExpr(string, (IDescription)speciesDescription);
            return iScope.evaluate(iExpression, iAgent).getValue();
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Error in evaluating Gaml code : '" + string + "' in " + String.valueOf(iScope.getAgent()) + Strings.LN + "Reason: " + gamaRuntimeException.getMessage()), (IScope)iScope), (boolean)false);
            return null;
        }
    }
}

