/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import gama.dev.DEBUG;
import java.io.IOException;
import java.io.InputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.util.FSTInputStream;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStreamDecoder
implements FSTDecoder {
    private FSTInputStream input;
    byte[] ascStringCache;
    FSTConfiguration conf;
    public FSTClazzNameRegistry clnames;
    char[] chBufS;

    public FSTStreamDecoder(FSTConfiguration fSTConfiguration) {
        this.conf = fSTConfiguration;
        this.clnames = (FSTClazzNameRegistry)fSTConfiguration.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(fSTConfiguration.getClassRegistry());
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public void setConf(FSTConfiguration fSTConfiguration) {
        this.conf = fSTConfiguration;
        this.clnames = (FSTClazzNameRegistry)fSTConfiguration.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(fSTConfiguration.getClassRegistry());
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public int ensureReadAhead(int n) {
        this.input.ensureReadAhead(n);
        return 0;
    }

    char[] getCharBuf(int n) {
        char[] cArray = this.chBufS;
        if (cArray == null || cArray.length < n) {
            this.chBufS = cArray = new char[Math.max(n, 15)];
        }
        return cArray;
    }

    @Override
    public String readStringUTF() throws IOException {
        int n = this.readFInt();
        char[] cArray = this.getCharBuf(n * 3);
        this.input.ensureReadAhead(n * 3);
        byte[] byArray = this.input.buf;
        int n2 = this.input.pos;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c;
            if ((c = (char)(byArray[n2++] + 256 & 0xFF)) < '\u00ff') {
                cArray[n3++] = c;
            } else {
                int n5 = byArray[n2++] + 256 & 0xFF;
                int n6 = byArray[n2++] + 256 & 0xFF;
                cArray[n3++] = (char)((n5 << 0) + (n6 << 8));
            }
            ++n4;
        }
        this.input.pos = n2;
        return new String(cArray, 0, n3);
    }

    @Override
    public byte readObjectHeaderTag() throws IOException {
        return this.readFByte();
    }

    @Override
    public String readStringAsc() throws IOException {
        int n = this.readFInt();
        if (this.ascStringCache == null || this.ascStringCache.length < n) {
            this.ascStringCache = new byte[n];
        }
        this.input.ensureReadAhead(n);
        System.arraycopy(this.input.buf, this.input.pos, this.ascStringCache, 0, n);
        this.input.pos += n;
        return new String(this.ascStringCache, 0, 0, n);
    }

    @Override
    public Object readFPrimitiveArray(Object object, Class clazz, int n) {
        try {
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.ensureReadAhead(byArray.length);
                System.arraycopy(this.input.buf, this.input.pos, byArray, 0, n);
                this.input.pos += n;
                return byArray;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.readFIntArr(n, nArray);
                return nArray;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.readFLongArr(n, lArray);
                return lArray;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                int n2 = 0;
                while (n2 < n) {
                    cArray[n2] = this.readFChar();
                    ++n2;
                }
                return cArray;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.ensureReadAhead(dArray.length * 8);
                int n3 = 0;
                while (n3 < n) {
                    dArray[n3] = this.readFDouble();
                    ++n3;
                }
                return dArray;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.ensureReadAhead(sArray.length * 2);
                int n4 = 0;
                while (n4 < n) {
                    sArray[n4] = this.readFShort();
                    ++n4;
                }
                return sArray;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.ensureReadAhead(fArray.length * 4);
                int n5 = 0;
                while (n5 < n) {
                    fArray[n5] = this.readFFloat();
                    ++n5;
                }
                return fArray;
            }
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                this.ensureReadAhead(blArray.length);
                int n6 = 0;
                while (n6 < n) {
                    blArray[n6] = this.readFByte() != 0;
                    ++n6;
                }
                return blArray;
            }
            throw new RuntimeException("unexpected primitive type " + clazz.getName());
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Failed to read primitive array", (Throwable)iOException);
            FSTUtil.rethrow(iOException);
            return null;
        }
    }

    public void _readFIntArr(int n, int[] nArray) throws IOException {
        this.ensureReadAhead(5 * n);
        byte[] byArray = this.input.buf;
        int n2 = this.input.pos;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if ((n4 = byArray[n2++]) > -127 && n4 <= 127) {
                nArray[n3] = n4;
            } else if (n4 == -128) {
                var7_7 = byArray[n2++] + 256 & 0xFF;
                var8_8 = byArray[n2++] + 256 & 0xFF;
                nArray[n3] = (short)((var7_7 << 8) + (var8_8 << 0));
            } else {
                var7_7 = byArray[n2++] + 256 & 0xFF;
                var8_8 = byArray[n2++] + 256 & 0xFF;
                int n5 = byArray[n2++] + 256 & 0xFF;
                int n6 = byArray[n2++] + 256 & 0xFF;
                nArray[n3] = (var7_7 << 24) + (var8_8 << 16) + (n5 << 8) + (n6 << 0);
            }
            ++n3;
        }
        this.input.pos = n2;
    }

    @Override
    public void readFIntArr(int n, int[] nArray) throws IOException {
        int n2 = nArray.length * 4;
        this.ensureReadAhead(n2);
        int n3 = this.input.pos;
        byte[] byArray = this.input.buf;
        int n4 = 0;
        while (n4 < n) {
            int n5 = byArray[n3++] + 256 & 0xFF;
            int n6 = byArray[n3++] + 256 & 0xFF;
            int n7 = byArray[n3++] + 256 & 0xFF;
            int n8 = byArray[n3++] + 256 & 0xFF;
            nArray[n4] = (n8 << 24) + (n7 << 16) + (n6 << 8) + (n5 << 0);
            ++n4;
        }
        this.input.pos += n2;
    }

    public void readFLongArr(int n, long[] lArray) throws IOException {
        int n2 = lArray.length * 8;
        this.ensureReadAhead(n2);
        int n3 = this.input.pos;
        byte[] byArray = this.input.buf;
        int n4 = 0;
        while (n4 < n) {
            long l = byArray[n3++] + 256 & 0xFF;
            long l2 = byArray[n3++] + 256 & 0xFF;
            long l3 = byArray[n3++] + 256 & 0xFF;
            long l4 = byArray[n3++] + 256 & 0xFF;
            long l5 = byArray[n3++] + 256 & 0xFF;
            long l6 = byArray[n3++] + 256 & 0xFF;
            long l7 = byArray[n3++] + 256 & 0xFF;
            long l8 = byArray[n3++] + 256 & 0xFF;
            lArray[n4] = (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + (l << 0);
            ++n4;
        }
        this.input.pos += n2;
    }

    @Override
    public int readFInt() throws IOException {
        this.ensureReadAhead(5);
        byte by = this.readFByte();
        if (by > -127 && by <= 127) {
            return by;
        }
        if (by == -128) {
            int n = this.input.pos;
            byte[] byArray = this.input.buf;
            int n2 = byArray[n++] + 256 & 0xFF;
            int n3 = byArray[n++] + 256 & 0xFF;
            this.input.pos = n;
            return (short)((n3 << 8) + (n2 << 0));
        }
        int n = this.input.pos;
        byte[] byArray = this.input.buf;
        int n4 = byArray[n++] + 256 & 0xFF;
        int n5 = byArray[n++] + 256 & 0xFF;
        int n6 = byArray[n++] + 256 & 0xFF;
        int n7 = byArray[n++] + 256 & 0xFF;
        this.input.pos = n;
        int n8 = (n7 << 24) + (n6 << 16) + (n5 << 8) + (n4 << 0);
        return n8;
    }

    @Override
    public double readFDouble() throws IOException {
        return Double.longBitsToDouble(this.readPlainLong());
    }

    @Override
    public float readFFloat() throws IOException {
        return Float.intBitsToFloat(this.readPlainInt());
    }

    @Override
    public final byte readFByte() throws IOException {
        this.input.ensureReadAhead(1);
        if (this.input.pos > this.input.count) {
            throw new IOException("Failed to read the next byte");
        }
        return this.input.buf[this.input.pos++];
    }

    @Override
    public final int readIntByte() throws IOException {
        this.input.ensureReadAhead(1);
        if (this.input.isFullyRead()) {
            return -1;
        }
        return this.input.buf[this.input.pos++] & 0xFF;
    }

    @Override
    public long readFLong() throws IOException {
        this.input.ensureReadAhead(9);
        byte by = this.readFByte();
        if (by > -126 && by <= 127) {
            return by;
        }
        if (by == -128) {
            int n = this.input.pos;
            byte[] byArray = this.input.buf;
            int n2 = byArray[n++] + 256 & 0xFF;
            int n3 = byArray[n++] + 256 & 0xFF;
            this.input.pos = n;
            return (short)((n3 << 8) + (n2 << 0));
        }
        if (by == -127) {
            int n = this.input.pos;
            byte[] byArray = this.input.buf;
            int n4 = byArray[n++] + 256 & 0xFF;
            int n5 = byArray[n++] + 256 & 0xFF;
            int n6 = byArray[n++] + 256 & 0xFF;
            int n7 = byArray[n++] + 256 & 0xFF;
            this.input.pos = n;
            int n8 = (n7 << 24) + (n6 << 16) + (n5 << 8) + (n4 << 0);
            return n8;
        }
        this.ensureReadAhead(8);
        int n = this.input.pos;
        byte[] byArray = this.input.buf;
        long l = byArray[n++] + 256 & 0xFF;
        long l2 = byArray[n++] + 256 & 0xFF;
        long l3 = byArray[n++] + 256 & 0xFF;
        long l4 = byArray[n++] + 256 & 0xFF;
        long l5 = byArray[n++] + 256 & 0xFF;
        long l6 = byArray[n++] + 256 & 0xFF;
        long l7 = byArray[n++] + 256 & 0xFF;
        long l8 = byArray[n++] + 256 & 0xFF;
        this.input.pos = n;
        return (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + (l << 0);
    }

    @Override
    public char readFChar() throws IOException {
        this.input.ensureReadAhead(3);
        char c = (char)(this.readFByte() + 256 & 0xFF);
        if (c >= '\u0000' && c < '\u00ff') {
            return c;
        }
        int n = this.readFByte() & 0xFF;
        int n2 = this.readFByte() & 0xFF;
        return (char)((n << 0) + (n2 << 8));
    }

    @Override
    public short readFShort() throws IOException {
        this.input.ensureReadAhead(3);
        int n = this.readFByte() & 0xFF;
        if (n >= 0 && n < 255) {
            return (short)n;
        }
        int n2 = this.readFByte() & 0xFF;
        int n3 = this.readFByte() & 0xFF;
        return (short)((n2 << 0) + (n3 << 8));
    }

    private char readPlainChar() throws IOException {
        this.input.ensureReadAhead(2);
        int n = this.input.pos;
        byte[] byArray = this.input.buf;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        this.input.pos = n;
        return (char)((n3 << 8) + (n2 << 0));
    }

    private short readPlainShort() throws IOException {
        this.input.ensureReadAhead(2);
        int n = this.input.pos;
        byte[] byArray = this.input.buf;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        this.input.pos = n;
        return (short)((n3 << 8) + (n2 << 0));
    }

    @Override
    public int readPlainInt() throws IOException {
        this.input.ensureReadAhead(4);
        int n = this.input.pos;
        byte[] byArray = this.input.buf;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        int n4 = byArray[n++] + 256 & 0xFF;
        int n5 = byArray[n++] + 256 & 0xFF;
        this.input.pos = n;
        int n6 = (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
        return n6;
    }

    private long readPlainLong() throws IOException {
        this.input.ensureReadAhead(8);
        int n = this.input.pos;
        byte[] byArray = this.input.buf;
        long l = byArray[n++] + 256 & 0xFF;
        long l2 = byArray[n++] + 256 & 0xFF;
        long l3 = byArray[n++] + 256 & 0xFF;
        long l4 = byArray[n++] + 256 & 0xFF;
        long l5 = byArray[n++] + 256 & 0xFF;
        long l6 = byArray[n++] + 256 & 0xFF;
        long l7 = byArray[n++] + 256 & 0xFF;
        long l8 = byArray[n++] + 256 & 0xFF;
        this.input.pos = n;
        return (l8 << 56) + (l7 << 48) + (l6 << 40) + (l5 << 32) + (l4 << 24) + (l3 << 16) + (l2 << 8) + (l << 0);
    }

    @Override
    public byte[] getBuffer() {
        return this.input.buf;
    }

    @Override
    public int getInputPos() {
        return this.input.pos;
    }

    @Override
    public void moveTo(int n) {
        this.input.pos = n;
    }

    @Override
    public void reset() {
        this.input.reset();
        this.clnames.clear();
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        if (this.input == null) {
            this.input = new FSTInputStream(inputStream);
        } else {
            this.input.initFromStream(inputStream);
        }
        this.clnames.clear();
    }

    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public void resetToCopyOf(byte[] byArray, int n, int n2) {
        this.input.reset();
        this.input.ensureCapacity(n2);
        this.input.count = n2;
        System.arraycopy(byArray, n, this.input.buf, 0, n2);
        this.clnames.clear();
        this.input.byteBacked = true;
    }

    @Override
    public void resetWith(byte[] byArray, int n) {
        this.clnames.clear();
        this.input.resetForReuse(byArray, n);
    }

    @Override
    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.clnames.decodeClass(this, this.conf);
    }

    @Override
    public Class classForName(String string) throws ClassNotFoundException {
        return this.clnames.classForName(string, this.conf);
    }

    @Override
    public void registerClass(Class clazz) {
        this.clnames.registerClass(clazz, this.conf);
    }

    @Override
    public void close() {
        this.conf.returnObject(this.clnames);
    }

    @Override
    public void skip(int n) {
        this.input.pos += n;
    }

    @Override
    public void readPlainBytes(byte[] byArray, int n, int n2) {
        this.input.ensureReadAhead(n2);
        System.arraycopy(this.input.buf, this.input.pos, byArray, n, n2);
        this.input.pos += n2;
    }

    @Override
    public boolean isMapBased() {
        return false;
    }

    @Override
    public Object getDirectObject() {
        return null;
    }

    @Override
    public int getObjectHeaderLen() {
        return -1;
    }

    @Override
    public void consumeEndMarker() {
    }

    @Override
    public Class readArrayHeader() throws Exception {
        return this.readClass().getClazz();
    }

    @Override
    public void readExternalEnd() {
    }

    @Override
    public boolean isEndMarker(String string) {
        return false;
    }

    @Override
    public int readVersionTag() throws IOException {
        return this.readFByte();
    }

    @Override
    public void pushBack(int n) {
        this.input.pos -= n;
    }

    @Override
    public void readArrayEnd(FSTClazzInfo fSTClazzInfo) {
    }

    @Override
    public void readObjectEnd() {
    }

    @Override
    public Object coerceElement(Class clazz, Object object) {
        return object;
    }

    @Override
    public int available() {
        this.input.ensureReadAhead(1);
        return this.input.available();
    }

    @Override
    public boolean inArray() {
        return false;
    }

    @Override
    public void startFieldReading(Object object) {
    }

    @Override
    public void endFieldReading(Object object) {
    }
}

