/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTClassSerializer
extends FSTBasicObjectSerializer {
    private final Map<String, Class> primitiveMap = new HashMap<String, Class>();

    public FSTClassSerializer() {
        Class[] classArray;
        Class[] classArray2 = classArray = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE, Void.TYPE};
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray2[n2];
            this.primitiveMap.put(clazz.getName(), clazz);
            ++n2;
        }
    }

    @Override
    public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
        Class clazz = (Class)object;
        fSTObjectOutput.writeBoolean(clazz.isPrimitive());
        fSTObjectOutput.writeStringUTF(clazz.getName());
    }

    @Override
    public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        boolean bl = fSTObjectInput.readBoolean();
        String string = fSTObjectInput.readStringUTF();
        Class clazz2 = bl ? this.primitiveMap.get(string) : fSTObjectInput.getClassForName(string);
        fSTObjectInput.registerObject(clazz2, n, fSTClazzInfo, fSTFieldInfo);
        return clazz2;
    }

    @Override
    public boolean alwaysCopy() {
        return false;
    }
}

