/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.math.BigInteger;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTBigIntegerSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
        byte[] byArray = ((BigInteger)object).toByteArray();
        fSTObjectOutput.writeInt(byArray.length);
        fSTObjectOutput.write(byArray);
    }

    @Override
    public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
        int n2 = fSTObjectInput.readInt();
        byte[] byArray = new byte[n2];
        fSTObjectInput.read(byArray);
        BigInteger bigInteger = new BigInteger(byArray);
        fSTObjectInput.registerObject(bigInteger, n, fSTClazzInfo, fSTFieldInfo);
        return bigInteger;
    }
}

