/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTBigNumberSerializers {

    public static class FSTByteSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
            fSTObjectOutput.writeByte(((Byte)object).byteValue());
        }

        @Override
        public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
            Byte by = fSTObjectInput.readByte();
            return by;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTCharSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
            fSTObjectOutput.writeChar(((Character)object).charValue());
        }

        @Override
        public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
            Character c = Character.valueOf(fSTObjectInput.readChar());
            return c;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTDoubleSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
            fSTObjectOutput.writeDouble((Double)object);
        }

        @Override
        public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
            Double d = new Double(fSTObjectInput.readDouble());
            return d;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTFloatSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
            fSTObjectOutput.writeFloat(((Float)object).floatValue());
        }

        @Override
        public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
            Float f = new Float(fSTObjectInput.readFloat());
            return f;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }

    public static class FSTShortSerializer
    extends FSTBasicObjectSerializer {
        @Override
        public void writeObject(FSTObjectOutput fSTObjectOutput, Object object, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws IOException {
            fSTObjectOutput.writeShort(((Short)object).shortValue());
        }

        @Override
        public Object instantiate(Class clazz, FSTObjectInput fSTObjectInput, FSTClazzInfo fSTClazzInfo, FSTClazzInfo.FSTFieldInfo fSTFieldInfo, int n) throws Exception {
            Short s = fSTObjectInput.readShort();
            return s;
        }

        @Override
        public boolean alwaysCopy() {
            return true;
        }

        @Override
        public boolean writeTupleEnd() {
            return false;
        }
    }
}

