/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.FSTSerializerRegistryDelegate;
import org.nustaq.serialization.util.FSTMap;

public class FSTClazzInfoRegistry {
    FSTMap<Class<?>, FSTClazzInfo> mInfos = new FSTMap(97);
    FSTSerializerRegistry serializerRegistry = new FSTSerializerRegistry();
    boolean ignoreAnnotations = false;
    final AtomicBoolean rwLock = new AtomicBoolean(false);
    private boolean structMode = false;

    public static void addAllReferencedClasses(Class<?> clazz, ArrayList<String> arrayList, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        FSTClazzInfoRegistry.addAllReferencedClasses(clazz, hashSet, new HashSet<String>(), string);
        arrayList.addAll(hashSet);
    }

    static void addAllReferencedClasses(Class<?> clazz, HashSet<String> hashSet, HashSet<String> hashSet2, String string) {
        Class<?>[] classArray;
        Class<?>[] classArray2;
        Object object;
        Method[] methodArray;
        Object object2;
        Object object3;
        Field[] fieldArray;
        if (clazz == null || hashSet2.contains(clazz.getName()) || !clazz.getName().startsWith(string)) {
            return;
        }
        hashSet2.add(clazz.getName());
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            object3 = fieldArray2[n2];
            object2 = ((Field)object3).getType();
            if (!((Class)object2).isPrimitive() && !((Class)object2).isArray()) {
                hashSet.add(((Class)object2).getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(object2, hashSet, hashSet2, string);
            }
            ++n2;
        }
        object2 = object3 = clazz.getDeclaredClasses();
        int n3 = ((Class<?>[])object3).length;
        n = 0;
        while (n < n3) {
            Object object4 = object2[n];
            if (!((Class)object4).isPrimitive() && !((Class)object4).isArray()) {
                hashSet.add(((Class)object4).getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(object4, hashSet, hashSet2, string);
            }
            ++n;
        }
        Method[] methodArray2 = methodArray = clazz.getDeclaredMethods();
        int n4 = methodArray.length;
        n3 = 0;
        while (n3 < n4) {
            Class<?>[] classArray3;
            Method method = methodArray2[n3];
            object = method.getReturnType();
            if (!((Class)object).isPrimitive() && !((Class)object).isArray()) {
                hashSet.add(((Class)object).getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(object, hashSet, hashSet2, string);
            }
            Class<?>[] classArray4 = classArray3 = method.getParameterTypes();
            int n5 = classArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                classArray2 = classArray4[n6];
                if (!classArray2.isPrimitive() && !classArray2.isArray()) {
                    hashSet.add(classArray2.getName());
                    FSTClazzInfoRegistry.addAllReferencedClasses(classArray2, hashSet, hashSet2, string);
                }
                ++n6;
            }
            ++n3;
        }
        Class<?>[] classArray5 = clazz.getDeclaredClasses();
        object = classArray5;
        int n7 = classArray5.length;
        n4 = 0;
        while (n4 < n7) {
            Object object5 = object[n4];
            if (!((Class)object5).isPrimitive() && !((Class)object5).isArray()) {
                hashSet.add(((Class)object5).getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(object5, hashSet, hashSet2, string);
            }
            ++n4;
        }
        Class<?> clazz2 = clazz.getEnclosingClass();
        if (clazz2 != null) {
            hashSet.add(clazz2.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(clazz2, hashSet, hashSet2, string);
        }
        hashSet.add(clazz.getName());
        FSTClazzInfoRegistry.addAllReferencedClasses(clazz.getSuperclass(), hashSet, hashSet2, string);
        classArray2 = classArray = clazz.getInterfaces();
        int n8 = classArray.length;
        int n9 = 0;
        while (n9 < n8) {
            Class<?> clazz3 = classArray2[n9];
            if (!clazz3.isPrimitive() && !clazz3.isArray()) {
                hashSet.add(clazz3.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(clazz3, hashSet, hashSet2, string);
            }
            ++n9;
        }
    }

    public FSTClazzInfo getCLInfo(Class<?> clazz, FSTConfiguration fSTConfiguration) {
        while (!this.rwLock.compareAndSet(false, true)) {
        }
        try {
            FSTClazzInfo fSTClazzInfo = this.mInfos.get(clazz);
            if (fSTClazzInfo == null) {
                if (clazz == null) {
                    throw new NullPointerException("Class is null");
                }
                fSTClazzInfo = new FSTClazzInfo(fSTConfiguration, clazz, this, this.ignoreAnnotations);
                this.mInfos.put(clazz, fSTClazzInfo);
            }
            FSTClazzInfo fSTClazzInfo2 = fSTClazzInfo;
            return fSTClazzInfo2;
        }
        finally {
            this.rwLock.set(false);
        }
    }

    public FSTSerializerRegistry getSerializerRegistry() {
        return this.serializerRegistry;
    }

    public final boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean bl) {
        this.ignoreAnnotations = bl;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate fSTSerializerRegistryDelegate) {
        this.serializerRegistry.setDelegate(fSTSerializerRegistryDelegate);
    }

    public FSTSerializerRegistryDelegate getSerializerRegistryDelegate() {
        return this.serializerRegistry.getDelegate();
    }

    public void setStructMode(boolean bl) {
        this.structMode = bl;
    }

    public boolean isStructMode() {
        return this.structMode;
    }
}

