/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.serialize.gaml;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.ISerialisationConstants;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

@GamlAnnotations.file(name="agent", extensions={"agent"}, buffer_type=5, buffer_content=4, buffer_index=1, concept={"file", "save_file"}, doc={@GamlAnnotations.doc(value="Represents a saved agent file. The internal contents is a string at index 0 that contains the binary (bytes) representation of the agent")})
public class GamaSavedAgentFile
extends GamaFile<IList<String>, String>
implements ISerialisationConstants {
    @GamlAnnotations.doc(value="File containing a saved agent in the java binary serialisation protocol")
    public GamaSavedAgentFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, true);
    }

    public IContainerType<?> getGamlType() {
        return Types.FILE.of((IType)Types.INT, (IType)Types.STRING);
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        try {
            byte[] byArray = Files.readAllBytes(Path.of(this.getPath(iScope), new String[0]));
            this.setBuffer((IAddressableContainer)GamaListFactory.create((IScope)iScope, (IType)Types.STRING, (Object[])new String[]{new String(byArray, STRING_BYTE_ARRAY_CHARSET)}));
        }
        catch (IOException iOException) {
            this.setBuffer((IAddressableContainer)GamaListFactory.create());
            throw GamaRuntimeException.create((Throwable)iOException, (IScope)iScope);
        }
    }

    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }
}

