/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import org.nustaq.serialization.util.FSTObject2IntMap;
import org.nustaq.serialization.util.FSTUtil;

public class FSTMap<K, V> {
    static int[] prim = FSTObject2IntMap.prim;
    private static final int GROFAC = 2;
    public Object[] mKeys;
    public Object[] mValues;
    public int mNumberOfElements;
    FSTMap<K, V> next;
    boolean checkClazzOnEquals = false;
    static int miss = 0;
    static int hit = 0;

    public static int adjustSize(int n) {
        int n2 = 0;
        while (n2 < prim.length - 1) {
            if (n < prim[n2]) {
                return prim[n2];
            }
            ++n2;
        }
        return n;
    }

    public FSTMap(int n) {
        if (n < 2) {
            n = 2;
        }
        n = FSTMap.adjustSize(n * 2);
        this.mKeys = new Object[n];
        this.mValues = new Object[n];
        this.mNumberOfElements = 0;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(K k, V v) {
        int n = k.hashCode() & Integer.MAX_VALUE;
        this.putHash(k, v, n, this);
    }

    final void putHash(K k, V v, int n, FSTMap<K, V> fSTMap) {
        int n2;
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (fSTMap != null && (fSTMap.mNumberOfElements + this.mNumberOfElements) * 2 > fSTMap.mKeys.length) {
                fSTMap.resize(fSTMap.mKeys.length * 2);
                fSTMap.put(k, v);
                return;
            }
            this.resize(this.mKeys.length * 2);
        }
        if (this.mKeys[n2 = n % this.mKeys.length] == null) {
            ++this.mNumberOfElements;
            this.mValues[n2] = v;
            this.mKeys[n2] = k;
        } else if (this.mKeys[n2].equals(k) && (!this.checkClazzOnEquals || this.mKeys[n2].getClass() == k.getClass())) {
            this.mValues[n2] = v;
        } else {
            this.putNext(n, k, v);
        }
    }

    final K removeHash(K k, int n) {
        int n2 = n % this.mKeys.length;
        Object object = this.mKeys[n2];
        if (object == null) {
            return null;
        }
        if (object.equals(k) && (!this.checkClazzOnEquals || this.mKeys[n2].getClass() == k.getClass())) {
            Object object2 = this.mKeys[n2];
            this.mValues[n2] = 0;
            this.mKeys[n2] = null;
            --this.mNumberOfElements;
            return (K)object2;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.removeHash(k, n);
    }

    final void putNext(int n, K k, V v) {
        if (this.next == null) {
            int n2 = this.mNumberOfElements / 3;
            this.next = new FSTMap<K, V>(n2);
        }
        this.next.putHash(k, v, n, this);
    }

    public final V get(K k) {
        int n = k.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.mKeys.length;
        Object object = this.mKeys[n2];
        if (object == null) {
            return null;
        }
        if (object.equals(k) && (!this.checkClazzOnEquals || object.getClass() == k.getClass())) {
            return (V)this.mValues[n2];
        }
        if (this.next == null) {
            return null;
        }
        V v = this.next.getHash(k, n);
        return v;
    }

    final V getHash(K k, int n) {
        int n2 = n % this.mKeys.length;
        Object object = this.mKeys[n2];
        if (object == null) {
            return null;
        }
        if (object.equals(k) && (!this.checkClazzOnEquals || object.getClass() == k.getClass())) {
            return (V)this.mValues[n2];
        }
        if (this.next == null) {
            return null;
        }
        V v = this.next.getHash(k, n);
        return v;
    }

    final void resize(int n) {
        n = FSTMap.adjustSize(n);
        Object[] objectArray = this.mKeys;
        Object[] objectArray2 = this.mValues;
        this.mKeys = new Object[n];
        this.mValues = new Object[n];
        this.mNumberOfElements = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                this.put(objectArray[n2], objectArray2[n2]);
            }
            ++n2;
        }
        if (this.next != null) {
            FSTMap<K, V> fSTMap = this.next;
            this.next = null;
            fSTMap.rePut(this);
        }
    }

    private void rePut(FSTMap<K, V> fSTMap) {
        int n = 0;
        while (n < this.mKeys.length) {
            Object object = this.mKeys[n];
            if (object != null) {
                fSTMap.put(object, this.mValues[n]);
            }
            ++n;
        }
        if (this.next != null) {
            this.next.rePut(fSTMap);
        }
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }
}

