/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import java.io.InputStream;
import java.io.ObjectStreamField;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import sun.misc.Unsafe;

public class FSTUtil {
    static Object[] EmptyObjArray = new Object[10000];
    static ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    public static Unsafe unFlaggedUnsafe = FSTUtil.getUnsafe();
    public static final long refoff;
    public static final long refscal;
    public static final long bufoff;
    public static final long choff;
    public static final long intoff;
    public static final long longoff;
    public static final long doubleoff;
    public static final long floatoff;
    public static final long intscal;
    public static final long longscal;
    public static final long chscal;
    public static final long floatscal;
    public static final long doublescal;

    static {
        if (unFlaggedUnsafe != null) {
            refoff = unFlaggedUnsafe.arrayBaseOffset(Object[].class);
            bufoff = unFlaggedUnsafe.arrayBaseOffset(byte[].class);
            intoff = unFlaggedUnsafe.arrayBaseOffset(int[].class);
            longoff = unFlaggedUnsafe.arrayBaseOffset(long[].class);
            longscal = unFlaggedUnsafe.arrayIndexScale(long[].class);
            intscal = unFlaggedUnsafe.arrayIndexScale(int[].class);
            chscal = unFlaggedUnsafe.arrayIndexScale(char[].class);
            refscal = unFlaggedUnsafe.arrayIndexScale(Object[].class);
            choff = unFlaggedUnsafe.arrayBaseOffset(char[].class);
            doubleoff = unFlaggedUnsafe.arrayBaseOffset(double[].class);
            doublescal = unFlaggedUnsafe.arrayIndexScale(double[].class);
            floatoff = unFlaggedUnsafe.arrayBaseOffset(float[].class);
            floatscal = unFlaggedUnsafe.arrayIndexScale(float[].class);
        } else {
            refscal = 0L;
            refoff = 0L;
            longoff = 0L;
            longscal = 0L;
            bufoff = 0L;
            intoff = 0L;
            intscal = 0L;
            choff = 0L;
            chscal = 0L;
            doublescal = 0L;
            doubleoff = 0L;
            floatscal = 0L;
            floatoff = 0L;
        }
    }

    public static void clear(int[] nArray) {
        Arrays.fill(nArray, 0);
    }

    public static void clear(Object[] objectArray) {
        int n = objectArray.length;
        FSTUtil.clear(objectArray, n);
    }

    public static void clear(Object[] objectArray, int n) {
        int n2 = 0;
        int n3 = EmptyObjArray.length;
        while (n - n2 > n3) {
            System.arraycopy(EmptyObjArray, 0, objectArray, n2, n3);
            n2 += n3;
        }
        System.arraycopy(EmptyObjArray, 0, objectArray, n2, n - n2);
    }

    public static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return throwable.getClass().getSimpleName() + ":" + throwable.getMessage() + "\n" + stringWriter.toString();
    }

    public static <T extends Throwable> void rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static String getPackage(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(91);
        if (n >= 0) {
            string = string.substring(n + 2);
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static boolean isPackEq(Class<?> clazz, Class<?> clazz2) {
        return FSTUtil.getPackage(clazz).equals(FSTUtil.getPackage(clazz2));
    }

    public static Method findPrivateMethod(Class<?> clazz, String string, Class[] classArray, Class<?> clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            int n = method.getModifiers();
            if (method.getReturnType() == clazz2 && (n & 2) != 0 && (n & 8) == 0) {
                method.setAccessible(true);
                return method;
            }
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method findDerivedMethod(Class<?> clazz, String string, Class[] classArray, Class<?> clazz2) {
        Method method = null;
        Class<?> clazz3 = clazz;
        while (clazz3 != null) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz3 = clazz3.getSuperclass();
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        int n = method.getModifiers();
        if ((n & 0x408) != 0) {
            return null;
        }
        if ((n & 5) != 0) {
            method.setAccessible(true);
            return method;
        }
        if ((n & 2) != 0) {
            method.setAccessible(true);
            if (clazz == clazz3) {
                return method;
            }
        } else {
            method.setAccessible(true);
            if (FSTUtil.isPackEq(clazz, clazz3)) {
                return method;
            }
        }
        return null;
    }

    public static void printEx(Throwable throwable) {
        while (throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        throwable.printStackTrace();
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            return clazz.isPrimitive();
        }
        return FSTUtil.isPrimitiveArray(clazz.getComponentType());
    }

    public static Unsafe getUnsafe() {
        try {
            if (unFlaggedUnsafe != null) {
                return unFlaggedUnsafe;
            }
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int writeSignedVarInt(int n, byte[] byArray, int n2) {
        return FSTUtil.writeUnsignedVarInt(n << 1 ^ n >> 31, byArray, n2);
    }

    public static int writeUnsignedVarInt(int n, byte[] byArray, int n2) {
        while ((long)(n & 0xFFFFFF80) != 0L) {
            byArray[n2++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        byArray[n2++] = (byte)(n & 0x7F);
        return n2;
    }

    public static List<Field> getAllFields(List<Field> list, Class<?> clazz) {
        list.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            list = FSTUtil.getAllFields(list, clazz.getSuperclass());
        }
        return list;
    }

    public static byte[] readAll(InputStream inputStream) throws Exception {
        int n = 0;
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            int n3;
            if (n >= byArray.length) {
                n3 = byArray.length * 2;
                if (byArray.length < n + n3) {
                    byArray = Arrays.copyOf(byArray, n + n3);
                }
            } else {
                n3 = byArray.length - n;
            }
            if ((n2 = inputStream.read(byArray, n, n3)) < 0) {
                if (n == byArray.length) break;
                byArray = Arrays.copyOf(byArray, n);
                break;
            }
            n += n2;
        }
        return byArray;
    }

    public static int nextPow2(int n) {
        return 1 << (n == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    public static Class<?> getRealEnumClass(Class<?> clazz) {
        if (clazz.isAnonymousClass()) {
            return clazz.getSuperclass();
        }
        return clazz;
    }
}

