/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import gama.dev.DEBUG;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class FSTOutputStream
extends OutputStream {
    public byte[] buf;
    public int pos;
    OutputStream outstream;
    private int off;

    public FSTOutputStream(OutputStream outputStream) {
        this(4000, outputStream);
    }

    public FSTOutputStream(int n, OutputStream outputStream) {
        this.buf = new byte[n];
        this.outstream = outputStream;
    }

    public OutputStream getOutstream() {
        return this.outstream;
    }

    public void setOutstream(OutputStream outputStream) {
        this.outstream = outputStream;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public void setBuf(byte[] byArray) {
        this.buf = byArray;
    }

    public void ensureFree(int n) throws IOException {
        if (this.pos + n - this.buf.length > 0) {
            this.grow(this.pos + n);
        }
    }

    public void ensureCapacity(int n) throws IOException {
        if (n - this.buf.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.buf.length;
        int n3 = n2 * 2;
        if (n2 > 0x3200000) {
            n3 = n + 0x1400000;
        } else if (n2 < 1001) {
            n3 = 4000;
        }
        if (n3 - n < 0) {
            n3 = n;
        }
        try {
            this.buf = Arrays.copyOf(this.buf, n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            DEBUG.ERR((Object)("OME resize from " + this.buf.length + " to " + n3 + " clearing caches .."), (Throwable)outOfMemoryError);
            throw new RuntimeException(outOfMemoryError);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.ensureCapacity(this.pos + 1);
        this.buf[this.pos] = (byte)n;
        ++this.pos;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureCapacity(this.pos + n2);
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
    }

    public void copyTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.pos);
    }

    public void reset() {
        this.pos = 0;
        this.off = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    public int size() {
        return this.pos;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.outstream != this) {
            this.outstream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pos > 0 && this.outstream != null && this.outstream != this) {
            this.copyTo(this.outstream);
            this.off = this.pos;
            this.reset();
        }
        if (this.outstream != this && this.outstream != null) {
            this.outstream.flush();
        }
    }

    public void reset(byte[] byArray) {
        this.reset();
        this.buf = byArray;
    }

    public int getOff() {
        return this.off;
    }
}

