/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.serialize.binary;

import gama.core.common.interfaces.ISerialisationConstants;
import gama.core.kernel.experiment.ISimulationRecorder;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.dev.DEBUG;
import gama.extension.serialize.binary.BinarySerialiser;
import gama.extension.serialize.binary.SimulationHistory;

public class SimulationSerialiser
implements ISimulationRecorder,
ISerialisationConstants {
    final BinarySerialiser processor = new BinarySerialiser();

    static {
        DEBUG.OFF();
    }

    public void record(SimulationAgent simulationAgent) {
        try {
            byte[] byArray = this.processor.saveObjectToBytes(simulationAgent.getScope(), simulationAgent);
            SimulationHistory simulationHistory = this.getSimulationHistory(simulationAgent);
            simulationHistory.push(byArray, simulationAgent.getClock().getCycle());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private SimulationHistory getSimulationHistory(SimulationAgent simulationAgent) {
        SimulationHistory simulationHistory = (SimulationHistory)simulationAgent.getAttribute("**history**");
        if (simulationHistory == null) {
            simulationHistory = new SimulationHistory();
            simulationAgent.setAttribute("**history**", (Object)simulationHistory);
        }
        return simulationHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(SimulationAgent simulationAgent) {
        try {
            SimulationAgent simulationAgent2 = simulationAgent;
            synchronized (simulationAgent2) {
                SimulationHistory simulationHistory = this.getSimulationHistory(simulationAgent);
                SimulationHistory.SimulationHistoryNode simulationHistoryNode = (SimulationHistory.SimulationHistoryNode)simulationHistory.pop();
                if (simulationHistoryNode != null && simulationHistoryNode.cycle() == (long)simulationAgent.getClock().getCycle()) {
                    simulationHistoryNode = (SimulationHistory.SimulationHistoryNode)simulationHistory.pop();
                }
                if (simulationHistoryNode != null) {
                    this.processor.restoreAgentFromBytes((IAgent)simulationAgent, simulationHistoryNode.bytes());
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean canStepBack(SimulationAgent simulationAgent) {
        return this.getSimulationHistory(simulationAgent).size() > 0;
    }
}

