/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.serialize.gaml;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.IGamaFile;
import gama.extension.serialize.binary.BinarySerialisation;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="target", type={11}, optional=false, doc={@GamlAnnotations.doc(value="The agent to restore. Its attributes will be replaced by the ones stored in the file or string. No verification is done regarding the compatibility ")}), @GamlAnnotations.facet(name="from", type={4, 12}, optional=false, doc={@GamlAnnotations.doc(value="The file or the string from which to restore the agent")})}, omissible="target")
@GamlAnnotations.doc(value="Allows to restore any agent that has been previously serialised or saved to a file, e.g. `string s <- serialize(a);` ...  `restore a from: s;` or `save simulation to: 'sim.gsim' format: 'binary';` ... `restore simulation from: file('sim.gsim');`")
public class RestoreStatement
extends AbstractStatement {
    private final IExpression from = this.getFacet(new String[]{"from"});
    private final IExpression target = this.getFacet(new String[]{"target"});

    public RestoreStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("restore");
    }

    public IAgent privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = Cast.asAgent((IScope)iScope, (Object)this.target.value(iScope));
        if (iAgent == null) {
            return null;
        }
        if (this.from == null) {
            return iAgent;
        }
        Object object = this.from.value(iScope);
        if (object instanceof String) {
            String string = (String)object;
            BinarySerialisation.restoreFromString(iAgent, string);
        } else if (object instanceof IGamaFile) {
            IGamaFile iGamaFile = (IGamaFile)object;
            BinarySerialisation.restoreFromFile(iAgent, iGamaFile.getPath(iScope));
        }
        return iAgent;
    }
}

