/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.nustaq.serialization.FSTClassInstantiator;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.annotations.AnonymousTransient;
import org.nustaq.serialization.annotations.Conditional;
import org.nustaq.serialization.annotations.Flat;
import org.nustaq.serialization.annotations.OneOf;
import org.nustaq.serialization.annotations.Predict;
import org.nustaq.serialization.annotations.Serialize;
import org.nustaq.serialization.annotations.Transient;
import org.nustaq.serialization.annotations.Version;
import org.nustaq.serialization.util.FSTMap;
import org.nustaq.serialization.util.FSTUtil;

public final class FSTClazzInfo {
    public static boolean BufferConstructorMeta = true;
    public static boolean BufferFieldMeta = true;
    public static ConcurrentHashMap<Class, Field[]> sharedFieldSets = new ConcurrentHashMap();
    public static final Comparator<FSTFieldInfo> defFieldComparator = (fSTFieldInfo, fSTFieldInfo2) -> {
        int n = 0;
        if (fSTFieldInfo.getVersion() != fSTFieldInfo2.getVersion()) {
            return fSTFieldInfo.getVersion() < fSTFieldInfo2.getVersion() ? -1 : 1;
        }
        if (fSTFieldInfo.getType() == Boolean.TYPE && fSTFieldInfo2.getType() != Boolean.TYPE) {
            return -1;
        }
        if (fSTFieldInfo.getType() != Boolean.TYPE && fSTFieldInfo2.getType() == Boolean.TYPE) {
            return 1;
        }
        if (fSTFieldInfo.isConditional() && !fSTFieldInfo2.isConditional()) {
            n = 1;
        } else if (!fSTFieldInfo.isConditional() && fSTFieldInfo2.isConditional() || fSTFieldInfo.isPrimitive() && !fSTFieldInfo2.isPrimitive()) {
            n = -1;
        } else if (!fSTFieldInfo.isPrimitive() && fSTFieldInfo2.isPrimitive()) {
            n = 1;
        }
        if (n == 0) {
            n = fSTFieldInfo.getType().getSimpleName().compareTo(fSTFieldInfo2.getType().getSimpleName());
        }
        if (n == 0) {
            n = fSTFieldInfo.getName().compareTo(fSTFieldInfo2.getName());
        }
        if (n == 0) {
            return fSTFieldInfo.getField().getDeclaringClass().getName().compareTo(fSTFieldInfo2.getField().getDeclaringClass().getName());
        }
        return n;
    };
    Class[] predict;
    private final boolean ignoreAnn;
    FSTMap<String, FSTFieldInfo> fieldMap;
    Method writeReplaceMethod;
    Method readResolveMethod;
    FSTMap<Class, FSTCompatibilityInfo> compInfo;
    Object decoderAttached;
    boolean requiresCompatibleMode;
    boolean externalizable;
    boolean flat;
    boolean isAsciiNameShortString = false;
    boolean requiresInit = false;
    boolean hasTransient;
    FSTObjectSerializer ser;
    FSTFieldInfo[] fieldInfo;
    Class clazz;
    Object[] enumConstants;
    Constructor cons;
    int clzId = -1;
    int structSize = 0;
    FSTConfiguration conf;
    protected FSTClassInstantiator instantiator;
    boolean crossPlatform;
    byte[] bufferedName;
    static ReentrantLock shareLock = new ReentrantLock(false);
    static AtomicInteger fiCount = new AtomicInteger(0);
    static AtomicInteger missCount = new AtomicInteger(0);

    public Object getDecoderAttached() {
        return this.decoderAttached;
    }

    public void setDecoderAttached(Object object) {
        this.decoderAttached = object;
    }

    public FSTClazzInfo(FSTConfiguration fSTConfiguration, Class<?> clazz, FSTClazzInfoRegistry fSTClazzInfoRegistry, boolean bl) {
        Object object;
        this.conf = fSTConfiguration;
        this.crossPlatform = fSTConfiguration.isCrossPlatform();
        this.clazz = clazz;
        this.enumConstants = clazz.getEnumConstants();
        this.ignoreAnn = bl;
        this.createFields(clazz);
        this.instantiator = fSTConfiguration.getInstantiator(clazz);
        if (Externalizable.class.isAssignableFrom(clazz)) {
            this.externalizable = true;
            this.cons = this.instantiator.findConstructorForExternalize(clazz);
        } else {
            if (!Serializable.class.isAssignableFrom(clazz) && clazz != Object.class && !fSTConfiguration.isForceSerializable() && this.getSer() == null) {
                throw new RuntimeException("Class " + clazz.getName() + " does not implement Serializable or externalizable");
            }
            this.externalizable = false;
            this.cons = this.instantiator.findConstructorForSerializable(clazz);
        }
        if (!bl) {
            object = clazz.getAnnotation(Predict.class);
            if (object != null) {
                this.predict = object.value();
            }
            this.flat = clazz.isAnnotationPresent(Flat.class);
        }
        if (this.cons != null) {
            this.cons.setAccessible(true);
        }
        if (((String)(object = clazz.getName())).length() < 127) {
            this.isAsciiNameShortString = true;
            int n = 0;
            while (n < ((String)object).length()) {
                if (((String)object).charAt(n) > '\u007f') {
                    this.isAsciiNameShortString = false;
                    break;
                }
                ++n;
            }
        }
        boolean bl2 = this.requiresInit = this.isExternalizable() || this.useCompatibleMode() || this.hasTransient;
        if (this.useCompatibleMode() && this.crossPlatform && this.getSer() == null && !clazz.isEnum()) {
            throw new RuntimeException("cannot support legacy JDK serialization methods in crossplatform mode. Define a serializer for this class " + clazz.getName());
        }
    }

    public byte[] getBufferedName() {
        if (this.bufferedName == null) {
            this.bufferedName = this.getClazz().getName().getBytes();
        }
        return this.bufferedName;
    }

    public String toString() {
        return "FSTClazzInfo{clazz=" + String.valueOf(this.clazz) + "}";
    }

    public boolean isAsciiNameShortString() {
        return this.isAsciiNameShortString;
    }

    public int getClzId() {
        return this.clzId;
    }

    public void setClzId(int n) {
        this.clzId = n;
    }

    public int getNumBoolFields() {
        FSTFieldInfo[] fSTFieldInfoArray = this.getFieldInfo();
        int n = 0;
        while (n < fSTFieldInfoArray.length) {
            FSTFieldInfo fSTFieldInfo = fSTFieldInfoArray[n];
            if (fSTFieldInfo.getType() != Boolean.TYPE) {
                return n;
            }
            ++n;
        }
        return fSTFieldInfoArray.length;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public Class[] getPredict() {
        return this.predict;
    }

    public Object newInstance(boolean bl) {
        return this.instantiator.newInstance(this.clazz, this.cons, bl || this.requiresInit, this.conf.isForceSerializable());
    }

    public List<Field> getAllFields(Class clazz, List<Field> list) {
        try {
            Field field;
            Field[] fieldArray;
            if (BufferFieldMeta) {
                shareLock.lock();
            }
            if (list == null) {
                list = new ArrayList<Field>();
            }
            if (clazz == null) {
                List<Field> list2 = list;
                return list2;
            }
            Field[] fieldArray2 = fieldArray = BufferFieldMeta && !this.conf.isStructMode() ? sharedFieldSets.get(clazz) : null;
            if (fieldArray == null) {
                fieldArray = clazz.getDeclaredFields();
                if (BufferFieldMeta && !this.conf.isStructMode()) {
                    sharedFieldSets.put(clazz, fieldArray);
                }
            }
            List list3 = Arrays.asList(fieldArray);
            Collections.reverse(list3);
            int n = 0;
            while (n < list3.size()) {
                field = (Field)list3.get(n);
                list.add(0, field);
                ++n;
            }
            n = 0;
            while (n < list.size()) {
                field = list.get(n);
                if (Modifier.isStatic(field.getModifiers()) || this.isTransient(clazz, field)) {
                    if (this.isTransient(clazz, field)) {
                        this.hasTransient = true;
                    }
                    list.remove(n);
                    --n;
                }
                ++n;
            }
            List<Field> list4 = this.getAllFields(clazz.getSuperclass(), list);
            ArrayList<Field> arrayList = new ArrayList<Field>(list4);
            return arrayList;
        }
        finally {
            if (BufferFieldMeta) {
                shareLock.unlock();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isTransient(Class<?> var1_1, Field var2_2) {
        if (!Modifier.isTransient(var2_2.getModifiers())) ** GOTO lbl4
        return true;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getSuperclass();
lbl4:
            // 2 sources

            ** while (var1_1.getName().indexOf((String)"$") >= 0)
        }
lbl5:
        // 1 sources

        if (var2_2.getName().startsWith("this$") && var1_1.getAnnotation(AnonymousTransient.class) != null) {
            return true;
        }
        return var1_1.getAnnotation(Transient.class) != null && var2_2.getAnnotation(Serialize.class) == null;
    }

    public FSTFieldInfo[] getFieldInfo() {
        return this.fieldInfo;
    }

    public final FSTFieldInfo[] getFieldInfoFiltered(Class ... classArray) {
        int n;
        FSTFieldInfo[] fSTFieldInfoArray;
        FSTFieldInfo[] fSTFieldInfoArray2 = this.getFieldInfo();
        int n2 = 0;
        FSTFieldInfo[] fSTFieldInfoArray3 = fSTFieldInfoArray2;
        int n3 = fSTFieldInfoArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            fSTFieldInfoArray = fSTFieldInfoArray3[n4];
            boolean bl = false;
            Class[] classArray2 = classArray;
            n = classArray.length;
            int n5 = 0;
            while (n5 < n) {
                Class clazz = classArray2[n5];
                if (fSTFieldInfoArray.getField().getDeclaringClass() == clazz) {
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                ++n2;
            }
            ++n4;
        }
        fSTFieldInfoArray = new FSTFieldInfo[n2];
        n2 = 0;
        FSTFieldInfo[] fSTFieldInfoArray4 = fSTFieldInfoArray2;
        int n6 = fSTFieldInfoArray2.length;
        n3 = 0;
        while (n3 < n6) {
            FSTFieldInfo fSTFieldInfo = fSTFieldInfoArray4[n3];
            boolean bl = false;
            Class[] classArray3 = classArray;
            int n7 = classArray.length;
            n = 0;
            while (n < n7) {
                Class clazz = classArray3[n];
                if (fSTFieldInfo.getField().getDeclaringClass() == clazz) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                fSTFieldInfoArray[n2++] = fSTFieldInfo;
            }
            ++n3;
        }
        return fSTFieldInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTFieldInfo getFieldInfo(String string, Class clazz) {
        if (this.fieldMap != null) {
            if (clazz == null) {
                return this.fieldMap.get(string);
            }
            return this.fieldMap.get(clazz.getName() + "#" + string);
        }
        FSTClazzInfo fSTClazzInfo = this;
        synchronized (fSTClazzInfo) {
            this.fieldMap = this.buildFieldMap();
            return this.getFieldInfo(string, clazz);
        }
    }

    private FSTMap<String, FSTFieldInfo> buildFieldMap() {
        FSTMap<String, FSTFieldInfo> fSTMap = new FSTMap<String, FSTFieldInfo>(this.fieldInfo.length);
        FSTFieldInfo[] fSTFieldInfoArray = this.fieldInfo;
        int n = this.fieldInfo.length;
        int n2 = 0;
        while (n2 < n) {
            FSTFieldInfo fSTFieldInfo = fSTFieldInfoArray[n2];
            Field field = fSTFieldInfo.getField();
            if (field != null) {
                fSTMap.put(field.getDeclaringClass().getName() + "#" + field.getName(), fSTFieldInfo);
                fSTMap.put(field.getName(), fSTFieldInfo);
            }
            ++n2;
        }
        return fSTMap;
    }

    private void createFields(Class clazz) {
        int n;
        Object object;
        Class clazz2;
        if (clazz.isInterface() || clazz.isPrimitive()) {
            return;
        }
        List<Field> list = this.getAllFields(clazz, null);
        this.fieldInfo = new FSTFieldInfo[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            Field field = list.get(n2);
            this.fieldInfo[n2] = this.createFieldInfo(field);
            ++n2;
        }
        Comparator comparator = (fSTFieldInfo, fSTFieldInfo2) -> {
            int n = 0;
            n = fSTFieldInfo.getType().getSimpleName().compareTo(fSTFieldInfo2.getType().getSimpleName());
            if (n == 0) {
                n = fSTFieldInfo.getType().getName().compareTo(fSTFieldInfo2.getType().getName());
            }
            if (n == 0) {
                Class<?> clazz = fSTFieldInfo.getType().getDeclaringClass();
                Class<?> clazz2 = fSTFieldInfo2.getType().getDeclaringClass();
                if (clazz == null) {
                    return clazz2 == null ? 0 : -1;
                }
                if (clazz2 == null) {
                    return 1;
                }
                if (n == 0) {
                    return clazz.getName().compareTo(clazz2.getName());
                }
            }
            return n;
        };
        boolean bl = false;
        if (!Externalizable.class.isAssignableFrom(clazz) && this.getSerNoStore() == null) {
            clazz2 = clazz;
            while (clazz2 != Object.class) {
                if (FSTUtil.findPrivateMethod(clazz2, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE) != null || FSTUtil.findPrivateMethod(clazz2, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE) != null || FSTUtil.findDerivedMethod(clazz2, "writeReplace", null, Object.class) != null || FSTUtil.findDerivedMethod(clazz2, "readResolve", null, Object.class) != null) {
                    bl = true;
                    break;
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        if (bl) {
            this.getCompInfo();
            this.fieldMap = this.buildFieldMap();
            clazz2 = clazz;
            list.clear();
            while (clazz2 != Object.class) {
                ObjectStreamClass objectStreamClass = null;
                try {
                    objectStreamClass = ObjectStreamClass.lookup(clazz2);
                }
                catch (Exception exception) {
                    FSTUtil.rethrow(exception);
                }
                if (objectStreamClass != null) {
                    Object object2;
                    ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
                    object = new ArrayList<FSTFieldInfo>();
                    if (objectStreamFieldArray != null) {
                        ObjectStreamField[] objectStreamFieldArray2 = objectStreamFieldArray;
                        int n3 = objectStreamFieldArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            object2 = objectStreamFieldArray2[n4];
                            String string = ((ObjectStreamField)object2).getName();
                            FSTFieldInfo fSTFieldInfo3 = this.fieldMap.get(clazz2.getName() + "#" + string);
                            if (fSTFieldInfo3 != null && fSTFieldInfo3.getField() != null) {
                                object.add(fSTFieldInfo3);
                                list.add(fSTFieldInfo3.getField());
                            } else {
                                FSTFieldInfo fSTFieldInfo4 = new FSTFieldInfo(null, null, true);
                                fSTFieldInfo4.type = ((ObjectStreamField)object2).getType();
                                fSTFieldInfo4.fakeName = ((ObjectStreamField)object2).getName();
                                object.add(fSTFieldInfo4);
                            }
                            ++n4;
                        }
                    }
                    Collections.sort(object, comparator);
                    object2 = new FSTCompatibilityInfo((List<FSTFieldInfo>)object, clazz2);
                    this.getCompInfo().put(clazz2, (FSTCompatibilityInfo)object2);
                    if (((FSTCompatibilityInfo)object2).needsCompatibleMode()) {
                        this.requiresCompatibleMode = true;
                    }
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        clazz2 = defFieldComparator;
        if (!this.conf.isStructMode()) {
            Arrays.sort(this.fieldInfo, clazz2);
        }
        this.structSize = n = 8;
        this.writeReplaceMethod = FSTUtil.findDerivedMethod(clazz, "writeReplace", null, Object.class);
        this.readResolveMethod = FSTUtil.findDerivedMethod(clazz, "readResolve", null, Object.class);
        if (this.writeReplaceMethod != null) {
            this.writeReplaceMethod.setAccessible(true);
        }
        if (this.readResolveMethod != null) {
            this.readResolveMethod.setAccessible(true);
        }
        int n5 = 0;
        while (n5 < this.fieldInfo.length) {
            object = this.fieldInfo[n5];
            ((FSTFieldInfo)object).indexId = n5++;
        }
    }

    public int getStructSize() {
        return this.structSize;
    }

    public boolean useCompatibleMode() {
        return this.requiresCompatibleMode || this.writeReplaceMethod != null || this.readResolveMethod != null;
    }

    protected FSTFieldInfo createFieldInfo(Field field) {
        Object object;
        FSTConfiguration.FieldKey fieldKey = null;
        if (this.conf.fieldInfoCache != null && (object = this.conf.fieldInfoCache.get(fieldKey = new FSTConfiguration.FieldKey(field.getDeclaringClass(), field.getName()))) != null) {
            fiCount.incrementAndGet();
            return object;
        }
        field.setAccessible(true);
        object = this.crossPlatform ? null : field.getAnnotation(Predict.class);
        FSTFieldInfo fSTFieldInfo = new FSTFieldInfo(object != null ? object.value() : null, field, this.ignoreAnn);
        if (this.conf.fieldInfoCache != null && fieldKey != null) {
            this.conf.fieldInfoCache.put(fieldKey, fSTFieldInfo);
        }
        missCount.incrementAndGet();
        return fSTFieldInfo;
    }

    public Method getReadResolveMethod() {
        return this.readResolveMethod;
    }

    public Method getWriteReplaceMethod() {
        return this.writeReplaceMethod;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public Object[] getEnumConstants() {
        return this.enumConstants;
    }

    public FSTMap<Class, FSTCompatibilityInfo> getCompInfo() {
        if (this.compInfo == null) {
            this.compInfo = new FSTMap(3);
        }
        return this.compInfo;
    }

    public FSTObjectSerializer getSer() {
        if (this.ser == null) {
            if (this.clazz == null) {
                return null;
            }
            this.ser = this.getSerNoStore();
            if (this.ser == null) {
                this.ser = FSTSerializerRegistry.NULL;
            }
        }
        if (this.ser == FSTSerializerRegistry.NULL) {
            return null;
        }
        return this.ser;
    }

    public FSTObjectSerializer getSerNoStore() {
        return this.conf.getCLInfoRegistry().getSerializerRegistry().getSerializer(this.clazz);
    }

    static class FSTCompatibilityInfo {
        Method writeMethod;
        Method readMethod;
        ObjectStreamClass objectStreamClass;
        List<FSTFieldInfo> infos;
        Class clazz;
        FSTFieldInfo[] infoArr;

        public FSTCompatibilityInfo(List<FSTFieldInfo> list, Class clazz) {
            this.readClazz(clazz);
            this.infos = list;
            this.clazz = clazz;
        }

        public List<FSTFieldInfo> getFields() {
            return this.infos;
        }

        public FSTFieldInfo[] getFieldArray() {
            if (this.infoArr == null) {
                List<FSTFieldInfo> list = this.getFields();
                FSTFieldInfo[] fSTFieldInfoArray = new FSTFieldInfo[list.size()];
                list.toArray(fSTFieldInfoArray);
                Arrays.sort(fSTFieldInfoArray, defFieldComparator);
                this.infoArr = fSTFieldInfoArray;
            }
            return this.infoArr;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public boolean needsCompatibleMode() {
            return this.writeMethod != null || this.readMethod != null;
        }

        public void readClazz(Class clazz) {
            this.writeMethod = FSTUtil.findPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
            this.readMethod = FSTUtil.findPrivateMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
            if (this.writeMethod != null) {
                this.writeMethod.setAccessible(true);
            }
            if (this.readMethod != null) {
                this.readMethod.setAccessible(true);
            }
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public void setReadMethod(Method method) {
            this.readMethod = method;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setWriteMethod(Method method) {
            this.writeMethod = method;
        }

        public boolean isAsymmetric() {
            return this.getReadMethod() == null && this.getWriteMethod() != null || this.getWriteMethod() == null && this.getReadMethod() != null;
        }
    }

    public static final class FSTFieldInfo {
        public static final int BOOL = 1;
        public static final int BYTE = 2;
        public static final int CHAR = 3;
        public static final int SHORT = 4;
        public static final int INT = 5;
        public static final int LONG = 6;
        public static final int FLOAT = 7;
        public static final int DOUBLE = 8;
        Class[] possibleClasses;
        FSTClazzInfo lastInfo;
        String[] oneOf = null;
        int arrayDim;
        Class arrayType;
        boolean flat = false;
        boolean isConditional = false;
        final Field field;
        Class type;
        boolean integral = false;
        boolean primitive = false;
        boolean isArr = false;
        byte version;
        int integralType;
        long memOffset = -1L;
        int structOffset = 0;
        int indexId;
        int align = 0;
        int alignPad = 0;
        Object bufferedName;
        public String fakeName;

        public FSTFieldInfo(Class[] classArray, Field field, boolean bl) {
            Object object;
            this.possibleClasses = classArray;
            this.field = field;
            if (field == null) {
                this.isArr = false;
            } else {
                this.isArr = this.field.getType().isArray();
                this.type = field.getType();
                this.primitive = this.type.isPrimitive();
                if (FSTUtil.unFlaggedUnsafe != null) {
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers())) {
                        try {
                            this.memOffset = (int)FSTUtil.unFlaggedUnsafe.objectFieldOffset(field);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            if (this.isArray()) {
                object = this.field.getType().getName();
                this.arrayDim = 1 + ((String)object).lastIndexOf(91);
                this.arrayType = this.calcComponentType(this.field.getType());
            }
            this.calcIntegral();
            if (field != null && !bl) {
                this.version = field.isAnnotationPresent(Version.class) ? field.getAnnotation(Version.class).value() : (byte)0;
                this.flat = field.isAnnotationPresent(Flat.class);
                this.isConditional = field.isAnnotationPresent(Conditional.class);
                if (this.isIntegral()) {
                    this.isConditional = false;
                }
                if ((object = field.getAnnotation(OneOf.class)) != null) {
                    this.oneOf = object.value();
                }
            }
        }

        public byte getVersion() {
            return this.version;
        }

        public Object getBufferedName() {
            return this.bufferedName;
        }

        public void setBufferedName(Object object) {
            this.bufferedName = object;
        }

        public int align(int n) {
            while (n / this.align * this.align != n) {
                ++n;
            }
            return n;
        }

        public int getIndexId() {
            return this.indexId;
        }

        public int getStructOffset() {
            return this.structOffset;
        }

        public void setStructOffset(int n) {
            this.structOffset = n;
        }

        public String[] getOneOf() {
            return this.oneOf;
        }

        public long getMemOffset() {
            return this.memOffset;
        }

        public int getAlign() {
            return this.align;
        }

        public int getAlignPad() {
            return this.alignPad;
        }

        public boolean isConditional() {
            return this.isConditional;
        }

        public FSTClazzInfo getLastInfo() {
            return this.lastInfo;
        }

        public void setLastInfo(FSTClazzInfo fSTClazzInfo) {
            this.lastInfo = fSTClazzInfo;
        }

        Class calcComponentType(Class clazz) {
            if (clazz.isArray()) {
                return this.calcComponentType(clazz.getComponentType());
            }
            return clazz;
        }

        public boolean isVolatile() {
            return Modifier.isVolatile(this.getField().getModifiers());
        }

        public Class getType() {
            return this.type;
        }

        public boolean isArray() {
            return this.isArr;
        }

        public int getArrayDepth() {
            return this.arrayDim;
        }

        public Class getArrayType() {
            return this.arrayType;
        }

        public Class[] getPossibleClasses() {
            return this.possibleClasses;
        }

        void setPossibleClasses(Class[] classArray) {
            this.possibleClasses = classArray;
        }

        public Field getField() {
            return this.field;
        }

        public void calcIntegral() {
            if (this.field == null) {
                return;
            }
            if (this.isArray()) {
                this.integral = this.isIntegral(this.getArrayType());
            } else {
                this.integral = this.isIntegral(this.field.getType());
                Class<?> clazz = this.field.getType();
                this.integralType = FSTFieldInfo.getIntegralCode(clazz);
            }
        }

        public static int getIntegralCode(Class clazz) {
            if (clazz == Boolean.TYPE) {
                return 1;
            }
            if (clazz == Byte.TYPE) {
                return 2;
            }
            if (clazz == Character.TYPE) {
                return 3;
            }
            if (clazz == Short.TYPE) {
                return 4;
            }
            if (clazz == Integer.TYPE) {
                return 5;
            }
            if (clazz == Long.TYPE) {
                return 6;
            }
            if (clazz == Float.TYPE) {
                return 7;
            }
            if (clazz == Double.TYPE) {
                return 8;
            }
            return 0;
        }

        public int getIntegralType() {
            return this.integralType;
        }

        public boolean isIntegral(Class clazz) {
            return clazz.isPrimitive();
        }

        public boolean isIntegral() {
            return this.integral;
        }

        public String getDesc() {
            return this.field != null ? "<" + this.field.getName() + " of " + this.field.getDeclaringClass().getSimpleName() + ">" : "<undefined referencee>";
        }

        public String toString() {
            return this.getDesc();
        }

        public boolean isFlat() {
            return this.flat;
        }

        public int getComponentStructSize() {
            if (this.arrayType == Boolean.TYPE || this.arrayType == Byte.TYPE) {
                return 1;
            }
            if (this.arrayType == Character.TYPE || this.arrayType == Short.TYPE) {
                return 2;
            }
            if (this.arrayType == Integer.TYPE || this.arrayType == Float.TYPE) {
                return 4;
            }
            if (this.arrayType == Long.TYPE || this.arrayType == Double.TYPE) {
                return 8;
            }
            return 0;
        }

        public int getStructSize() {
            if (this.type == Boolean.TYPE || this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE || this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE || this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE || this.type == Double.TYPE) {
                return 8;
            }
            if (this.isArray()) {
                if (this.isIntegral()) {
                    return 8;
                }
                return 16;
            }
            return 4;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public int getByteValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getByte(object, this.memOffset);
            }
            return this.field.getByte(object);
        }

        public int getCharValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getChar(object, this.memOffset);
            }
            return this.field.getChar(object);
        }

        public int getShortValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getShort(object, this.memOffset);
            }
            return this.field.getShort(object);
        }

        public int getIntValueUnsafe(Object object) throws IllegalAccessException {
            return FSTUtil.unFlaggedUnsafe.getInt(object, this.memOffset);
        }

        public long getLongValueUnsafe(Object object) throws IllegalAccessException {
            return FSTUtil.unFlaggedUnsafe.getLong(object, this.memOffset);
        }

        public boolean getBooleanValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getBoolean(object, this.memOffset);
            }
            return this.field.getBoolean(object);
        }

        public Object getObjectValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getObject(object, this.memOffset);
            }
            return this.field.get(object);
        }

        public float getFloatValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getFloat(object, this.memOffset);
            }
            return this.field.getFloat(object);
        }

        public void setCharValue(Object object, char c) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putChar(object, this.memOffset, c);
                return;
            }
            this.field.setChar(object, c);
        }

        public void setShortValue(Object object, short s) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putShort(object, this.memOffset, s);
                return;
            }
            this.field.setShort(object, s);
        }

        public void setObjectValue(Object object, Object object2) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putObject(object, this.memOffset, object2);
                return;
            }
            this.field.set(object, object2);
        }

        public void setFloatValue(Object object, float f) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putFloat(object, this.memOffset, f);
                return;
            }
            this.field.setFloat(object, f);
        }

        public void setDoubleValue(Object object, double d) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putDouble(object, this.memOffset, d);
                return;
            }
            this.field.setDouble(object, d);
        }

        public void setLongValue(Object object, long l) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putLong(object, this.memOffset, l);
                return;
            }
            this.field.setLong(object, l);
        }

        public long getLongValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getLong(object, this.memOffset);
            }
            return this.field.getLong(object);
        }

        public double getDoubleValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getDouble(object, this.memOffset);
            }
            return this.field.getDouble(object);
        }

        public void setIntValue(Object object, int n) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putInt(object, this.memOffset, n);
                return;
            }
            this.field.setInt(object, n);
        }

        public int getIntValue(Object object) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getInt(object, this.memOffset);
            }
            return this.field.getInt(object);
        }

        public void setBooleanValue(Object object, boolean bl) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putBoolean(object, this.memOffset, bl);
                return;
            }
            this.field.setBoolean(object, bl);
        }

        public void setByteValue(Object object, byte by) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putByte(object, this.memOffset, by);
                return;
            }
            this.field.setByte(object, by);
        }

        public String getName() {
            return this.field != null ? this.field.getName() : this.fakeName;
        }
    }
}

