/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.sound;

import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import java.io.File;
import java.util.Map;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerEvent;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;

public class GamaSoundPlayer {
    public static final String OVERWRITE_MODE = "overwrite";
    final BasicPlayer basicPlayer = new BasicPlayer();
    Boolean repeat = false;
    volatile boolean agentDiedOrSimDisposed = false;
    Boolean endOfMedia = false;
    Boolean playerStopped = false;

    public GamaSoundPlayer() {
        this.basicPlayer.addBasicPlayerListener(new MyBasicPlayerListener());
    }

    void repeatSound(IScope iScope) {
        if (!this.agentDiedOrSimDisposed) {
            try {
                this.basicPlayer.play();
            }
            catch (BasicPlayerException basicPlayerException) {
                throw GamaRuntimeException.error((String)"Failed to replay sound", (IScope)iScope);
            }
        }
    }

    public void play(IScope iScope, File file, String string, boolean bl) throws GamaRuntimeException {
        try {
            int n = this.basicPlayer.getStatus();
            if (n == -1 || n == 2) {
                this.basicPlayer.open(file);
                this.basicPlayer.play();
            } else if ((n == 0 || n == 1) && OVERWRITE_MODE.equals(string)) {
                this.basicPlayer.stop();
                this.basicPlayer.open(file);
                this.basicPlayer.play();
            }
            this.repeat = bl;
        }
        catch (BasicPlayerException basicPlayerException) {
            basicPlayerException.printStackTrace();
            throw GamaRuntimeException.error((String)basicPlayerException.getMessage(), (IScope)iScope);
        }
    }

    public void stop(IScope iScope, boolean bl) throws GamaRuntimeException {
        this.agentDiedOrSimDisposed = bl;
        try {
            this.endOfMedia = true;
            this.basicPlayer.stop();
        }
        catch (BasicPlayerException basicPlayerException) {
            basicPlayerException.printStackTrace();
            throw GamaRuntimeException.error((String)"Failed to stop sound player", (IScope)iScope);
        }
    }

    public void pause(IScope iScope) throws GamaRuntimeException {
        try {
            this.basicPlayer.pause();
        }
        catch (BasicPlayerException basicPlayerException) {
            basicPlayerException.printStackTrace();
            throw GamaRuntimeException.error((String)"Failed to pause sound player", (IScope)iScope);
        }
    }

    public void resume(IScope iScope) throws GamaRuntimeException {
        try {
            this.basicPlayer.resume();
        }
        catch (BasicPlayerException basicPlayerException) {
            basicPlayerException.printStackTrace();
            throw GamaRuntimeException.error((String)"Failed to resume sound player", (IScope)iScope);
        }
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean canBeReused() {
        return this.repeat == false && this.playerStopped != false;
    }

    class MyBasicPlayerListener
    implements BasicPlayerListener {
        MyBasicPlayerListener() {
        }

        @Override
        public void opened(Object object, Map map) {
        }

        @Override
        public void progress(int n, long l, byte[] byArray, Map map) {
        }

        @Override
        public void stateUpdated(BasicPlayerEvent basicPlayerEvent) {
            if (basicPlayerEvent.getCode() == 8 && GamaSoundPlayer.this.repeat.booleanValue()) {
                GamaSoundPlayer.this.endOfMedia = true;
            }
            if (basicPlayerEvent.getCode() == 3) {
                if (GamaSoundPlayer.this.repeat.booleanValue() && GamaSoundPlayer.this.endOfMedia.booleanValue()) {
                    GamaSoundPlayer.this.endOfMedia = false;
                    GamaSoundPlayer.this.repeatSound(GAMA.getRuntimeScope());
                }
                GamaSoundPlayer.this.playerStopped = true;
            }
        }

        @Override
        public void setController(BasicController basicController) {
        }
    }
}

