/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.sound;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.sound.GamaSoundPlayer;
import gama.extension.sound.SoundPlayerBroker;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;

@GamlAnnotations.doc(value="Allows to pause the sound output")
@GamlAnnotations.inside(kinds={3, 11, 6, 5})
@validator(value=PauseSoundValidator.class)
public class PauseSoundStatement
extends AbstractStatementSequence {
    private AbstractStatementSequence sequence = null;

    public PauseSoundStatement(IDescription iDescription) {
        super(iDescription);
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new AbstractStatementSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        GamaSoundPlayer gamaSoundPlayer = SoundPlayerBroker.getInstance().getSoundPlayer(iAgent);
        gamaSoundPlayer.pause(iScope);
        if (this.sequence != null) {
            iScope.execute((IExecutable)this.sequence, iAgent, null);
        }
        return null;
    }

    public static class PauseSoundValidator
    implements IDescriptionValidator<IDescription> {
        public void validate(IDescription iDescription) {
        }
    }
}

