/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.sound;

import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.sound.GamaSoundPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SoundPlayerBroker {
    private static final int MAX_NB_OF_MUSIC_PLAYERS = 2;
    private final List<GamaSoundPlayer> soundPlayerPools = Collections.synchronizedList(new ArrayList(2));
    private static Map<SimulationAgent, Map<IAgent, GamaSoundPlayer>> soundPlayerOfAgents = new HashMap<SimulationAgent, Map<IAgent, GamaSoundPlayer>>();
    private static volatile SoundPlayerBroker broker = null;

    public static SoundPlayerBroker getInstance() {
        if (broker == null) {
            broker = new SoundPlayerBroker();
        }
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGamaSoundPlayer() {
        List<GamaSoundPlayer> list = this.soundPlayerPools;
        synchronized (list) {
            int n = 0;
            while (n < 2) {
                this.soundPlayerPools.add(new GamaSoundPlayer());
                ++n;
            }
        }
    }

    private SoundPlayerBroker() {
        this.initializeGamaSoundPlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GamaSoundPlayer getSoundPlayer(IAgent iAgent) {
        Map<SimulationAgent, Map<IAgent, GamaSoundPlayer>> map = soundPlayerOfAgents;
        synchronized (map) {
            GamaSoundPlayer gamaSoundPlayer;
            IScope iScope2 = iAgent.getScope();
            SimulationAgent simulationAgent = iScope2.getSimulation();
            Map<IAgent, GamaSoundPlayer> map2 = soundPlayerOfAgents.get(simulationAgent);
            if (map2 == null) {
                map2 = new HashMap<IAgent, GamaSoundPlayer>();
                soundPlayerOfAgents.put(simulationAgent, map2);
                simulationAgent.postEndAction(iScope -> {
                    broker.manageMusicPlayers(simulationAgent);
                    return null;
                });
                simulationAgent.postDisposeAction(iScope -> {
                    broker.schedulerDisposed(simulationAgent);
                    return null;
                });
            }
            if ((gamaSoundPlayer = map2.get(iAgent)) == null) {
                List<GamaSoundPlayer> list = this.soundPlayerPools;
                synchronized (list) {
                    if (!this.soundPlayerPools.isEmpty()) {
                        gamaSoundPlayer = this.soundPlayerPools.remove(0);
                        map2.put(iAgent, gamaSoundPlayer);
                    }
                }
            }
            return gamaSoundPlayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageMusicPlayers(SimulationAgent simulationAgent) throws GamaRuntimeException {
        Object object3;
        GamaSoundPlayer gamaSoundPlayer;
        Object object22;
        Map<IAgent, GamaSoundPlayer> map = soundPlayerOfAgents.get(simulationAgent);
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>();
        for (Object object22 : map.keySet()) {
            if (!object22.dead()) continue;
            arrayList.add((IAgent)object22);
        }
        for (Object object22 : arrayList) {
            gamaSoundPlayer = map.get(object22);
            gamaSoundPlayer.stop(object22.getScope(), true);
            map.remove(object22);
            object3 = this.soundPlayerPools;
            synchronized (object3) {
                this.soundPlayerPools.add(new GamaSoundPlayer());
            }
        }
        object22 = soundPlayerOfAgents;
        synchronized (object22) {
            ArrayList arrayList2 = new ArrayList();
            for (Object object3 : map.keySet()) {
                gamaSoundPlayer = map.get(object3);
                if (!gamaSoundPlayer.canBeReused()) continue;
                arrayList2.add(object3);
            }
            Iterator<Object> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                object3 = (IAgent)iterator.next();
                map.remove(object3);
                List<GamaSoundPlayer> list = this.soundPlayerPools;
                synchronized (list) {
                    this.soundPlayerPools.add(new GamaSoundPlayer());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulerDisposed(SimulationAgent simulationAgent) throws GamaRuntimeException {
        Map<IAgent, GamaSoundPlayer> map = soundPlayerOfAgents.get(simulationAgent);
        if (map != null) {
            for (GamaSoundPlayer object2 : map.values()) {
                object2.stop(simulationAgent.getScope(), true);
            }
            List<GamaSoundPlayer> list = this.soundPlayerPools;
            synchronized (list) {
                this.soundPlayerPools.clear();
                this.initializeGamaSoundPlayer();
            }
            map.clear();
            soundPlayerOfAgents.remove(simulationAgent);
        }
    }
}

