/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.stats;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.filter.In;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Containers;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapComparison {
    @GamlAnnotations.operator(value={"kappa"}, content_type=2, category={"Map comparaison operators"}, concept={"map"})
    @GamlAnnotations.doc(value="kappa indicator for 2 map comparisons: kappa(list_vals1,list_vals2,categories). Reference: Cohen, J. A coefficient of agreement for nominal scales. Educ. Psychol. Meas. 1960, 20.", examples={@GamlAnnotations.example(value="kappa([cat1,cat1,cat2,cat3,cat2],[cat2,cat1,cat2,cat1,cat2],[cat1,cat2,cat3])", isExecutable=false), @GamlAnnotations.example(value="kappa([1,3,5,1,5],[1,1,1,1,5],[1,3,5])", equals="0.3333333333333334"), @GamlAnnotations.example(value="kappa([1,1,1,1,5],[1,1,1,1,5],[1,3,5])", equals="1.0")})
    public static double kappa(IScope iScope, IList<Object> iList, IList<Object> iList2, IList<Object> iList3) {
        return MapComparison.kappa(iScope, iList, iList2, iList3, null);
    }

    @GamlAnnotations.operator(value={"kappa"}, content_type=2, category={"Map comparaison operators"}, concept={})
    @GamlAnnotations.doc(value="kappa indicator for 2 map comparisons: kappa(list_vals1,list_vals2,categories, weights). Reference: Cohen, J. A coefficient of agreement for nominal scales. Educ. Psychol. Meas. 1960, 20. ", examples={@GamlAnnotations.example(value="kappa([\"cat1\",\"cat3\",\"cat2\",\"cat1\",\"cat3\"],[\"cat1\",\"cat3\",\"cat2\",\"cat3\",\"cat1\"],[\"cat1\",\"cat2\",\"cat3\"], [1.0, 2.0, 3.0, 1.0, 5.0])", equals="0.29411764705882354")})
    public static double kappa(IScope iScope, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IList<Object> iList4) {
        int n;
        if (iList == null || iList2 == null) {
            return 1.0;
        }
        int n2 = iList.size();
        if (n2 != iList2.size()) {
            return 0.0;
        }
        int n3 = iList3.size();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[][] dArray3 = new double[n3][n3];
        int n4 = 0;
        while (n4 < n3) {
            dArray[n4] = 0.0;
            dArray2[n4] = 0.0;
            n = 0;
            while (n < n3) {
                dArray3[n4][n] = 0.0;
                ++n;
            }
            ++n4;
        }
        IMap iMap = GamaMapFactory.create();
        n = 0;
        while (n < n3) {
            iMap.put(iList3.get(n), n);
            ++n;
        }
        double d = 0.0;
        int n5 = 0;
        while (n5 < n2) {
            double d2 = iList4 == null ? 1.0 : Cast.asFloat((IScope)iScope, (Object)iList4.get(n5));
            d += d2;
            Object object = iList.get(n5);
            Object object2 = iList2.get(n5);
            int n6 = (Integer)iMap.get(object);
            int n7 = (Integer)iMap.get(object2);
            int n8 = n6;
            dArray[n8] = dArray[n8] + d2;
            int n9 = n7;
            dArray2[n9] = dArray2[n9] + d2;
            double[] dArray4 = dArray3[n6];
            int n10 = n7;
            dArray4[n10] = dArray4[n10] + d2;
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            int n11 = n5;
            dArray[n11] = dArray[n11] / d;
            int n12 = n5;
            dArray2[n12] = dArray2[n12] / d;
            int n13 = 0;
            while (n13 < n3) {
                double[] dArray5 = dArray3[n5];
                int n14 = n13++;
                dArray5[n14] = dArray5[n14] / d;
            }
            ++n5;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        int n15 = 0;
        while (n15 < n3) {
            d3 += dArray3[n15][n15];
            d4 += dArray[n15] * dArray2[n15];
            ++n15;
        }
        if (d4 == 1.0) {
            return 1.0;
        }
        return (d3 - d4) / (1.0 - d4);
    }

    @GamlAnnotations.operator(value={"kappa_sim"}, content_type=2, category={"Map comparaison operators"}, concept={"map"})
    @GamlAnnotations.doc(value="Kappa simulation indicator for 2 map comparisons. Reference: `van Vliet, J., Bregt, A.K. & Hagen-Zanker, A. (2011). Revisiting Kappa to account for change in the accuracy assessment of land-use change models, Ecological Modelling 222(8).`", masterDoc=true, examples={@GamlAnnotations.example(value="kappa_sim([\"cat1\",\"cat1\",\"cat2\",\"cat2\",\"cat2\"],[\"cat1\",\"cat3\",\"cat2\",\"cat1\",\"cat3\"],[\"cat1\",\"cat3\",\"cat2\",\"cat3\",\"cat1\"],[\"cat1\",\"cat2\",\"cat3\"])", equals="0.3333333333333335")})
    public static double kappaSimulation(IScope iScope, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IList<Object> iList4) {
        return MapComparison.kappaSimulation(iScope, iList, iList2, iList3, iList4, null);
    }

    @GamlAnnotations.operator(value={"kappa_sim"}, content_type=2, category={"Map comparaison operators"}, concept={})
    @GamlAnnotations.doc(value="kappa simulation indicator for 2 map comparisons: kappa(list_valsInits,list_valsObs,list_valsSim, categories, weights). Reference: van Vliet, J., Bregt, A.K. & Hagen-Zanker, A. (2011). Revisiting Kappa to account for change in the accuracy assessment of land-use change models, Ecological Modelling 222(8)", usages={@GamlAnnotations.usage(value="kappa_sim can be used with an additional weights operand", examples={@GamlAnnotations.example(value="kappa_sim([\"cat1\",\"cat1\",\"cat2\",\"cat2\",\"cat2\"],[\"cat1\",\"cat3\",\"cat2\",\"cat1\",\"cat3\"],[\"cat1\",\"cat3\",\"cat2\",\"cat3\",\"cat1\"],[\"cat1\",\"cat2\",\"cat3\"], [1.0, 2.0, 3.0, 1.0, 5.0])", equals="0.2702702702702703")})})
    public static double kappaSimulation(IScope iScope, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IList<Object> iList4, IList<Object> iList5) {
        int n;
        int n2;
        if (iList == null || iList2 == null || iList3 == null) {
            return 1.0;
        }
        int n3 = iList.size();
        if (n3 != iList2.size() || n3 != iList3.size()) {
            return 0.0;
        }
        int n4 = iList4.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[n4][n4];
        double[][] dArray3 = new double[n4][n4];
        double[][] dArray4 = new double[n4][n4];
        int n5 = 0;
        while (n5 < n4) {
            dArray[n5] = 0.0;
            n2 = 0;
            while (n2 < n4) {
                dArray2[n5][n2] = 0.0;
                dArray3[n5][n2] = 0.0;
                dArray4[n5][n2] = 0.0;
                ++n2;
            }
            ++n5;
        }
        IMap iMap = GamaMapFactory.create();
        n2 = 0;
        while (n2 < n4) {
            iMap.put(iList4.get(n2), n2);
            ++n2;
        }
        double d = 0.0;
        int n6 = 0;
        while (n6 < n3) {
            int n7;
            double d2 = iList5 == null ? 1.0 : Cast.asFloat((IScope)iScope, (Object)iList5.get(n6));
            d += d2;
            Object object = iList2.get(n6);
            Object object2 = iList3.get(n6);
            Object object3 = iList.get(n6);
            int n8 = (Integer)iMap.get(object);
            n = (Integer)iMap.get(object2);
            int n9 = n7 = ((Integer)iMap.get(object3)).intValue();
            dArray[n9] = dArray[n9] + d2;
            double[] dArray5 = dArray2[n8];
            int n10 = n;
            dArray5[n10] = dArray5[n10] + d2;
            double[] dArray6 = dArray3[n7];
            int n11 = n8;
            dArray6[n11] = dArray6[n11] + d2;
            double[] dArray7 = dArray4[n7];
            int n12 = n;
            dArray7[n12] = dArray7[n12] + d2;
            ++n6;
        }
        n6 = 0;
        while (n6 < n4) {
            int n13 = 0;
            while (n13 < n4) {
                double[] dArray8 = dArray2[n6];
                int n14 = n13;
                dArray8[n14] = dArray8[n14] / d;
                if (dArray[n6] > 0.0) {
                    double[] dArray9 = dArray3[n6];
                    int n15 = n13;
                    dArray9[n15] = dArray9[n15] / dArray[n6];
                    double[] dArray10 = dArray4[n6];
                    int n16 = n13;
                    dArray10[n16] = dArray10[n16] / dArray[n6];
                }
                ++n13;
            }
            int n17 = n6++;
            dArray[n17] = dArray[n17] / d;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        int n18 = 0;
        while (n18 < n4) {
            d3 += dArray2[n18][n18];
            double d5 = 0.0;
            n = 0;
            while (n < n4) {
                d5 += dArray3[n18][n] * dArray4[n18][n];
                ++n;
            }
            d4 += dArray[n18] * d5;
            ++n18;
        }
        if (d4 == 1.0) {
            return 1.0;
        }
        return (d3 - d4) / (1.0 - d4);
    }

    @GamlAnnotations.operator(value={"fuzzy_kappa"}, content_type=2, category={"Map comparaison operators"}, concept={"map"})
    @GamlAnnotations.doc(value="fuzzy kappa indicator for 2 map comparisons: fuzzy_kappa(agents_list,list_vals1,list_vals2, output_similarity_per_agents,categories,fuzzy_categories_matrix, fuzzy_distance). Reference: Visser, H., and T. de Nijs, 2006. The map comparison kit, Environmental Modelling & Software, 21", examples={@GamlAnnotations.example(value="fuzzy_kappa([ag1, ag2, ag3, ag4, ag5],[cat1,cat1,cat2,cat3,cat2],[cat2,cat1,cat2,cat1,cat2], similarity_per_agents,[cat1,cat2,cat3],[[1,0,0],[0,1,0],[0,0,1]], 2)", isExecutable=false)})
    public static double fuzzyKappa(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<Object> iList, IList<Object> iList2, IList<Double> iList3, IList<Object> iList4, GamaMatrix<Double> gamaMatrix, Double d) {
        return MapComparison.fuzzyKappa(iScope, iAddressableContainer, iList, iList2, iList3, iList4, gamaMatrix, d, null);
    }

    @GamlAnnotations.operator(value={"fuzzy_kappa"}, content_type=2, category={"Map comparaison operators"}, concept={})
    @GamlAnnotations.doc(value="fuzzy kappa indicator for 2 map comparisons: fuzzy_kappa(agents_list,list_vals1,list_vals2, output_similarity_per_agents,categories,fuzzy_categories_matrix, fuzzy_distance, weights). Reference: Visser, H., and T. de Nijs, 2006. The map comparison kit, Environmental Modelling & Software, 21", examples={@GamlAnnotations.example(value="fuzzy_kappa([ag1, ag2, ag3, ag4, ag5],[cat1,cat1,cat2,cat3,cat2],[cat2,cat1,cat2,cat1,cat2], similarity_per_agents,[cat1,cat2,cat3],[[1,0,0],[0,1,0],[0,0,1]], 2, [1.0,3.0,2.0,2.0,4.0])", isExecutable=false)})
    public static double fuzzyKappa(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<Object> iList, IList<Object> iList2, IList<Double> iList3, IList<Object> iList4, GamaMatrix<Double> gamaMatrix, Double d, IList<Object> iList5) {
        if (iAddressableContainer == null) {
            return 1.0;
        }
        int n = iAddressableContainer.length(iScope);
        if (n < 1) {
            return 1.0;
        }
        int n2 = iList4.size();
        iList3.clear();
        boolean[] blArray = new boolean[n];
        double[][] dArray = new double[n][n2];
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        double[][] dArray4 = new double[n][n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        IMap iMap = GamaMapFactory.create();
        int n3 = 0;
        while (n3 < n2) {
            iMap.put(iList4.get(n3), n3);
            ++n3;
        }
        IAgentFilter iAgentFilter = In.list((IScope)iScope, iAddressableContainer);
        MapComparison.computeXYCrispVector(iScope, (Map<Object, Integer>)iMap, iList4, iList, iList2, gamaMatrix, n2, n, dArray, dArray2, dArray5, dArray6, blArray, iList5);
        double d2 = MapComparison.computeSimilarity(iScope, iAgentFilter, d, iList, iList2, iAddressableContainer, n2, n, dArray, dArray2, blArray, dArray3, dArray4, iList3, iList5);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        IMap iMap2 = GamaMapFactory.create();
        int n4 = MapComparison.buildRings(iScope, iAgentFilter, d, arrayList, (Map<Double, Integer>)iMap2, iAddressableContainer);
        double d3 = MapComparison.computeExpectedSim(n2, dArray5, dArray6, n4, arrayList, (Map<Double, Integer>)iMap2);
        if (d3 == 1.0) {
            return 1.0;
        }
        return (d2 - d3) / (1.0 - d3);
    }

    @GamlAnnotations.operator(value={"fuzzy_kappa_sim"}, content_type=2, category={"Map comparaison operators"}, concept={"map"})
    @GamlAnnotations.doc(value="fuzzy kappa simulation indicator for 2 map comparisons: fuzzy_kappa_sim(agents_list,list_vals1,list_vals2, output_similarity_per_agents,fuzzy_transitions_matrix, fuzzy_distance). Reference: Jasper van Vliet, Alex Hagen-Zanker, Jelle Hurkens, Hedwig van Delden, A fuzzy set approach to assess the predictive accuracy of land use simulations, Ecological Modelling, 24 July 2013, Pages 32-42, ISSN 0304-3800, ", examples={@GamlAnnotations.example(value="fuzzy_kappa_sim([ag1, ag2, ag3, ag4, ag5], [cat1,cat1,cat2,cat3,cat2],[cat2,cat1,cat2,cat1,cat2], similarity_per_agents,[cat1,cat2,cat3],[[1,0,0,0,0,0,0,0,0],[0,1,0,0,0,0,0,0,0],[0,0,1,0,0,0,0,0,0],[0,0,0,1,0,0,0,0,0],[0,0,0,0,1,0,0,0,0],[0,0,0,0,0,1,0,0,0],[0,0,0,0,0,0,1,0,0],[0,0,0,0,0,0,0,1,0],[0,0,0,0,0,0,0,0,1]], 2)", isExecutable=false)})
    public static double fuzzyKappaSimulation(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IList<Double> iList4, IList<Object> iList5, GamaMatrix<Double> gamaMatrix, Double d) {
        return MapComparison.fuzzyKappaSimulation(iScope, iAddressableContainer, iList, iList2, iList3, iList4, iList5, gamaMatrix, d, null);
    }

    @GamlAnnotations.operator(value={"fuzzy_kappa_sim"}, content_type=2, category={"Map comparaison operators"}, concept={"map"})
    @GamlAnnotations.doc(value="fuzzy kappa simulation indicator for 2 map comparisons: fuzzy_kappa_sim(agents_list,list_vals1,list_vals2, output_similarity_per_agents,fuzzy_transitions_matrix, fuzzy_distance, weights). Reference: Jasper van Vliet, Alex Hagen-Zanker, Jelle Hurkens, Hedwig van Delden, A fuzzy set approach to assess the predictive accuracy of land use simulations, Ecological Modelling, 24 July 2013, Pages 32-42, ISSN 0304-3800, ", examples={@GamlAnnotations.example(value="fuzzy_kappa_sim([ag1, ag2, ag3, ag4, ag5], [cat1,cat1,cat2,cat3,cat2],[cat2,cat1,cat2,cat1,cat2], similarity_per_agents,[cat1,cat2,cat3],[[1,0,0,0,0,0,0,0,0],[0,1,0,0,0,0,0,0,0],[0,0,1,0,0,0,0,0,0],[0,0,0,1,0,0,0,0,0],[0,0,0,0,1,0,0,0,0],[0,0,0,0,0,1,0,0,0],[0,0,0,0,0,0,1,0,0],[0,0,0,0,0,0,0,1,0],[0,0,0,0,0,0,0,0,1]], 2,[1.0,3.0,2.0,2.0,4.0])", isExecutable=false)})
    public static double fuzzyKappaSimulation(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IList<Double> iList4, IList<Object> iList5, GamaMatrix<Double> gamaMatrix, Double d, IList<Object> iList6) {
        int n;
        int n2;
        if (iAddressableContainer == null) {
            return 1.0;
        }
        int n3 = iAddressableContainer.length(iScope);
        if (n3 < 1) {
            return 1.0;
        }
        iList4.clear();
        int n4 = iList5.size();
        double[] dArray = new double[n4];
        double[][] dArray2 = new double[n4][n4];
        double[][] dArray3 = new double[n4][n4];
        IMap iMap = GamaMapFactory.create();
        IMap iMap2 = GamaMapFactory.create();
        IMap iMap3 = GamaMapFactory.create();
        LinkedHashSet<Double> linkedHashSet = new LinkedHashSet<Double>();
        int n5 = 0;
        while (n5 < n4) {
            iMap.put(iList5.get(n5), n5);
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            dArray[n5] = 0.0;
            int n6 = 0;
            while (n6 < n4) {
                dArray2[n5][n6] = 0.0;
                dArray3[n5][n6] = 0.0;
                ++n6;
            }
            ++n5;
        }
        IAgentFilter iAgentFilter = In.list((IScope)iScope, iAddressableContainer);
        double d2 = 0.0;
        int n7 = 0;
        while (n7 < n3) {
            double d3 = iList6 == null ? 1.0 : Cast.asFloat((IScope)iScope, (Object)iList6.get(n7));
            d2 += d3;
            int n8 = (Integer)iMap.get(iList.get(n7));
            n2 = (Integer)iMap.get(iList2.get(n7));
            n = (Integer)iMap.get(iList3.get(n7));
            int n9 = n8;
            dArray[n9] = dArray[n9] + d3;
            double[] dArray4 = dArray2[n8];
            int n10 = n2;
            dArray4[n10] = dArray4[n10] + d3;
            double[] dArray5 = dArray3[n8];
            int n11 = n;
            dArray5[n11] = dArray5[n11] + d3;
            ++n7;
        }
        double d4 = MapComparison.computePo(iScope, iAgentFilter, (Map<Object, Integer>)iMap, gamaMatrix, d, iList, iList2, iList3, iAddressableContainer, n4, n3, iList4, iList6);
        double d5 = 0.0;
        MapComparison.computeXaXsTransitions(iScope, iAgentFilter, gamaMatrix, d, iAddressableContainer, n4, (Map<List<Integer>, Map<Double, Double>>)iMap2, (Map<List<Integer>, Map<Double, Double>>)iMap3, linkedHashSet);
        n2 = 0;
        while (n2 < n4) {
            n = 0;
            while (n < n4) {
                int n12 = 0;
                while (n12 < n4) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    arrayList.add(n2);
                    arrayList.add(n);
                    arrayList.add(n12);
                    Map map = (Map)iMap2.get(arrayList);
                    Map map2 = (Map)iMap3.get(arrayList);
                    double d6 = 0.0;
                    for (Double d7 : linkedHashSet) {
                        double d8 = map == null || !map.containsKey(d7) ? 0.0 : (Double)map.get(d7);
                        double d9 = map2 == null || !map2.containsKey(d7) ? 0.0 : (Double)map2.get(d7);
                        double d10 = d7 * d8 * d9;
                        d6 += d10;
                    }
                    double d11 = dArray[n2] == 0.0 ? 0.0 : dArray2[n2][n] / dArray[n2] * dArray3[n2][n12] / d2;
                    d5 += d6 * d11;
                    ++n12;
                }
                ++n;
            }
            ++n2;
        }
        if (d5 == 1.0) {
            return 1.0;
        }
        return (d4 - d5) / (1.0 - d5);
    }

    private static double computePo(IScope iScope, IAgentFilter iAgentFilter, Map<Object, Integer> map, GamaMatrix<Double> gamaMatrix, Double d, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, int n, int n2, IList<Double> iList4, IList<Object> iList5) {
        int n3;
        IMap iMap = GamaMapFactory.create();
        int n4 = 0;
        while (n4 < iAddressableContainer.length(iScope)) {
            iMap.put((IAgent)iAddressableContainer.get(iScope, (Object)n4), n4);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            Object object = iList2.get(n4);
            Object object2 = iList3.get(n4);
            Object object3 = iList.get(n4);
            n3 = map.get(object);
            int n5 = map.get(object2);
            int n6 = map.get(object3);
            IAgent iAgent = (IAgent)iAddressableContainer.get(iScope, (Object)n4);
            double[] dArray = MapComparison.computeXaXs(iScope, iAgentFilter, map, (Map<IAgent, Integer>)iMap, n3, n5, n6, gamaMatrix, d, iAgent, iList, iList2, iList3, iAddressableContainer, n);
            iList4.add((Object)Math.min(dArray[0], dArray[1]));
            ++n4;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        n3 = 0;
        while (n3 < n2) {
            double d4 = iList5 == null ? 1.0 : Cast.asFloat((IScope)iScope, (Object)iList5.get(n3));
            double d5 = d4 * (Double)iList4.get(n3);
            d3 += d4;
            d2 += d5;
            ++n3;
        }
        return d2 /= d3;
    }

    private static double[] computeXaXs(IScope iScope, IAgentFilter iAgentFilter, Map<Object, Integer> map, Map<IAgent, Integer> map2, int n, int n2, int n3, GamaMatrix<Double> gamaMatrix, Double d, IAgent iAgent, IList<Object> iList, IList<Object> iList2, IList<Object> iList3, IContainer.Addressable<Integer, IAgent> addressable, int n4) {
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[2];
        double d4 = Math.sqrt(iAgent.getEnvelope().getArea());
        ArrayList arrayList = d == 0.0 || iAgentFilter == null ? new ArrayList() : new ArrayList(iScope.getTopology().getNeighborsOf(iScope, (IShape)iAgent, d, iAgentFilter));
        IMap iMap = GamaMapFactory.create();
        iMap.put(iAgent, 1.0);
        for (IAgent iAgent2 : arrayList) {
            double d5 = iAgent.getLocation().euclidianDistanceTo(iAgent2.getLocation());
            iMap.put(iAgent2, 1.0 / (1.0 + d5 / d4));
        }
        for (IAgent iAgent2 : iMap.keySet()) {
            int n5 = map2.get(iAgent2);
            Object object = iList.get(n5);
            Object object2 = iList2.get(n5);
            Object object3 = iList3.get(n5);
            int n6 = map.get(object2);
            int n7 = map.get(object3);
            int n8 = map.get(object);
            double d6 = (Double)iMap.get(iAgent2);
            double d7 = MapComparison.fuzzyTransition(iScope, gamaMatrix, n4, n3, n2, n8, n6) * d6;
            double d8 = MapComparison.fuzzyTransition(iScope, gamaMatrix, n4, n3, n, n8, n7) * d6;
            if (d7 > d2) {
                d2 = d7;
            }
            if (!(d8 > d3)) continue;
            d3 = d8;
        }
        dArray[0] = d2;
        dArray[1] = d3;
        return dArray;
    }

    private static double fuzzyTransition(IScope iScope, GamaMatrix<Double> gamaMatrix, int n, int n2, int n3, int n4, int n5) {
        return (Double)gamaMatrix.get(iScope, n2 + n * n3, n4 + n * n5);
    }

    private static void computeXaXsTransitions(IScope iScope, IAgentFilter iAgentFilter, GamaMatrix<Double> gamaMatrix, Double d, IContainer<Integer, IAgent> iContainer, int n, Map<List<Integer>, Map<Double, Double>> map, Map<List<Integer>, Map<Double, Double>> map2, Set<Double> set) {
        IAgent iAgent2;
        IList iList = GamaListFactory.create((IType)Types.POINT);
        for (IAgent iAgent2 : iContainer.iterable(iScope)) {
            iList.add((Object)iAgent2.getLocation());
        }
        iAgent2 = (GamaPoint)Containers.opMean((IScope)iScope, (IContainer)iList);
        if (iAgentFilter != null) {
            double d2;
            IAgent iAgent3 = iScope.getTopology().getAgentClosestTo(iScope, (IShape)iAgent2, iAgentFilter);
            ArrayList arrayList = d == 0.0 ? new ArrayList() : new ArrayList(iScope.getTopology().getNeighborsOf(iScope, (IShape)iAgent3, d, iAgentFilter));
            double d3 = Math.sqrt(iAgent3.getEnvelope().getArea());
            IMap iMap = GamaMapFactory.create();
            iMap.put(iAgent3, 1.0);
            for (IAgent iAgent4 : arrayList) {
                double d4 = iAgent3.getLocation().euclidianDistanceTo(iAgent4.getLocation());
                d2 = 1.0 / (1.0 + d4 / d3);
                iMap.put(iAgent4, d2);
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n) {
                        Object object;
                        Object object22;
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                        arrayList2.add(n2);
                        arrayList2.add(n3);
                        arrayList2.add(n4);
                        d2 = 0.0;
                        double d5 = 0.0;
                        for (Object object22 : iMap.keySet()) {
                            double d6 = (Double)iMap.get(object22);
                            double d7 = MapComparison.fuzzyTransition(iScope, gamaMatrix, n, n2, n4, n2, n3) * d6;
                            double d8 = MapComparison.fuzzyTransition(iScope, gamaMatrix, n, n2, n3, n2, n4) * d6;
                            if (d7 > d2) {
                                d2 = d7;
                            }
                            if (!(d8 > d5)) continue;
                            d5 = d8;
                        }
                        if (d2 > 0.0) {
                            object22 = map.get(arrayList2);
                            if (object22 == null) {
                                object22 = GamaMapFactory.create();
                                object22.put(d2, 1.0);
                                map.put(arrayList2, (Map<Double, Double>)object22);
                            } else {
                                object = (Double)object22.get(d2);
                                if (object == null) {
                                    object = 0.0;
                                }
                                object22.put(d2, (Double)object + 1.0);
                            }
                            set.add(d2);
                        }
                        if (d5 > 0.0) {
                            object22 = map2.get(arrayList2);
                            if (object22 == null) {
                                object22 = GamaMapFactory.create();
                                object22.put(d5, 1.0);
                                map2.put(arrayList2, (Map<Double, Double>)object22);
                            } else {
                                object = (Double)object22.get(d5);
                                if (object == null) {
                                    object = 0.0;
                                }
                                object22.put(d5, (Double)object + 1.0);
                            }
                            set.add(d5);
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private static double p(double d, int n, int n2, double[] dArray, double[] dArray2, Map<Double, Integer> map) {
        int n3 = 0;
        if (d > 0.0) {
            n3 = map.get(d);
        }
        return (1.0 - Math.pow(1.0 - dArray[n], n3)) * (1.0 - Math.pow(1.0 - dArray2[n2], n3));
    }

    private static double computeExpectedSim(int n, double[] dArray, double[] dArray2, int n2, List<Double> list, Map<Double, Integer> map) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d += dArray[n3] * dArray2[n3];
            ++n3;
        }
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            double d3 = d2;
            d2 = list.get(n4);
            double d4 = Math.pow(2.0, d2 / -2.0);
            double d5 = 0.0;
            int n5 = 0;
            while (n5 < n) {
                double d6 = dArray2[n5];
                int n6 = 0;
                while (n6 < n) {
                    double d7 = dArray[n6];
                    int n7 = n5 == n6 ? 1 : 0;
                    d5 += (double)(1 - n7) * d6 * d7 * (MapComparison.p(d2, n5, n6, dArray, dArray2, map) - MapComparison.p(d3, n5, n6, dArray, dArray2, map));
                    ++n6;
                }
                ++n5;
            }
            d += d4 * d5;
            ++n4;
        }
        return d;
    }

    private static double computeSimilarity(IScope iScope, IAgentFilter iAgentFilter, Double d, IList<Object> iList, IList<Object> iList2, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, int n, int n2, double[][] dArray, double[][] dArray2, boolean[] blArray, double[][] dArray3, double[][] dArray4, IList<Double> iList3, IList<Object> iList4) {
        double d2;
        IMap iMap = GamaMapFactory.create();
        int n3 = 0;
        while (n3 < iAddressableContainer.length(iScope)) {
            iMap.put((IAgent)iAddressableContainer.get(iScope, (Object)n3), n3);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (blArray[n3]) {
                iList3.add((Object)1.0);
            } else {
                double d3;
                IAgent iAgent = (IAgent)iAddressableContainer.get(iScope, (Object)n3);
                d2 = Math.sqrt(iAgent.getEnvelope().getArea());
                ArrayList arrayList = d == 0.0 || iAgentFilter == null ? new ArrayList() : new ArrayList(iScope.getTopology().getNeighborsOf(iScope, (IShape)iAgent, d, iAgentFilter));
                IMap iMap2 = GamaMapFactory.create();
                iMap2.put(iAgent, 1.0);
                for (IAgent iAgent2 : arrayList) {
                    d3 = iAgent.getLocation().euclidianDistanceTo(iAgent2.getLocation());
                    iMap2.put(iAgent2, 1.0 / (1.0 + d3 / d2));
                }
                int n4 = 0;
                while (n4 < n) {
                    double d4 = 0.0;
                    double d5 = 0.0;
                    for (IAgent iAgent3 : arrayList) {
                        int n5 = (Integer)iMap.get(iAgent3);
                        double d6 = dArray[n5][n4] * (Double)iMap2.get(iAgent3);
                        double d7 = dArray2[n5][n4] * (Double)iMap2.get(iAgent3);
                        if (d6 > d4) {
                            d4 = d6;
                        }
                        if (!(d7 > d5)) continue;
                        d5 = d7;
                    }
                    dArray3[n3][n4] = d4;
                    dArray4[n3][n4] = d5;
                    ++n4;
                }
                double d8 = -1.7976931348623157E308;
                d3 = -1.7976931348623157E308;
                int n6 = 0;
                while (n6 < n) {
                    double d9 = Math.min(dArray3[n3][n6], dArray2[n3][n6]);
                    double d10 = Math.min(dArray4[n3][n6], dArray[n3][n6]);
                    if (d9 > d8) {
                        d8 = d9;
                    }
                    if (d10 > d3) {
                        d3 = d10;
                    }
                    ++n6;
                }
                iList3.add((Object)Math.min(d8, d3));
            }
            ++n3;
        }
        double d11 = 0.0;
        d2 = 0.0;
        int n7 = 0;
        while (n7 < n2) {
            double d12 = iList4 == null ? 1.0 : Cast.asFloat((IScope)iScope, (Object)iList4.get(n7));
            double d13 = d12 * (Double)iList3.get(n7);
            d2 += d12;
            d11 += d13;
            ++n7;
        }
        return d11 /= d2;
    }

    private static void computeXYCrispVector(IScope iScope, Map<Object, Integer> map, List<Object> list, IList<Object> iList, IList<Object> iList2, GamaMatrix<Double> gamaMatrix, int n, int n2, double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, boolean[] blArray, IList<Object> iList3) {
        int n3 = 0;
        while (n3 < n) {
            dArray3[n3] = 0.0;
            dArray4[n3] = 0.0;
            ++n3;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            double d2 = iList3 == null ? 1.0 : Cast.asFloat((IScope)iScope, (Object)iList3.get(n4));
            d += d2;
            Object object = iList.get(n4);
            Object object2 = iList2.get(n4);
            int n5 = map.get(object);
            int n6 = map.get(object2);
            int n7 = n5;
            dArray3[n7] = dArray3[n7] + d2;
            int n8 = n6;
            dArray4[n8] = dArray4[n8] + d2;
            int n9 = 0;
            while (n9 < n) {
                dArray[n4][n9] = Cast.asFloat((IScope)iScope, (Object)gamaMatrix.get(iScope, n5, n9));
                dArray2[n4][n9] = Cast.asFloat((IScope)iScope, (Object)gamaMatrix.get(iScope, n6, n9));
                ++n9;
            }
            blArray[n4] = object.equals(object2);
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            int n10 = n4;
            dArray3[n10] = dArray3[n10] / d;
            int n11 = n4++;
            dArray4[n11] = dArray4[n11] / d;
        }
    }

    private static int buildRings(IScope iScope, IAgentFilter iAgentFilter, Double d, List<Double> list, Map<Double, Integer> map, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer) {
        IAgent iAgent2;
        IList iList = GamaListFactory.create((IType)Types.POINT);
        for (IAgent iAgent2 : iAddressableContainer.iterable(iScope)) {
            iList.add((Object)iAgent2.getLocation());
        }
        iAgent2 = (GamaPoint)Containers.opMean((IScope)iScope, (IContainer)iList);
        IAgent iAgent3 = iScope.getTopology().getAgentClosestTo(iScope, (IShape)iAgent2, iAgentFilter);
        ArrayList arrayList = d == 0.0 || iAgentFilter == null ? new ArrayList() : new ArrayList(iScope.getTopology().getNeighborsOf(iScope, (IShape)iAgent3, d, iAgentFilter));
        for (IAgent iAgent4 : arrayList) {
            double d2 = iAgent2.euclidianDistanceTo(iAgent4.getLocation());
            if (d2 == 0.0) continue;
            if (!list.contains(d2)) {
                list.add(d2);
                map.put(d2, 1);
                continue;
            }
            map.put(d2, 1 + map.get(d2));
        }
        Collections.sort(list);
        int n = 1;
        while (n < list.size()) {
            double d3 = list.get(n);
            double d4 = list.get(n - 1);
            map.put(d3, map.get(d3) + map.get(d4));
            ++n;
        }
        return list.size();
    }

    @GamlAnnotations.operator(value={"percent_absolute_deviation"}, content_type=2, category={"Map comparaison operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="percent absolute deviation indicator for 2 series of values: percent_absolute_deviation(list_vals_observe,list_vals_sim)", examples={@GamlAnnotations.example(value="percent_absolute_deviation([200,300,150,150,200],[250,250,100,200,200])", equals="20.0")})
    public static double percentAbsoluteDeviation(IScope iScope, IList<Double> iList, IList<Double> iList2) {
        if (iList == null || iList2 == null) {
            return 1.0;
        }
        int n = iList.size();
        if (n != iList2.size()) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d3 = Cast.asFloat((IScope)iScope, (Object)iList.get(n2));
            double d4 = Cast.asFloat((IScope)iScope, (Object)iList2.get(n2));
            d2 += d3;
            d += Math.abs(d3 - d4) * 100.0;
            ++n2;
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }
}

