/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.stats;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.GamaMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.RegressionResults;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="parameters", type=5, of=2, doc={@GamlAnnotations.doc(value="List of regression coefficients (float) - same order as the variable in the input matrix ")}), @GamlAnnotations.variable(name="nb_features", type=1, doc={@GamlAnnotations.doc(value="number of variables")}), @GamlAnnotations.variable(name="RSquare", type=2, doc={@GamlAnnotations.doc(value="Estimated pearson's R-squared statistic")}), @GamlAnnotations.variable(name="residuals", type=5, of=2, doc={@GamlAnnotations.doc(value="error terms associated to each observation of the sample")})})
public class GamaRegression
implements IValue {
    RegressionResults regressionResults;
    int nbFeatures;
    double[] param;
    double[] error;
    double rsquare;

    public GamaRegression(IScope iScope, GamaMatrix<?> gamaMatrix) throws Exception {
        OLSMultipleLinearRegression oLSMultipleLinearRegression = new OLSMultipleLinearRegression();
        int n = gamaMatrix.numCols - 1;
        int n2 = gamaMatrix.numRows;
        double[] dArray = new double[gamaMatrix.numCols * gamaMatrix.numRows];
        int n3 = 0;
        while (n3 < gamaMatrix.length(iScope)) {
            dArray[n3] = Cast.asFloat((IScope)iScope, (Object)gamaMatrix.getNthElement(Integer.valueOf(n3)));
            ++n3;
        }
        oLSMultipleLinearRegression.newSampleData(dArray, n2, n);
        this.param = oLSMultipleLinearRegression.estimateRegressionParameters();
        this.rsquare = oLSMultipleLinearRegression.calculateAdjustedRSquared();
        this.error = oLSMultipleLinearRegression.estimateResiduals();
    }

    public GamaRegression(double[] dArray, int n, RegressionResults regressionResults) {
        this.regressionResults = regressionResults;
        this.nbFeatures = n;
        this.param = dArray;
    }

    public Double predict(IScope iScope, IList<?> iList) {
        if (this.param == null) {
            return null;
        }
        double d = this.param[0];
        int n = 1;
        while (n < this.param.length) {
            d += this.param[n] * Cast.asFloat((IScope)iScope, (Object)iList.get(n - 1));
            ++n;
        }
        return d;
    }

    @GamlAnnotations.getter(value="parameters")
    public IList<Double> getParameters() {
        if (this.param == null) {
            return GamaListFactory.create((IType)Types.FLOAT);
        }
        IList iList = GamaListFactory.create((IType)Types.FLOAT);
        double[] dArray = this.param;
        int n = this.param.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            iList.add((Object)d);
            ++n2;
        }
        return iList;
    }

    @GamlAnnotations.getter(value="residuals")
    public IList<Double> getResiduals() {
        IList iList = GamaListFactory.create((IType)Types.FLOAT);
        if (this.error != null) {
            double[] dArray = this.error;
            int n = this.error.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                iList.add((Object)d);
                ++n2;
            }
        }
        return iList;
    }

    @GamlAnnotations.getter(value="RSquare")
    public double getRSquare() {
        return this.rsquare;
    }

    @GamlAnnotations.getter(value="nb_features")
    public Integer getNbFeatures() {
        return this.nbFeatures;
    }

    public String serializeToGaml(boolean bl) {
        return this.stringValue(null);
    }

    public IType<?> getGamlType() {
        return Types.get((int)21);
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        if (this.param == null) {
            return "no function";
        }
        StringBuilder stringBuilder = new StringBuilder("y = ").append(this.param[0]);
        int n = 1;
        while (n < this.param.length) {
            stringBuilder.append(" + ").append(this.param[n]).append(" x").append(n);
            ++n;
        }
        return stringBuilder.toString();
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        return new GamaRegression((double[])this.param.clone(), this.nbFeatures, this.regressionResults);
    }

    public int intValue(IScope iScope) {
        return this.nbFeatures;
    }

    public double floatValue(IScope iScope) {
        return this.getRSquare();
    }

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "nb_features", (Object)this.nbFeatures, "parameters", (Object)json.array(this.param), "RSquare", (Object)this.rsquare, "residuals", (Object)json.array(this.error));
    }
}

