/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.stats;

import cern.colt.list.DoubleArrayList;
import cern.jet.math.Arithmetic;
import cern.jet.stat.Descriptive;
import cern.jet.stat.Gamma;
import cern.jet.stat.Probability;
import com.google.common.collect.Ordering;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.common.util.StringUtils;
import gama.core.kernel.batch.exploration.morris.Morris;
import gama.core.kernel.batch.exploration.sobol.Sobol;
import gama.core.kernel.batch.exploration.stochanalysis.Stochanalysis;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.GamaMatrix;
import gama.extension.stats.GamaRegression;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Containers;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.clustering.DoublePoint;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.apache.commons.math3.stat.inference.TTest;
import org.locationtech.jts.geom.Coordinate;

public class Stats {
    @GamlAnnotations.operator(value={"auto_correlation"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the auto-correlation of a data sequence given some lag", comment="", examples={@GamlAnnotations.example(value="auto_correlation([1,0,1,0,1,0],2)", equals="1"), @GamlAnnotations.example(value="auto_correlation([1,0,1,0,1,0],1)", equals="-1")})
    public static Double opAutoCorrelation(IScope iScope, IContainer iContainer, Integer n) {
        double d = (Double)Containers.opMean((IScope)iScope, (IContainer)iContainer);
        double d2 = Stats.opVariance(iScope, iContainer);
        return Descriptive.autoCorrelation((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (int)n, (double)d, (double)d2);
    }

    @GamlAnnotations.operator(value={"beta"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the beta function with arguments a, b.", comment="Checked on R. beta(4,5)", examples={@GamlAnnotations.example(value="beta(4,5) with_precision(4)", equals="0.0036")})
    public static Double opBeta(IScope iScope, Double d, Double d2) {
        try {
            return Gamma.beta((double)d, (double)d2);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .beta reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"binomial_coeff"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns n choose k as a double. Note the integerization of the double return value.", comment="", examples={@GamlAnnotations.example(value="binomial_coeff(10,2)", equals="45")})
    public static Double opBinomialCoeff(IScope iScope, Integer n, Integer n2) {
        try {
            return Math.rint(Arithmetic.binomial((long)n.intValue(), (long)n2.intValue()));
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .Arithmetic.binomial reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"binomial_complemented"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the sum of the terms k+1 through n of the Binomial probability density, where n is the number of trials and P is the probability of success in the range 0 to 1.", comment="", examples={@GamlAnnotations.example(value="binomial_complemented(10,5,0.5) with_precision(2)", equals="0.38")})
    public static Double opBinomialComplemented(IScope iScope, Integer n, Integer n2, Double d) {
        try {
            return Probability.binomialComplemented((int)n2, (int)n, (double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .binomialComplement reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"binomial_sum", "pbinom"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the sum of the terms 0 through k of the Binomial probability density, where n is the number of trials and p is the probability of success in the range 0 to 1.", comment="", examples={@GamlAnnotations.example(value="binomial_sum(5,10,0.5) with_precision(2)", equals="0.62")})
    public static Double opBinomialSum(IScope iScope, Integer n, Integer n2, Double d) {
        try {
            return Probability.binomial((int)n, (int)n2, (double)d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw GamaRuntimeException.error((String)("colt Probability.binomial reports: " + String.valueOf(illegalArgumentException)), (IScope)iScope);
        }
        catch (ArithmeticException arithmeticException) {
            throw GamaRuntimeException.error((String)("colt Probability.normal reports: " + String.valueOf(arithmeticException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"chi_square", "pchisq"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the area under the left hand tail (from 0 to x) of the Chi square probability density function with df degrees of freedom.", comment="", examples={@GamlAnnotations.example(value="chi_square(20.0,10) with_precision(3)", equals="0.971")})
    public static Double opChiSquare(IScope iScope, Double d, Double d2) {
        try {
            return Probability.chiSquare((double)d2, (double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .chiSquare reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"chi_square_complemented"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the area under the right hand tail (from x to infinity) of the Chi square probability density function with df degrees of freedom.", comment="", examples={@GamlAnnotations.example(value="chi_square_complemented(2,10) with_precision(3)", equals="0.996")})
    public static Double opChiSquareComplemented(IScope iScope, Double d, Double d2) {
        try {
            return Probability.chiSquareComplemented((double)d2, (double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .chiSquareComplemented reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"correlation"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the correlation of two data sequences (having the same size)", comment="", examples={@GamlAnnotations.example(value="correlation([1,2,1,3,1,2], [1,2,1,3,1,2]) with_precision(4)", equals="1.2"), @GamlAnnotations.example(value="correlation([13,2,1,4,1,2], [1,2,1,3,1,2]) with_precision(2)", equals="-0.21")})
    public static Double opCorrelation(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        double d = Stats.opStandardDeviation(iScope, iContainer);
        double d2 = Stats.opStandardDeviation(iScope, iContainer2);
        return Descriptive.correlation((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (double)d, (DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer2), (double)d2);
    }

    @GamlAnnotations.operator(value={"covariance"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the covariance of two data sequences", comment="", examples={@GamlAnnotations.example(value="covariance([13,2,1,4,1,2], [1,2,1,3,1,2]) with_precision(2)", equals="-0.67")})
    public static Double opCovariance(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        return Descriptive.covariance((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer2));
    }

    @GamlAnnotations.operator(value={"dbscan"}, can_be_const=false, type=5, category={"Statistical operators"}, concept={"statistic", "clustering"})
    @GamlAnnotations.doc(value="returns the list of clusters (list of instance indices) computed with the dbscan (density-based spatial clustering of applications with noise) algorithm from the first operand data according to the maximum radius of the neighborhood to be considered (eps) and the minimum number of points needed for a cluster (minPts). Usage: dbscan(data,eps,minPoints)", special_cases={"if the lengths of two vectors in the right-hand aren't equal, returns 0"}, examples={@GamlAnnotations.example(value="dbscan ([[2,4,5], [3,8,2], [1,1,3], [4,3,4]],10,2)", equals="[[0,1,2,3]]")})
    public static IList<IList> opDBScan(IScope iScope, IList iList, Double d, Integer n) throws GamaRuntimeException {
        double[] dArray;
        Object object;
        IList iList2 = GamaListFactory.create((IType)Types.INT);
        DBSCANClusterer dBSCANClusterer = new DBSCANClusterer(d.doubleValue(), n.intValue());
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        int n2 = 0;
        while (n2 < iList.size()) {
            object = (IList)iList.get(n2);
            dArray = new double[object.size()];
            int n3 = 0;
            while (n3 < object.size()) {
                dArray[n3] = Cast.asFloat((IScope)iScope, (Object)object.get(n3));
                ++n3;
            }
            iList2.add((Object)n2);
            arrayList.add(new Instance(n2, dArray));
            ++n2;
        }
        List list = dBSCANClusterer.cluster(arrayList);
        object = null;
        dArray = null;
        try (Collector.AsList asList = Collector.getList();){
            IList iList3;
            for (Object object2 : list) {
                iList3 = GamaListFactory.create();
                for (DoublePoint doublePoint : object2.getPoints()) {
                    Integer n4 = ((Instance)doublePoint).getId();
                    iList3.addValue(iScope, (Object)n4);
                    iList2.remove((Object)n4);
                }
                asList.add((Object)iList3);
            }
            for (Object object2 : iList2) {
                iList3 = GamaListFactory.create();
                iList3.add(object2);
                asList.add((Object)iList3);
            }
            return asList.items();
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    @GamlAnnotations.operator(value={"durbin_watson"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Durbin-Watson computation", comment="", examples={@GamlAnnotations.example(value="durbin_watson([13,2,1,4,1,2]) with_precision(4)", equals="0.7231")})
    public static Double opDurbinWatson(IScope iScope, IContainer iContainer) {
        return Descriptive.durbinWatson((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer));
    }

    @GamlAnnotations.operator(value={"dtw"}, can_be_const=false, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="returns the dynamic time warping between the two series of values (step pattern used: symetric1)", examples={@GamlAnnotations.example(value="dtw([32.0,5.0,1.0,3.0],[1.0,10.0,5.0,1.0])", equals="38.0")})
    public static Double opDynamicTimeWarping(IScope iScope, IList iList, IList iList2) throws GamaRuntimeException {
        int n = iList.size();
        int n2 = iList2.size();
        double[][] dArray = new double[2][n2 + 1];
        dArray[0][0] = 0.0;
        int n3 = 1;
        while (n3 <= n2) {
            dArray[0][n3] = Double.POSITIVE_INFINITY;
            ++n3;
        }
        n3 = 1;
        while (n3 <= n) {
            dArray[1][0] = Double.POSITIVE_INFINITY;
            int n4 = 1;
            while (n4 <= n2) {
                double d = Math.abs(Cast.asFloat((IScope)iScope, (Object)iList.get(n3 - 1)) - Cast.asFloat((IScope)iScope, (Object)iList2.get(n4 - 1)));
                double d2 = dArray[0][n4 - 1];
                if (d2 > dArray[0][n4]) {
                    d2 = dArray[0][n4];
                }
                if (d2 > dArray[1][n4 - 1]) {
                    d2 = dArray[1][n4 - 1];
                }
                dArray[1][n4] = d + d2;
                ++n4;
            }
            double[] dArray2 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = dArray2;
            ++n3;
        }
        return dArray[0][n2];
    }

    @GamlAnnotations.operator(value={"dtw"}, can_be_const=false, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="returns the dynamic time warping between the two series of values (step pattern used: symetric1) with Sakoe-Chiba band (radius: the window width of Sakoe-Chiba band)", examples={@GamlAnnotations.example(value="dtw([10.0,5.0,1.0, 3.0],[1.0,10.0,5.0,1.0], 2)", equals="11.0")})
    public static Double opDynamicTimeWarping(IScope iScope, IList iList, IList iList2, int n) throws GamaRuntimeException {
        int n2 = iList.size();
        int n3 = iList2.size();
        double[][] dArray = new double[2][n3 + 1];
        dArray[0][0] = 0.0;
        int n4 = 1;
        while (n4 <= n3) {
            dArray[0][n4] = Double.POSITIVE_INFINITY;
            ++n4;
        }
        n4 = 1;
        while (n4 <= n2) {
            int n5 = Math.max(1, n4 - n);
            int n6 = Math.min(n3, n4 + n);
            dArray[1][n5 - 1] = Double.POSITIVE_INFINITY;
            if (n6 < n3) {
                dArray[1][n6 + 1] = Double.POSITIVE_INFINITY;
            }
            int n7 = n5;
            while (n7 <= n6) {
                double d = Math.abs(Cast.asFloat((IScope)iScope, (Object)iList.get(n4 - 1)) - Cast.asFloat((IScope)iScope, (Object)iList2.get(n7 - 1)));
                double d2 = dArray[0][n7 - 1];
                if (d2 > dArray[0][n7]) {
                    d2 = dArray[0][n7];
                }
                if (d2 > dArray[1][n7 - 1]) {
                    d2 = dArray[1][n7 - 1];
                }
                dArray[1][n7] = d + d2;
                ++n7;
            }
            double[] dArray2 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = dArray2;
            ++n4;
        }
        return dArray[0][n3];
    }

    @GamlAnnotations.operator(value={"frequency_of"}, can_be_const=true, iterator=true, index_type=-298, content_type=1, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns a map with keys equal to the application of the right-hand argument (like collect) and values equal to the frequency of this key (i.e. how many times it has been obtained)", comment="", examples={@GamlAnnotations.example(value="[1, 2, 3, 3, 4, 4, 5, 3, 3, 4] frequency_of each", equals="map([1::1,2::1,3::4,4::3,5::1])")})
    public static IMap opFrequencyOf(IScope iScope, IContainer iContainer, IExpression iExpression) throws GamaRuntimeException {
        if (iContainer == null) {
            return GamaMapFactory.create((IType)Types.NO_TYPE, (IType)Types.INT);
        }
        IMap iMap = GamaMapFactory.create((IType)iContainer.getGamlType().getContentType(), (IType)Types.INT);
        for (Object t : iContainer.iterable(iScope)) {
            iScope.setEach(t);
            Object object = iExpression.value(iScope);
            if (!iMap.containsKey(object)) {
                iMap.put(object, (Object)1);
                continue;
            }
            iMap.put(object, (Object)((Integer)iMap.get(object) + 1));
        }
        return iMap;
    }

    @GamlAnnotations.operator(value={"gamma"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the value of the Gamma function at x.", comment="", examples={@GamlAnnotations.example(value="gamma(5)", equals="24.0")})
    public static Double opGamma(IScope iScope, Double d) {
        try {
            return Gamma.gamma((double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .gamma reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"gamma_distribution", "pgamma"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the integral from zero to x of the gamma probability density function.", comment="incomplete_gamma(a,x) is equal to pgamma(a,1,x).", examples={@GamlAnnotations.example(value="gamma_distribution(2,3,0.9) with_precision(3)", equals="0.269")})
    public static Double opGamma(IScope iScope, Double d, Double d2, Double d3) {
        try {
            return Probability.gamma((double)d, (double)d2, (double)d3);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .gamma reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"gamma_distribution_complemented"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the integral from x to infinity of the gamma probability density function.", comment="", examples={@GamlAnnotations.example(value="gamma_distribution_complemented(2,3,0.9) with_precision(3)", equals="0.731")})
    public static Double opGammaComplemented(IScope iScope, Double d, Double d2, Double d3) {
        try {
            return Probability.gammaComplemented((double)d, (double)d2, (double)d3);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .gamma reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"geometric_mean"}, can_be_const=true, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the geometric mean of the elements of the operand. See <a href=\"http://en.wikipedia.org/wiki/Geometric_mean\">Geometric_mean</a> for more details.", comment="The operator casts all the numerical element of the list into float. The elements that are not numerical are discarded.", special_cases={""}, examples={@GamlAnnotations.example(value="geometric_mean ([4.5, 3.5, 5.5, 7.0])", equals="4.962326343467649")}, see={"mean", "median", "harmonic_mean"})
    public static Double opGeometricMean(IScope iScope, IContainer iContainer) {
        DataSet dataSet = Stats.toDataSet(iScope, iContainer);
        return dataSet.getGeometricMean();
    }

    @GamlAnnotations.operator(value={"gini"}, category={"Spatial operators", "Statistical operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="return the Gini Index of the given list of values (list of floats)", examples={@GamlAnnotations.example(value="gini([1.0, 0.5, 2.0])", equals="the gini index computed i.e. 0.2857143", test=false)})})
    @GamlAnnotations.test(value="(gini([1.0, 0.5, 2.0]) with_precision 4) = 0.2857")
    public static double opGini(IScope iScope, IList<Double> iList) {
        int n = iList.size();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d3 = (Double)iList.get(n2);
            d2 += d3;
            int n3 = 0;
            while (n3 < n) {
                double d4 = (Double)iList.get(n3);
                d += Math.abs(d3 - d4);
                ++n3;
            }
            ++n2;
        }
        return d /= (double)(2 * n) * d2;
    }

    @GamlAnnotations.operator(value={"harmonic_mean"}, can_be_const=true, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the harmonic mean of the elements of the operand. See <a href=\"http://en.wikipedia.org/wiki/Harmonic_mean\">Harmonic_mean</a> for more details.", comment="The operator casts all the numerical element of the list into float. The elements that are not numerical are discarded.", special_cases={""}, examples={@GamlAnnotations.example(value="harmonic_mean ([4.5, 3.5, 5.5, 7.0])", equals="4.804159445407279")}, see={"mean", "median", "geometric_mean"})
    public static Double opHarmonicMean(IScope iScope, IContainer iContainer) {
        DataSet dataSet = Stats.toDataSet(iScope, iContainer);
        return dataSet.getHarmonicMean();
    }

    @GamlAnnotations.operator(value={"incomplete_beta"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the regularized integral of the beta function with arguments a and b, from zero to x.", comment="", examples={@GamlAnnotations.example(value="incomplete_beta(2,3,0.9) with_precision(3)", equals="0.996")})
    public static Double opIncompleteBeta(IScope iScope, Double d, Double d2, Double d3) {
        try {
            return Gamma.incompleteBeta((double)d, (double)d2, (double)d3);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .incompleteBeta reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"incomplete_gamma"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value=" Returns the regularized integral of the Gamma function with argument a to the integration end point x.", comment="", examples={@GamlAnnotations.example(value="incomplete_gamma(1,5.3) with_precision(3)", equals="0.995")})
    public static Double opIncompleteGamma(IScope iScope, Double d, Double d2) {
        try {
            return Gamma.incompleteGamma((double)d, (double)d2);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .incompleteGamma reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"incomplete_gamma_complement"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the complemented regularized incomplete Gamma function of the argument a and integration start point x.", comment="Is the complement to 1 of incomplete_gamma.", examples={@GamlAnnotations.example(value="incomplete_gamma_complement(1,5.3) with_precision(3)", equals="0.005")})
    public static Double opIncompleteGammaComplement(IScope iScope, Double d, Double d2) {
        try {
            return Gamma.incompleteGammaComplement((double)d, (double)d2);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .incompleteGammaComplement reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"kmeans"}, can_be_const=false, type=5, category={"Statistical operators"}, concept={"statistic", "clustering"})
    @GamlAnnotations.doc(value="returns the list of clusters (list of instance indices) computed with the kmeans++ algorithm from the first operand data according to the number of clusters to split the data into (k). Usage: kmeans(data,k)", usages={@GamlAnnotations.usage(value="The maximum number of (third operand) can be omitted.", examples={@GamlAnnotations.example(value="kmeans ([[2,4,5], [3,8,2], [1,1,3], [4,3,4]],2)", equals="[[0,2,3],[1]]")})})
    public static IList<IList> opKMeans(IScope iScope, IList iList, Integer n) throws GamaRuntimeException {
        return Stats.opKMeans(iScope, iList, n, -1);
    }

    @GamlAnnotations.operator(value={"kmeans"}, can_be_const=false, type=5, category={"Statistical operators"}, concept={"statistic", "clustering"})
    @GamlAnnotations.doc(value="returns the list of clusters (list of instance indices) computed with the kmeans++ algorithm from the first operand data according to the number of clusters to split the data into (k) and the maximum number of iterations to run the algorithm.(If negative, no maximum will be used) (maxIt). Usage: kmeans(data,k,maxit)", masterDoc=true, examples={@GamlAnnotations.example(value="kmeans ([[2,4,5], [3,8,2], [1,1,3], [4,3,4]],2,10)", equals="[[0,2,3],[1]]")})
    public static IList<IList> opKMeans(IScope iScope, IList iList, Integer n, Integer n2) throws GamaRuntimeException {
        Object object;
        Object object2;
        MersenneTwister mersenneTwister = new MersenneTwister(iScope.getRandom().getSeed().longValue());
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        int n3 = 0;
        while (n3 < iList.size()) {
            object2 = (IList)iList.get(n3);
            object = new double[object2.size()];
            int n4 = 0;
            while (n4 < object2.size()) {
                object[n4] = Cast.asFloat((IScope)iScope, (Object)object2.get(n4));
                ++n4;
            }
            arrayList.add(new Instance(n3, (double[])object));
            ++n3;
        }
        KMeansPlusPlusClusterer kMeansPlusPlusClusterer = new KMeansPlusPlusClusterer(n.intValue(), n2.intValue(), (DistanceMeasure)new EuclideanDistance(), (RandomGenerator)mersenneTwister);
        object2 = kMeansPlusPlusClusterer.cluster(arrayList);
        object = null;
        Object var9_12 = null;
        try (Collector.AsList asList = Collector.getList();){
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Cluster cluster = (Cluster)iterator.next();
                IList iList2 = GamaListFactory.create();
                for (DoublePoint doublePoint : cluster.getPoints()) {
                    iList2.addValue(iScope, (Object)((Instance)doublePoint).getId());
                }
                asList.add((Object)iList2);
            }
            return asList.items();
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    @GamlAnnotations.operator(value={"kurtosis"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the kurtosis from a moment and a standard deviation", comment="", examples={@GamlAnnotations.example(value="kurtosis(3,12) with_precision(4)", equals="-2.9999")})
    public static Double opKurtosis(IScope iScope, Double d, Double d2) {
        return Descriptive.kurtosis((double)d, (double)d2);
    }

    @GamlAnnotations.operator(value={"kurtosis"}, can_be_const=true, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic", "clustering"})
    @GamlAnnotations.doc(value="Returns the kurtosis (aka excess) of a list of values (kurtosis = { [n(n+1) / (n -1)(n - 2)(n-3)] sum[(x_i - mean)^4] / std^4 } - [3(n-1)^2 / (n-2)(n-3)])", special_cases={"if the length of the list is lower than 3, returns NaN"}, examples={@GamlAnnotations.example(value="kurtosis ([1,2,3,4,5])", equals="-1.200000000000002"), @GamlAnnotations.example(value="kurtosis([13,2,1,4,1,2]) with_precision(4)", equals="4.8083")})
    public static Double opKurtosis(IScope iScope, IList iList) throws GamaRuntimeException {
        Kurtosis kurtosis = new Kurtosis();
        double[] dArray = new double[iList.length(iScope)];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Cast.asFloat((IScope)iScope, (Object)iList.get(n));
            ++n;
        }
        return kurtosis.evaluate(dArray);
    }

    @GamlAnnotations.operator(value={"log_gamma", "lgamma"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the log of the value of the Gamma function at x.", comment="", examples={@GamlAnnotations.example(value="log_gamma(0.6) with_precision(4)", equals="0.3982")})
    public static Double opLogGamma(IScope iScope, Double d) {
        try {
            return Gamma.logGamma((double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .logGamma reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"max"}, can_be_const=true, type=-299, expected_content_type={1, 2, 7}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the maximum element found in the operand", masterDoc=true, comment="the max operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list of int of float, max returns the maximum of all the elements", examples={@GamlAnnotations.example(value="max ([100, 23.2, 34.5])", equals="100.0")}), @GamlAnnotations.usage(value="if it is a list of points: max returns the maximum of all points as a point (i.e. the point with the greatest coordinate on the x-axis, in case of equality the point with the greatest coordinate on the y-axis is chosen. If all the points are equal, the first one is returned. )", examples={@GamlAnnotations.example(value="max([{1.0,3.0},{3.0,5.0},{9.0,1.0},{7.0,8.0}])", equals="{9.0,1.0}")}), @GamlAnnotations.usage(value="if it is a population of a list of other type: max transforms all elements into integer and returns the maximum of them"), @GamlAnnotations.usage(value="if it is a map, max returns the maximum among the list of all elements value"), @GamlAnnotations.usage(value="if it is a file, max returns the maximum of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a graph, max returns the maximum of the list of the elements of the graph (that can be the list of edges or vertexes depending on the graph)"), @GamlAnnotations.usage(value="if it is a matrix of int, float or object, max returns the maximum of all the numerical elements (thus all elements for integer and float matrices)"), @GamlAnnotations.usage(value="if it is a matrix of geometry, max returns the maximum of the list of the geometries"), @GamlAnnotations.usage(value="if it is a matrix of another type, max returns the maximum of the elements transformed into float")}, see={"min"})
    public static Object opMax(IScope iScope, IContainer iContainer) {
        if (iContainer instanceof GamaField) {
            return ((GamaField)iContainer).getMinMax()[1];
        }
        Object object = null;
        GamaPoint gamaPoint = null;
        for (Object t : iContainer.iterable(iScope)) {
            if (t instanceof GamaPoint && object == null) {
                if (gamaPoint != null && ((GamaPoint)t).compareTo((Coordinate)gamaPoint) <= 0) continue;
                gamaPoint = (GamaPoint)t;
                continue;
            }
            if (t instanceof Number && gamaPoint == null && (object == null || ((Number)t).doubleValue() > ((Number)object).doubleValue())) {
                object = (Number)t;
                continue;
            }
            Double d = Cast.asFloat((IScope)iScope, t);
            if (object != null && !(d > ((Number)object).doubleValue())) continue;
            object = d;
        }
        return object == null ? gamaPoint : object;
    }

    @GamlAnnotations.operator(value={"mean_deviation"}, can_be_const=true, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the deviation from the mean of all the elements of the operand. See <a href= \"http://en.wikipedia.org/wiki/Absolute_deviation\" >Mean_deviation</a> for more details.", comment="The operator casts all the numerical element of the list into float. The elements that are not numerical are discarded.", examples={@GamlAnnotations.example(value="mean_deviation ([4.5, 3.5, 5.5, 7.0])", equals="1.125")}, see={"mean", "standard_deviation"})
    public static Double opMeanDeviation(IScope iScope, IContainer iContainer) {
        DataSet dataSet = Stats.toDataSet(iScope, iContainer);
        return dataSet.getMeanDeviation();
    }

    @GamlAnnotations.operator(value={"median"}, can_be_const=true, type=-299, expected_content_type={1, 2, 7, 6}, category={"Statistical operators", "Containers-related operators", "Color-related operators"}, concept={"statistic", "color"})
    @GamlAnnotations.doc(value="the median of all the elements of the operand.", special_cases={"if the container contains points, the result will be a point. If the container contains rgb values, the result will be a rgb color"}, examples={@GamlAnnotations.example(value="median ([4.5, 3.5, 5.5, 3.4, 7.0])", equals="4.5")}, see={"mean"})
    public static Object opMedian(IScope iScope, IContainer iContainer) {
        Object object3;
        IType iType = iContainer.getGamlType().getContentType();
        if (iContainer.length(iScope) == 0) {
            return iType.cast(iScope, (Object)0.0, null, false);
        }
        switch (iType.id()) {
            case 1: 
            case 2: {
                Object object22;
                DataSet dataSet = new DataSet();
                for (Object object22 : iContainer.iterable(iScope)) {
                    dataSet.addValue(Cast.asFloat((IScope)iScope, object22));
                }
                object22 = dataSet.getSize() == 0 ? 0.0 : dataSet.getMedian();
                return iType.cast(iScope, object22, null, false);
            }
            case 7: {
                DataSet dataSet = new DataSet();
                DataSet dataSet2 = new DataSet();
                DataSet dataSet3 = new DataSet();
                for (Object t : iContainer.iterable(iScope)) {
                    GamaPoint gamaPoint = (GamaPoint)t;
                    dataSet.addValue(gamaPoint.getX());
                    dataSet2.addValue(gamaPoint.getY());
                    dataSet3.addValue(gamaPoint.getZ());
                }
                if (dataSet.getSize() == 0) {
                    return new GamaPoint(0.0, 0.0, 0.0);
                }
                return new GamaPoint(dataSet.getMedian(), dataSet2.getMedian(), dataSet3.getMedian());
            }
            case 6: {
                DataSet dataSet = new DataSet();
                DataSet dataSet4 = new DataSet();
                DataSet dataSet5 = new DataSet();
                for (Object t : iContainer.iterable(iScope)) {
                    GamaColor gamaColor = (GamaColor)t;
                    dataSet.addValue(gamaColor.getRed());
                    dataSet4.addValue(gamaColor.getGreen());
                    dataSet5.addValue(gamaColor.getBlue());
                }
                if (dataSet.getSize() == 0) {
                    return GamaColor.get((int)0, (int)0, (int)0, (int)0);
                }
                return GamaColor.get((int)((int)dataSet.getMedian()), (int)((int)dataSet4.getMedian()), (int)((int)dataSet5.getMedian()), (int)0);
            }
        }
        DataSet dataSet = new DataSet();
        for (Object object3 : iContainer.iterable(iScope)) {
            dataSet.addValue(Cast.asFloat((IScope)iScope, object3));
        }
        object3 = dataSet.getSize() == 0 ? 0.0 : dataSet.getMedian();
        return Cast.asFloat((IScope)iScope, object3);
    }

    @GamlAnnotations.operator(value={"min"}, can_be_const=true, type=-299, expected_content_type={1, 2, 7}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the minimum element found in the operand.", masterDoc=true, comment="the min operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list of int or float: min returns the minimum of all the elements", examples={@GamlAnnotations.example(value="min ([100, 23.2, 34.5])", equals="23.2")}), @GamlAnnotations.usage(value="if it is a list of points: min returns the minimum of all points as a point (i.e. the point with the smallest coordinate on the x-axis, in case of equality the point with the smallest coordinate on the y-axis is chosen. If all the points are equal, the first one is returned. )"), @GamlAnnotations.usage(value="if it is a population of a list of other types: min transforms all elements into integer and returns the minimum of them"), @GamlAnnotations.usage(value="if it is a map, min returns the minimum among the list of all elements value"), @GamlAnnotations.usage(value="if it is a file, min returns the minimum of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a graph, min returns the minimum of the list of the elements of the graph (that can be the list of edges or vertexes depending on the graph)"), @GamlAnnotations.usage(value="if it is a matrix of int, float or object, min returns the minimum of all the numerical elements (thus all elements for integer and float matrices)"), @GamlAnnotations.usage(value="if it is a matrix of geometry, min returns the minimum of the list of the geometries"), @GamlAnnotations.usage(value="if it is a matrix of another type, min returns the minimum of the elements transformed into float")}, see={"max"})
    public static Object opMin(IScope iScope, IContainer iContainer) {
        if (iContainer instanceof GamaField) {
            return ((GamaField)iContainer).getMinMax()[0];
        }
        Object object = null;
        GamaPoint gamaPoint = null;
        for (Object t : iContainer.iterable(iScope)) {
            if (t instanceof GamaPoint && object == null) {
                if (gamaPoint != null && ((GamaPoint)t).compareTo((Coordinate)gamaPoint) >= 0) continue;
                gamaPoint = (GamaPoint)t;
                continue;
            }
            if (t instanceof Number && gamaPoint == null && (object == null || ((Number)t).doubleValue() < ((Number)object).doubleValue())) {
                object = (Number)t;
                continue;
            }
            Double d = Cast.asFloat((IScope)iScope, t);
            if (object != null && !(d < ((Number)object).doubleValue())) continue;
            object = d;
        }
        return object == null ? gamaPoint : object;
    }

    @GamlAnnotations.operator(value={"moment"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the moment of k-th order with constant c of a data sequence", comment="", examples={@GamlAnnotations.example(value="moment([13,2,1,4,1,2], 2, 1.2) with_precision(4)", equals="24.74")})
    public static Double opMoment(IScope iScope, IContainer iContainer, Integer n, Double d) {
        return Descriptive.moment((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (int)n, (double)d);
    }

    @GamlAnnotations.operator(value={"normal_area", "pnorm"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the area to the left of x in the normal distribution with the given mean and standard deviation.", comment="", examples={@GamlAnnotations.example(value="normal_area(0.9,0,1) with_precision(3)", equals="0.816")})
    public static Double opNormalArea(IScope iScope, Double d, Double d2, Double d3) {
        try {
            return Probability.normal((double)d2, (double)d3, (double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .normal reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"normal_density", "dnorm"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the probability of x in the normal distribution with the given mean and standard deviation.", comment="", examples={@GamlAnnotations.example(value="(normal_density(2,1,1)*100) with_precision 2", equals="24.2")})
    public static Double opNormalDensity(IScope iScope, Double d, Double d2, Double d3) {
        double d4 = d3 * d3;
        double d5 = 1.0 / Math.sqrt(Math.PI * 2 * d4);
        double d6 = (d - d2) * (d - d2) / (2.0 * d4);
        return d5 * Math.exp(-d6);
    }

    @GamlAnnotations.operator(value={"normal_inverse"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the x in the normal distribution with the given mean and standard deviation, to the left of which lies the given area. normal.", comment="", examples={@GamlAnnotations.example(value="normal_inverse(0.98,0,1) with_precision(2)", equals="2.05")})
    public static Double opNormalInverse(IScope iScope, Double d, Double d2, Double d3) {
        try {
            double d4 = Probability.normalInverse((double)d);
            return (d4 + d2) * d3;
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .normalInverse reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"predict"}, can_be_const=false, type=2, category={"Statistical operators"}, concept={"statistic", "regression"})
    @GamlAnnotations.doc(value="returns the value predicted by the regression parameters for a given instance. Usage: predict(regression, instance)", examples={@GamlAnnotations.example(value="predict(my_regression, [1,2,3])", isExecutable=false)})
    @GamlAnnotations.test(value="predict(build(matrix([[1.0,2.0,3.0,4.0],[2.0,3.0,4.0,2.0]])),[1,2,3,2] ) = 2.1818181818181817")
    public static Double opPredict(IScope iScope, GamaRegression gamaRegression, IList iList) {
        return gamaRegression.predict(iScope, iList);
    }

    @GamlAnnotations.operator(value={"mul", "product"}, can_be_const=true, type=-299, expected_content_type={1, 2, 7}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the product of all the elements of the operand", masterDoc=true, comment="the mul operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list of int or float: mul returns the product of all the elements", examples={@GamlAnnotations.example(value="mul ([100, 23.2, 34.5])", equals="80040.0")}), @GamlAnnotations.usage(value="if it is a list of points: mul returns the product of all points as a point (each coordinate is the product of the corresponding coordinate of each element)"), @GamlAnnotations.usage(value="if it is a list of other types: mul transforms all elements into integer and multiplies them"), @GamlAnnotations.usage(value="if it is a map, mul returns the product of the value of all elements"), @GamlAnnotations.usage(value="if it is a file, mul returns the product of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a graph, mul returns the product of the list of the elements of the graph (that can be the list of edges or vertexes depending on the graph)"), @GamlAnnotations.usage(value="if it is a matrix of int, float or object, mul returns the product of all the numerical elements (thus all elements for integer and float matrices)"), @GamlAnnotations.usage(value="if it is a matrix of geometry, mul returns the product of the list of the geometries"), @GamlAnnotations.usage(value="if it is a matrix of other types: mul transforms all elements into float and multiplies them")}, see={"sum"})
    public static Object opProduct(IScope iScope, IContainer iContainer) {
        DataSet dataSet = new DataSet();
        DataSet dataSet2 = null;
        DataSet dataSet3 = null;
        for (Object t : iContainer.iterable(iScope)) {
            if (t instanceof GamaPoint) {
                if (dataSet2 == null) {
                    dataSet2 = new DataSet();
                    dataSet3 = new DataSet();
                }
                GamaPoint gamaPoint = (GamaPoint)t;
                dataSet.addValue(gamaPoint.getX());
                dataSet2.addValue(gamaPoint.getY());
                dataSet3.addValue(gamaPoint.getZ());
                continue;
            }
            dataSet.addValue(Cast.asFloat((IScope)iScope, t));
        }
        if (dataSet.getSize() == 0) {
            if (dataSet2 == null) {
                return 0.0;
            }
            return new GamaPoint(0.0, 0.0, 0.0);
        }
        if (dataSet2 == null) {
            return dataSet.getProduct();
        }
        return new GamaPoint(dataSet.getProduct(), dataSet2.getProduct(), dataSet3.getProduct());
    }

    @GamlAnnotations.operator(value={"product_of"}, type=-198, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the product of the right-hand expression evaluated on each of the elements of the left-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] product_of (each)", equals="48")})}, examples={@GamlAnnotations.example(value="[1,2] product_of (each * 10 )", equals="200")}, see={"min_of", "max_of", "sum_of", "mean_of"})
    @GamlAnnotations.test(value="[3,4] product_of (each *2) = 48")
    public static Object opProductOf(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Stats.opProduct(iScope, (IContainer)Containers.collect((IScope)iScope, (IContainer)iContainer, (IExpression)iExpression));
    }

    @GamlAnnotations.operator(value={"pValue_for_fStat"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the P value of F statistic fstat with numerator degrees of freedom dfn and denominator degress of freedom dfd. Uses the incomplete Beta function.", comment="", examples={@GamlAnnotations.example(value="pValue_for_fStat(1.9,10,12) with_precision(3)", equals="0.145")})
    public static Double opPvalueForFstat(IScope iScope, Double d, Integer n, Integer n2) {
        double d2 = (double)n2.intValue() / ((double)n2.intValue() + (double)n.intValue() * d);
        try {
            return Gamma.incompleteBeta((double)((double)n2.intValue() / 2.0), (double)((double)n.intValue() / 2.0), (double)d2);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .incompleteBeta reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"pValue_for_tStat"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the P value of the T statistic tstat with df degrees of freedom. This is a two-tailed test so we just double the right tail which is given by studentT of -|tstat|.", comment="", examples={@GamlAnnotations.example(value="pValue_for_tStat(0.9,10) with_precision(3)", equals="0.389")})
    public static Double opPvalueForTstat(IScope iScope, Double d, Integer n) {
        double d2 = Math.abs(d);
        try {
            double d3 = Probability.studentT((double)n.intValue(), (double)(-d2));
            return 2.0 * d3;
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .studentT reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"quantile"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the phi-quantile; that is, an element elem for which holds that phi percent of data elements are less than elem. The quantile does not need necessarily to be contained in the data sequence, it can be a linear interpolation. Note that the container holding the values must be sorted first", comment="", examples={@GamlAnnotations.example(value="quantile([1,3,5,6,9,11,12,13,19,21,22,32,35,36,45,44,55,68,79,80,81,88,90,91,92,100], 0.5)", equals="35.5")})
    public static Double opQuantile(IScope iScope, IContainer iContainer, Double d) {
        return Descriptive.quantile((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (double)d);
    }

    @GamlAnnotations.operator(value={"quantile_inverse", "percentile"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns how many percent of the elements contained in the receiver are <= element. Does linear interpolation if the element is not contained but lies in between two contained elements. Note that the container holding the values must be sorted first", comment="", examples={@GamlAnnotations.example(value="quantile_inverse([1,3,5,6,9,11,12,13,19,21,22,32,35,36,45,44,55,68,79,80,81,88,90,91,92,100], 35.5) with_precision(2)", equals="0.52")})
    public static Double opQuantileInverse(IScope iScope, IContainer iContainer, Double d) {
        return Descriptive.quantileInverse((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (double)d);
    }

    @GamlAnnotations.operator(value={"rank_interpolated"}, can_be_const=true, type=2, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the linearly interpolated number of elements in a list less or equal to a given element. The rank is the number of elements <= element. Ranks are of the form {0, 1, 2,..., sortedList.size()}. If no element is <= element, then the rank is zero. If the element lies in between two contained elements, then linear interpolation is used and a non integer value is returned. Note that the container holding the values must be sorted first", comment="", examples={@GamlAnnotations.example(value="rank_interpolated([1,3,5,6,9,11,12,13,19,21,22,32,35,36,45,44,55,68,79,80,81,88,90,91,92,100], 35)", equals="13.0")})
    public static Double opRankInterpolated(IScope iScope, IContainer iContainer, Double d) {
        return Descriptive.rankInterpolated((DoubleArrayList)Stats.toDoubleArrayList(iScope, iContainer), (double)d);
    }

    @GamlAnnotations.operator(value={"build"}, can_be_const=false, type=21, category={"Statistical operators"}, concept={})
    @GamlAnnotations.doc(value="returns the regression build from the matrix data (a row = an instance, the first value of each line is the y value) while using the given ordinary least squares method. Usage: build(data)", examples={@GamlAnnotations.example(value="build(matrix([[1.0,2.0,3.0,4.0],[2.0,3.0,4.0,2.0]]))", isExecutable=false)})
    @GamlAnnotations.test(value="build(matrix([[1.0,2.0,3.0,4.0],[2.0,3.0,4.0,2.0],[5.0,1.0,3.0,5.0],[3.0,4.0,5.0,1.0]])).parameters collect (each with_precision 5) = [0.5,2.5,0.0,-1.5]")
    public static GamaRegression opRegression(IScope iScope, GamaMatrix gamaMatrix) throws GamaRuntimeException {
        try {
            return new GamaRegression(iScope, gamaMatrix);
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)"The build operator is not usable for these data", (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"rSquare"}, type=2, category={"Statistical operators"}, concept={"statistic", "regression"})
    @GamlAnnotations.doc(value="Return the value of the adjusted R square for a given regression model", examples={@GamlAnnotations.example(value="rSquare(my_regression)", isExecutable=false)})
    @GamlAnnotations.test(value="rSquare(build(matrix([[4.0,1.0,2.0,3.0],[4.0,2.0,3.0,4.0]]))) = 0.8363636363636364")
    public static Double rSquare(IScope iScope, GamaRegression gamaRegression) {
        return gamaRegression.getRSquare();
    }

    @GamlAnnotations.operator(value={"residuals"}, type=5, category={"Statistical operators"}, concept={"statistic", "regression"})
    @GamlAnnotations.doc(value="Return the list of residuals for a given regression model", examples={@GamlAnnotations.example(value="residuals(my_regression)", isExecutable=false)})
    public static IList<Double> residuals(IScope iScope, GamaRegression gamaRegression) {
        return gamaRegression.getResiduals();
    }

    @GamlAnnotations.operator(value={"sobolAnalysis"}, type=4, can_be_const=true, category={"Statistical operators"}, concept={"statistic"}, expected_content_type={4, 1})
    @GamlAnnotations.doc(value="Return a string containing the Report of the sobol analysis for the corresponding .csv file and save this report in a txt/csv file.")
    public static String sobolAnalysis(IScope iScope, String string, String string2, int n) {
        File file = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false));
        File file2 = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string2, (boolean)false));
        Sobol sobol = new Sobol(file, n, iScope);
        sobol.evaluate();
        sobol.saveResult(file2);
        return sobol.buildReportString(FileNameUtils.getExtension((String)file2.getPath()));
    }

    @GamlAnnotations.operator(value={"morrisAnalysis"}, type=4, can_be_const=true, category={"Statistical operators"}, concept={"statistic"}, expected_content_type={4, 1})
    @GamlAnnotations.doc(value="Return a string containing the Report of the morris analysis for the corresponding CSV file")
    public static String morrisAnalysis(IScope iScope, String string, int n, int n2) {
        File file = new File(FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)false));
        Morris morris = new Morris(file, n2, n, iScope);
        morris.evaluate();
        return morris.buildReportString(FileNameUtils.getExtension((String)string));
    }

    public static String stochanalyse(int n, int n2, String string, int n3, IScope iScope) {
        String string2 = iScope.getExperiment().getWorkingPath() + "/" + string;
        return Stochanalysis.stochasticityAnalysis_From_CSV((int)n, (double)n2, (String)string2, (int)n3, (IScope)iScope);
    }

    @GamlAnnotations.operator(value={"rms"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the RMS (Root-Mean-Square) of a data sequence. The RMS of data sequence is the square-root of the mean of the squares of the elements in the data sequence. It is a measure of the average size of the elements of a data sequence.", comment="", examples={@GamlAnnotations.example(value=" list<float> data_sequence <- [6.0, 7.0, 8.0, 9.0]; "), @GamlAnnotations.example(value=" list<float> squares <- data_sequence collect (each*each); "), @GamlAnnotations.example(value=" rms(length(data_sequence),sum(squares)) with_precision(4) ", equals="7.5829")})
    public static Double opRms(IScope iScope, Integer n, Double d) {
        return Descriptive.rms((int)n, (double)d);
    }

    @GamlAnnotations.operator(value={"skewness", "skew"}, can_be_const=false, category={"Statistical operators"}, concept={"statistic", "clustering"})
    @GamlAnnotations.doc(value="returns skewness value computed from the operand list of values", special_cases={"if the length of the list is lower than 3, returns NaN"}, examples={@GamlAnnotations.example(value="skewness ([1,2,3,4,5])", equals="0.0")})
    public static Double opSkewness(IScope iScope, IList iList) throws GamaRuntimeException {
        Skewness skewness = new Skewness();
        double[] dArray = new double[iList.length(iScope)];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Cast.asFloat((IScope)iScope, (Object)iList.get(n));
            ++n;
        }
        return skewness.evaluate(dArray);
    }

    @GamlAnnotations.operator(value={"split"}, can_be_const=true, content_type=5, expected_content_type={1, 2}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(see={"split_in", "split_using"}, value="Splits a list of numbers into n=(1+3.3*log10(elements)) bins. The splitting is strict (i.e. elements are in the ith bin if they are strictly smaller than the ith bound)", examples={@GamlAnnotations.example(value="split([1.0,2.0,1.0,3.0,1.0,2.0])", equals="[[1.0,1.0,1.0],[2.0,2.0],[3.0]]")})
    public static <T extends Number> IList<IList<T>> opSplit(IScope iScope, IList<T> iList) {
        int n = (int)(1.0 + 3.3 * Math.log10(iList.size()));
        return Stats.opSplitIn(iScope, iList, n);
    }

    @GamlAnnotations.operator(value={"split_in"}, can_be_const=true, content_type=5, expected_content_type={1, 2}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(see={"split", "split_using"}, value="Splits a list of numbers into n bins defined by n-1 bounds between the minimum and maximum values found in the first argument. The splitting is strict (i.e. elements are in the ith bin if they are strictly smaller than the ith bound)", examples={@GamlAnnotations.example(value="list<float> li <- [1.0,3.1,5.2,6.0,9.2,11.1,12.0,13.0,19.9,35.9,40.0];"), @GamlAnnotations.example(value="split_in(li,3)", equals="[[1.0,3.1,5.2,6.0,9.2,11.1,12.0,13.0],[19.9],[35.9,40.0]]")})
    public static <T extends Number> IList<IList<T>> opSplitIn(IScope iScope, IList<T> iList, int n) {
        return Stats.opSplitIn(iScope, iList, n, true);
    }

    @GamlAnnotations.operator(value={"split_in"}, can_be_const=true, content_type=5, expected_content_type={1, 2}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(see={"split", "split_using"}, value="Splits a list of numbers into n bins defined by n-1 bounds between the minimum and maximum values found in the first argument. The boolean argument controls whether or not the splitting is  strict (if true, elements are in the ith bin if they are strictly smaller than the ith bound)", examples={@GamlAnnotations.example(value="list<float> l <- [1.0,3.1,5.2,6.0,9.2,11.1,12.0,13.0,19.9,35.9,40.0];"), @GamlAnnotations.example(value="split_in(l,3, true)", equals="[[1.0,3.1,5.2,6.0,9.2,11.1,12.0,13.0],[19.9],[35.9,40.0]]")})
    public static <T extends Number> IList<IList<T>> opSplitIn(IScope iScope, IList<T> iList, int n, boolean bl) {
        if (n <= 1) {
            IList iList2 = GamaListFactory.create((IType)Types.LIST.of(iList.getGamlType().getContentType()));
            iList2.add(iList);
            return iList2;
        }
        DataSet dataSet = Stats.toDataSet(iScope, iList);
        IList iList3 = GamaListFactory.create((IScope)iScope, (IType)Types.FLOAT, (double[])dataSet.getStops(n));
        return Stats.opSplitUsing(iScope, iList, (IList<? extends Comparable>)iList3);
    }

    @GamlAnnotations.operator(value={"split_using"}, can_be_const=true, content_type=5, expected_content_type={1, 2, 7}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(see={"split", "split_in"}, value="Splits a list of numbers into n+1 bins using a set of n bounds passed as the second argument. The splitting is strict (i.e. elements are in the ith bin if they are strictly smaller than the ith bound), when no boolean attribute is specified.", masterDoc=true, examples={@GamlAnnotations.example(value="list<float> li <- [1.0,3.1,5.2,6.0,9.2,11.1,12.0,13.0,19.9,35.9,40.0];"), @GamlAnnotations.example(value="split_using(li,[1.0,3.0,4.2])", equals="[[],[1.0],[3.1],[5.2,6.0,9.2,11.1,12.0,13.0,19.9,35.9,40.0]]")})
    public static <T extends Number> IList<IList<T>> opSplitUsing(IScope iScope, IList<T> iList, IList<? extends Comparable> iList2) {
        return Stats.opSplitUsing(iScope, iList, iList2, true);
    }

    @GamlAnnotations.operator(value={"split_using"}, can_be_const=true, content_type=5, expected_content_type={1, 2, 7}, category={"Statistical operators", "Containers-related operators"}, concept={"statistic"})
    @GamlAnnotations.doc(see={"split", "split_in"}, value="Splits a list of numbers into n+1 bins using a set of n bounds passed as the second argument. The boolean argument controls whether or not the splitting is strict (if true, elements are in the ith bin if they are strictly smaller than the ith bound", examples={@GamlAnnotations.example(value="list<float> l <- [1.0,3.1,5.2,6.0,9.2,11.1,12.0,13.0,19.9,35.9,40.0];"), @GamlAnnotations.example(value="split_using(l,[1.0,3.0,4.2], true)", equals="[[],[1.0],[3.1],[5.2,6.0,9.2,11.1,12.0,13.0,19.9,35.9,40.0]]")})
    public static <T extends Number> IList<IList<T>> opSplitUsing(IScope iScope, IList<T> iList, IList<? extends Comparable> iList2, boolean bl) {
        if (iList2.size() == 0) {
            IList iList3 = GamaListFactory.create((IType)Types.LIST.of(iList.getGamlType().getContentType()));
            iList3.add(iList);
            return iList3;
        }
        if (!Ordering.natural().isStrictlyOrdered(iList2)) {
            throw GamaRuntimeException.error((String)("The list " + StringUtils.toGaml(iList2, (boolean)false) + " should be ordered and cannot contain duplicates"), (IScope)iScope);
        }
        DataSet dataSet = Stats.toDataSet(iScope, iList2);
        dataSet.addValue(Double.MAX_VALUE);
        IType iType = iList.getGamlType().getContentType();
        IList iList4 = GamaListFactory.createWithoutCasting((IType)Types.LIST.of(iType), (Object[])new IList[0]);
        int n = 0;
        while (n < dataSet.dataSetSize) {
            iList4.add((Object)GamaListFactory.createWithoutCasting((IType)iType, (Object[])new Number[0]));
            ++n;
        }
        block1: for (Number number : iList) {
            int n2 = 0;
            while (n2 < dataSet.dataSetSize) {
                if (bl ? number.doubleValue() < dataSet.dataSet[n2] : number.doubleValue() <= dataSet.dataSet[n2]) {
                    ((IList)iList4.get(n2)).add((Object)((Number)iType.cast(iScope, (Object)number, null, false)));
                    continue block1;
                }
                ++n2;
            }
        }
        return iList4;
    }

    @GamlAnnotations.operator(value={"standard_deviation"}, can_be_const=true, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the standard deviation on the elements of the operand. See <a href=\"http://en.wikipedia.org/wiki/Standard_deviation\">Standard_deviation</a> for more details.", comment="The operator casts all the numerical element of the list into float. The elements that are not numerical are discarded.", special_cases={""}, examples={@GamlAnnotations.example(value="standard_deviation ([4.5, 3.5, 5.5, 7.0])", equals="1.2930100540985752")}, see={"mean", "mean_deviation"})
    public static Double opStandardDeviation(IScope iScope, IContainer iContainer) {
        DataSet dataSet = Stats.toDataSet(iScope, iContainer);
        return dataSet.getStandardDeviation();
    }

    @GamlAnnotations.operator(value={"student_area"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the area to the left of x in the Student T distribution with the given degrees of freedom.", comment="", examples={@GamlAnnotations.example(value="student_area(1.64,3) with_precision(2)", equals="0.9")})
    public static Double opStudentArea(IScope iScope, Double d, Integer n) {
        try {
            return Probability.studentT((double)n.intValue(), (double)d);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .studentT reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"student_t_inverse"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the value, t, for which the area under the Student-t probability density function (integrated from minus infinity to t) is equal to x.", comment="", examples={@GamlAnnotations.example(value="student_t_inverse(0.9,3) with_precision(2)", equals="1.64")})
    public static Double opStudentTInverse(IScope iScope, Double d, Integer n) {
        double d2 = 2.0 * (1.0 - d);
        try {
            return Probability.studentTInverse((double)d2, (int)n);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            throw GamaRuntimeException.error((String)("colt .studentTInverse reports: " + String.valueOf(runtimeException)), (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"t_test"}, can_be_const=false, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the observed significance level, or p-value, associated with a two-sample, two-tailed t-test comparing the means of the two input lists.The number returned is the smallest significance level at which one can reject the null hypothesis", examples={@GamlAnnotations.example(value="t_test([10.0,5.0,1.0, 3.0],[1.0,10.0,5.0,1.0])", equals="0.01")})
    public static Double opTTest(IScope iScope, IList iList, IList iList2) {
        TTest tTest = new TTest();
        double[] dArray = new double[iList.length(iScope)];
        int n = 0;
        while (n < iList.length(iScope)) {
            dArray[n] = Cast.asFloat((IScope)iScope, (Object)iList.get(n));
            ++n;
        }
        double[] dArray2 = new double[iList2.length(iScope)];
        int n2 = 0;
        while (n2 < iList2.length(iScope)) {
            dArray2[n2] = Cast.asFloat((IScope)iScope, (Object)iList2.get(n2));
            ++n2;
        }
        return tTest.tTest(dArray, dArray2);
    }

    @GamlAnnotations.operator(value={"variance"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the variance from a standard deviation.", comment="", examples={@GamlAnnotations.example(value="int(variance([1,3,5,6,9,11,12,13]))", equals="17", returnType="int")})
    public static Double opVariance(IScope iScope, Double d) {
        return Descriptive.variance((double)d);
    }

    @GamlAnnotations.operator(value={"variance"}, can_be_const=true, expected_content_type={1, 2}, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="the variance of the elements of the operand. See <a href=\"http://en.wikipedia.org/wiki/Variance\">Variance</a> for more details.", comment="The operator casts all the numerical element of the list into float. The elements that are not numerical are discarded. ", examples={@GamlAnnotations.example(value="variance ([4.5, 3.5, 5.5, 7.0])", equals="1.671875")}, see={"mean", "median"})
    public static Double opVariance(IScope iScope, IContainer iContainer) {
        DataSet dataSet = Stats.toDataSet(iScope, iContainer);
        return dataSet.getVariance();
    }

    @GamlAnnotations.operator(value={"variance"}, can_be_const=true, type=2, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="Returns the variance of a data sequence. That is (sumOfSquares - mean*sum) / size with mean = sum/size.", comment="In the example we consider variance of [1,3,5,7]. The size is 4, the sum is 1+3+5+7=16 and the sum of squares is 84.The variance is (84- 16^2/4)/4. CQFD.", examples={@GamlAnnotations.example(value="int(variance(4,16,84))", equals="5", returnType="int")})
    public static Double opVariance(IScope iScope, Integer n, Double d, Double d2) {
        return Descriptive.variance((int)n, (double)d, (double)d2);
    }

    @GamlAnnotations.operator(value={"variance_of"}, type=-198, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the variance of the right-hand expression evaluated on each of the elements of the left-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", see={"min_of", "max_of", "sum_of", "product_of"}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] variance_of each with_precision 2", equals="2.92", returnType="float")})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] variance_of each with_precision 2 = 2.92")
    public static Object opVarianceOf(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Stats.opVariance(iScope, (IContainer)Containers.collect((IScope)iScope, (IContainer)iContainer, (IExpression)iExpression));
    }

    private static DataSet toDataSet(IScope iScope, IContainer iContainer) {
        DataSet dataSet = new DataSet(iContainer.length(iScope));
        for (Object t : iContainer.iterable(iScope)) {
            if (!(t instanceof Number)) continue;
            dataSet.addValue(((Number)t).doubleValue());
        }
        return dataSet;
    }

    static DoubleArrayList toDoubleArrayList(IScope iScope, IContainer iContainer) {
        DoubleArrayList doubleArrayList = new DoubleArrayList(iContainer.length(iScope));
        for (Object t : iContainer.iterable(iScope)) {
            if (!(t instanceof Number)) continue;
            doubleArrayList.add(((Number)t).doubleValue());
        }
        return doubleArrayList;
    }

    @GamlAnnotations.operator(value={"mean_of"}, type=-1198, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the mean of the right-hand expression evaluated on each of the elements of the left-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] mean_of (each)", equals="4")})}, examples={@GamlAnnotations.example(value="[1,2] mean_of (each * 10 )", equals="15")}, see={"min_of", "max_of", "sum_of", "product_of"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="[1,2] mean_of (each * 10 ) = 15"), @GamlAnnotations.test(value="[1,2] mean_of (each * 10 ) = 15"), @GamlAnnotations.test(value="[1,2] mean_of (each * 10 ) = 15")})
    public static Object opMeanOf(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.opMean((IScope)iScope, (IContainer)Containers.collect((IScope)iScope, (IContainer)iContainer, (IExpression)iExpression));
    }

    @GamlAnnotations.operator(value={"min_of"}, type=-198, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the minimum value of the right-hand expression evaluated on each of the elements of the left-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil or empty, min_of throws an error"), @GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] min_of (each + 3)", equals="5")})}, examples={@GamlAnnotations.example(value="[1,2,4,3,5,7,6,8] min_of (each * 100 )", equals="100"), @GamlAnnotations.example(value="graph g2 <- as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="g2 min_of (length(g2 out_edges_of each) )", equals="0"), @GamlAnnotations.example(value="(list(node) min_of (round(node(each).location.x))", equals="4", isExecutable=false)}, see={"max_of"})
    @GamlAnnotations.test(value="[1,2,4,3,5,7,6,8] min_of (each * 100 ) = 100")
    @validator(value=Containers.ComparableValidator.class)
    public static Object opMinOf(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.stream((IScope)iScope, (IContainer)iContainer).map(Containers.with((IScope)iScope, (IExpression)iExpression)).minBy(Function.identity()).orElse(null);
    }

    @GamlAnnotations.operator(value={"max_of"}, type=-198, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the maximum value of the right-hand expression evaluated on each of the elements of the left-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="As of GAMA 1.6, if the left-hand operand is nil or empty, max_of throws an error"), @GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] max_of (each + 3)", equals="9")})}, examples={@GamlAnnotations.example(value="[1,2,4,3,5,7,6,8] max_of (each * 100 )", equals="800"), @GamlAnnotations.example(value="graph g2 <- as_edge_graph([{1,5}::{12,45},{12,45}::{34,56}]);"), @GamlAnnotations.example(value="g2.vertices max_of (g2 degree_of( each ))", equals="2"), @GamlAnnotations.example(value="(list(node) max_of (round(node(each).location.x))", equals="96", isExecutable=false)}, see={"min_of"})
    @GamlAnnotations.test(value="[1,2,4,3,5,7,6,8] max_of (each * 100 ) = 800")
    @validator(value=Containers.ComparableValidator.class)
    public static Object opMaxOf(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.stream((IScope)iScope, (IContainer)iContainer).map(Containers.with((IScope)iScope, (IExpression)iExpression)).maxBy(Function.identity()).orElse(null);
    }

    private static class DataSet {
        private static final int DEFAULT_CAPACITY = 50;
        private static final double GROWTH_RATE = 1.5;
        double[] dataSet;
        int dataSetSize = 0;
        private double total = 0.0;
        private double product = 1.0;
        private double reciprocalSum = 0.0;
        private double minimum = Double.MAX_VALUE;
        private double maximum = Double.MIN_VALUE;

        public DataSet() {
            this(50);
        }

        public DataSet(int n) {
            this.dataSet = new double[n];
            this.dataSetSize = 0;
        }

        public void addValue(double d) {
            if (this.dataSetSize == this.dataSet.length) {
                int n = (int)Math.round(1.5 * (double)this.dataSetSize);
                double[] dArray = new double[n];
                System.arraycopy(this.dataSet, 0, dArray, 0, this.dataSetSize);
                this.dataSet = dArray;
            }
            this.dataSet[this.dataSetSize] = d;
            this.updateStatsWithNewValue(d);
            ++this.dataSetSize;
        }

        public final double getArithmeticMean() {
            return this.total / (double)this.dataSetSize;
        }

        public final double getGeometricMean() {
            return Math.pow(this.product, 1.0 / (double)this.dataSetSize);
        }

        public final double getHarmonicMean() {
            return (double)this.dataSetSize / this.reciprocalSum;
        }

        public final double getMeanDeviation() {
            double d = this.getArithmeticMean();
            double d2 = 0.0;
            int n = 0;
            while (n < this.dataSetSize) {
                d2 += Math.abs(d - this.dataSet[n]);
                ++n;
            }
            return d2 / (double)this.dataSetSize;
        }

        public final double getMedian() {
            double[] dArray = new double[this.getSize()];
            System.arraycopy(this.dataSet, 0, dArray, 0, dArray.length);
            Arrays.sort(dArray);
            int n = dArray.length / 2;
            if (dArray.length % 2 != 0) {
                return dArray[n];
            }
            return dArray[n - 1] + (dArray[n] - dArray[n - 1]) / 2.0;
        }

        public final double getProduct() {
            return this.product;
        }

        public final int getSize() {
            return this.dataSetSize;
        }

        public final double getStandardDeviation() {
            return Math.sqrt(this.getVariance());
        }

        public double[] getStops(int n) {
            double d = (this.maximum - this.minimum) / (double)n;
            double[] dArray = new double[n - 1];
            int n2 = 1;
            while (n2 < n) {
                dArray[n2 - 1] = this.minimum + (double)n2 * d;
                ++n2;
            }
            return dArray;
        }

        public final double getVariance() {
            return this.sumSquaredDiffs() / (double)this.getSize();
        }

        private double sumSquaredDiffs() {
            double d = this.getArithmeticMean();
            double d2 = 0.0;
            int n = 0;
            while (n < this.getSize()) {
                double d3 = d - this.dataSet[n];
                d2 += d3 * d3;
                ++n;
            }
            return d2;
        }

        private void updateStatsWithNewValue(double d) {
            this.total += d;
            this.product *= d;
            this.reciprocalSum += 1.0 / d;
            this.minimum = Math.min(this.minimum, d);
            this.maximum = Math.max(this.maximum, d);
        }
    }

    public static class Instance
    extends DoublePoint {
        private static final long serialVersionUID = 1L;
        int id;

        public Instance(int n, double[] dArray) {
            super(dArray);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int n) {
            this.id = n;
        }
    }
}

