/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.traffic.driving;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.IGraph;
import gama.core.util.path.IPath;
import gama.core.util.path.PathFactory;
import gama.dev.DEBUG;
import gama.extension.traffic.driving.RoadNodeSkill;
import gama.extension.traffic.driving.RoadSkill;
import gama.extension.traffic.driving.carfollowing.MOBIL;
import gama.extension.traffic.driving.carfollowing.Utils;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.operators.Random;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.skills.MovingSkill;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.locationtech.jts.geom.Coordinate;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="speed", type=2, init="0.0", doc={@GamlAnnotations.doc(value="the speed of the agent (in meter/second)")}), @GamlAnnotations.variable(name="acceleration", type=2, init="0.0", doc={@GamlAnnotations.doc(value="the current acceleration of the vehicle (in m/s^2)")}), @GamlAnnotations.variable(name="current_path", type=17, init="nil", doc={@GamlAnnotations.doc(value="the path which the agent is currently following")}), @GamlAnnotations.variable(name="final_target", type=11, init="nil", doc={@GamlAnnotations.doc(value="the final target of the agent")}), @GamlAnnotations.variable(name="current_target", type=11, init="nil", doc={@GamlAnnotations.doc(value="the current target of the agent")}), @GamlAnnotations.variable(name="current_index", type=1, init="0", doc={@GamlAnnotations.doc(value="the index of the current edge (road) in the path")}), @GamlAnnotations.variable(name="safety_distance_coeff", type=2, init="1.0", doc={@GamlAnnotations.doc(value="the coefficient for the computation of the the min distance between two vehicles (according to the vehicle speed - security_distance = max(min_security_distance, security_distance_coeff `*` min(self.speed, other.speed) )")}), @GamlAnnotations.variable(name="min_safety_distance", type=2, init="0.5", doc={@GamlAnnotations.doc(value="the minimum distance of the vehicle's front bumper to the leading vehicle's rear bumper, known as the parameter s0 in the Intelligent Driver Model")}), @GamlAnnotations.variable(name="lowest_lane", type=1, init="0", doc={@GamlAnnotations.doc(value="the lane with the smallest index that the vehicle is in")}), @GamlAnnotations.variable(name="num_lanes_occupied", type=1, init="1", doc={@GamlAnnotations.doc(value="the number of lanes that the vehicle occupies", comment="e.g. if `num_lanes_occupied=3` and `lowest_lane=1`, the vehicle will be in lane 1, 2 and 3`")}), @GamlAnnotations.variable(name="vehicle_length", type=2, init="0.0", doc={@GamlAnnotations.doc(value="the length of the vehicle (in meters)")}), @GamlAnnotations.variable(name="speed_coeff", type=2, init="1.0", doc={@GamlAnnotations.doc(value="speed coefficient for the speed that the vehicle want to reach (according to the max speed of the road)")}), @GamlAnnotations.variable(name="max_speed", type=2, init="50.0", doc={@GamlAnnotations.doc(value="the maximum speed that the vehicle can achieve. Known as the parameter 'v0' in the Intelligent Driver Model")}), @GamlAnnotations.variable(name="time_headway", type=2, init="1.5", doc={@GamlAnnotations.doc(value="the time gap that to the leading vehicle that the driver must maintain. Known as the parameter 'T' in the Intelligent Driver Model")}), @GamlAnnotations.variable(name="max_acceleration", type=2, init="0.3", doc={@GamlAnnotations.doc(value="the maximum acceleration of the vehicle. Known as the parameter 'a' in the Intelligent Driver Model")}), @GamlAnnotations.variable(name="max_deceleration", type=2, init="3.0", doc={@GamlAnnotations.doc(value="the maximum deceleration of the vehicle. Known as the parameter 'b' in the Intelligent Driver Model")}), @GamlAnnotations.variable(name="delta_idm", type=2, init="4.0", doc={@GamlAnnotations.doc(value="the exponent used in the computation of free-road acceleration in the Intelligent Driver Model")}), @GamlAnnotations.variable(name="politeness_factor", type=2, init="0.5", doc={@GamlAnnotations.doc(value="determines the politeness level of the vehicle when changing lanes. Known as the parameter 'p' in the MOBIL lane changing model")}), @GamlAnnotations.variable(name="max_safe_deceleration", type=2, init="4", doc={@GamlAnnotations.doc(value="the maximum deceleration that the vehicle is willing to induce on its back vehicle when changing lanes. Known as the parameter 'b_save' in the MOBIL lane changing model")}), @GamlAnnotations.variable(name="acc_gain_threshold", type=2, init="0.2", doc={@GamlAnnotations.doc(value="the minimum acceleration gain for the vehicle to switch to another lane, introduced to prevent frantic lane changing. Known as the parameter 'a_th' in the MOBIL lane changing model")}), @GamlAnnotations.variable(name="acc_bias", type=2, init="0.25", doc={@GamlAnnotations.doc(value="the bias term used for asymmetric lane changing, parameter 'a_bias' in MOBIL")}), @GamlAnnotations.variable(name="lane_change_cooldown", type=2, init="4", doc={@GamlAnnotations.doc(value="the duration that a vehicle must wait before changing lanes again")}), @GamlAnnotations.variable(name="time_since_lane_change", type=2, init="0.0", doc={@GamlAnnotations.doc(value="the elapsed time since the last lane change")}), @GamlAnnotations.variable(name="ignore_oneway", type=3, init="false", doc={@GamlAnnotations.doc(value="if set to `true`, the vehicle will be able to violate one-way traffic rule")}), @GamlAnnotations.variable(name="violating_oneway", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if the vehicle is moving in the wrong direction on an one-way (unlinked) road")}), @GamlAnnotations.variable(name="current_road", type=11, init="nil", doc={@GamlAnnotations.doc(value="the road which the vehicle is currently on")}), @GamlAnnotations.variable(name="next_road", type=11, init="nil", doc={@GamlAnnotations.doc(value="the road which the vehicle will enter next")}), @GamlAnnotations.variable(name="using_linked_road", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if the vehicle is occupying at least one lane on the linked road")}), @GamlAnnotations.variable(name="allowed_lanes", type=5, init="[]", doc={@GamlAnnotations.doc(value="a list containing possible lane index values for the attribute lowest_lane")}), @GamlAnnotations.variable(name="linked_lane_limit", type=1, init="-1", doc={@GamlAnnotations.doc(value="the maximum number of linked lanes that the vehicle can use; the default value is -1, i.e. the vehicle can use all available linked lanes")}), @GamlAnnotations.variable(name="lane_change_limit", type=1, init="1", doc={@GamlAnnotations.doc(value="the maximum number of lanes that the vehicle can change during a simulation step")}), @GamlAnnotations.variable(name="proba_use_linked_road", type=2, init="0.0", doc={@GamlAnnotations.doc(value="probability to change to a linked lane to gain acceleration, within one second")}), @GamlAnnotations.variable(name="proba_respect_priorities", type=2, init="1.0", doc={@GamlAnnotations.doc(value="probability to respect priority (right or left) laws, within one second")}), @GamlAnnotations.variable(name="proba_respect_stops", type=5, of=2, init="[]", doc={@GamlAnnotations.doc(value="probability to respect stop laws - one value for each type of stop, within one second")}), @GamlAnnotations.variable(name="proba_block_node", type=2, init="0.0", doc={@GamlAnnotations.doc(value="probability to block a node (do not let other vehicle cross the crossroad), within one second")}), @GamlAnnotations.variable(name="right_side_driving", type=3, init="true", doc={@GamlAnnotations.doc(value="are vehicles driving on the right size of the road?")}), @GamlAnnotations.variable(name="distance_to_goal", type=2, init="0.0", doc={@GamlAnnotations.doc(value="euclidean distance to the endpoint of the current segment")}), @GamlAnnotations.variable(name="distance_to_current_target", type=2, init="0.0", doc={@GamlAnnotations.doc(value="euclidean distance to the current target node")}), @GamlAnnotations.variable(name="segment_index_on_road", type=1, init="-1", doc={@GamlAnnotations.doc(value="current segment index of the agent on the current road ")}), @GamlAnnotations.variable(name="leading_vehicle", type=11, init="nil", doc={@GamlAnnotations.doc(value="the vehicle which is right ahead of the current vehicle.\nIf this is set to nil, the leading vehicle does not exist or might be very far away.")}), @GamlAnnotations.variable(name="leading_distance", type=2, init="nil", doc={@GamlAnnotations.doc(value="the distance to the leading vehicle")}), @GamlAnnotations.variable(name="leading_speed", type=2, init="nil", doc={@GamlAnnotations.doc(value="the speed of the leading vehicle")}), @GamlAnnotations.variable(name="follower", type=11, init="nil", doc={@GamlAnnotations.doc(value="the vehicle following this vehicle")})})
public class DrivingSkill
extends MovingSkill {
    public static final String ADVANCED_DRIVING = "advanced_driving";
    public static final String SAFETY_DISTANCE_COEFF = "safety_distance_coeff";
    public static final String MIN_SAFETY_DISTANCE = "min_safety_distance";
    public static final String CURRENT_ROAD = "current_road";
    public static final String NEXT_ROAD = "next_road";
    public static final String LOWEST_LANE = "lowest_lane";
    public static final String DISTANCE_TO_GOAL = "distance_to_goal";
    public static final String DISTANCE_TO_CURRENT_TARGET = "distance_to_current_target";
    public static final String VEHICLE_LENGTH = "vehicle_length";
    public static final String PROBA_RESPECT_PRIORITIES = "proba_respect_priorities";
    public static final String PROBA_RESPECT_STOPS = "proba_respect_stops";
    public static final String PROBA_BLOCK_NODE = "proba_block_node";
    public static final String PROBA_USE_LINKED_ROAD = "proba_use_linked_road";
    public static final String RIGHT_SIDE_DRIVING = "right_side_driving";
    public static final String IGNORE_ONEWAY = "ignore_oneway";
    public static final String VIOLATING_ONEWAY = "violating_oneway";
    public static final String ON_LINKED_ROAD = "on_linked_road";
    public static final String USING_LINKED_ROAD = "using_linked_road";
    public static final String LINKED_LANE_LIMIT = "linked_lane_limit";
    public static final String ALLOWED_LANES = "allowed_lanes";
    public static final String CURRENT_TARGET = "current_target";
    public static final String CURRENT_INDEX = "current_index";
    public static final String FINAL_TARGET = "final_target";
    public static final String CURRENT_PATH = "current_path";
    public static final String ACCELERATION = "acceleration";
    public static final String MAX_ACCELERATION = "max_acceleration";
    public static final String MAX_DECELERATION = "max_deceleration";
    public static final String TIME_HEADWAY = "time_headway";
    public static final String DELTA_IDM = "delta_idm";
    public static final String POLITENESS_FACTOR = "politeness_factor";
    public static final String MAX_SAFE_DECELERATION = "max_safe_deceleration";
    public static final String ACC_GAIN_THRESHOLD = "acc_gain_threshold";
    public static final String ACC_BIAS = "acc_bias";
    public static final String TIME_SINCE_LC = "time_since_lane_change";
    public static final String LC_COOLDOWN = "lane_change_cooldown";
    public static final String SPEED_COEFF = "speed_coeff";
    public static final String MAX_SPEED = "max_speed";
    public static final String SEGMENT_INDEX = "segment_index_on_road";
    public static final String NUM_LANES_OCCUPIED = "num_lanes_occupied";
    public static final String LANE_CHANGE_LIMIT = "lane_change_limit";
    public static final String LEADING_VEHICLE = "leading_vehicle";
    public static final String LEADING_DISTANCE = "leading_distance";
    public static final String LEADING_SPEED = "leading_speed";
    public static final String FOLLOWER = "follower";
    public static final String ACT_CHOOSE_LANE = "choose_lane";
    private static final double EPSILON = 0.01;

    static {
        DEBUG.OFF();
    }

    @GamlAnnotations.getter(value="speed")
    public static double getSpeed(IAgent iAgent) {
        if (iAgent == null || !iAgent.hasAttribute("speed")) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("speed");
    }

    @GamlAnnotations.setter(value="speed")
    public static void setSpeed(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("speed", (Object)d);
    }

    @GamlAnnotations.setter(value="acceleration")
    public static void setAccelerationReadOnly(IAgent iAgent, Double d) {
    }

    private static void setAcceleration(IAgent iAgent, Double d) {
        iAgent.setAttribute(ACCELERATION, (Object)d);
    }

    @GamlAnnotations.getter(value="max_acceleration")
    public static double getMaxAcceleration(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MAX_ACCELERATION);
    }

    @GamlAnnotations.setter(value="max_acceleration")
    public static void setMaxAcceleration(IAgent iAgent, Double d) {
        iAgent.setAttribute(MAX_ACCELERATION, (Object)d);
    }

    @GamlAnnotations.getter(value="max_deceleration")
    public static double getMaxDeceleration(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MAX_DECELERATION);
    }

    @GamlAnnotations.getter(value="time_headway")
    public static double getTimeHeadway(IAgent iAgent) {
        return (Double)iAgent.getAttribute(TIME_HEADWAY);
    }

    @GamlAnnotations.getter(value="delta_idm")
    public static double getDeltaIDM(IAgent iAgent) {
        return (Double)iAgent.getAttribute(DELTA_IDM);
    }

    @GamlAnnotations.getter(value="politeness_factor")
    public static double getPolitenessFactor(IAgent iAgent) {
        return (Double)iAgent.getAttribute(POLITENESS_FACTOR);
    }

    @GamlAnnotations.getter(value="max_safe_deceleration")
    public static double getMaxSafeDeceleration(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MAX_SAFE_DECELERATION);
    }

    @GamlAnnotations.getter(value="acc_gain_threshold")
    public static double getAccGainThreshold(IAgent iAgent) {
        return (Double)iAgent.getAttribute(ACC_GAIN_THRESHOLD);
    }

    @GamlAnnotations.getter(value="acc_bias")
    public static double getAccBias(IAgent iAgent) {
        return (Double)iAgent.getAttribute(ACC_BIAS);
    }

    @GamlAnnotations.getter(value="time_since_lane_change")
    public static double getTimeSinceLC(IAgent iAgent) {
        return (Double)iAgent.getAttribute(TIME_SINCE_LC);
    }

    public static void setTimeSinceLCReadOnly(IAgent iAgent, double d) {
    }

    @GamlAnnotations.setter(value="time_since_lane_change")
    public static void setTimeSinceLC(IAgent iAgent, double d) {
        iAgent.setAttribute(TIME_SINCE_LC, (Object)d);
    }

    @GamlAnnotations.getter(value="lane_change_cooldown")
    public static double getLCCooldown(IAgent iAgent) {
        return (Double)iAgent.getAttribute(LC_COOLDOWN);
    }

    @GamlAnnotations.getter(value="speed_coeff")
    public static double getSpeedCoeff(IAgent iAgent) {
        return (Double)iAgent.getAttribute(SPEED_COEFF);
    }

    @GamlAnnotations.setter(value="speed_coeff")
    public static void setSpeedCoeff(IAgent iAgent, Double d) {
        iAgent.setAttribute(SPEED_COEFF, (Object)d);
    }

    @GamlAnnotations.getter(value="max_speed")
    public static double getMaxSpeed(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MAX_SPEED);
    }

    @GamlAnnotations.setter(value="max_speed")
    public static void setMaxSpeed(IAgent iAgent, Double d) {
        iAgent.setAttribute(MAX_SPEED, (Object)d);
    }

    @GamlAnnotations.getter(value="current_target")
    public static IAgent getCurrentTarget(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(CURRENT_TARGET);
    }

    @GamlAnnotations.setter(value="current_target")
    public static void setCurrentTarget(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(CURRENT_TARGET, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="final_target")
    public static IAgent getFinalTarget(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(FINAL_TARGET);
    }

    @GamlAnnotations.setter(value="final_target")
    public static void setFinalTarget(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(FINAL_TARGET, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="current_index")
    public static Integer getCurrentIndex(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(CURRENT_INDEX);
    }

    @GamlAnnotations.setter(value="current_index")
    public static void setCurrentIndex(IAgent iAgent, Integer n) {
        iAgent.setAttribute(CURRENT_INDEX, (Object)n);
    }

    @GamlAnnotations.getter(value="segment_index_on_road")
    public static Integer getSegmentIndex(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(SEGMENT_INDEX);
    }

    @GamlAnnotations.setter(value="segment_index_on_road")
    public static void setSegmentIndex(IAgent iAgent, Integer n) {
        iAgent.setAttribute(SEGMENT_INDEX, (Object)n);
    }

    @GamlAnnotations.getter(value="current_path")
    public static IPath getCurrentPath(IAgent iAgent) {
        return (IPath)iAgent.getAttribute(CURRENT_PATH);
    }

    @GamlAnnotations.setter(value="current_path")
    public static void setCurrentPath(IAgent iAgent, IPath iPath) {
        iAgent.setAttribute(CURRENT_PATH, (Object)iPath);
        if (iPath != null) {
            IAgent iAgent2 = (IAgent)iPath.getStartVertex();
            IAgent iAgent3 = (IAgent)iPath.getEndVertex();
            iAgent.setLocation(iAgent2.getLocation());
            DrivingSkill.setCurrentIndex(iAgent, -1);
            DrivingSkill.setCurrentTarget(iAgent, (IAgent)iPath.getVertexList().get(0));
            DrivingSkill.setFinalTarget(iAgent, iAgent3);
        }
    }

    public static List<IAgent> getTargets(IAgent iAgent) {
        IPath iPath = DrivingSkill.getCurrentPath(iAgent);
        return iPath == null ? null : iPath.getVertexList();
    }

    @GamlAnnotations.getter(value="proba_use_linked_road")
    public static double getProbaUseLinkedRoad(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PROBA_USE_LINKED_ROAD);
    }

    @GamlAnnotations.setter(value="proba_use_linked_road")
    public static void setProbaUseLinkedRoad(IAgent iAgent, Double d) {
        iAgent.setAttribute(PROBA_USE_LINKED_ROAD, (Object)d);
    }

    @GamlAnnotations.getter(value="proba_respect_priorities")
    public static double getProbaRespectPriorities(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PROBA_RESPECT_PRIORITIES);
    }

    @GamlAnnotations.setter(value="proba_respect_priorities")
    public static void setProbaRespectPriorities(IAgent iAgent, Double d) {
        iAgent.setAttribute(PROBA_RESPECT_PRIORITIES, (Object)d);
    }

    @GamlAnnotations.getter(value="proba_block_node")
    public static double getProbaBlockNode(IAgent iAgent) {
        return (Double)iAgent.getAttribute(PROBA_BLOCK_NODE);
    }

    @GamlAnnotations.setter(value="proba_block_node")
    public static void setProbaBlockNode(IAgent iAgent, Double d) {
        iAgent.setAttribute(PROBA_BLOCK_NODE, (Object)d);
    }

    @GamlAnnotations.getter(value="proba_respect_stops")
    public static List<Double> getProbasRespectStops(IAgent iAgent) {
        return (List)iAgent.getAttribute(PROBA_RESPECT_STOPS);
    }

    @GamlAnnotations.setter(value="proba_respect_stops")
    public static void setProbasRespectStops(IAgent iAgent, List<Boolean> list) {
        iAgent.setAttribute(PROBA_RESPECT_STOPS, list);
    }

    @GamlAnnotations.getter(value="using_linked_road")
    public static boolean isUsingLinkedRoad(IAgent iAgent) {
        int n;
        int n2;
        IAgent iAgent2 = DrivingSkill.getCurrentRoad(iAgent);
        if (iAgent2 == null) {
            return false;
        }
        int n3 = DrivingSkill.getLowestLane(iAgent);
        return n3 > (n2 = RoadSkill.getNumLanes(iAgent2)) - (n = DrivingSkill.getNumLanesOccupied(iAgent).intValue());
    }

    @GamlAnnotations.setter(value="using_linked_road")
    public static void setUsingLinkedRoad(IAgent iAgent, boolean bl) {
    }

    @GamlAnnotations.getter(value="ignore_oneway")
    public static boolean canIgnoreOneway(IAgent iAgent) {
        return (Boolean)iAgent.getAttribute(IGNORE_ONEWAY);
    }

    @GamlAnnotations.getter(value="violating_oneway")
    public static boolean isViolatingOneway(IAgent iAgent) {
        return (Boolean)iAgent.getAttribute(VIOLATING_ONEWAY);
    }

    @GamlAnnotations.setter(value="violating_oneway")
    public static void setViolatingOneway(IAgent iAgent, boolean bl) {
        iAgent.setAttribute(VIOLATING_ONEWAY, (Object)bl);
    }

    @GamlAnnotations.getter(value="allowed_lanes")
    public static List<Integer> getAllowedLanes(IAgent iAgent) {
        return (List)iAgent.getAttribute(ALLOWED_LANES);
    }

    @GamlAnnotations.getter(value="linked_lane_limit")
    public static int getLinkedLaneLimit(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(LINKED_LANE_LIMIT);
    }

    @GamlAnnotations.setter(value="linked_lane_limit")
    public static void setLinkedLaneLimit(IAgent iAgent, int n) {
        iAgent.setAttribute(LINKED_LANE_LIMIT, (Object)n);
    }

    @GamlAnnotations.getter(value="lane_change_limit")
    public static int getLaneChangeLimit(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(LANE_CHANGE_LIMIT);
    }

    @GamlAnnotations.getter(value="right_side_driving")
    public static boolean getRightSideDriving(IAgent iAgent) {
        return (Boolean)iAgent.getAttribute(RIGHT_SIDE_DRIVING);
    }

    @GamlAnnotations.setter(value="right_side_driving")
    public static void setRightSideDriving(IAgent iAgent, Boolean bl) {
        iAgent.setAttribute(RIGHT_SIDE_DRIVING, (Object)bl);
    }

    @GamlAnnotations.getter(value="safety_distance_coeff")
    public static double getSafetyDistanceCoeff(IAgent iAgent) {
        return (Double)iAgent.getAttribute(SAFETY_DISTANCE_COEFF);
    }

    @GamlAnnotations.setter(value="safety_distance_coeff")
    public static void setSafetyDistanceCoeff(IAgent iAgent, double d) {
        iAgent.setAttribute(SAFETY_DISTANCE_COEFF, (Object)d);
    }

    @GamlAnnotations.getter(value="current_road")
    public static IAgent getCurrentRoad(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(CURRENT_ROAD);
    }

    @GamlAnnotations.setter(value="current_road")
    public static void setCurrentRoad(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(CURRENT_ROAD, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="next_road")
    public static IAgent getNextRoad(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(NEXT_ROAD);
    }

    @GamlAnnotations.setter(value="next_road")
    public static void setNextRoad(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(NEXT_ROAD, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="vehicle_length")
    public static double getVehicleLength(IAgent iAgent) {
        return (Double)iAgent.getAttribute(VEHICLE_LENGTH);
    }

    @GamlAnnotations.getter(value="lowest_lane")
    public static int getLowestLane(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(LOWEST_LANE);
    }

    @GamlAnnotations.setter(value="lowest_lane")
    public static void setLowestLane(IAgent iAgent, int n) {
        iAgent.setAttribute(LOWEST_LANE, (Object)n);
    }

    @GamlAnnotations.getter(value="distance_to_goal")
    public static double getDistanceToGoal(IAgent iAgent) {
        return (Double)iAgent.getAttribute(DISTANCE_TO_GOAL);
    }

    @GamlAnnotations.getter(value="distance_to_current_target")
    public static double getDistanceToCurrentTarget(IAgent iAgent) {
        return (Double)iAgent.getAttribute(DISTANCE_TO_CURRENT_TARGET);
    }

    @GamlAnnotations.setter(value="distance_to_current_target")
    public static void setDistanceToCurrentTarget(IAgent iAgent, double d) {
        iAgent.setAttribute(DISTANCE_TO_CURRENT_TARGET, (Object)d);
    }

    @GamlAnnotations.getter(value="min_safety_distance")
    public static double getMinSafetyDistance(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MIN_SAFETY_DISTANCE);
    }

    @GamlAnnotations.setter(value="distance_to_goal")
    public static void setDistanceToGoal(IAgent iAgent, double d) {
        iAgent.setAttribute(DISTANCE_TO_GOAL, (Object)d);
    }

    @GamlAnnotations.getter(value="num_lanes_occupied")
    public static Integer getNumLanesOccupied(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(NUM_LANES_OCCUPIED);
    }

    @GamlAnnotations.setter(value="num_lanes_occupied")
    public static void setNumLanesOccupied(IAgent iAgent, Integer n) {
        iAgent.setAttribute(NUM_LANES_OCCUPIED, (Object)n);
    }

    @GamlAnnotations.getter(value="leading_vehicle")
    public static IAgent getLeadingVehicle(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(LEADING_VEHICLE);
    }

    @GamlAnnotations.setter(value="leading_vehicle")
    public static void setLeadingVehicleReadOnly(IAgent iAgent, IAgent iAgent2) {
    }

    public static void setLeadingVehicle(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(LEADING_VEHICLE, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="leading_distance")
    public static double getLeadingDistance(IAgent iAgent) {
        Double d = (Double)iAgent.getAttribute(LEADING_DISTANCE);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @GamlAnnotations.getter(value="leading_speed")
    public static double getLeadingSpeed(IAgent iAgent) {
        Double d = (Double)iAgent.getAttribute(LEADING_SPEED);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @GamlAnnotations.setter(value="leading_distance")
    public static void setLeadingDistanceReadOnly(IAgent iAgent, double d) {
    }

    public static void setLeadingDistance(IAgent iAgent, double d) {
        iAgent.setAttribute(LEADING_DISTANCE, (Object)d);
    }

    @GamlAnnotations.setter(value="leading_speed")
    public static void setLeadingSpeedReadOnly(IAgent iAgent, double d) {
    }

    public static void setLeadingSpeed(IAgent iAgent, double d) {
        iAgent.setAttribute(LEADING_SPEED, (Object)d);
    }

    public static void setFollower(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(FOLLOWER, (Object)iAgent2);
    }

    @GamlAnnotations.action(name="ready_to_cross", args={@GamlAnnotations.arg(name="node", type=11, optional=false, doc={@GamlAnnotations.doc(value="the road node to test")}), @GamlAnnotations.arg(name="new_road", type=11, optional=false, doc={@GamlAnnotations.doc(value="the road to test")})}, doc={@GamlAnnotations.doc(value="action to test if the vehicle cross a road node to move to a new road", returns="true if the vehicle can cross the road node, false otherwise", examples={@GamlAnnotations.example(value="do is_ready_next_road new_road: a_road lane: 0;")})})
    public Boolean primReadyToCross(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        IAgent iAgent2 = (IAgent)iScope.getArg("node", 11);
        IAgent iAgent3 = (IAgent)iScope.getArg("new_road", 11);
        return DrivingSkill.readyToCross(iScope, iAgent, iAgent2, iAgent3);
    }

    @GamlAnnotations.action(name="test_next_road", args={@GamlAnnotations.arg(name="new_road", type=11, optional=false, doc={@GamlAnnotations.doc(value="the road to test")})}, doc={@GamlAnnotations.doc(value="action to test if the vehicle can take the given road", returns="true (the vehicle can take the road) or false (the vehicle cannot take the road)", examples={@GamlAnnotations.example(value="do test_next_road new_road: a_road;")})})
    public Boolean primTestNextRoad(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    public static Boolean readyToCross(IScope iScope, IAgent iAgent, IAgent iAgent2, IAgent iAgent3) throws GamaRuntimeException {
        double d = DrivingSkill.getVehicleLength(iAgent);
        ISpecies iSpecies = iAgent.getSpecies();
        IStatement.WithArgs withArgs = iSpecies.getAction("test_next_road");
        Arguments arguments = new Arguments();
        arguments.put("new_road", (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)iAgent3));
        withArgs.setRuntimeArgs(iScope, arguments);
        if (!((Boolean)withArgs.executeOn(iScope)).booleanValue()) {
            return false;
        }
        IAgent iAgent4 = (IAgent)iAgent.getAttribute(CURRENT_ROAD);
        if (iAgent4 != null) {
            Serializable serializable;
            List list = (List)iAgent2.getAttribute("stop");
            List<Double> list2 = DrivingSkill.getProbasRespectStops(iAgent);
            int n = 0;
            while (n < list.size()) {
                serializable = Boolean.valueOf(((List)list.get(n)).contains(iAgent4));
                if (((Boolean)serializable).booleanValue() && (list2.size() <= n || Random.opFlip((IScope)iScope, (Double)list2.get(n)).booleanValue())) {
                    return false;
                }
                ++n;
            }
            Map map = (Map)iAgent2.getAttribute("block");
            serializable = new LinkedHashSet(map.keySet());
            Iterator<Object> iterator = serializable.iterator();
            while (iterator.hasNext()) {
                Object object = (IAgent)iterator.next();
                if (object.getLocation().equals((Object)iAgent2.getLocation())) continue;
                map.remove(object);
            }
            for (Object object : map.values()) {
                if (!object.contains(iAgent4)) continue;
                return false;
            }
            double d2 = DrivingSkill.getProbaRespectPriorities(iAgent);
            if (!Random.opFlip((IScope)iScope, (Double)d2).booleanValue()) {
                return true;
            }
            Boolean bl = DrivingSkill.getRightSideDriving(iAgent);
            List list3 = (List)iAgent2.getAttribute("priority_roads");
            boolean bl2 = list3 != null && list3.contains(iAgent4);
            IList iList = iAgent4.getGeometry().getPoints();
            GamaPoint gamaPoint = (GamaPoint)iList.get(iList.size() - 2);
            GamaPoint gamaPoint2 = (GamaPoint)iAgent3.getGeometry().getPoints().get(1);
            double d3 = Math.max(0.5, DrivingSkill.getSpeed(iAgent));
            double d4 = DrivingSkill.getSafetyDistanceCoeff(iAgent);
            double d5 = DrivingSkill.getDistanceToCurrentTarget(iAgent);
            List list4 = (List)iAgent2.getAttribute("roads_in");
            for (IAgent iAgent5 : list4) {
                boolean bl3;
                if (iAgent5 == iAgent4) continue;
                IList iList2 = iAgent5.getGeometry().getPoints();
                GamaPoint gamaPoint3 = (GamaPoint)iList2.get(iList2.size() - 2);
                int n2 = Utils.sideOfPoint(gamaPoint, gamaPoint2, gamaPoint3);
                boolean bl4 = list3 != null && list3.contains(iAgent5);
                boolean bl5 = bl2 && !bl4;
                boolean bl6 = bl3 = !bl2 && bl4;
                if (bl5 || !bl3 && (!bl.booleanValue() || n2 >= 0) && (bl.booleanValue() || n2 <= 0)) continue;
                for (OrderedBidiMap<IAgent, Double> orderedBidiMap : RoadSkill.getVehicleOrdering(iAgent5)) {
                    double d6;
                    IAgent iAgent6;
                    OrderedBidiMap orderedBidiMap2 = orderedBidiMap.inverseBidiMap();
                    if (orderedBidiMap2.isEmpty() || (iAgent6 = (IAgent)orderedBidiMap2.get((Object)(d6 = ((Double)orderedBidiMap2.lastKey()).doubleValue()))) == null || iAgent6.dead()) continue;
                    double d7 = DrivingSkill.getVehicleLength(iAgent6);
                    double d8 = DrivingSkill.getSpeed(iAgent6);
                    if (DrivingSkill.getCurrentTarget(iAgent6) != iAgent2) {
                        d8 = -d8;
                    }
                    double d9 = d5 + d6 - (d / 2.0 + d7 / 2.0);
                    if (!(DrivingSkill.getSpeed(iAgent6) > 0.0) || !(0.5 + d4 * Math.max(0.0, d3 - d8) > d9)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @GamlAnnotations.action(name="compute_path", args={@GamlAnnotations.arg(name="graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="the graph representing the road network")}), @GamlAnnotations.arg(name="target", type=11, optional=true, doc={@GamlAnnotations.doc(value="the target node to reach")}), @GamlAnnotations.arg(name="source", type=11, optional=true, doc={@GamlAnnotations.doc(value="the source node (optional, if not defined, closest node to the agent location)")}), @GamlAnnotations.arg(name="nodes", type=5, optional=true, doc={@GamlAnnotations.doc(value="the nodes forming the resulting path")})}, doc={@GamlAnnotations.doc(value="Action to compute the shortest path to the target node, or shortest path based on the provided list of nodes", returns="the computed path, or nil if no valid path is found", comment="either `nodes` or `target` must be specified", examples={@GamlAnnotations.example(value="do compute_path graph: road_network target: target_node;"), @GamlAnnotations.example(value="do compute_path graph: road_network nodes: [node1, node5, node10];")})})
    public IPath primComputePath(IScope iScope) throws GamaRuntimeException {
        IPath iPath;
        GamaGraph gamaGraph = (GamaGraph)iScope.getArg("graph", 15);
        IList iList = (IList)iScope.getArg("nodes", 5);
        IAgent iAgent = (IAgent)iScope.getArg("target", 11);
        IAgent iAgent2 = (IAgent)iScope.getArg("source", 11);
        IAgent iAgent3 = this.getCurrentAgent(iScope);
        if (DrivingSkill.canIgnoreOneway(iAgent3)) {
            gamaGraph.setDirected(false);
        }
        if (iAgent != null) {
            if (!gamaGraph.vertexSet().contains(iAgent)) {
                throw GamaRuntimeException.error((String)(iAgent.getName() + " must be a vertex in the given graph"), (IScope)iScope);
            }
            if (iAgent2 == null) {
                iAgent2 = (IAgent)SpatialQueries.closest_to((IScope)iScope, (IContainer)gamaGraph.getVertices(), (IShape)iAgent3);
            } else if (!gamaGraph.vertexSet().contains(iAgent2)) {
                throw GamaRuntimeException.error((String)(iAgent2.getName() + " must be a vertex in the given graph"), (IScope)iScope);
            }
            iPath = gamaGraph.getPathComputer().computeShortestPathBetween(iScope, (Object)iAgent2, (Object)iAgent);
        } else if (iList != null && !iList.isEmpty()) {
            iAgent2 = (IAgent)iList.firstValue(iScope);
            iAgent = (IAgent)iList.lastValue(iScope);
            IList iList2 = GamaListFactory.create();
            int n = 0;
            while (n < iList.size() - 1) {
                IList iList3 = gamaGraph.getPathComputer().computeBestRouteBetween(iScope, iList.get(n), iList.get(n + 1));
                iList2.addAll((Collection)iList3);
                ++n;
            }
            iPath = PathFactory.newInstance((IGraph)gamaGraph, (Object)iAgent2, (Object)iAgent, (IList)iList2);
        } else {
            throw GamaRuntimeException.error((String)"one of `nodes` or `target` must be non nil", (IScope)iScope);
        }
        gamaGraph.setDirected(true);
        if (iPath != null && !iPath.getEdgeGeometry().isEmpty()) {
            DrivingSkill.setCurrentPath(iAgent3, iPath);
            return iPath;
        }
        this.clearDrivingStates(iScope);
        return null;
    }

    @GamlAnnotations.action(name="drive_random", args={@GamlAnnotations.arg(name="graph", type=15, optional=false, doc={@GamlAnnotations.doc(value="a graph representing the road network")}), @GamlAnnotations.arg(name="proba_roads", type=10, optional=true, doc={@GamlAnnotations.doc(value="a map containing for each road (key), the probability to be selected as next road (value)")})}, doc={@GamlAnnotations.doc(value="action to drive by chosen randomly the next road", examples={@GamlAnnotations.example(value="do drive_random init_node: some_node;")})})
    public boolean primDriveRandom(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)iScope.getArg("graph", 15);
        Map map = (Map)iScope.getArg("proba_roads", 10);
        if (gamaSpatialGraph == null) {
            throw GamaRuntimeException.error((String)"The parameter `graph` must be set", (IScope)iScope);
        }
        IAgent iAgent2 = null;
        if (DrivingSkill.getCurrentRoad(iAgent) == null) {
            IList iList = gamaSpatialGraph.getVertices();
            IShape iShape = SpatialQueries.closest_to((IScope)iScope, (IContainer)iList, (IShape)iAgent);
            iAgent2 = iShape.getAgent();
            this.setLocation(iAgent, iAgent2.getLocation());
            DrivingSkill.setCurrentTarget(iAgent, iAgent2);
            DrivingSkill.setNextRoad(iAgent, this.chooseNextRoadRandomly(iScope, gamaSpatialGraph, iAgent2, map));
        }
        return this.moveAcrossRoads(iScope, true, gamaSpatialGraph, map);
    }

    @GamlAnnotations.action(name="drive", doc={@GamlAnnotations.doc(value="action to drive toward the target", examples={@GamlAnnotations.example(value="do drive;")})})
    public boolean primDrive(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        IPath iPath = DrivingSkill.getCurrentPath(iAgent);
        if (iPath == null) {
            String string = String.format("%s is not driving because it has not been assigned a valid path. The action `compute_path` might have been used with the same source and target node.", iAgent.getName());
            throw GamaRuntimeException.warning((String)string, (IScope)iScope);
        }
        if (DrivingSkill.getCurrentIndex(iAgent) == -1) {
            DrivingSkill.setNextRoad(iAgent, (IAgent)iPath.getEdgeList().get(0));
        }
        return this.moveAcrossRoads(iScope, false, null, null);
    }

    @GamlAnnotations.action(name="on_entering_new_road", doc={@GamlAnnotations.doc(value="override this if you want to do something when the vehicle enters a new road (e.g. adjust parameters)")})
    public void primOnEnteringNewRoad(IScope iScope) throws GamaRuntimeException {
    }

    @GamlAnnotations.action(name="external_factor_impact", args={@GamlAnnotations.arg(name="new_road", type=11, optional=false, doc={@GamlAnnotations.doc(value="the road on which to the vehicle wants to go")}), @GamlAnnotations.arg(name="remaining_time", type=2, optional=false, doc={@GamlAnnotations.doc(value="the remaining time")})}, doc={@GamlAnnotations.doc(value="action that allows to define how the remaining time is impacted by external factor", returns="the remaining time", examples={@GamlAnnotations.example(value="do external_factor_impact new_road: a_road remaining_time: 0.5;")})})
    public Double primExternalFactorOnRemainingTime(IScope iScope) throws GamaRuntimeException {
        return iScope.getFloatArg("remaining_time");
    }

    @GamlAnnotations.action(name="unregister", doc={@GamlAnnotations.doc(value="remove the vehicle from its current roads", examples={@GamlAnnotations.example(value="do unregister")})})
    public boolean primUnregister(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        return DrivingSkill.unregister(iScope, iAgent);
    }

    @GamlAnnotations.action(name="choose_lane", args={@GamlAnnotations.arg(name="new_road", type=11, optional=false, doc={@GamlAnnotations.doc(value="the new road that's the vehicle is going to enter")})}, doc={@GamlAnnotations.doc(value="Override this if you want to manually choose a lane when entering new road. By default, the vehicle tries to stay in the current lane. If the new road has fewer lanes than the current one and the current lane index is too big, it tries to enter the most uppermost lane.", returns="an integer representing the lane index")})
    public Integer primChooseLane(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)iScope.getArg("new_road", 11);
        int n = RoadSkill.getNumLanes(iAgent);
        IAgent iAgent2 = this.getCurrentAgent(iScope);
        int n2 = DrivingSkill.getNumLanesOccupied(iAgent2);
        int n3 = DrivingSkill.getLowestLane(iAgent2);
        int n4 = Utils.computeLinkedLaneLimit(iAgent2, iAgent);
        return Math.min(n3, n + n4 - n2);
    }

    private IAgent chooseNextRoadRandomly(IScope iScope, GamaSpatialGraph gamaSpatialGraph, IAgent iAgent2, Map<IAgent, Double> map) {
        IAgent iAgent3 = this.getCurrentAgent(iScope);
        IList iList = GamaListFactory.create();
        iList.addAll(RoadNodeSkill.getRoadsOut(iAgent2));
        if (DrivingSkill.canIgnoreOneway(iAgent3)) {
            iList.addAll(RoadNodeSkill.getRoadsIn(iAgent2));
            iList.remove((Object)DrivingSkill.getCurrentRoad(iAgent3));
        }
        iList.removeIf(iAgent -> !gamaSpatialGraph.getEdges().contains(iAgent));
        if (iList.isEmpty()) {
            return null;
        }
        if (iList.size() == 1) {
            return (IAgent)iList.get(0);
        }
        if (map == null || map.isEmpty()) {
            return (IAgent)iList.anyValue(iScope);
        }
        IList iList2 = GamaListFactory.create((IType)Types.FLOAT);
        for (IAgent iAgent4 : iList) {
            Double d = map.get(iAgent4);
            iList2.add((Object)(d == null ? 0.0 : d));
        }
        return (IAgent)iList.get(Random.opRndChoice((IScope)iScope, (IList)iList2).intValue());
    }

    public void blockIntersection(IScope iScope, IAgent iAgent, IAgent iAgent2, IAgent iAgent3) {
        List list = (List)iAgent3.getAttribute("roads_in");
        if (list.size() <= 1) {
            return;
        }
        IList iList = GamaListFactory.create((IType)Types.AGENT);
        for (IAgent iAgent4 : list) {
            if (iAgent4.getLocation().equals((Object)iAgent2.getLocation())) continue;
            iList.add(iAgent4);
        }
        if (!iList.isEmpty()) {
            IAgent iAgent4;
            iAgent4 = this.getCurrentAgent(iScope);
            Map map = (Map)iAgent3.getAttribute("block");
            map.put(iAgent4, iList);
        }
    }

    private void updateVehicleOrdering(IScope iScope, int n, double d) {
        int n2;
        IAgent iAgent = this.getCurrentAgent(iScope);
        int n3 = DrivingSkill.getNumLanesOccupied(iAgent);
        int n4 = DrivingSkill.getLowestLane(iAgent);
        Set set = IntStream.range(n4, n4 + n3).boxed().collect(Collectors.toCollection(LinkedHashSet::new));
        Set set2 = IntStream.range(n, n + n3).boxed().collect(Collectors.toCollection(LinkedHashSet::new));
        IAgent iAgent2 = DrivingSkill.getCurrentRoad(iAgent);
        int n5 = RoadSkill.getNumLanes(iAgent2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            RoadSkill.getVehicleOrderingMap(iScope, iAgent2, n2).remove((Object)iAgent);
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            double d2 = n2 < n5 ? d : RoadSkill.getTotalLength(iAgent2) - d;
            RoadSkill.getVehicleOrderingMap(iScope, iAgent2, n2).put((Object)iAgent, (Object)d2);
        }
        DrivingSkill.setDistanceToCurrentTarget(iAgent, d);
        DrivingSkill.setLowestLane(iAgent, n);
    }

    private boolean moveAcrossRoads(IScope iScope, boolean bl, GamaSpatialGraph gamaSpatialGraph, Map<IAgent, Double> map) {
        if (((Boolean)GamaExecutorService.CONCURRENCY_SPECIES.getValue()).booleanValue()) {
            throw GamaRuntimeException.error((String)"Driving agents cannot be scheduled in parallel. Please disable \"Make species schedule theirs agents in parallel\" in Preferences > Execution > Parallelism.", (IScope)iScope);
        }
        IAgent iAgent = this.getCurrentAgent(iScope);
        ISpecies iSpecies = iAgent.getSpecies();
        IStatement.WithArgs withArgs = iSpecies.getAction("external_factor_impact");
        Arguments arguments = new Arguments();
        IAgent iAgent2 = DrivingSkill.getFinalTarget(iAgent);
        double d = iScope.getSimulation().getClock().getStepInSeconds();
        int n = 0;
        while (d > 0.0) {
            ImmutablePair<Integer, Double> immutablePair;
            ++n;
            GamaPoint gamaPoint = iAgent.getLocation();
            IAgent iAgent3 = DrivingSkill.getCurrentTarget(iAgent);
            GamaPoint gamaPoint2 = iAgent3.getLocation();
            if (!bl && DrivingSkill.getCurrentIndex(iAgent) == DrivingSkill.getCurrentPath(iAgent).getEdgeList().size() - 1 && gamaPoint.equals((Object)iAgent2.getLocation())) {
                this.clearDrivingStates(iScope);
                return true;
            }
            if (gamaPoint.equals((Object)gamaPoint2)) {
                Object object;
                IAgent iAgent4;
                int n2;
                boolean bl2;
                var17_17 = DrivingSkill.getNextRoad(iAgent);
                if (var17_17 == null) {
                    if (n > 1) {
                        return true;
                    }
                    String string = bl ? "which has no outgoing roads" : "because it has reached the end of the path";
                    throw GamaRuntimeException.warning((String)(iAgent.getName() + " stopped at " + iAgent3.getName() + ", " + string), (IScope)iScope);
                }
                GamaPoint gamaPoint3 = RoadSkill.getSourceNode(var17_17).getLocation();
                boolean bl3 = bl2 = !gamaPoint.equals((Object)gamaPoint3);
                if (!DrivingSkill.readyToCross(iScope, iAgent, iAgent3, var17_17).booleanValue()) {
                    DrivingSkill.setSpeed(iAgent, 0.0);
                    return true;
                }
                IStatement.WithArgs withArgs2 = iSpecies.getAction(ACT_CHOOSE_LANE);
                Arguments arguments2 = new Arguments();
                arguments2.put("new_road", (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)var17_17));
                withArgs2.setRuntimeArgs(iScope, arguments2);
                int n3 = (Integer)withArgs2.executeOn(iScope);
                immutablePair = MOBIL.chooseLane(iScope, iAgent, var17_17, n3);
                if (immutablePair == null) {
                    return false;
                }
                double d2 = (Double)immutablePair.getRight();
                double d3 = this.computeSpeed(iScope, d2, var17_17);
                if (d3 == 0.0) {
                    DrivingSkill.setSpeed(iAgent, d3);
                    double d4 = DrivingSkill.getProbaBlockNode(iAgent);
                    boolean bl4 = Random.opFlip((IScope)iScope, (Double)d4);
                    IAgent iAgent5 = DrivingSkill.getCurrentRoad(iAgent);
                    if (iAgent5 != null && bl4) {
                        this.blockIntersection(iScope, iAgent5, var17_17, iAgent3);
                    }
                    return true;
                }
                IStatement.WithArgs withArgs3 = iSpecies.getAction("on_entering_new_road");
                withArgs3.executeOn(iScope);
                arguments.put("remaining_time", (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)d));
                arguments.put("new_road", (IExpressionDescription)ConstantExpressionDescription.createNoCache((Object)var17_17));
                withArgs.setRuntimeArgs(iScope, arguments);
                d = (Double)withArgs.executeOn(iScope);
                if (d <= 0.0) {
                    return false;
                }
                if (!bl) {
                    n2 = DrivingSkill.getCurrentIndex(iAgent) + 1;
                    iAgent4 = DrivingSkill.getTargets(iAgent).get(n2 + 1);
                    IPath iPath = DrivingSkill.getCurrentPath(iAgent);
                    object = n2 < iPath.getEdgeList().size() - 1 ? (IAgent)iPath.getEdgeList().get(n2 + 1) : null;
                    DrivingSkill.setCurrentIndex(iAgent, n2);
                } else {
                    iAgent4 = !bl2 ? RoadSkill.getTargetNode(var17_17) : RoadSkill.getSourceNode(var17_17);
                    object = this.chooseNextRoadRandomly(iScope, gamaSpatialGraph, iAgent4, map);
                }
                DrivingSkill.setNextRoad(iAgent, object);
                DrivingSkill.setCurrentTarget(iAgent, iAgent4);
                DrivingSkill.setViolatingOneway(iAgent, bl2);
                DrivingSkill.unregister(iScope, iAgent);
                n2 = (Integer)immutablePair.getLeft();
                RoadSkill.register(iScope, iAgent, var17_17, n2);
            } else {
                var17_17 = DrivingSkill.getCurrentRoad(iAgent);
                int n4 = DrivingSkill.getLowestLane(iAgent);
                immutablePair = MOBIL.chooseLane(iScope, iAgent, var17_17, n4);
            }
            int n5 = (Integer)immutablePair.getLeft();
            double d5 = (Double)immutablePair.getRight();
            d = this.moveAcrossSegments(iScope, d5, d, n5);
        }
        return true;
    }

    @GamlAnnotations.action(name="force_move", args={@GamlAnnotations.arg(name="lane", type=1, optional=false, doc={@GamlAnnotations.doc(value="the lane on which to make the agent move")}), @GamlAnnotations.arg(name="acceleration", type=2, optional=false, doc={@GamlAnnotations.doc(value="acceleration of the vehicle")}), @GamlAnnotations.arg(name="time", type=2, optional=false, doc={@GamlAnnotations.doc(value="time of move")})}, doc={@GamlAnnotations.doc(value="action to drive by chosen randomly the next road", examples={@GamlAnnotations.example(value="do drive_random init_node: some_node;")})})
    public double primForceMove(IScope iScope) throws GamaRuntimeException {
        Integer n = iScope.getIntArg("lane");
        Double d = iScope.getFloatArg(ACCELERATION);
        Double d2 = iScope.getFloatArg("time");
        return this.moveAcrossSegments(iScope, d, d2, n);
    }

    public double moveAcrossSegments(IScope iScope, double d, double d2, int n) {
        double d3;
        double d4;
        IAgent iAgent = this.getCurrentAgent(iScope);
        IAgent iAgent2 = DrivingSkill.getCurrentRoad(iAgent);
        IAgent iAgent3 = DrivingSkill.getCurrentTarget(iAgent);
        int n2 = DrivingSkill.getSegmentIndex(iAgent);
        double d5 = DrivingSkill.getDistanceToGoal(iAgent);
        boolean bl = DrivingSkill.isViolatingOneway(iAgent);
        GamaPoint gamaPoint = iAgent.getLocation();
        double d6 = DrivingSkill.getSpeed(iAgent);
        if (d6 == 0.0 && d == 0.0) {
            return 0.0;
        }
        if (d6 + d * d2 < 0.0) {
            d4 = -0.5 * Math.pow(d6, 2.0) / d;
            d3 = 0.0;
        } else {
            d4 = d6 * d2 + 0.5 * d * Math.pow(d2, 2.0);
            d3 = this.computeSpeed(iScope, d, iAgent2);
        }
        double d7 = d4;
        Coordinate[] coordinateArray = iAgent2.getInnerGeometry().getCoordinates();
        GamaPoint gamaPoint2 = !bl ? new GamaPoint(coordinateArray[n2 + 1]) : new GamaPoint(coordinateArray[n2]);
        while (d7 >= d5 || d5 < 0.01) {
            if (gamaPoint2.equals((Object)iAgent3.getLocation())) {
                this.setLocation(iAgent, gamaPoint2);
                DrivingSkill.setDistanceToGoal(iAgent, 0.0);
                DrivingSkill.setDistanceToCurrentTarget(iAgent, 0.0);
                this.updateVehicleOrdering(iScope, n, 0.0);
                return d5 < 0.01 ? d2 : d2 - d5 / d3;
            }
            d7 -= d5;
            gamaPoint = gamaPoint2;
            n2 = !bl ? n2 + 1 : n2 - 1;
            gamaPoint2 = !bl ? new GamaPoint(coordinateArray[n2 + 1]) : new GamaPoint(coordinateArray[n2]);
            d5 = RoadSkill.getSegmentLengths(iAgent2).get(n2);
        }
        double d8 = d7 / d5;
        double d9 = gamaPoint.getX() + d8 * (gamaPoint2.getX() - gamaPoint.getX());
        double d10 = gamaPoint.getY() + d8 * (gamaPoint2.getY() - gamaPoint.getY());
        this.setLocation(iAgent, new GamaPoint(d9, d10));
        DrivingSkill.setSpeed(iAgent, d3);
        DrivingSkill.setAcceleration(iAgent, d);
        DrivingSkill.setDistanceToGoal(iAgent, d5 - d7);
        DrivingSkill.setSegmentIndex(iAgent, n2);
        this.updateVehicleOrdering(iScope, n, DrivingSkill.getDistanceToCurrentTarget(iAgent) - d4);
        return 0.0;
    }

    private double computeSpeed(IScope iScope, double d, IAgent iAgent) {
        IAgent iAgent2 = this.getCurrentAgent(iScope);
        double d2 = iScope.getSimulation().getClock().getStepInSeconds();
        double d3 = DrivingSkill.getSpeed(iAgent2) + d * d2;
        return Math.max(0.0, d3);
    }

    private void clearDrivingStates(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        DrivingSkill.setCurrentIndex(iAgent, -1);
        DrivingSkill.setCurrentTarget(iAgent, null);
        DrivingSkill.setFinalTarget(iAgent, null);
        DrivingSkill.setCurrentPath(iAgent, null);
    }

    public static boolean unregister(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        IAgent iAgent2 = DrivingSkill.getCurrentRoad(iAgent);
        if (iAgent2 == null) {
            return false;
        }
        Integer n = (Integer)iAgent.getAttribute(LOWEST_LANE);
        int n2 = (Integer)iAgent.getAttribute(NUM_LANES_OCCUPIED);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n + n3;
            RoadSkill.getVehicleOrderingMap(iScope, iAgent2, n4).remove((Object)iAgent);
            ++n3;
        }
        DrivingSkill.setCurrentRoad(iAgent, null);
        return true;
    }

    @GamlAnnotations.action(name="goto_drive", args={@GamlAnnotations.arg(name="target", type=13, optional=false, doc={@GamlAnnotations.doc(value="the entity towards which to move.")}), @GamlAnnotations.arg(name="speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the speed to use for this move (replaces the current value of speed)")}), @GamlAnnotations.arg(name="on", type=0, optional=true, doc={@GamlAnnotations.doc(value="graph, topology, list of geometries or map of geometries that restrain this move")}), @GamlAnnotations.arg(name="recompute_path", type=3, optional=true, doc={@GamlAnnotations.doc(value="if false, the path is not recompute even if the graph is modified (by default: true)")}), @GamlAnnotations.arg(name="return_path", type=3, optional=true, doc={@GamlAnnotations.doc(value="if true, return the path followed (by default: false)")}), @GamlAnnotations.arg(name="following", type=17, optional=true, doc={@GamlAnnotations.doc(value="Path to follow.")})}, doc={@GamlAnnotations.doc(value="moves the agent towards the target passed in the arguments.", returns="optional: the path followed by the agent.", examples={@GamlAnnotations.example(value="do goto_drive target: one_of road on: road_network;")})})
    public IPath primGotoDrive(IScope iScope) throws GamaRuntimeException {
        Object object;
        IAgent iAgent = this.getCurrentAgent(iScope);
        IAgent iAgent2 = (IAgent)iScope.getArg("target", 13);
        Object object2 = DrivingSkill.getCurrentPath(iAgent);
        IAgent iAgent3 = DrivingSkill.getFinalTarget(iAgent);
        if (iAgent2 == null) {
            throw GamaRuntimeException.create((Throwable)new IllegalArgumentException("target parameter in goto_drive can not be null"), (IScope)iScope);
        }
        if (iAgent3 != null && !iAgent3.equals(iAgent2.getLocation())) {
            object = (IPath)iScope.getArg("follow", 17);
            if (object != null && !object2.equals(object)) {
                DrivingSkill.setCurrentPath(iAgent, (IPath)object);
                DrivingSkill.setFinalTarget(iAgent, iAgent2);
                object2 = object;
            } else {
                object2 = null;
            }
        } else if (iAgent3 == null) {
            object2 = null;
        }
        if (object2 != null) {
            this.primDrive(iScope);
        } else {
            object = iScope.getArg("on", 0);
            iScope.getExecutionContext().putLocalVar("graph", object);
            this.primComputePath(iScope);
        }
        return DrivingSkill.getCurrentPath(iAgent);
    }

    @GamlAnnotations.skill(name="driving", concept={"transport", "skill"}, doc={@GamlAnnotations.doc(value="A skill that provides driving primitives and operators")})
    public static class NewDrivingSkill
    extends DrivingSkill {
    }
}

