/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.traffic.driving;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.extension.traffic.driving.DrivingSkill;
import gama.extension.traffic.driving.carfollowing.CustomDualTreeBidiMap;
import gama.gaml.operators.Containers;
import gama.gaml.skills.Skill;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.OrderedBidiMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="all_agents", type=5, of=11, doc={@GamlAnnotations.doc(value="the list of agents on the road")}), @GamlAnnotations.variable(name="source_node", type=11, doc={@GamlAnnotations.doc(value="the source node of the road")}), @GamlAnnotations.variable(name="target_node", type=11, doc={@GamlAnnotations.doc(value="the target node of the road")}), @GamlAnnotations.variable(name="num_lanes", type=1, init="2", doc={@GamlAnnotations.doc(value="the number of lanes")}), @GamlAnnotations.variable(name="num_segments", type=1, doc={@GamlAnnotations.doc(value="the number of road segments")}), @GamlAnnotations.variable(name="linked_road", type=-199, doc={@GamlAnnotations.doc(value="the linked road: the lanes of this linked road will be usable by drivers on the road")}), @GamlAnnotations.variable(name="maxspeed", type=2, init="50#km/#h", doc={@GamlAnnotations.doc(value="the maximal speed on the road")}), @GamlAnnotations.variable(name="segment_lengths", type=5, doc={@GamlAnnotations.doc(value="stores the length of each road segment. The index of each element corresponds to the segment index.")}), @GamlAnnotations.variable(name="vehicle_ordering", type=5, depends_on={"num_lanes"}, doc={@GamlAnnotations.doc(value="provides information about the ordering of vehicle on any given lane")})})
@GamlAnnotations.skill(name="road_skill", concept={"transport", "skill"}, doc={@GamlAnnotations.doc(value="A skill for agents representing roads in traffic simulations")})
public class RoadSkill
extends Skill {
    public static final String SKILL_ROAD = "skill_road";
    public static final String ALL_AGENTS = "all_agents";
    public static final String SOURCE_NODE = "source_node";
    public static final String TARGET_NODE = "target_node";
    public static final String MAXSPEED = "maxspeed";
    public static final String LINKED_ROAD = "linked_road";
    public static final String NUM_LANES = "num_lanes";
    public static final String NUM_SEGMENTS = "num_segments";
    public static final String SEGMENT_LENGTHS = "segment_lengths";
    public static final String VEHICLE_ORDERING = "vehicle_ordering";

    @GamlAnnotations.getter(value="all_agents")
    public static IList<IAgent> getAgents(IAgent iAgent) {
        IList iList = GamaListFactory.create((IType)Types.AGENT);
        for (OrderedBidiMap<IAgent, Double> orderedBidiMap : RoadSkill.getVehicleOrdering(iAgent)) {
            iList.addAll((Collection)orderedBidiMap.keySet());
        }
        return Containers.remove_duplicates((IScope)GAMA.getRuntimeScope(), (IContainer)iList);
    }

    @GamlAnnotations.setter(value="all_agents")
    public static void setAgents(IAgent iAgent, List list) {
    }

    @GamlAnnotations.getter(value="source_node")
    public static IAgent getSourceNode(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(SOURCE_NODE);
    }

    @GamlAnnotations.setter(value="source_node")
    public static void setSourceNode(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(SOURCE_NODE, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="target_node")
    public static IAgent getTargetNode(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(TARGET_NODE);
    }

    @GamlAnnotations.setter(value="target_node")
    public static void setTargetNode(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(TARGET_NODE, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="num_lanes")
    public static int getNumLanes(IAgent iAgent) {
        return (Integer)iAgent.getAttribute(NUM_LANES);
    }

    @GamlAnnotations.setter(value="num_lanes")
    public static void setNumLanes(IAgent iAgent, int n) {
        iAgent.setAttribute(NUM_LANES, (Object)n);
    }

    public static int getNumLanesTotal(IAgent iAgent) {
        IAgent iAgent2 = RoadSkill.getLinkedRoad(iAgent);
        int n = iAgent2 != null ? RoadSkill.getNumLanes(iAgent2) : 0;
        return RoadSkill.getNumLanes(iAgent) + n;
    }

    @GamlAnnotations.getter(value="maxspeed")
    public static Double getMaxSpeed(IAgent iAgent) {
        return (Double)iAgent.getAttribute(MAXSPEED);
    }

    @GamlAnnotations.setter(value="maxspeed")
    public static void setMaxSpeed(IAgent iAgent, Double d) {
        iAgent.setAttribute(MAXSPEED, (Object)d);
    }

    @GamlAnnotations.getter(value="linked_road")
    public static IAgent getLinkedRoad(IAgent iAgent) {
        return (IAgent)iAgent.getAttribute(LINKED_ROAD);
    }

    @GamlAnnotations.setter(value="linked_road")
    public static void setLinkedRoad(IAgent iAgent, IAgent iAgent2) {
        iAgent.setAttribute(LINKED_ROAD, (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="num_segments")
    public static int getNumSegments(IAgent iAgent) {
        return GeometryUtils.getPointsOf((IShape)iAgent).length - 1;
    }

    @GamlAnnotations.setter(value="num_segments")
    public static void setNumSegments(IAgent iAgent, int n) {
    }

    @GamlAnnotations.getter(value="segment_lengths")
    public static List<Double> getSegmentLengths(IAgent iAgent) {
        List list = (List)iAgent.getAttribute(SEGMENT_LENGTHS);
        if (list.isEmpty()) {
            Geometry geometry = iAgent.getInnerGeometry();
            if (iAgent.getInnerGeometry() == null) {
                throw GamaRuntimeException.error((String)"The shape of the road has not been initialized", (IScope)GAMA.getRuntimeScope());
            }
            Coordinate[] coordinateArray = geometry.getCoordinates();
            int n = 0;
            while (n < coordinateArray.length - 1) {
                list.add(coordinateArray[n].distance(coordinateArray[n + 1]));
                ++n;
            }
        }
        return list;
    }

    public static double getTotalLength(IAgent iAgent) {
        List<Double> list = RoadSkill.getSegmentLengths(iAgent);
        return list.stream().reduce(0.0, Double::sum);
    }

    @GamlAnnotations.getter(value="vehicle_ordering")
    public static List<OrderedBidiMap<IAgent, Double>> getVehicleOrdering(IAgent iAgent3) {
        List list = (List)iAgent3.getAttribute(VEHICLE_ORDERING);
        if (list.isEmpty()) {
            int n = 0;
            while (n < RoadSkill.getNumLanes(iAgent3)) {
                list.add(new CustomDualTreeBidiMap((iAgent, iAgent2) -> {
                    int n = iAgent.getSpeciesName().compareTo(iAgent2.getSpeciesName());
                    if (n != 0) {
                        return n;
                    }
                    return Integer.compare(iAgent.getIndex(), iAgent2.getIndex());
                }, Collections.reverseOrder()));
                ++n;
            }
        }
        return list;
    }

    @GamlAnnotations.setter(value="vehicle_ordering")
    public static void setVehicleOrdering(IAgent iAgent, List<OrderedBidiMap<IAgent, Double>> list) {
        iAgent.setAttribute(VEHICLE_ORDERING, list);
    }

    public static OrderedBidiMap<IAgent, Double> getVehicleOrderingMap(IScope iScope, IAgent iAgent, int n) {
        int n2;
        IAgent iAgent2;
        int n3 = RoadSkill.getNumLanesTotal(iAgent);
        if (n >= n3) {
            String string = String.format("Trying to access lane with index %d on road %s, which only have %d valid lanes", n, iAgent.getName(), n3);
            throw GamaRuntimeException.error((String)string, (IScope)iScope);
        }
        int n4 = RoadSkill.getNumLanes(iAgent);
        if (n < n4) {
            iAgent2 = iAgent;
            n2 = n;
        } else {
            IAgent iAgent3 = RoadSkill.getLinkedRoad(iAgent);
            int n5 = RoadSkill.getNumLanes(iAgent3);
            iAgent2 = iAgent3;
            n2 = n4 + n5 - 1 - n;
        }
        return RoadSkill.getVehicleOrdering(iAgent2).get(n2);
    }

    @GamlAnnotations.action(name="register", args={@GamlAnnotations.arg(name="agent", type=11, optional=false, doc={@GamlAnnotations.doc(value="the agent to register on the road.")}), @GamlAnnotations.arg(name="lane", type=1, optional=false, doc={@GamlAnnotations.doc(value="the lane index on which to register; if lane index >= number of lanes, then register on the linked road")})}, doc={@GamlAnnotations.doc(value="register the agent on the road at the given lane", examples={@GamlAnnotations.example(value="do register agent: the_driver lane: 0;")})})
    public boolean primRegister(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        IAgent iAgent2 = (IAgent)iScope.getArg("agent", 11);
        int n = iScope.getIntArg("lane");
        return RoadSkill.register(iScope, iAgent2, iAgent, n);
    }

    public static boolean register(IScope iScope, IAgent iAgent, IAgent iAgent2, int n) throws GamaRuntimeException {
        if (iAgent == null) {
            return false;
        }
        int n2 = DrivingSkill.getNumLanesOccupied(iAgent);
        int n3 = RoadSkill.getNumSegments(iAgent2);
        List<Double> list = RoadSkill.getSegmentLengths(iAgent2);
        GamaPoint gamaPoint = RoadSkill.getTargetNode(iAgent2).getLocation();
        boolean bl = !DrivingSkill.getCurrentTarget(iAgent).getLocation().equals((Object)gamaPoint);
        int n4 = !bl ? 0 : RoadSkill.getNumSegments(iAgent2) - 1;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n + n5;
            RoadSkill.getVehicleOrderingMap(iScope, iAgent2, n6).put((Object)iAgent, (Object)RoadSkill.getTotalLength(iAgent2));
            ++n5;
        }
        DrivingSkill.setViolatingOneway(iAgent, bl);
        if (!bl) {
            DrivingSkill.setDistanceToGoal(iAgent, list.get(0));
        } else {
            DrivingSkill.setDistanceToGoal(iAgent, list.get(n3 - 1));
        }
        DrivingSkill.setDistanceToCurrentTarget(iAgent, RoadSkill.getTotalLength(iAgent2));
        DrivingSkill.setCurrentRoad(iAgent, iAgent2);
        DrivingSkill.setLowestLane(iAgent, n);
        DrivingSkill.setSegmentIndex(iAgent, n4);
        return true;
    }
}

