/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.traffic.driving.carfollowing;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.extension.traffic.driving.DrivingSkill;
import gama.extension.traffic.driving.RoadNodeSkill;
import gama.extension.traffic.driving.RoadSkill;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class Utils {
    public static double rescaleProba(double d, double d2) {
        return Math.min(d * d2, 1.0);
    }

    public static int computeLinkedLaneLimit(IAgent iAgent, IAgent iAgent2) {
        int n;
        double d = DrivingSkill.getProbaUseLinkedRoad(iAgent);
        int n2 = DrivingSkill.getLinkedLaneLimit(iAgent);
        IAgent iAgent3 = RoadSkill.getLinkedRoad(iAgent2);
        int n3 = n = iAgent3 != null ? RoadSkill.getNumLanes(iAgent3) : 0;
        n2 = d == 0.0 ? 0 : (n2 == -1 ? n : Math.min(n2, n));
        return n2;
    }

    public static int sideOfPoint(GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3) {
        return (int)Math.signum((gamaPoint3.x - gamaPoint.x) * (gamaPoint2.y - gamaPoint.y) - (gamaPoint3.y - gamaPoint.y) * (gamaPoint2.x - gamaPoint.x));
    }

    public static Triple<IAgent, Double, Boolean> findLeader(IScope iScope, IAgent iAgent, int n) {
        IAgent iAgent2;
        IAgent iAgent3 = DrivingSkill.getCurrentRoad(iAgent);
        IAgent iAgent4 = DrivingSkill.getCurrentTarget(iAgent);
        double d = DrivingSkill.getDistanceToCurrentTarget(iAgent);
        double d2 = DrivingSkill.getVehicleLength(iAgent);
        double d3 = DrivingSkill.getMinSafetyDistance(iAgent);
        int n2 = DrivingSkill.getNumLanesOccupied(iAgent);
        if (iAgent3 != null && n <= RoadSkill.getNumLanesTotal(iAgent3) - n2 && (iAgent2 = Utils.findNeighborOnCurrentRoad(iScope, iAgent, n, true)) != null) {
            return iAgent2;
        }
        iAgent2 = null;
        double d4 = Double.MAX_VALUE;
        boolean bl = false;
        IAgent iAgent5 = DrivingSkill.getNextRoad(iAgent);
        if (iAgent5 == null || !DrivingSkill.readyToCross(iScope, iAgent, iAgent4, iAgent5).booleanValue()) {
            return ImmutableTriple.of((Object)iAgent4, (Object)(d + d3), (Object)false);
        }
        boolean bl2 = iAgent4 == RoadSkill.getTargetNode(iAgent5);
        IAgent iAgent6 = !bl2 ? RoadSkill.getTargetNode(iAgent5) : RoadSkill.getSourceNode(iAgent5);
        int n3 = RoadSkill.getNumLanes(iAgent5);
        int n4 = Utils.computeLinkedLaneLimit(iAgent, iAgent5);
        int n5 = Math.min(n, n3 + n4 - n2);
        int n6 = 0;
        while (n6 < n2) {
            double d5;
            IAgent iAgent7;
            boolean bl3;
            int n7 = n5 + n6;
            OrderedBidiMap orderedBidiMap = RoadSkill.getVehicleOrderingMap(iScope, iAgent5, n7).inverseBidiMap();
            boolean bl4 = bl3 = n7 >= n3;
            boolean bl5 = bl2 ? !bl3 : (bl3 = bl3);
            if (!orderedBidiMap.isEmpty() && (iAgent7 = (IAgent)orderedBidiMap.get((Object)(d5 = (!bl3 ? (Double)orderedBidiMap.firstKey() : (Double)orderedBidiMap.lastKey()).doubleValue()))) != null && !iAgent7.dead()) {
                double d6;
                boolean bl6 = iAgent6 == DrivingSkill.getCurrentTarget(iAgent7);
                double d7 = !bl3 ? RoadSkill.getTotalLength(iAgent5) - d5 : d5;
                double d8 = d + d7 - 0.5 * d2 - 0.5 * (d6 = DrivingSkill.getVehicleLength(iAgent7));
                if (d8 < 0.0) {
                    return ImmutableTriple.of((Object)iAgent7, (Object)d8, (Object)bl6);
                }
                if (d8 < d4) {
                    d4 = d8;
                    iAgent2 = iAgent7;
                    bl = bl6;
                }
            }
            ++n6;
        }
        if (iAgent2 != null) {
            return ImmutableTriple.of(iAgent2, (Object)d4, (Object)bl);
        }
        return ImmutableTriple.of(null, (Object)1000000.0, (Object)false);
    }

    public static Triple<IAgent, Double, Boolean> findFollower(IScope iScope, IAgent iAgent, int n) {
        IAgent iAgent2;
        IAgent iAgent3 = DrivingSkill.getCurrentRoad(iAgent);
        IAgent iAgent4 = DrivingSkill.getCurrentTarget(iAgent);
        double d = DrivingSkill.getDistanceToCurrentTarget(iAgent);
        double d2 = DrivingSkill.getVehicleLength(iAgent);
        int n2 = DrivingSkill.getNumLanesOccupied(iAgent);
        if (iAgent3 != null && n <= RoadSkill.getNumLanesTotal(iAgent3) - n2) {
            iAgent2 = Utils.findNeighborOnCurrentRoad(iScope, iAgent, n, false);
            if (iAgent2 != null) {
                return iAgent2;
            }
        } else {
            return ImmutableTriple.of(null, (Object)1000000.0, (Object)false);
        }
        iAgent2 = null;
        double d3 = Double.MAX_VALUE;
        boolean bl = false;
        IAgent iAgent5 = iAgent4 == RoadSkill.getTargetNode(iAgent3) ? RoadSkill.getSourceNode(iAgent3) : iAgent4;
        block0: for (IAgent iAgent6 : RoadNodeSkill.getRoadsIn(iAgent5)) {
            int n3 = RoadSkill.getNumLanes(iAgent6);
            int n4 = RoadSkill.getNumLanesTotal(iAgent6);
            int n5 = 0;
            while (n5 < n2) {
                double d4;
                IAgent iAgent7;
                OrderedBidiMap orderedBidiMap;
                boolean bl2;
                int n6 = n + n5;
                if (n6 >= n4 - n2) continue block0;
                boolean bl3 = bl2 = n6 >= n3;
                if (bl2) {
                    iAgent6 = RoadSkill.getLinkedRoad(iAgent6);
                }
                if (!(orderedBidiMap = RoadSkill.getVehicleOrderingMap(iScope, iAgent6, n6).inverseBidiMap()).isEmpty() && DrivingSkill.getCurrentTarget(iAgent7 = (IAgent)orderedBidiMap.get((Object)(d4 = (!bl2 ? (Double)orderedBidiMap.lastKey() : (Double)orderedBidiMap.firstKey()).doubleValue()))) == iAgent5) {
                    boolean bl4 = iAgent5 == DrivingSkill.getCurrentTarget(iAgent7);
                    double d5 = !bl2 ? d4 : RoadSkill.getTotalLength(iAgent6) - d4;
                    double d6 = RoadSkill.getTotalLength(iAgent3) - d + d5 - 0.5 * d2 - 0.5 * DrivingSkill.getVehicleLength(iAgent7);
                    if (d6 < 0.0) {
                        return ImmutableTriple.of((Object)iAgent7, (Object)d6, (Object)bl4);
                    }
                    if (d6 < d3) {
                        d3 = d6;
                        iAgent2 = iAgent7;
                        bl = bl4;
                    }
                }
                ++n5;
            }
        }
        if (iAgent2 != null && !iAgent2.dead()) {
            return ImmutableTriple.of(iAgent2, (Object)d3, (Object)bl);
        }
        return ImmutableTriple.of(null, (Object)1000000.0, (Object)false);
    }

    private static Triple<IAgent, Double, Boolean> findNeighborOnCurrentRoad(IScope iScope, IAgent iAgent, int n, boolean bl) {
        IAgent iAgent2 = DrivingSkill.getCurrentRoad(iAgent);
        IAgent iAgent3 = DrivingSkill.getCurrentTarget(iAgent);
        double d = DrivingSkill.getDistanceToCurrentTarget(iAgent);
        double d2 = DrivingSkill.getVehicleLength(iAgent);
        boolean bl2 = DrivingSkill.isViolatingOneway(iAgent);
        int n2 = RoadSkill.getNumLanes(iAgent2);
        int n3 = DrivingSkill.getNumLanesOccupied(iAgent);
        IAgent iAgent4 = null;
        double d3 = Double.MAX_VALUE;
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < n3) {
            double d4;
            IAgent iAgent5;
            Double d5;
            double d6;
            boolean bl4;
            int n5 = n + n4;
            OrderedBidiMap orderedBidiMap = RoadSkill.getVehicleOrderingMap(iScope, iAgent2, n5).inverseBidiMap();
            boolean bl5 = bl4 = n5 >= n2;
            bl4 = bl2 ? !bl4 : bl4;
            double d7 = d6 = !bl4 ? d : RoadSkill.getTotalLength(iAgent2) - d;
            if (orderedBidiMap.containsKey((Object)d6) && orderedBidiMap.get((Object)d6) != iAgent) {
                return ImmutableTriple.of((Object)((IAgent)orderedBidiMap.get((Object)d6)), (Object)-1.0, (Object)false);
            }
            if (bl) {
                d5 = !bl4 ? (Double)orderedBidiMap.nextKey((Object)d6) : (Double)orderedBidiMap.previousKey((Object)d6);
            } else {
                Double d8 = d5 = !bl4 ? (Double)orderedBidiMap.previousKey((Object)d6) : (Double)orderedBidiMap.nextKey((Object)d6);
            }
            if (d5 != null && (iAgent5 = (IAgent)orderedBidiMap.get((Object)(d4 = d5.doubleValue()))) != null && !iAgent5.dead()) {
                boolean bl6 = iAgent3 == DrivingSkill.getCurrentTarget(iAgent5);
                double d9 = DrivingSkill.getVehicleLength(iAgent5);
                double d10 = Math.abs(d4 - d6) - 0.5 * d2 - 0.5 * d9;
                if (d10 < 0.0) {
                    return ImmutableTriple.of((Object)iAgent5, (Object)d10, (Object)bl6);
                }
                if (d10 < d3) {
                    d3 = d10;
                    iAgent4 = iAgent5;
                    bl3 = bl6;
                }
            }
            ++n4;
        }
        if (iAgent4 != null) {
            return ImmutableTriple.of(iAgent4, (Object)d3, (Object)bl3);
        }
        return null;
    }
}

