/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.job;

import gama.core.kernel.model.IModel;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.BinaryOperator;
import gama.gaml.types.GamaFileType;
import gama.headless.common.DataType;

public class Parameter {
    private String name;
    private String var;
    private Object value;
    private final DataType type;

    public Parameter(Parameter parameter) {
        this.name = parameter.name;
        this.var = parameter.var;
        this.value = parameter.value;
        this.type = parameter.type;
    }

    public Parameter clone(Parameter parameter) {
        return new Parameter(parameter);
    }

    public static Parameter loadAndBuildParameter(IDescription iDescription, IModel iModel) {
        Object object;
        String string = iDescription.getLitteral("name");
        String string2 = iDescription.getLitteral("var");
        IExpression iExpression = iDescription.getFacetExpr(new String[]{"init"});
        Object object2 = object = iExpression.isConst() ? iExpression.getConstValue() : iExpression.serializeToGaml(true);
        if (iExpression.getGamlType().getParent() instanceof GamaFileType) {
            object = ((BinaryOperator)iExpression).arg(0);
        }
        Parameter parameter = new Parameter(string, string2, object, Parameter.translate(iDescription.getGamlType().id()));
        return parameter;
    }

    public static DataType translate(Integer n) {
        if (n.equals(3)) {
            return DataType.BOOLEAN;
        }
        if (n.equals(1)) {
            return DataType.INT;
        }
        if (n.equals(2)) {
            return DataType.FLOAT;
        }
        if (n.equals(4)) {
            return DataType.STRING;
        }
        return DataType.UNDEFINED;
    }

    public Parameter(String string, String string2, Object object, DataType dataType) {
        this.name = string;
        this.var = string2;
        this.value = object;
        this.type = dataType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public DataType getType() {
        return this.type;
    }
}

