/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.job;

import gama.dev.DEBUG;
import gama.headless.common.Globals;
import gama.headless.core.GamaHeadlessException;
import gama.headless.job.Output;
import gama.headless.job.Parameter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface IExperimentJob
extends Runnable {
    @Override
    default public void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DebugStream debugStream = new DebugStream(this);){
                this.loadAndBuild();
                this.playAndDispose();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)exception);
        }
    }

    public String getExperimentID();

    public String getExperimentName();

    public String getModelName();

    public List<Parameter> getParameters();

    public List<Output> getOutputs();

    public void addParameter(Parameter var1);

    public void addOutput(Output var1);

    public List<String> getOutputNames();

    public void removeOutputWithName(String var1);

    public void setOutputFrameRate(String var1, int var2);

    public void setParameterValueOf(String var1, Object var2);

    public void setSeed(double var1);

    public double getSeed();

    public long getStep();

    public void setFinalStep(long var1);

    public void loadAndBuild() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, GamaHeadlessException;

    public Element asXMLDocument(Document var1);

    public void playAndDispose();

    public void play();

    public void dispose();

    public void doStep();

    public void doBackStep();

    public static class DebugStream
    extends FileOutputStream {
        DebugStream(IExperimentJob iExperimentJob) throws FileNotFoundException {
            super(Globals.OUTPUT_PATH + "/console-outputs-" + iExperimentJob.getExperimentID() + ".txt");
            DEBUG.REGISTER_LOG_WRITER((OutputStream)this);
        }

        public DebugStream(int n) throws FileNotFoundException {
            super(Globals.OUTPUT_PATH + "/console-outputs-" + n + ".txt");
            DEBUG.REGISTER_LOG_WRITER((OutputStream)this);
        }

        @Override
        public void close() throws IOException {
            super.close();
            DEBUG.UNREGISTER_LOG_WRITER();
        }
    }
}

