/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.listener;

import gama.core.common.GamlFileExtension;
import gama.core.runtime.server.CommandExecutor;
import gama.core.runtime.server.CommandResponse;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.GamaWebSocketServer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.headless.server.GamaServerExperimentJob;
import java.io.File;
import java.io.IOException;
import org.java_websocket.WebSocket;

public class LoadCommand
implements ISocketCommand {
    public CommandResponse execute(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        Object object = iMap.get((Object)"model");
        Object object2 = iMap.get((Object)"experiment");
        if (object == null || object2 == null) {
            return new CommandResponse(GamaServerMessage.Type.MalformedRequest, (Object)"For load, mandatory parameters are: 'model' and 'experiment'", iMap, false);
        }
        try {
            return this.launchGamlSimulation(gamaWebSocketServer, webSocket, (IList)iMap.get((Object)"parameters"), iMap.get((Object)"until") != null ? iMap.get((Object)"until").toString() : "", iMap);
        }
        catch (GamaCompilationFailedException gamaCompilationFailedException) {
            DEBUG.OUT((Object)((Object)gamaCompilationFailedException));
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, (Object)gamaCompilationFailedException.toJsonString(), iMap, true);
        }
        catch (Exception exception) {
            DEBUG.OUT((Object)exception);
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, (Object)exception, iMap, false);
        }
    }

    public CommandResponse launchGamlSimulation(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IList iList, String string, IMap<String, Object> iMap) throws IOException, GamaCompilationFailedException {
        String string2 = iMap.get((Object)"model").toString();
        String string3 = iMap.get((Object)"socket_id") != null ? iMap.get((Object)"socket_id").toString() : GamaWebSocketServer.getSocketId((WebSocket)webSocket);
        File file = new File(string2);
        if (!file.exists()) {
            DEBUG.OUT((Object)(file.getAbsolutePath() + " does not exist"));
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, (Object)("'" + file.getAbsolutePath() + "' does not exist"), iMap, false);
        }
        if (!GamlFileExtension.isGaml((String)file.getAbsoluteFile().toString())) {
            DEBUG.OUT((Object)(file.getAbsolutePath() + " is not a gaml file"));
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, (Object)("'" + file.getAbsolutePath() + "' is not a gaml file"), iMap, false);
        }
        String string4 = iMap.get((Object)"experiment").toString();
        GamaServerExperimentJob gamaServerExperimentJob = null;
        boolean bl = iMap.get((Object)"console") != null ? Boolean.parseBoolean(String.valueOf(iMap.get((Object)"console"))) : true;
        boolean bl2 = iMap.get((Object)"status") != null ? Boolean.parseBoolean(String.valueOf(iMap.get((Object)"status"))) : false;
        boolean bl3 = iMap.get((Object)"dialog") != null ? Boolean.parseBoolean(String.valueOf(iMap.get((Object)"dialog"))) : false;
        boolean bl4 = iMap.get((Object)"runtime") != null ? Boolean.parseBoolean(String.valueOf(iMap.get((Object)"runtime"))) : true;
        CommandResponse commandResponse = CommandExecutor.checkLoadParameters((IList)iList, iMap);
        if (commandResponse != null) {
            return commandResponse;
        }
        gamaServerExperimentJob = new GamaServerExperimentJob(file.getAbsoluteFile().toString(), string4, webSocket, iList, string, bl, bl2, bl3, bl4);
        gamaServerExperimentJob.load();
        if (gamaServerExperimentJob.simulator.getModel().getExperiment(string4) == null) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, (Object)("'" + string4 + "' is not an experiment present in '" + file.getAbsolutePath() + "'"), iMap, false);
        }
        if (gamaServerExperimentJob.controller.processOpen(true)) {
            gamaServerExperimentJob.controller.getExperiment().setStopCondition(string);
            gamaWebSocketServer.addExperiment(string3, gamaServerExperimentJob.getExperimentID(), gamaServerExperimentJob.controller.getExperiment());
            gamaWebSocketServer.execute((Runnable)gamaServerExperimentJob.controller.executionThread);
            return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, (Object)gamaServerExperimentJob.getExperimentID(), iMap, false);
        }
        return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, (Object)gamaServerExperimentJob.getExperimentID(), iMap, false);
    }
}

