/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.server;

import gama.core.kernel.experiment.AbstractExperimentController;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.CommandResponse;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.gaml.operators.Cast;
import gama.headless.server.GamaServerExperimentJob;
import java.io.IOException;
import org.java_websocket.WebSocket;

public class GamaServerExperimentController
extends AbstractExperimentController {
    final IList parameters;
    final String stopCondition;
    public MyRunnable executionThread;
    private final GamaServerExperimentJob _job;

    public GamaServerExperimentController(GamaServerExperimentJob gamaServerExperimentJob, IList iList, String string, WebSocket webSocket, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._job = gamaServerExperimentJob;
        this.serverConfiguration = new GamaServerExperimentConfiguration(webSocket, "Unknown", bl, bl2, bl3, bl4);
        this.parameters = iList;
        this.stopCondition = string;
        this.executionThread = new MyRunnable(gamaServerExperimentJob);
        this.commandThread.setUncaughtExceptionHandler(GamaExecutorService.EXCEPTION_HANDLER);
        this.lock.acquire();
        this.commandThread.start();
    }

    protected boolean processUserCommand(IExperimentController.ExperimentCommand experimentCommand) {
        switch (experimentCommand) {
            case _OPEN: {
                try {
                    this._job.loadAndBuildWithJson(this.parameters, this.stopCondition);
                }
                catch (GamaCompilationFailedException | IOException throwable) {
                    DEBUG.OUT((Object)throwable);
                    GAMA.reportError((IScope)this.scope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)this.scope), (boolean)true);
                    return false;
                }
                return true;
            }
            case _START: {
                this.paused = false;
                this.lock.release();
                return true;
            }
            case _PAUSE: {
                this.paused = true;
                return true;
            }
            case _STEP: {
                this.paused = true;
                this.lock.release();
                return true;
            }
            case _BACK: {
                this.paused = true;
                this.experiment.getAgent().backward(this.getScope());
                return true;
            }
            case _RELOAD: {
                try {
                    this.experiment.reload();
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    gamaRuntimeException.printStackTrace();
                    this.closeExperiment((Exception)((Object)gamaRuntimeException));
                    GAMA.reportError((IScope)this.scope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)gamaRuntimeException, (IScope)this.scope), (boolean)true);
                    return false;
                }
                catch (Throwable throwable) {
                    this.closeExperiment((Exception)((Object)GamaRuntimeException.create((Throwable)throwable, (IScope)this.scope)));
                    GAMA.reportError((IScope)this.scope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)this.scope), (boolean)true);
                    return false;
                }
                return true;
            }
            case _CLOSE: {
                return true;
            }
        }
        return true;
    }

    public void dispose() {
        this.scope = null;
        if (this.experiment != null) {
            try {
                this.paused = true;
                GAMA.updateExperimentState((IExperimentPlan)this.experiment, (IExperimentStateListener.State)IExperimentStateListener.State.NOTREADY);
                this.getScope().getGui().closeDialogs(this.getScope());
            }
            finally {
                this.acceptingCommands = false;
                this.experimentAlive = false;
                this.lock.release();
                GAMA.updateExperimentState((IExperimentPlan)this.experiment, (IExperimentStateListener.State)IExperimentStateListener.State.NONE);
                if (this.commandThread != null && this.commandThread.isAlive()) {
                    this.commands.offer(IExperimentController.ExperimentCommand._CLOSE);
                }
            }
        }
    }

    public void close() {
        this.closeExperiment(null);
    }

    public void closeExperiment(Exception exception) {
        this.disposing = true;
        if (exception != null) {
            this.getScope().getGui().getStatus().errorStatus(this.getScope(), exception);
        }
        this.experiment.dispose();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void schedule(ExperimentAgent experimentAgent) {
        block3: {
            this.scope = experimentAgent.getScope();
            this.serverConfiguration = this.serverConfiguration.withExpId(this._job.getExperimentID());
            this.scope.setServerConfiguration(this.serverConfiguration);
            try {
                if (!this.scope.init((IAgent)experimentAgent).passed()) {
                    this.scope.setDisposeStatus();
                }
            }
            catch (Throwable throwable) {
                if (this.scope != null && this.scope.interrupted() || throwable instanceof GamaRuntimeException) break block3;
                GAMA.reportError((IScope)this.scope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)this.scope), (boolean)true);
            }
        }
    }

    public void step() {
        if (this.paused) {
            this.lock.acquire();
        }
        try {
            this._job.doStep();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public boolean processStep(boolean bl) {
        this.paused = true;
        if (bl) {
            this._job.doStep();
            return true;
        }
        return super.processStep(bl);
    }

    public boolean processBack(boolean bl) {
        this.paused = true;
        if (bl) {
            this._job.doBackStep();
            return true;
        }
        return super.processBack(bl);
    }

    public class MyRunnable
    implements Runnable {
        final GamaServerExperimentJob mexp;

        MyRunnable(GamaServerExperimentJob gamaServerExperimentJob) {
            this.mexp = gamaServerExperimentJob;
        }

        @Override
        public void run() {
            try {
                while (GamaServerExperimentController.this.experimentAlive) {
                    IScope iScope;
                    if (this.mexp.simulator.isInterrupted()) break;
                    SimulationAgent simulationAgent = this.mexp.simulator.getSimulation();
                    ExperimentAgent experimentAgent = this.mexp.simulator.getExperimentPlan().getAgent();
                    IScope iScope2 = iScope = simulationAgent == null ? experimentAgent.getScope() : simulationAgent.getScope();
                    if (Cast.asBool((IScope)iScope, (Object)experimentAgent.getStopCondition().value(iScope)).booleanValue()) {
                        if (!"".equals(GamaServerExperimentController.this.stopCondition)) {
                            this.mexp.socket.send(Json.getNew().valueOf((Object)new CommandResponse(GamaServerMessage.Type.SimulationEnded, (Object)"", (IMap)experimentAgent.getAttribute("%%playCommand%%"), false)).toString());
                        }
                        break;
                    }
                    GamaServerExperimentController.this.step();
                }
            }
            catch (Exception exception) {
                DEBUG.OUT((Object)exception);
            }
        }
    }
}

