/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch.documentation;

import gama.headless.batch.documentation.ConceptManager;
import gama.headless.batch.documentation.MetadataStructure;
import gama.headless.batch.documentation.ScreenshotStructure;
import gama.headless.batch.documentation.Utils;
import gama.headless.common.Globals;
import gama.headless.core.GamaHeadlessException;
import gama.headless.runtime.HeadlessApplication;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelLibraryGenerator {
    static String wikiFolder = "F:/Gama/GamaWiki/";
    static String sourceFolder = "F:/Gama/GamaSource/";
    static String[] inputPathToModelLibrary = new String[]{sourceFolder + "gama.library/models/", sourceFolder + "gama.extension.maths/models"};
    static String outputPathToModelLibrary = wikiFolder + "References/ModelLibrary";
    static String modelLibraryImagesPath = wikiFolder + "resources/images/modelLibraryScreenshots";
    static String inputFileForHeadlessExecution = wikiFolder + "tempInputForHeadless.xml";
    static String inputModelScreenshot = wikiFolder + "modelScreenshot.xml";
    static String[] listNoScreenshot = new String[]{"gama.library/models/Syntax", "gama.library/models/Features/3D Visualization"};
    static HashMap<String, ScreenshotStructure> mapModelScreenshot;
    static HashMap<String, String> mainKeywordsMap;
    static List<String> expeUsedFromTheXML;

    static {
        expeUsedFromTheXML = new ArrayList<String>();
    }

    private static void updatePath() {
        outputPathToModelLibrary = wikiFolder + "/References/ModelLibrary";
        modelLibraryImagesPath = wikiFolder + "/resources/images/modelLibraryScreenshots";
        inputFileForHeadlessExecution = wikiFolder + "/tempInputForHeadless.xml";
        inputModelScreenshot = wikiFolder + "/modelScreenshot.xml";
    }

    public static void start(HeadlessApplication headlessApplication, List<String> list) throws IOException, TransformerException, InterruptedException {
        Object object;
        wikiFolder = list.get(list.size() - 2);
        sourceFolder = list.get(list.size() - 3);
        Globals.OUTPUT_PATH = list.get(list.size() - 1);
        ModelLibraryGenerator.updatePath();
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = inputPathToModelLibrary;
        int n = inputPathToModelLibrary.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            ArrayList<File> arrayList2 = new ArrayList<File>();
            Utils.getFilesFromFolder((String)object, arrayList2);
            arrayList.addAll(arrayList2);
            ++n2;
        }
        object = Utils.filterFilesByExtensions(arrayList, "gaml");
        System.out.println("----- Start to load the file " + inputModelScreenshot + " -----");
        ModelLibraryGenerator.loadModelScreenshot();
        System.out.println("----> file " + inputModelScreenshot + " loaded properly !");
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            System.out.println("path " + file.getAbsolutePath());
        }
        System.out.println("----- Start to write the input xml for headless -----");
        ModelLibraryGenerator.prepareInputFileForHeadless((ArrayList<File>)object, headlessApplication);
        System.out.println("----> file " + inputFileForHeadlessExecution + " written properly !");
        System.out.println("----- Run the headless -----" + inputFileForHeadlessExecution);
        headlessApplication.runXMLForModelLibrary(inputFileForHeadlessExecution);
        System.out.println("----- Headless executed properly ! -----");
        File file = new File(Globals.OUTPUT_PATH);
        ModelLibraryGenerator.deleteDirectoryAndItsContent(file);
        System.out.println("----- Read all the meta files to generate the map of main keywords for each model -----");
        ModelLibraryGenerator.prepareMainKeywordMap((ArrayList<File>)object);
        System.out.println("----> selection of main keywords effectued !");
        System.out.println("----- Start to write md content -----");
        ModelLibraryGenerator.writeMdContent((ArrayList<File>)object);
        System.out.println("----> MD content generated !");
        ConceptManager.printStatistics();
    }

    public static void prepareInputFileForHeadless(ArrayList<File> arrayList, HeadlessApplication headlessApplication) {
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file : arrayList) {
            String string = file.getAbsoluteFile().toString().replace("\\", "/");
            arrayList2.add(file);
            String[] stringArray = listNoScreenshot;
            int n = listNoScreenshot.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string.contains(sourceFolder + string2)) {
                    arrayList2.remove(file);
                }
                if ("include".compareTo(string.split("/")[string.split("/").length - 2]) == 0 || "includes".compareTo(string.split("/")[string.split("/").length - 2]) == 0) {
                    arrayList2.remove(file);
                }
                ++n2;
            }
        }
        try {
            headlessApplication.buildXMLForModelLibrary(arrayList2, inputFileForHeadlessExecution);
        }
        catch (GamaHeadlessException | IOException | ParserConfigurationException | TransformerException exception) {
            exception.printStackTrace();
        }
    }

    public static boolean deleteDirectoryAndItsContent(File file) {
        File[] fileArray = null;
        if (file == null) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (!file.isDirectory()) {
            return false;
        }
        fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (!ModelLibraryGenerator.deleteDirectoryAndItsContent(file2)) {
                    return false;
                }
                ++n2;
            }
        }
        return file.delete();
    }

    /*
     * WARNING - void declaration
     */
    private static void prepareMainKeywordMap(ArrayList<File> arrayList) throws IOException {
        void var4_9;
        String string;
        Iterator<String> iterator;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        mainKeywordsMap = new HashMap();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = ModelLibraryGenerator.getSectionName();
        for (File object2 : arrayList) {
            object = object2.getAbsolutePath();
            String string2 = "";
            for (String string3 : arrayList3) {
                String string5 = ((String)(object = ((String)object).replace("\\", "/"))).replace("models/" + string3, "models/" + string3 + "/.metadata");
                string5 = string5 + ".meta";
                serializable2 = new File(string5);
                if (!((File)serializable2).exists()) continue;
                serializable = ModelLibraryGenerator.getGAMLWords(new File(string5));
                iterator = ((ArrayList)serializable).iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    if (hashMap.containsKey(string)) {
                        int n = (Integer)hashMap.get(string);
                        hashMap.put(string, n + 1);
                        continue;
                    }
                    hashMap.put(string, 1);
                }
            }
        }
        for (String string6 : hashMap.keySet()) {
            if ((Integer)hashMap.get(string6) >= 20) continue;
            arrayList2.add(string6);
        }
        boolean bl = false;
        while (var4_9 < arrayList.size()) {
            Object object5 = arrayList.get((int)var4_9).getAbsolutePath();
            object = "";
            for (String string7 : arrayList3) {
                object5 = ((String)object5).replace("\\", "/");
                object = ((String)object5).replace("models/" + string7 + "/", "models/" + string7 + "/.metadata/");
                File file = new File((String)(object = (String)object + ".meta"));
                if (!file.exists()) continue;
                serializable2 = ModelLibraryGenerator.getGAMLWords(new File((String)object));
                serializable = new StringBuilder();
                iterator = ((ArrayList)serializable2).iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    if (!arrayList2.contains(string)) continue;
                    ((StringBuilder)serializable).append("[//]: # (keyword|").append(string).append(")\n");
                }
                string = ((String)object).replace("/.metadata", "").replace(".meta", "");
                mainKeywordsMap.put(string, ((StringBuilder)serializable).toString());
            }
            ++var4_9;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<String> getGAMLWords(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2 = null;
                    String[] stringArray = new String[]{"operator", "type", "statement", "skill", "architecture", "constant"};
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String[] stringArray2 = stringArray;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] stringArray3;
                            String string3 = stringArray2[n2];
                            string = Utils.findAndReturnRegex(string2, string3 + "s=(.*)");
                            String[] stringArray4 = stringArray3 = string.split("~");
                            int n3 = stringArray3.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object object = stringArray4[n4];
                                if ("constant".equals(string3)) {
                                    object = "#" + (String)object;
                                }
                                object = string3 + "_" + (String)object;
                                arrayList.add((String)object);
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
                if (inputStream == null) return arrayList;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return arrayList;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void loadModelScreenshot() {
        mapModelScreenshot = new HashMap();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputModelScreenshot);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("experiment");
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    String string = element.getAttribute("id");
                    ScreenshotStructure screenshotStructure = new ScreenshotStructure(string);
                    int n2 = 0;
                    while (n2 < element.getElementsByTagName("display").getLength()) {
                        String string2 = ((Element)element.getElementsByTagName("display").item(n2)).getAttribute("name");
                        int n3 = Integer.parseInt(((Element)element.getElementsByTagName("display").item(n2)).getAttribute("cycle_number"));
                        if (n3 == 0) {
                            n3 = 10;
                        }
                        screenshotStructure.addDisplay(string2, n3);
                        ++n2;
                    }
                    mapModelScreenshot.put(string, screenshotStructure);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static ArrayList<String> getSectionName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = inputPathToModelLibrary;
        int n = inputPathToModelLibrary.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            File file2 = new File(string2);
            String[] stringArray2 = file2.list((file, string) -> new File(file, string).isDirectory());
            Collections.addAll(arrayList, stringArray2);
            ++n2;
        }
        return arrayList;
    }

    private static void writeMdContent(ArrayList<File> arrayList) throws IOException {
        try {
            ConceptManager.loadConcepts();
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < arrayList.size()) {
            File file = arrayList.get(n);
            String string3 = ModelLibraryGenerator.extractHeader(file);
            MetadataStructure metadataStructure = new MetadataStructure(string3);
            if (!"".equals(metadataStructure.getName())) {
                String string4;
                ArrayList<File> arrayList2 = new ArrayList<File>();
                Utils.getFilesFromFolder(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4), arrayList2);
                Object object = "";
                object = file.getAbsolutePath().replace("\\", "/");
                boolean bl = false;
                Object object2 = inputPathToModelLibrary;
                int n2 = inputPathToModelLibrary.length;
                int n3 = 0;
                while (n3 < n2) {
                    string4 = object2[n3];
                    if (((String)object).contains(string4)) {
                        if (!string4.equals(inputPathToModelLibrary[0])) {
                            bl = true;
                        }
                        object = ((String)object).split(string4)[1];
                    }
                    ++n3;
                }
                string4 = metadataStructure.getName();
                if (!((String)object).contains("include") && !string4.startsWith("_")) {
                    Serializable serializable;
                    String string5 = ((String)object).split("/")[1];
                    String string6 = ((String)object).split("/")[0];
                    object2 = string5 + " " + ((String)object).split("/")[((String)object).split("/").length - 1];
                    if (bl) {
                        string6 = "Additionnal Plugins";
                    }
                    object = string6 + "/" + string5 + "/" + (String)object2;
                    object = ((String)object).replace(".gaml", "");
                    object = ((String)object).replace("/models", "");
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    for (File file2 : arrayList2) {
                        if (file2.getName().contains("-0.png")) {
                            file2.delete();
                            continue;
                        }
                        serializable = new File(modelLibraryImagesPath + "/" + (String)object + "/" + file2.getName());
                        ((File)serializable).getParentFile().mkdirs();
                        Files.move(file2.toPath(), ((File)serializable).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        arrayList3.add(((File)serializable).toPath().toString());
                    }
                    if (arrayList2.size() != 0) {
                        arrayList2.get(0).getParentFile().delete();
                    }
                    if (!string2.equals(string5)) {
                        ModelLibraryGenerator.createSubSectionFile(outputPathToModelLibrary + "/" + string6 + "/" + string5 + ".md");
                    }
                    ModelLibraryGenerator.addModel(outputPathToModelLibrary + "/" + string6 + "/" + string5 + ".md", string4, ((String)object2).replace(".gaml", ""), arrayList3);
                    if (!string.equals(string6)) {
                        ModelLibraryGenerator.createSectionFile(outputPathToModelLibrary + "/" + string6 + ".md");
                    }
                    if (!string2.equals(string5)) {
                        ModelLibraryGenerator.addSubSection(outputPathToModelLibrary + "/" + string6 + ".md", string5);
                    }
                    string2 = string5;
                    string = string6;
                    StringBuilder comparable2 = new StringBuilder().append(outputPathToModelLibrary).append("/").append((String)object);
                    comparable2.append(".md");
                    File file3 = new File(comparable2.toString());
                    Utils.createFolder(file3.getParentFile());
                    file3.createNewFile();
                    serializable = null;
                    Object var18_24 = null;
                    try (OutputStream outputStream = Files.newOutputStream(file3.toPath(), new OpenOption[0]);){
                        outputStream.write(mainKeywordsMap.get(file.getAbsolutePath().replace("\\", "/")).getBytes());
                        outputStream.write(metadataStructure.getMdHeader().getBytes());
                        for (String string7 : arrayList3) {
                            String string8 = string7.replace("\\", "/");
                            outputStream.write(ModelLibraryGenerator.getHTMLCodeForImage(string8).getBytes());
                        }
                        ArrayList<String> arrayList4 = ModelLibraryGenerator.searchInputListRecursive(file, new ArrayList<String>());
                        if (arrayList4.size() > 0) {
                            if (arrayList4.size() > 1) {
                                outputStream.write("Imported models : \n\n".getBytes());
                            } else {
                                outputStream.write("Imported model : \n\n".getBytes());
                            }
                        }
                        for (String string9 : arrayList4) {
                            outputStream.write(ModelLibraryGenerator.getModelCode(new File(string9)).getBytes());
                            outputStream.write("\n\n".getBytes());
                        }
                        outputStream.write("Code of the model : \n\n".getBytes());
                        outputStream.write(ModelLibraryGenerator.getModelCode(file).getBytes());
                    }
                    catch (Throwable throwable) {
                        if (serializable == null) {
                            serializable = throwable;
                        } else if (serializable != throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                        throw serializable;
                    }
                }
            } else {
                System.out.println("WARNING : The model contained in the file " + file.getName() + " has not been created because impossible to read the name or the header.");
            }
            ++n;
        }
    }

    private static void createSectionFile(String string) throws IOException {
        File file = new File(string);
        Utils.createFolder(file.getParentFile());
        file.createNewFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            String string2 = string.split("/")[string.split("/").length - 1].replace(".md", "");
            outputStream.write(("# " + string2 + "\n\nThis section is composed of the following sub-section :\n\n").getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void createSubSectionFile(String string) throws IOException {
        File file = new File(string);
        Utils.createFolder(file.getParentFile());
        file.createNewFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            String string2 = string.split("/")[string.split("/").length - 1].replace(".md", "");
            outputStream.write(("# " + string2 + "\n\nThis sub-section is composed of the following models :\n\n").getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addSubSection(String string, String string2) throws IOException {
        String string3 = string2.replace(" ", "");
        Files.write(Paths.get(string, new String[0]), ("* [" + string2 + "](references#" + string3 + ")\n\n").getBytes(), StandardOpenOption.APPEND);
    }

    private static void addModel(String string, String string2, String string3, List<String> list) throws IOException {
        String string4 = string3.replace(" ", "");
        Files.write(Paths.get(string, new String[0]), ("* [" + string2 + "](references#" + string4 + ")\n\n").getBytes(), StandardOpenOption.APPEND);
        for (String string5 : list) {
            Files.write(Paths.get(string, new String[0]), ModelLibraryGenerator.getHTMLCodeForImage(string5).getBytes(), StandardOpenOption.APPEND);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String extractHeader(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                block16: {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                        String string = null;
                        string = bufferedReader.readLine();
                        if (string != null && string.startsWith("/**")) {
                            stringBuilder.append(string).append("\n");
                            while ((string = bufferedReader.readLine()) != null) {
                                stringBuilder.append(string).append("\n");
                                if (!string.startsWith("*/")) {
                                    if (!string.startsWith(" */")) continue;
                                }
                                break block16;
                            }
                            break block16;
                        }
                        bufferedReader.close();
                    }
                }
                if (inputStream == null) return stringBuilder.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return stringBuilder.toString();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<String> searchInputListRecursive(File file, ArrayList<String> arrayList) throws IOException {
        ArrayList<String> arrayList2 = arrayList;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string = null;
                    string = bufferedReader.readLine();
                    while (string != null) {
                        String string2 = Utils.findAndReturnRegex(string, "import \"(.*[^\"])\"");
                        if (!"".equals(string2)) {
                            arrayList2.add(0, file.getParentFile().getAbsolutePath().replace("\\", "/") + "/" + string2);
                            arrayList2 = ModelLibraryGenerator.searchInputListRecursive(new File(file.getParentFile().getAbsolutePath().replace("\\", "/") + "/" + string2), arrayList2);
                        }
                        string = bufferedReader.readLine();
                    }
                }
                if (inputStream == null) return arrayList2;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return arrayList2;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getModelCode(File file) throws IOException {
        Object object = "";
        object = "```\n";
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string = null;
                    boolean bl = true;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (!bl) {
                            object = (String)object + string + "\n";
                            continue;
                        }
                        if (string.startsWith("*/") || string.startsWith(" */")) {
                            bl = false;
                            continue;
                        }
                        if (!string.startsWith("model")) continue;
                        bl = false;
                        object = (String)object + string + "\n";
                    }
                    object = (String)object + "```\n";
                }
                if (inputStream == null) return object;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return object;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static String getHTMLCodeForImage(String string) {
        String string2 = string.replace("\\", "/");
        String string3 = "gm_wiki/" + string2.split(wikiFolder)[1];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<p>");
        stringBuilder.append("<img src=\"").append(string3).append("\" alt=\"Eclipse folder.\" title class=\"img-responsive\">");
        stringBuilder.append("</p>");
        return stringBuilder.toString();
    }
}

