/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.runtime;

import gama.dev.DEBUG;
import gama.headless.job.IExperimentJob;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimulationRuntime
extends ThreadPoolExecutor
implements RejectedExecutionHandler {
    static int DEFAULT_NB_THREADS = 32;

    public SimulationRuntime() {
        super(DEFAULT_NB_THREADS, DEFAULT_NB_THREADS, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setRejectedExecutionHandler(this);
    }

    public void setNumberOfThreads(int n) {
        int n2 = this.getCorePoolSize();
        if (n == n2) {
            return;
        }
        if (n < n2) {
            this.setCorePoolSize(n);
            this.setMaximumPoolSize(n);
        } else {
            this.setMaximumPoolSize(n);
            this.setCorePoolSize(n);
        }
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        if (runnable instanceof IExperimentJob) {
            IExperimentJob iExperimentJob = (IExperimentJob)runnable;
            DEBUG.ON();
            DEBUG.ERR((Object)("The execution of  " + iExperimentJob.getExperimentID() + " has been rejected"));
        }
    }
}

