/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.script;

import gama.gaml.compilation.GamaCompilationFailedException;
import gama.headless.job.IExperimentJob;
import gama.headless.job.JobListFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExperimentationPlanFactory {
    public static final long DEFAULT_SEED = 1L;
    public static final long DEFAULT_FINAL_STEP = 1000L;

    public static List<IExperimentJob> buildExperiment(String string, Integer n, Integer n2) throws IOException, GamaCompilationFailedException {
        long[] lArray = new long[]{1L};
        return JobListFactory.constructAllJobs(string, lArray, n == null ? 1000L : (long)n.intValue(), n2);
    }

    public static List<IExperimentJob> buildExperiment(String string) throws IOException, GamaCompilationFailedException {
        return ExperimentationPlanFactory.buildExperiment(string, null, null);
    }

    public static Document buildXmlDocument(List<IExperimentJob> list) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("Experiment_plan");
        document.appendChild(element);
        for (IExperimentJob iExperimentJob : list) {
            Element element2 = iExperimentJob.asXMLDocument(document);
            element.appendChild(element2);
        }
        return document;
    }

    public static Document buildXmlDocumentForModelLibrary(List<IExperimentJob> list) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("Experiment_plan");
        document.appendChild(element);
        for (IExperimentJob iExperimentJob : list) {
            Element element2 = iExperimentJob.asXMLDocument(document);
            String string = element2.getAttribute("sourcePath").replace("\\", "/");
            element2.setAttribute("sourcePath", "/" + element2.getAttribute("sourcePath"));
            element2.setAttribute("finalStep", "11");
            Node node = element2.getElementsByTagName("Outputs").item(0);
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element3 = (Element)nodeList.item(n);
                String string2 = element3.getAttribute("name");
                element3.setAttribute("output_path", string.substring(0, string.length() - 5) + "/" + string2);
                element3.setAttribute("framerate", "10");
                ++n;
            }
            element.appendChild(element2);
        }
        return document;
    }

    public static ArrayList<String> readDirectory(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    ArrayList<String> arrayList2 = ExperimentationPlanFactory.readDirectory(file.getAbsolutePath() + File.separator + string2);
                    arrayList.addAll(arrayList2);
                    ++n2;
                }
            }
        } else if ("gaml".equals(ExperimentationPlanFactory.getFileExtension(file.getAbsolutePath()))) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    public static String getFileExtension(String string) {
        String string2 = null;
        try {
            string2 = string.substring(string.lastIndexOf(".") + 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }
}

