/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.server;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.NullGuiHandler;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.GamaServerConsoleListener;
import gama.core.runtime.server.GamaServerMessager;
import gama.core.runtime.server.GamaServerStatusDisplayer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.runtime.server.MessageType;
import gama.dev.DEBUG;
import gama.headless.listener.LoadCommand;
import gama.headless.listener.PlayCommand;
import gama.headless.listener.StopCommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GamaServerGUIHandler
extends NullGuiHandler {
    IStatusDisplayer status;
    GamaServerMessager dialogMessager = new GamaServerMessager(){

        public boolean canSendMessage(IExperimentAgent iExperimentAgent) {
            if (iExperimentAgent == null) {
                return false;
            }
            IScope iScope = iExperimentAgent.getScope();
            return iScope != null && iScope.getServerConfiguration().dialog();
        }
    };

    private boolean canSendRuntimeErrors(IScope iScope) {
        if (iScope != null && iScope.getExperiment() != null && iScope.getExperiment().getScope() != null) {
            return iScope.getExperiment().getScope().getServerConfiguration().runtime();
        }
        return true;
    }

    public void openMessageDialog(IScope iScope, String string) {
        DEBUG.OUT((Object)string);
        if (!this.dialogMessager.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.dialogMessager.sendMessage(iScope.getExperiment(), (Object)string, MessageType.SimulationDialog);
    }

    public void openErrorDialog(IScope iScope, String string) {
        DEBUG.OUT((Object)string);
        if (!this.dialogMessager.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.dialogMessager.sendMessage(iScope.getExperiment(), (Object)string, MessageType.SimulationErrorDialog);
    }

    public void runtimeError(IScope iScope, GamaRuntimeException gamaRuntimeException) {
        DEBUG.OUT((Object)((Object)gamaRuntimeException));
        if (!this.canSendRuntimeErrors(iScope)) {
            return;
        }
        this.dialogMessager.sendMessage(iScope.getExperiment(), (Object)gamaRuntimeException, MessageType.SimulationError);
    }

    public IStatusDisplayer getStatus() {
        if (this.status == null) {
            this.status = new GamaServerStatusDisplayer();
        }
        return this.status;
    }

    public IConsoleListener getConsole() {
        if (this.console == null) {
            this.console = new GamaServerConsoleListener();
        }
        return this.console;
    }

    public Map<String, ISocketCommand> getServerCommands() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(super.getServerCommands());
        hashMap.put("load", new LoadCommand());
        hashMap.put("play", new PlayCommand());
        hashMap.put("stop", new StopCommand());
        return Collections.unmodifiableMap(hashMap);
    }
}

