/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.command;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.headless.job.ExperimentJob;
import gama.headless.runtime.SimulationRuntime;
import java.io.File;

@GamlAnnotations.inside(kinds={3, 2, 0, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="of", type={4}, optional=false, doc={@GamlAnnotations.doc(value="Indicates the model containing the experiment to run")}), @GamlAnnotations.facet(name="name", type={4}, optional=false, doc={@GamlAnnotations.doc(value="Indicates the name of the experiment to run")}), @GamlAnnotations.facet(name="end_cycle", type={1}, optional=true, doc={@GamlAnnotations.doc(value="Indicates the cycle at which the experiment should stop")}), @GamlAnnotations.facet(name="core", type={1}, optional=true, doc={@GamlAnnotations.doc(value="Indicates the number of cores to use to run the experiments")}), @GamlAnnotations.facet(name="seed", type={1}, optional=true, doc={@GamlAnnotations.doc(value="Provides a predetermined seed instead of letting GAMA choose one")}), @GamlAnnotations.facet(name="with_output", type={10}, doc={@GamlAnnotations.doc(value="<i>This needs to be docummented</i>")}, optional=true), @GamlAnnotations.facet(name="with_param", type={10}, doc={@GamlAnnotations.doc(value="The parameters to pass to the new experiment")}, optional=true)}, omissible="name")
public class HeadlessStatement
extends AbstractStatement {
    private final SimulationRuntime processorQueue = new SimulationRuntime();
    private int maxSimulationID = 0;

    public String getSimulationId() {
        return String.valueOf(this.maxSimulationID++);
    }

    public HeadlessStatement(IDescription iDescription) {
        super(iDescription);
    }

    private String retrieveModelFileAbsolutePath(IScope iScope, String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        return new File(iScope.getModel().getFilePath()).getParentFile().getAbsolutePath() + "/" + string;
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        int n = 0;
        String string = Cast.asString((IScope)iScope, (Object)this.getFacetValue(iScope, "name"));
        String string2 = Cast.asString((IScope)iScope, (Object)this.getFacetValue(iScope, "of"));
        string2 = string2 != null && !string2.isEmpty() ? this.retrieveModelFileAbsolutePath(iScope, string2) : iScope.getModel().getFilePath();
        if (this.hasFacet("seed")) {
            n = Cast.asInt((IScope)iScope, (Object)this.getFacetValue(iScope, "seed"));
        }
        long l = n;
        ExperimentJob experimentJob = new ExperimentJob(this.getSimulationId(), string2, string, 1000L, "", l);
        this.processorQueue.execute(experimentJob);
        return null;
    }
}

