/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch;

import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.model.IModel;
import gama.dependencies.webb.WebbException;
import gama.dev.DEBUG;
import gama.dev.STRINGS;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.headless.batch.AbstractModelLibraryRunner;
import gama.headless.core.Experiment;
import gama.headless.runtime.HeadlessApplication;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;

public class ModelLibraryRunner
extends AbstractModelLibraryRunner {
    private static ModelLibraryRunner instance;

    private ModelLibraryRunner() {
        DEBUG.ON();
    }

    @Override
    public int start() throws IOException {
        Object object2;
        Injector injector = HeadlessApplication.getInjector();
        GamlModelBuilder gamlModelBuilder = this.createBuilder(injector);
        int[] nArray = new int[1];
        int[] nArray2 = new int[2];
        Multimap multimap = GamaBundleLoader.getPluginsWithModels();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Object object2 : multimap.keySet()) {
            for (String string2 : multimap.get(object2)) {
                Enumeration enumeration = object2.findEntries(string2, "*", true);
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    URL uRL = (URL)enumeration.nextElement();
                    if (!this.isModel(uRL)) continue;
                    URL uRL2 = FileLocator.toFileURL((URL)uRL);
                    arrayList.add(uRL2);
                }
            }
        }
        gamlModelBuilder.loadURLs(arrayList);
        object2 = new HashMap();
        arrayList.forEach(arg_0 -> this.lambda$0(gamlModelBuilder, (Map)object2, nArray, nArray2, arg_0));
        DEBUG.OUT((Object)(nArray[0] + " GAMA models compiled in built-in library and plugins. " + nArray2[0] + " compilation errors found"));
        DEBUG.SECTION((String)"SUMMARY");
        object2.forEach((string, exception) -> DEBUG.OUT((Object)(string + " = " + exception.toString())));
        DEBUG.SECTION((String)"SUMMARY");
        return nArray2[0] + nArray2[1];
    }

    private void validateAndRun(GamlModelBuilder gamlModelBuilder, Map<String, Exception> map, int[] nArray, int[] nArray2, URL uRL, boolean bl, int n) {
        if (uRL.toString().contains("Database")) {
            return;
        }
        STRINGS.PAD((String)"", (int)80, (char)'=');
        ArrayList arrayList = new ArrayList();
        IModel iModel = gamlModelBuilder.compile(uRL, arrayList);
        nArray[0] = nArray[0] + 1;
        arrayList.stream().filter(GamlCompilationError::isError).forEach(gamlCompilationError -> {
            DEBUG.OUT((Object)("Error in " + String.valueOf(gamlCompilationError.getURI()) + ":\n " + gamlCompilationError.toString() + " \n " + gamlCompilationError.getStatement().toString() + "\n"));
            nArray[0] = nArray2[0] + 1;
        });
        Experiment experiment = null;
        try {
            experiment = new Experiment(iModel);
        }
        catch (Exception exception) {
            map.put(uRL.getPath() + "\n", exception);
        }
        for (String string : iModel.getDescription().getExperimentNames()) {
            IExperimentPlan iExperimentPlan = iModel.getExperiment(string);
            if (iExperimentPlan.isBatch() && bl) continue;
            DEBUG.OUT((Object)("*********** Run experiment " + String.valueOf(iExperimentPlan) + " from model: " + iModel.getName()));
            if (experiment == null) continue;
            try {
                experiment.setup(string, 0.1);
                int n2 = 0;
                while (n2 < n) {
                    experiment.step();
                    DEBUG.OUT((Object)"****** Ap step()");
                    ++n2;
                }
            }
            catch (WebbException webbException) {
                DEBUG.OUT((Object)"gama.dependencies.webb.WebbException");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                map.put(uRL.getPath() + "\n" + string, exception);
            }
        }
    }

    public static ModelLibraryRunner getInstance() {
        if (instance == null) {
            instance = new ModelLibraryRunner();
        }
        return instance;
    }

    private /* synthetic */ void lambda$0(GamlModelBuilder gamlModelBuilder, Map map, int[] nArray, int[] nArray2, URL uRL) {
        this.validateAndRun(gamlModelBuilder, map, nArray, nArray2, uRL, true, 1);
    }
}

