/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.runtime;

import com.google.inject.Injector;
import gama.core.common.GamlFileExtension;
import gama.core.common.interfaces.IGui;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.model.IModel;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.NullGuiHandler;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.headless.batch.ModelLibraryRunner;
import gama.headless.batch.ModelLibraryTester;
import gama.headless.batch.ModelLibraryValidator;
import gama.headless.batch.documentation.ModelLibraryGenerator;
import gama.headless.common.Globals;
import gama.headless.common.HeadLessErrors;
import gama.headless.core.GamaHeadlessException;
import gama.headless.job.ExperimentJob;
import gama.headless.job.IExperimentJob;
import gama.headless.runtime.GamaHeadlessWebSocketServer;
import gama.headless.runtime.SimulationRuntime;
import gama.headless.script.ExperimentationPlanFactory;
import gama.headless.server.GamaServerGUIHandler;
import gama.headless.xml.ConsoleReader;
import gama.headless.xml.Reader;
import gama.headless.xml.XMLWriter;
import gaml.compiler.GamlStandaloneSetup;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.w3c.dom.Document;

public class HeadlessApplication
implements IApplication {
    static Injector INJECTOR;
    public static final String HELP_PARAMETER = "-help";
    public static final String GAMA_VERSION = "-version";
    public static final String CONSOLE_PARAMETER = "-c";
    public static final String VERBOSE_PARAMETER = "-v";
    public static final String THREAD_PARAMETER = "-hpc";
    public static final String STEPS_PARAMETER = "-steps";
    public static final String PING_INTERVAL = "-ping_interval";
    public static final String SOCKET_PARAMETER = "-socket";
    public static final String SSOCKET_PARAMETER = "-ssocket";
    public static final String SSOCKET_PARAMETER_JKSPATH = "-jks";
    public static final String SSOCKET_PARAMETER_SPWD = "-spwd";
    public static final String SSOCKET_PARAMETER_KPWD = "-kpwd";
    public static final String TUNNELING_PARAMETER = "-p";
    public static final String VALIDATE_LIBRARY_PARAMETER = "-validate";
    public static final String TEST_LIBRARY_PARAMETER = "-test";
    public static final String BUILD_XML_PARAMETER = "-xml";
    public static final String CHECK_MODEL_PARAMETER = "-check";
    public static final String RUN_LIBRARY_PARAMETER = "-runLibrary";
    public static final String BATCH_PARAMETER = "-batch";
    public static final String GAML_PARAMETER = "-gaml";
    public static final String WRITE_XMI = "-write-xmi";
    private int socket = -1;
    private int ping = 10000;
    private boolean consoleMode = false;
    private boolean tunnelingMode = false;
    private boolean verbose = false;
    private final SimulationRuntime processorQueue = new SimulationRuntime();
    private static boolean isServer;

    static {
        isServer = false;
    }

    public static Injector getInjector() {
        return HeadlessApplication.configureInjector();
    }

    private static Injector configureInjector() {
        if (INJECTOR != null) {
            return INJECTOR;
        }
        DEBUG.LOG((Object)"GAMA configuring and loading...");
        System.setProperty("java.awt.headless", "true");
        GAMA.setHeadLessMode((boolean)isServer);
        GAMA.setHeadlessGui((IGui)(isServer ? new GamaServerGUIHandler() : new NullGuiHandler()));
        try {
            INJECTOR = GamlStandaloneSetup.doSetup();
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, (IScope)GAMA.getRuntimeScope());
        }
        GamaPreferences.External.CORE_SEED_DEFINED.set((Object)true);
        GamaPreferences.External.CORE_SEED.set((Object)1.0);
        return INJECTOR;
    }

    private static void showVersion() {
        DEBUG.ON();
        DEBUG.LOG((Object)"Welcome to Gama-platform.org version GAMA 2025.5.2-SNAPSHOT\n");
        DEBUG.OFF();
    }

    private static void showHelp() {
        HeadlessApplication.showVersion();
        DEBUG.ON();
        DEBUG.LOG((Object)"sh ./gama-headless.sh [Options]\n\nList of available options:\n\t=== Headless Options ===\n\t\t-m [mem]                      -- allocate memory (ex 2048m)\n\t\t-c                            -- start the console to write xml parameter file\n\t\t-v                            -- verbose mode\n\t\t-hpc [core]                   -- set the number of core available for experimentation\n\t\t-p                            -- start pipeline to interact with another framework\n\t\t-ping_interval [pingInterval] -- when in server mode (socket parameter set), defines in milliseconds the time between each ping packet sent to clients to keep alive the connection. The default value is 10000, set to -1 to deactivate this behaviour.\n\t=== Infos ===\n\t\t-help                         -- get the help of the command line\n\t\t-version                      -- get the the version of gama\n\t=== Library Runner ===\n\t\t-validate                     -- invokes GAMA to validate models present in built-in library and plugins\n\t\t-test                         -- invokes GAMA to execute the tests present in built-in library and plugins and display their results\n\t=== GAMA Headless Runner ===\n\t\t-socket [socketPort]          -- starts socket pipeline to interact with another framework\n\t\t-batch [experimentName] [modelFile.gaml]\n\t\t                              -- Run batch experiment in headless mode\n\t\t-xml [experimentName] [modelFile.gaml] [xmlOutputFile.xml]\n\t\t                              -- build an xml parameter file from a model\n\t\t[xmlHeadlessFile.xml] [outputDirectory]\n\t\t                              -- default usage of GAMA headless");
        DEBUG.OFF();
    }

    private boolean checkParameters(List<String> list) {
        int n;
        File file;
        int n2 = list.size();
        boolean bl = true;
        boolean bl2 = true;
        if (list.contains(VERBOSE_PARAMETER)) {
            --n2;
            this.verbose = true;
            DEBUG.ON();
            DEBUG.LOG((Object)"Log active", (boolean)true);
        }
        if (list.contains(CONSOLE_PARAMETER)) {
            --n2;
            bl = false;
            this.consoleMode = true;
        }
        if (list.contains(TUNNELING_PARAMETER)) {
            --n2;
            bl2 = false;
            this.tunnelingMode = true;
        }
        if (list.contains(SOCKET_PARAMETER)) {
            n2 -= 2;
            bl = false;
            bl2 = false;
            this.socket = Integer.parseInt(this.after(list, SOCKET_PARAMETER));
            isServer = true;
        }
        if (list.contains(SSOCKET_PARAMETER)) {
            n2 -= 2;
            bl = false;
            bl2 = false;
            this.socket = Integer.parseInt(this.after(list, SSOCKET_PARAMETER));
            isServer = true;
        }
        if (list.contains(PING_INTERVAL)) {
            n2 -= 2;
            this.ping = Integer.parseInt(this.after(list, PING_INTERVAL));
        }
        if (list.contains(THREAD_PARAMETER)) {
            n2 -= 2;
            this.processorQueue.setNumberOfThreads(Integer.parseInt(this.after(list, THREAD_PARAMETER)));
        }
        if (list.contains(WRITE_XMI) || list.contains(GAMA_VERSION) || list.contains(HELP_PARAMETER) || list.contains(VALIDATE_LIBRARY_PARAMETER) || list.contains(TEST_LIBRARY_PARAMETER)) {
            --n2;
            bl = false;
            bl2 = false;
        }
        if (list.contains(BATCH_PARAMETER)) {
            n2 -= 3;
            bl2 = false;
        }
        if (list.contains(BUILD_XML_PARAMETER)) {
            n2 -= 4;
            bl2 = false;
            bl = false;
        }
        if (list.contains(GAML_PARAMETER)) {
            n2 -= 2;
        }
        if (bl && bl2 && n2 < 2) {
            return HeadlessApplication.showError(5, null);
        }
        if (!bl && bl2 && n2 < 1) {
            return HeadlessApplication.showError(6, null);
        }
        if (bl2) {
            Globals.OUTPUT_PATH = list.get(list.size() - 1);
            File file2 = new File(Globals.OUTPUT_PATH);
            if (!file2.exists() && !file2.mkdir()) {
                return HeadlessApplication.showError(2, Globals.OUTPUT_PATH);
            }
            Globals.IMAGES_PATH = Globals.OUTPUT_PATH + "/snapshot";
            file = new File((String)Globals.IMAGES_PATH);
            if (!file.exists() && !file.mkdir()) {
                return HeadlessApplication.showError(2, Globals.IMAGES_PATH);
            }
        }
        if (bl && !(file = new File(list.get(n = list.size() - (bl2 ? 2 : 1)))).exists()) {
            return HeadlessApplication.showError(4, list.get(n));
        }
        return true;
    }

    private static boolean showError(int n, String string) {
        DEBUG.ON();
        DEBUG.ERR((Object)HeadLessErrors.getError(n, string));
        DEBUG.OFF();
        return false;
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        Map map = iApplicationContext.getArguments();
        List<String> list = Arrays.asList((String[])map.get("application.args"));
        if (!this.checkParameters(list)) {
            System.exit(-1);
        }
        boolean bl = false;
        if (list.contains(GAMA_VERSION)) {
            HeadlessApplication.showVersion();
            bl = true;
        } else if (list.contains(HELP_PARAMETER)) {
            HeadlessApplication.showHelp();
            bl = true;
        }
        if (bl) {
            System.exit(0);
        }
        HeadlessApplication.configureInjector();
        DEBUG.OFF();
        if (list.contains(VALIDATE_LIBRARY_PARAMETER)) {
            return ModelLibraryValidator.getInstance().start();
        }
        if (list.contains(TEST_LIBRARY_PARAMETER)) {
            return ModelLibraryTester.getInstance().start();
        }
        if (list.contains(RUN_LIBRARY_PARAMETER)) {
            return ModelLibraryRunner.getInstance().start();
        }
        if (list.contains(CHECK_MODEL_PARAMETER)) {
            ModelLibraryGenerator.start(this, list);
        } else if (list.contains(BATCH_PARAMETER)) {
            this.runBatchSimulation(list.get(list.size() - 2), list.get(list.size() - 1));
        } else if (list.contains(GAML_PARAMETER)) {
            this.runGamlSimulation(list);
        } else if (list.contains(BUILD_XML_PARAMETER)) {
            this.buildXML(list);
        } else if (list.contains(SOCKET_PARAMETER)) {
            GamaHeadlessWebSocketServer.startForHeadless(this.socket, this.processorQueue, this.ping);
        } else if (list.contains(SSOCKET_PARAMETER)) {
            String string = list.contains(SSOCKET_PARAMETER_JKSPATH) ? this.after(list, SSOCKET_PARAMETER_JKSPATH) : "";
            String string2 = list.contains(SSOCKET_PARAMETER_SPWD) ? this.after(list, SSOCKET_PARAMETER_SPWD) : "";
            String string3 = list.contains(SSOCKET_PARAMETER_KPWD) ? this.after(list, SSOCKET_PARAMETER_KPWD) : "";
            GAMA.getPlatformAgent().setServer(GamaHeadlessWebSocketServer.startForSecureHeadless(this.socket, this.processorQueue, true, string, string2, string3, this.ping));
        } else {
            this.runSimulation(list);
        }
        return null;
    }

    public String after(List<String> list, String string) {
        if (list == null || list.size() < 2) {
            return null;
        }
        int n = 0;
        while (n < list.size() - 1) {
            if (list.get(n).equals(string)) {
                return list.get(n + 1);
            }
            ++n;
        }
        return null;
    }

    public void buildXML(List<String> list) throws ParserConfigurationException, TransformerException, IOException, GamaHeadlessException {
        if (list.size() < 3) {
            DEBUG.ON();
            DEBUG.ERR((Object)"Check your parameters!");
            HeadlessApplication.showHelp();
            return;
        }
        String string = list.get(list.size() - 3);
        String string2 = list.get(list.size() - 2);
        String string3 = list.get(list.size() - 1);
        List<IExperimentJob> list2 = ExperimentationPlanFactory.buildExperiment(string2);
        ArrayList<IExperimentJob> arrayList = new ArrayList<IExperimentJob>();
        for (IExperimentJob object : list2) {
            if (!object.getExperimentName().equals(string)) continue;
            arrayList.add(object);
            break;
        }
        if (arrayList.size() == 0) {
            DEBUG.ON();
            DEBUG.ERR((Object)"\n=== ERROR ===\n\tGAMA is about to generate an empty XML file.\n\tIf you want to run a Batch experiment, please check the \"-batch\" flag.");
            System.exit(-1);
        } else {
            Document document = ExperimentationPlanFactory.buildXmlDocument(arrayList);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string3);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(dOMSource, streamResult);
            DEBUG.ON();
            DEBUG.LOG((Object)("Parameter file saved at: " + file.getAbsolutePath()));
        }
    }

    public void buildXMLForModelLibrary(ArrayList<File> arrayList, String string) throws ParserConfigurationException, TransformerException, IOException, GamaHeadlessException {
        Object object;
        ArrayList<IExperimentJob> arrayList2 = new ArrayList<IExperimentJob>();
        for (File object22 : arrayList) {
            object = ExperimentationPlanFactory.buildExperiment(object22.getAbsolutePath());
            arrayList2.addAll((Collection<IExperimentJob>)object);
        }
        Document document = ExperimentationPlanFactory.buildXmlDocumentForModelLibrary(arrayList2);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        object = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        File file = new File(string);
        file.createNewFile();
        StreamResult streamResult = new StreamResult(file);
        ((Transformer)object).transform(dOMSource, streamResult);
        DEBUG.ON();
        DEBUG.LOG((Object)("Parameter file saved at: " + file.getAbsolutePath()));
    }

    public void runXMLForModelLibrary(String string) throws FileNotFoundException, InterruptedException {
        this.runXML(new Reader(string));
    }

    public void runSimulation(List<String> list) throws FileNotFoundException, InterruptedException {
        if (this.verbose && !this.tunnelingMode) {
            DEBUG.FORCE_ON();
        }
        this.runXML(this.consoleMode ? new Reader(ConsoleReader.readOnConsole()) : new Reader(list.get(list.size() - 2)));
        System.exit(0);
    }

    private void runXML(Reader reader) throws InterruptedException {
        reader.parseXmlFile();
        this.buildAndRunSimulation(reader.getSimulation());
        reader.dispose();
        this.processorQueue.shutdown();
        while (!this.processorQueue.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
        }
    }

    public void buildAndRunSimulation(Collection<ExperimentJob> collection) {
        for (ExperimentJob experimentJob : collection) {
            try {
                XMLWriter xMLWriter = null;
                xMLWriter = this.tunnelingMode ? new XMLWriter(new BufferedWriter(new OutputStreamWriter(System.out))) : new XMLWriter(Globals.OUTPUT_PATH + "/simulation-outputs" + experimentJob.getExperimentID() + ".xml");
                experimentJob.setBufferedWriter(xMLWriter);
                this.processorQueue.execute(experimentJob);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public void stop() {
    }

    public void runBatchSimulation(String string, String string2) {
        URI uRI;
        this.assertIsAModelFile(string2);
        Injector injector = HeadlessApplication.getInjector();
        GamlModelBuilder gamlModelBuilder = new GamlModelBuilder(injector);
        ArrayList arrayList = new ArrayList();
        try {
            uRI = URI.createFileURI((String)string2);
        }
        catch (Exception exception) {
            uRI = URI.createURI((String)string2);
        }
        IModel iModel = gamlModelBuilder.compile(uRI, arrayList);
        if (iModel == null) {
            DEBUG.LOG((Object)"GAMA couldn't compile your input file. Please verify that the input file path is correct and ensure that there are no errors in the GAML model.");
            System.exit(1);
            return;
        }
        GamaExecutorService.CONCURRENCY_SIMULATIONS.set((Object)true);
        GamaExecutorService.THREADS_NUMBER.set((Object)this.processorQueue.getCorePoolSize());
        IExperimentPlan iExperimentPlan = iModel.getExperiment(string);
        this.assertIsExperiment(string, iExperimentPlan);
        iExperimentPlan.setHeadless(true);
        iExperimentPlan.open();
        GAMA.getControllers().add(iExperimentPlan.getController());
        iExperimentPlan.getController().processStart(false);
        System.exit(0);
    }

    public void runGamlSimulation(List<String> list) throws IOException, GamaCompilationFailedException, InterruptedException {
        String string = list.get(list.size() - 3);
        String string2 = list.get(list.size() - 2);
        String string3 = list.get(list.size() - 1);
        Integer n = list.contains(STEPS_PARAMETER) ? Integer.valueOf(Integer.parseInt(this.after(list, STEPS_PARAMETER))) : null;
        Integer n2 = list.contains(THREAD_PARAMETER) ? Integer.valueOf(Integer.parseInt(this.after(list, THREAD_PARAMETER))) : null;
        this.assertIsAModelFile(string2);
        List<IExperimentJob> list2 = ExperimentationPlanFactory.buildExperiment(string2, n, n2);
        ExperimentJob experimentJob = null;
        for (IExperimentJob iExperimentJob : list2) {
            if (!iExperimentJob.getExperimentName().equals(string)) continue;
            experimentJob = (ExperimentJob)iExperimentJob;
            break;
        }
        if (experimentJob == null) {
            return;
        }
        Globals.OUTPUT_PATH = string3;
        experimentJob.setBufferedWriter(new XMLWriter(Globals.OUTPUT_PATH + "/simulation-outputs.xml"));
        this.processorQueue.setNumberOfThreads(n2 != null ? n2 : SimulationRuntime.DEFAULT_NB_THREADS);
        this.processorQueue.execute(experimentJob);
        this.processorQueue.shutdown();
        while (!this.processorQueue.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
        }
        System.exit(0);
    }

    private void assertIsAModelFile(String string) {
        if (!GamlFileExtension.isGaml((String)string)) {
            DEBUG.LOG((Object)("The file " + string + " is not a GAML model or experiment file."));
            System.exit(-1);
        }
    }

    private void assertIsExperiment(String string, IExperimentPlan iExperimentPlan) {
        if (iExperimentPlan == null) {
            DEBUG.LOG((Object)("Experiment " + string + " does not exist. Verify its name."));
            System.exit(-1);
        }
    }
}

