/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch.documentation;

import gama.headless.batch.documentation.ConceptManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataStructure {
    private static final String NAME_REGEX = "\\* Name: (.*)";
    private static final String AUTHOR_REGEX = "\\* Author: (.*)";
    private static final String DESCRIPTION_REGEX = "(?s)\\* Description: (.*)\\* Tags";
    private static final String TAGS_REGEX = "\\* Tags: (.*)";
    private static final String TAGS_SEPARATOR = ",";
    private String m_name;
    private String m_author;
    private String m_description;
    private String[] m_tags;

    public MetadataStructure(String string, String string2, String string3, String[] stringArray) {
        this.m_name = string;
        this.m_author = string2;
        this.m_description = string3;
        this.m_tags = stringArray;
    }

    public MetadataStructure(String string) {
        try {
            this.computeMetadata(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void computeMetadata(String string) throws IllegalArgumentException, IllegalAccessException {
        String string2 = this.findAndReturnRegex(string, NAME_REGEX);
        String string3 = this.findAndReturnRegex(string, AUTHOR_REGEX);
        String string4 = string.replace("* \n", "\n");
        String string5 = this.findAndReturnRegex(string4, DESCRIPTION_REGEX);
        string5 = string5.replaceAll("(\\n\\*(\\s|\\t)+)", "");
        String string6 = this.findAndReturnRegex(string, TAGS_REGEX);
        string6 = string6.replace(" ", "");
        String[] stringArray = null;
        if (!string6.isEmpty()) {
            string6 = string6.toLowerCase();
            stringArray = string6.split(TAGS_SEPARATOR);
        }
        this.m_name = string2;
        this.m_author = string3;
        this.m_description = string5;
        this.m_tags = stringArray;
    }

    public String getMdHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_tags != null) {
            int n = 0;
            while (n < this.m_tags.length) {
                if (ConceptManager.conceptIsPossibleToAdd(this.m_tags[n])) {
                    ConceptManager.addOccurrenceOfConcept(this.m_tags[n]);
                    stringBuilder.append("[//]: # (keyword|concept_");
                    stringBuilder.append(this.m_tags[n]);
                    stringBuilder.append(")\n");
                } else {
                    System.out.println("WARNING : the concept " + this.m_tags[n] + " does not exist in the list predefined concept tags ! (in model " + this.m_name + ")");
                }
                ++n;
            }
        }
        if (this.m_name != null && !this.m_name.isEmpty()) {
            stringBuilder.append("# ");
            stringBuilder.append(this.m_name);
            stringBuilder.append("\n\n\n");
        }
        if (this.m_author != null && !this.m_author.isEmpty()) {
            stringBuilder.append("_Author : ");
            stringBuilder.append(this.m_author);
            stringBuilder.append("_\n\n");
        }
        if (this.m_description != null && !this.m_description.isEmpty()) {
            stringBuilder.append(this.m_description);
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this.m_name;
    }

    private String findAndReturnRegex(String string, String string2, int n) {
        String string3 = "";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string3 = matcher.group(n);
        }
        return string3;
    }

    private String findAndReturnRegex(String string, String string2) {
        return this.findAndReturnRegex(string, string2, 1);
    }
}

