/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.xml;

import gama.headless.common.DataType;
import gama.headless.job.ExperimentJob;
import gama.headless.job.ListenedVariable;
import gama.headless.xml.Writer;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

public class XMLWriter
implements Writer {
    private BufferedWriter file;

    public XMLWriter(String string) {
        try {
            this.file = new BufferedWriter(new FileWriter(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public XMLWriter(BufferedWriter bufferedWriter) {
        this.file = bufferedWriter;
    }

    @Override
    public void close() {
        String string = "</Simulation>";
        try {
            this.file.write(string);
            this.file.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void writeResultStep(long l, ListenedVariable[] listenedVariableArray) {
        StringBuilder stringBuilder = new StringBuilder().append("\t<Step id='").append(l).append("' >\n");
        int n = 0;
        while (n < listenedVariableArray.length) {
            stringBuilder.append("\t\t<Variable name='").append(listenedVariableArray[n].getName()).append("' type='").append((listenedVariableArray[n].getDataType() == null ? DataType.UNDEFINED : listenedVariableArray[n].getDataType()).name()).append("'>").append(listenedVariableArray[n].getValue()).append("</Variable>\n");
            ++n;
        }
        stringBuilder.append("\t</Step>\n");
        try {
            this.file.write(stringBuilder.toString());
            this.file.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void writeSimulationHeader(ExperimentJob experimentJob) {
        Object object = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        object = (String)object + "<Simulation id=\"" + experimentJob.getExperimentID() + "\" >\n";
        try {
            this.file.write((String)object);
            this.file.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

