/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.batch.documentation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static void getFilesFromFolder(String string, List<File> list) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (file2.isFile()) {
                    list.add(file2);
                } else if (file2.isDirectory()) {
                    Utils.getFilesFromFolder(file2.getAbsolutePath(), list);
                }
                ++n2;
            }
        }
    }

    public static ArrayList<File> filterFilesByExtensions(List<File> list, String ... stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < list.size()) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray2[n3];
                if (list.get(n).getName().endsWith(string)) {
                    arrayList.add(list.get(n));
                }
                ++n3;
            }
            ++n;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<String> getConceptKeywords(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        string = Utils.findAndReturnRegex(string2, "\\[//\\]: # \\(keyword\\|concept_(.*)\\)");
                        if ("".equals(string)) continue;
                        arrayList.add(string);
                        string = "";
                    }
                }
                if (inputStream == null) return arrayList;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return arrayList;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static String findAndReturnRegex(String string, String string2) {
        String string3 = "";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string3 = matcher.group(1);
        }
        return string3;
    }

    public static boolean isInList(String string, String[] stringArray) {
        boolean bl = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string.equals(string2)) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public static boolean createFolder(File file) {
        if (!file.mkdir() && !file.exists()) {
            Utils.createFolder(file.getParentFile());
            return file.mkdir();
        }
        return true;
    }
}

