/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.server;

import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.model.IModel;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.headless.core.RichExperiment;
import gama.headless.core.RichOutput;
import gama.headless.job.ExperimentJob;
import gama.headless.job.ListenedVariable;
import gama.headless.server.GamaServerExperimentController;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.java_websocket.WebSocket;

public class GamaServerExperimentJob
extends ExperimentJob {
    public WebSocket socket;
    public GamaServerExperimentController controller;

    public GamaServerExperimentJob(String string, String string2, WebSocket webSocket, IList iList, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, string2, 0L, "", 0.0);
        this.socket = webSocket;
        this.controller = new GamaServerExperimentController(this, iList, string3, this.socket, bl, bl2, bl3, bl4);
    }

    @Override
    public void doStep() {
        this.step = this.simulator.step();
    }

    @Override
    public void doBackStep() {
        this.step = this.simulator.backStep();
    }

    @Override
    public void load() throws IOException, GamaCompilationFailedException {
        System.setProperty("user.dir", this.sourcePath);
        ArrayList arrayList = new ArrayList();
        IModel iModel = GamlModelBuilder.getDefaultInstance().compile(new File(this.sourcePath), arrayList, null);
        this.modelName = iModel.getName();
        this.simulator = new RichExperiment(iModel);
    }

    public void loadAndBuildWithJson(IList iList, String string) throws IOException, GamaCompilationFailedException {
        if (this.simulator == null) {
            this.load();
        }
        this.setup();
        this.controller.setExperiment(this.simulator.getModel().getExperiment(this.experimentName));
        this.simulator.setup(this.experimentName, this.seed, iList, this);
        this.simulator.getExperimentPlan().setStopCondition(string);
    }

    public void initParam(IList iList) {
        IList iList2 = iList;
        if (iList2 != null) {
            ExperimentPlan experimentPlan = (ExperimentPlan)this.simulator.getExperimentPlan();
            for (Object e : iList2.listValue(null, (IType)Types.MAP, false)) {
                IParameter.Batch batch;
                IMap iMap = (IMap)e;
                String string = iMap.get((Object)"type").toString();
                Object object = iMap.get((Object)"value");
                if ("int".equals(string)) {
                    object = Integer.valueOf(String.valueOf(iMap.get((Object)"value")));
                }
                if ("float".equals(string)) {
                    object = Double.valueOf(String.valueOf(iMap.get((Object)"value")));
                }
                if ((batch = experimentPlan.getParameterByTitle(iMap.get((Object)"name").toString())) != null) {
                    experimentPlan.setParameterValueByTitle(experimentPlan.getExperimentScope(), iMap.get((Object)"name").toString(), object);
                    continue;
                }
                experimentPlan.setParameterValue(experimentPlan.getExperimentScope(), iMap.get((Object)"name").toString(), object);
            }
        }
    }

    @Override
    public void exportVariables() {
        int n = this.listenedVariables.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ListenedVariable listenedVariable = this.listenedVariables[n2];
            if (this.step % (long)listenedVariable.getFrameRate() == 0L) {
                RichOutput richOutput = this.simulator.getRichOutput(listenedVariable);
                if (richOutput != null && richOutput.getValue() != null) {
                    if (richOutput.getValue() instanceof BufferedImage) {
                        try {
                            var5_5 = null;
                            var6_8 = null;
                            try {
                                var7_10 = new ByteArrayOutputStream();
                                try {
                                    var8_11 = (BufferedImage)richOutput.getValue();
                                    ImageIO.write((RenderedImage)var8_11, "png", (OutputStream)var7_10);
                                    var9_12 = ((ByteArrayOutputStream)var7_10).toByteArray();
                                    byte[] byArray = new byte[1];
                                    byte[] byArray2 = new byte[]{(byte)n2};
                                    byte[] byArray3 = Arrays.copyOf(var9_12, ((byte[])var9_12).length + byArray.length + byArray2.length);
                                    System.arraycopy(byArray, 0, byArray3, ((byte[])var9_12).length, byArray.length);
                                    System.arraycopy(byArray2, 0, byArray3, ((byte[])var9_12).length + byArray.length, byArray2.length);
                                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
                                    if (!this.socket.isClosing() && !this.socket.isClosed()) {
                                        this.socket.send(byteBuffer);
                                    }
                                    byteBuffer.clear();
                                }
                                finally {
                                    if (var7_10 != null) {
                                        ((ByteArrayOutputStream)var7_10).close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (var5_5 == null) {
                                    var5_5 = throwable;
                                } else if (var5_5 != throwable) {
                                    ((Throwable)var5_5).addSuppressed(throwable);
                                }
                                throw var5_5;
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        var5_5 = (richOutput.getName() + ": " + richOutput.getValue().toString()).getBytes();
                        var6_8 = new byte[]{1};
                        var7_10 = new byte[]{(byte)n2};
                        var8_11 = Arrays.copyOf((byte[])var5_5, ((Object)var5_5).length + var6_8.length + ((Object)var7_10).length);
                        System.arraycopy(var6_8, 0, var8_11, ((Object)var5_5).length, var6_8.length);
                        System.arraycopy(var7_10, 0, var8_11, ((Object)var5_5).length + var6_8.length, ((Object)var7_10).length);
                        var9_12 = ByteBuffer.wrap((byte[])var8_11);
                        if (!this.socket.isClosing() && !this.socket.isClosed()) {
                            this.socket.send((ByteBuffer)var9_12);
                        }
                        listenedVariable.setValue(richOutput.getValue(), richOutput.getType());
                    }
                }
            } else {
                listenedVariable.setValue(null);
            }
            ++n2;
        }
    }
}

