/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.common;

import gama.headless.common.DataType;

public final class DataTypeFactory {
    public static DataType getObjectMetaData(Object object) {
        return switch (object.getClass().getSimpleName()) {
            case "Integer", "Long" -> DataType.INT;
            case "Float", "Double" -> DataType.FLOAT;
            case "Boolean" -> DataType.BOOLEAN;
            case "String" -> DataType.STRING;
            default -> DataType.UNDEFINED;
        };
    }

    public static Object getObjectFromText(String string, DataType dataType) {
        return switch (dataType) {
            case DataType.INT -> Integer.valueOf(string);
            case DataType.BOOLEAN -> Boolean.valueOf(string);
            case DataType.FLOAT -> Double.valueOf(string);
            default -> string;
        };
    }
}

