/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.job;

import gama.core.kernel.model.IModel;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.headless.job.ExperimentJob;
import gama.headless.job.IExperimentJob;
import gama.headless.job.Output;
import gama.headless.job.Parameter;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class JobListFactory {
    public static List<IExperimentJob> constructAllJobs(String string, long[] lArray, long l, Integer n) throws IOException, GamaCompilationFailedException {
        ExperimentDescription experimentDescription2;
        IModel iModel = GamlModelBuilder.getDefaultInstance().compile(new File(string), null, null);
        LinkedHashMap<JobPlanExperimentID, Object> linkedHashMap = new LinkedHashMap<JobPlanExperimentID, Object>();
        if (n != null && n > 0) {
            for (ExperimentDescription experimentDescription2 : iModel.getExperiments()) {
                experimentDescription2.setConcurrency((IExpression)GAML.getExpressionFactory().createConst((Object)n, (IType)Types.INT));
            }
        }
        for (ExperimentDescription experimentDescription2 : iModel.getDescription().getExperiments()) {
            if ("batch".equals(experimentDescription2.getLitteral("type"))) continue;
            ExperimentJob experimentJob = ExperimentJob.loadAndBuildJob(experimentDescription2, iModel.getFilePath(), iModel);
            experimentJob.setSeed(12.0);
            linkedHashMap.put(new JobPlanExperimentID(experimentJob.getModelName(), experimentJob.getExperimentName()), experimentJob);
        }
        experimentDescription2 = new ArrayList();
        for (Object object : linkedHashMap.values()) {
            experimentDescription2.addAll(JobListFactory.constructJobWithName((IExperimentJob)object, lArray, l, null, null));
        }
        return experimentDescription2;
    }

    private static List<IExperimentJob> constructJobWithName(IExperimentJob iExperimentJob, long[] lArray, long l, List<Parameter> list, List<Output> list2) {
        ArrayList<IExperimentJob> arrayList = new ArrayList<IExperimentJob>();
        long[] lArray2 = lArray;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l2 = lArray2[n2];
            ExperimentJob experimentJob = new ExperimentJob((ExperimentJob)iExperimentJob);
            experimentJob.setSeed(l2);
            experimentJob.setFinalStep(l);
            if (list != null) {
                for (Parameter parameter : list) {
                    experimentJob.setParameterValueOf(parameter.getName(), parameter.getValue());
                }
            }
            if (list2 != null) {
                List<String> list3 = experimentJob.getOutputNames();
                for (Output output : list2) {
                    experimentJob.setOutputFrameRate(output.getName(), output.getFrameRate());
                    list3.remove(output.getName());
                }
                for (String string : list3) {
                    experimentJob.removeOutputWithName(string);
                }
            }
            arrayList.add(experimentJob);
            ++n2;
        }
        return arrayList;
    }

    public record JobPlanExperimentID(String modelName, String experimentName) {
    }
}

