/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.job;

import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.COUNTER;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.operators.Cast;
import gama.headless.common.Display2D;
import gama.headless.common.Globals;
import gama.headless.core.IRichExperiment;
import gama.headless.core.RichExperiment;
import gama.headless.core.RichOutput;
import gama.headless.job.IExperimentJob;
import gama.headless.job.ListenedVariable;
import gama.headless.job.Output;
import gama.headless.job.Parameter;
import gama.headless.xml.Writer;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExperimentJob
implements IExperimentJob {
    protected ListenedVariable[] listenedVariables;
    protected List<Parameter> parameters;
    protected List<Output> outputs;
    protected Writer outputFile;
    protected String sourcePath;
    public String experimentName;
    protected String modelName;
    public double seed;
    public long step;
    private String experimentID;
    public long finalStep;
    protected String untilCond;
    public volatile IRichExperiment simulator;

    static {
        DEBUG.ON();
    }

    public ExperimentJob(ExperimentJob experimentJob) {
        this.untilCond = "";
        this.experimentID = experimentJob.experimentID != null ? experimentJob.experimentID : "" + ExperimentJob.generateID();
        this.sourcePath = experimentJob.sourcePath;
        this.finalStep = experimentJob.finalStep;
        this.experimentName = experimentJob.experimentName;
        this.modelName = experimentJob.modelName;
        this.parameters = new ArrayList<Parameter>();
        this.outputs = new ArrayList<Output>();
        this.listenedVariables = experimentJob.listenedVariables;
        this.step = experimentJob.step;
        this.seed = experimentJob.seed;
        for (Parameter object : experimentJob.parameters) {
            this.addParameter(new Parameter(object));
        }
        for (Output output : experimentJob.outputs) {
            this.addOutput(new Output(output));
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    private static long generateID() {
        return COUNTER.GET_UNIQUE();
    }

    public void setBufferedWriter(Writer writer) {
        this.outputFile = writer;
    }

    @Override
    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public void addOutput(Output output) {
        output.setId("" + this.outputs.size());
        this.outputs.add(output);
    }

    public ExperimentJob(String string, String string2, long l, String string3, double d) {
        this(string, Long.toString(ExperimentJob.generateID()), string2, l, string3, d);
    }

    public ExperimentJob(String string, String string2, String string3, long l, String string4, double d) {
        this.parameters = new ArrayList<Parameter>();
        this.outputs = new ArrayList<Output>();
        this.experimentID = string2;
        this.sourcePath = string;
        this.finalStep = l;
        this.untilCond = string4;
        this.experimentName = string3;
        this.seed = d;
        this.modelName = null;
    }

    @Override
    public void loadAndBuild() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, GamaCompilationFailedException {
        this.load();
        this.listenedVariables = new ListenedVariable[this.outputs.size()];
        for (Parameter parameter : this.parameters) {
            if (parameter.getName() == null || "".equals(parameter.getName())) {
                this.simulator.setParameter(parameter.getVar(), parameter.getValue());
                continue;
            }
            this.simulator.setParameter(parameter.getName(), parameter.getValue());
        }
        this.setup();
        this.simulator.setup(this.experimentName, this.seed);
        int n = 0;
        while (n < this.outputs.size()) {
            Output output = this.outputs.get(n);
            this.listenedVariables[n] = new ListenedVariable(output.getName(), output.getWidth(), output.getHeight(), output.getFrameRate(), this.simulator.getTypeOf(output.getName()), output.getOutputPath());
            ++n;
        }
        this.simulator.getExperimentPlan().setStopCondition(this.untilCond);
    }

    public void load() throws IOException, GamaCompilationFailedException {
        System.setProperty("user.dir", this.sourcePath);
        ArrayList arrayList = new ArrayList();
        IModel iModel = GamlModelBuilder.getDefaultInstance().compile(new File(this.sourcePath), arrayList, null);
        this.modelName = iModel.getName();
        this.simulator = new RichExperiment(iModel);
    }

    public void setup() {
        this.step = 0L;
    }

    @Override
    public void playAndDispose() {
        DEBUG.TIMER((String)"GAMA", (String)"Simulation running ", (String)"for: ", () -> {
            this.play();
            this.dispose();
        }, (Consumer[])new Consumer[0]);
    }

    @Override
    public void play() {
        if (this.outputFile != null) {
            this.outputFile.writeSimulationHeader(this);
        }
        long l = this.finalStep < 100L ? 1L : this.finalStep / 100L;
        try {
            int n = 0;
            while (this.finalStep < 0L || (long)n < this.finalStep) {
                if ((long)n % l == 0L) {
                    DEBUG.LOG((Object)".", (boolean)false);
                }
                if (!this.simulator.isInterrupted()) {
                    IScope iScope;
                    SimulationAgent simulationAgent = this.simulator.getSimulation();
                    ExperimentAgent experimentAgent = this.simulator.getExperimentPlan().getAgent();
                    IScope iScope2 = iScope = simulationAgent == null ? experimentAgent.getScope() : simulationAgent.getScope();
                    if (!Cast.asBool((IScope)iScope, (Object)experimentAgent.getStopCondition().value(iScope)).booleanValue()) {
                        this.doStep();
                        ++n;
                        continue;
                    }
                }
                break;
            }
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            DEBUG.ERR((Object)"\n The simulation has stopped before the end due to the following exception: ", (Throwable)gamaRuntimeException);
        }
    }

    @Override
    public void dispose() {
        if (this.simulator != null) {
            this.simulator.dispose();
            this.simulator = null;
        }
        if (this.outputFile != null) {
            this.outputFile.close();
            this.outputFile = null;
        }
    }

    @Override
    public void doStep() {
        this.step = this.simulator.step();
        this.exportVariables();
    }

    @Override
    public void doBackStep() {
        this.step = this.simulator.backStep();
    }

    @Override
    public String getExperimentID() {
        return this.experimentID;
    }

    public void setExperimentID(String string) {
        this.experimentID = string;
    }

    public ListenedVariable[] getListenedVariables() {
        return this.listenedVariables;
    }

    protected void exportVariables() {
        int n = this.listenedVariables.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            ListenedVariable listenedVariable = this.listenedVariables[n2];
            if (this.step % (long)listenedVariable.getFrameRate() == 0L) {
                RichOutput richOutput = this.simulator.getRichOutput(listenedVariable);
                if (richOutput != null && richOutput.getValue() != null) {
                    if (richOutput.getValue() instanceof BufferedImage) {
                        listenedVariable.setValue(this.writeImageInFile((BufferedImage)richOutput.getValue(), listenedVariable.getName(), listenedVariable.getPath()), richOutput.getType());
                    } else {
                        listenedVariable.setValue(richOutput.getValue(), richOutput.getType());
                    }
                }
            } else {
                listenedVariable.setValue(null);
            }
            ++n2;
        }
        if (this.outputFile != null) {
            this.outputFile.writeResultStep(this.step, this.listenedVariables);
        }
    }

    @Override
    public long getStep() {
        return this.step;
    }

    protected Display2D writeImageInFile(BufferedImage bufferedImage, String string, String string2) {
        String string3 = string + this.getExperimentID() + "-" + this.step + ".png";
        String string4 = Globals.IMAGES_PATH + "/" + string3;
        if (!"".equals(string2) && string2 != null) {
            string4 = string2 + "-" + this.step + ".png";
            File file = new File(string4);
            file.getParentFile().mkdirs();
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string4));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return new Display2D(string + this.getExperimentID() + "-" + this.step + ".png");
    }

    @Override
    public void setSeed(double d) {
        this.seed = d;
    }

    @Override
    public double getSeed() {
        return this.seed;
    }

    @Override
    public Element asXMLDocument(Document document) {
        Attr attr;
        Attr attr2;
        Attr attr3;
        Node node;
        Element element = document.createElement("Simulation");
        Attr attr4 = document.createAttribute("id");
        attr4.setValue(this.experimentID);
        element.setAttributeNode(attr4);
        Attr attr5 = document.createAttribute("sourcePath");
        attr5.setValue(this.sourcePath);
        element.setAttributeNode(attr5);
        Attr attr6 = document.createAttribute("finalStep");
        attr6.setValue(Long.toString(this.finalStep));
        element.setAttributeNode(attr6);
        Attr attr7 = document.createAttribute("seed");
        attr7.setValue(Float.toString((float)this.seed));
        element.setAttributeNode(attr7);
        Attr attr8 = document.createAttribute("experiment");
        attr8.setValue(this.experimentName);
        element.setAttributeNode(attr8);
        Element element2 = document.createElement("Parameters");
        element.appendChild(element2);
        for (Parameter parameter : this.parameters) {
            Element element3 = document.createElement("Parameter");
            element2.appendChild(element3);
            node = document.createAttribute("name");
            node.setValue(parameter.getName());
            element3.setAttributeNode((Attr)node);
            attr3 = document.createAttribute("var");
            attr3.setValue(parameter.getVar());
            element3.setAttributeNode(attr3);
            attr2 = document.createAttribute("type");
            attr2.setValue(parameter.getType().toString());
            element3.setAttributeNode(attr2);
            attr = document.createAttribute("value");
            attr.setValue(parameter.getValue().toString());
            element3.setAttributeNode(attr);
        }
        Element element4 = document.createElement("Outputs");
        element.appendChild(element4);
        for (Output output : this.outputs) {
            node = document.createElement("Output");
            element4.appendChild(node);
            attr3 = document.createAttribute("id");
            attr3.setValue(output.getId());
            node.setAttributeNode(attr3);
            attr2 = document.createAttribute("name");
            attr2.setValue(output.getName());
            node.setAttributeNode(attr2);
            attr = document.createAttribute("framerate");
            attr.setValue(Integer.toString(output.getFrameRate()));
            node.setAttributeNode(attr);
        }
        return element;
    }

    public static ExperimentJob loadAndBuildJob(ExperimentDescription experimentDescription, String string, IModel iModel) {
        Iterable iterable;
        String string2 = experimentDescription.getName();
        IExpressionDescription iExpressionDescription = experimentDescription.getFacet("seed");
        double d = 0.0;
        if (iExpressionDescription != null) {
            d = Double.parseDouble(iExpressionDescription.getExpression().literalValue());
        }
        IDescription iDescription = experimentDescription.getChildWithKeyword("output");
        ExperimentJob experimentJob = new ExperimentJob(string, Long.toString(ExperimentJob.generateID()), string2, 0L, "", d);
        if (iDescription != null) {
            Iterable iterable22;
            iterable = iDescription.getChildrenWithKeyword("monitor");
            for (Iterable iterable22 : iterable) {
                experimentJob.addOutput(Output.loadAndBuildOutput((IDescription)iterable22));
            }
            iterable22 = iDescription.getChildrenWithKeyword("display");
            for (IDescription iDescription2 : iterable22) {
                if (iDescription2.getFacetExpr(new String[]{"virtual"}) == IExpressionFactory.TRUE_EXPR) continue;
                experimentJob.addOutput(Output.loadAndBuildOutput(iDescription2));
            }
        }
        iterable = experimentDescription.getChildrenWithKeyword("parameter");
        for (Iterable iterable22 : iterable) {
            experimentJob.addParameter(Parameter.loadAndBuildParameter((IDescription)iterable22, iModel));
        }
        return experimentJob;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    private Parameter getParameter(String string) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getName().equals(string)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private Output getOutput(String string) {
        for (Output output : this.outputs) {
            if (!output.getName().equals(string)) continue;
            return output;
        }
        return null;
    }

    @Override
    public List<Output> getOutputs() {
        return this.outputs;
    }

    @Override
    public void setParameterValueOf(String string, Object object) {
        this.getParameter(string).setValue(object);
    }

    @Override
    public void removeOutputWithName(String string) {
        this.outputs.remove(this.getOutput(string));
    }

    @Override
    public void setOutputFrameRate(String string, int n) {
        this.getOutput(string).setFrameRate(n);
    }

    @Override
    public List<String> getOutputNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Output output : this.outputs) {
            arrayList.add(output.getName());
        }
        return arrayList;
    }

    public long getFinalStep() {
        return this.finalStep;
    }

    @Override
    public void setFinalStep(long l) {
        this.finalStep = l;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    public static enum OutputType {
        OUTPUT,
        EXPERIMENT_ATTRIBUTE,
        SIMULATION_ATTRIBUTE;

    }
}

