/*
 * Decompiled with CFR 0.152.
 */
package gama.headless.xml;

import gama.dev.DEBUG;
import gama.headless.common.DataType;
import gama.headless.common.DataTypeFactory;
import gama.headless.job.ExperimentJob;
import gama.headless.job.Output;
import gama.headless.job.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Reader {
    public String fileName;
    public InputStream myStream;
    ArrayList<ExperimentJob> sims;

    static {
        DEBUG.ON();
    }

    public void dispose() {
        this.fileName = null;
        try {
            this.myStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.myStream = null;
        this.sims.clear();
        this.sims = null;
    }

    public Reader(String string) throws FileNotFoundException {
        this.fileName = string;
        this.myStream = new FileInputStream(new File(string));
    }

    public Reader(InputStream inputStream) {
        this.myStream = inputStream;
    }

    public Collection<ExperimentJob> getSimulation() {
        return this.sims;
    }

    private Parameter readParameter(Node node) {
        String string = this.getAttributeWithoutCase(node, "name");
        String string2 = this.getAttributeWithoutCase(node, "value");
        String string3 = this.getAttributeWithoutCase(node, "var");
        String string4 = this.getAttributeWithoutCase(node, "type");
        DataType dataType = DataType.valueOf(string4);
        return new Parameter(string, string3, DataTypeFactory.getObjectFromText(string2, dataType), dataType);
    }

    private Output readOutput(Node node) {
        String string = this.getAttributeWithoutCase(node, "name");
        String string2 = this.getAttributeWithoutCase(node, "id");
        String string3 = this.getAttributeWithoutCase(node, "output_path");
        int n = Integer.parseInt(this.getAttributeWithoutCase(node, "width") != null ? this.getAttributeWithoutCase(node, "width") : "500");
        int n2 = Integer.parseInt(this.getAttributeWithoutCase(node, "height") != null ? this.getAttributeWithoutCase(node, "height") : "500");
        int n3 = Integer.parseInt(this.getAttributeWithoutCase(node, "framerate") != null ? this.getAttributeWithoutCase(node, "framerate") : "1");
        return new Output(string, n, n2, n3, string2, string3);
    }

    private List<Node> findElementByNameWithoutCase(Node node, String string) {
        String string2 = string.toLowerCase();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node.getNodeName().toLowerCase().equals(string2)) {
            arrayList.add(node);
            return arrayList;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            arrayList.addAll(this.findElementByNameWithoutCase(node2, string));
            ++n;
        }
        return arrayList;
    }

    private void readParameter(ExperimentJob experimentJob, Node node) {
        List<Node> list = this.findElementByNameWithoutCase(node, "Parameter");
        if (list != null && list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                Node node2 = list.get(n);
                Parameter parameter = this.readParameter(node2);
                experimentJob.addParameter(parameter);
                ++n;
            }
        }
    }

    private void readOutput(ExperimentJob experimentJob, Node node) {
        List<Node> list = this.findElementByNameWithoutCase(node, "Output");
        if (list != null && list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                Node node2 = list.get(n);
                Output output = this.readOutput(node2);
                experimentJob.addOutput(output);
                ++n;
            }
        }
    }

    private String getAttributeWithoutCase(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node2 = namedNodeMap.item(n);
            if (node2.getNodeName().toLowerCase().equals(string2)) {
                return node2.getTextContent();
            }
            ++n;
        }
        return null;
    }

    private ExperimentJob readSimulation(Node node) {
        Object object;
        double d;
        int n;
        String string = this.getAttributeWithoutCase(node, "id");
        String string2 = this.getAttributeWithoutCase(node, "finalStep");
        if (string2 == null || "".equals(string2) || "INFINITY".equals(string2.toUpperCase())) {
            n = -1;
        } else {
            n = Integer.parseInt(string2);
            if (n < 0) {
                DEBUG.ERR((Object)"WARNING: the headless simulation has no final step!");
            }
        }
        String string3 = this.getAttributeWithoutCase(node, "until");
        Object object2 = this.getAttributeWithoutCase(node, "sourcePath");
        String string4 = this.getAttributeWithoutCase(node, "experiment");
        String string5 = this.getAttributeWithoutCase(node, "seed");
        double d2 = d = string5 == null || string5.length() == 0 ? 0.0 : Double.parseDouble(string5);
        if (((String)object2).charAt(0) != '/' && ((String)object2).charAt(0) != '\\' && ((String)object2).charAt(1) != ':') {
            if (this.fileName != null) {
                File file = new File(this.fileName);
                String string6 = file.getAbsolutePath();
                object = string6.substring(0, string6.length() - file.getName().length());
                object = (String)object + "/";
            } else {
                object = new File(".").getAbsolutePath();
            }
            object = ((String)object).substring(0, ((String)object).length() - 1);
            object2 = (String)object + (String)object2;
        }
        object = new ExperimentJob((String)object2, string, string4, n, string3, d);
        this.readParameter((ExperimentJob)object, node);
        this.readOutput((ExperimentJob)object, node);
        return object;
    }

    private ArrayList<ExperimentJob> readSimulation(Document document) {
        ArrayList<ExperimentJob> arrayList = new ArrayList<ExperimentJob>();
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            List<Node> list = this.findElementByNameWithoutCase(nodeList.item(n), "Simulation");
            if (list != null && list.size() > 0) {
                int n2 = 0;
                while (n2 < list.size()) {
                    Node node = list.get(n2);
                    arrayList.add(this.readSimulation(node));
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    public void parseXmlFile() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.myStream);
            this.sims = this.readSimulation(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

