/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.annotations.precompiler.GamlAnnotations;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ListenerProcessor
extends ElementProcessor<GamlAnnotations.listener> {
    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, Element e, GamlAnnotations.listener node) {
        boolean isDynamic;
        String clazz = ListenerProcessor.rawNameOf(context, e.getEnclosingElement().asType());
        String clazzObject = ListenerProcessor.toClassObject(clazz);
        ExecutableElement ex = (ExecutableElement)e;
        List<? extends VariableElement> argParams = ex.getParameters();
        int n = argParams.size();
        if (n == 0) {
            context.emitError("listeners must declare at least one argument corresponding to the new value of the variable (or 2 if the scope is passed)", ex);
            return;
        }
        String[] args = new String[n];
        int i = 0;
        while (i < args.length) {
            args[i] = ListenerProcessor.rawNameOf(context, argParams.get(i).asType());
            ++i;
        }
        boolean scope = n > 0 && args[0].contains("IScope");
        String method = ex.getSimpleName().toString();
        boolean bl = isDynamic = !scope && n == 2 || scope && n == 3;
        String param_class = ListenerProcessor.checkPrim(isDynamic ? args[!scope ? 1 : 2] : args[!scope ? 0 : 1]);
        String listenerHelper = ListenerProcessor.concat("(s,a,t,v)->{if (t != null) ((", clazz, ") t).", method, "(", scope ? "s," : "", isDynamic ? "a, " : "", "(" + param_class + ") v); return null; }");
        sb.append("_listener(").append(ListenerProcessor.toJavaString(node.value())).append(',').append(clazzObject).append(',').append(listenerHelper).append(");");
    }

    @Override
    protected Class<GamlAnnotations.listener> getAnnotationClass() {
        return GamlAnnotations.listener.class;
    }
}

