/*
 * Decompiled with CFR 0.152.
 */
package gama.processor;

import gama.processor.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class ProcessorContext
implements ProcessingEnvironment,
RoundEnvironment,
Constants {
    private static final boolean PRODUCES_DOC = true;
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String ADDITIONS_PACKAGE_BASE = "gaml.additions";
    public static final String ADDITIONS_CLASS_NAME = "GamlAdditions";
    private static final boolean PRODUCES_WARNING = true;
    public static final StandardLocation OUT = StandardLocation.SOURCE_OUTPUT;
    private final ProcessingEnvironment delegate;
    private RoundEnvironment round;
    public volatile String currentPlugin;
    public volatile String shortcut;
    public List<String> roots;
    public static final DocumentBuilder xmlBuilder;
    public final Set<String> imports = Stream.of("gama.gaml.multi_criteria", "gama.core.outputs.layers.charts", "gama.core.outputs.layers", "gama.core.outputs", "gama.core.kernel.batch", "gama.core.kernel.root", "gama.gaml.architecture.weighted_tasks", "gama.gaml.architecture.user", "gama.gaml.architecture.reflex", "gama.gaml.architecture.finite_state_machine", "gama.gaml.species", "gama.core.metamodel.shape", "gama.gaml.expressions", "gama.core.metamodel.topology", "gama.gaml.statements.test", "gama.core.metamodel.population", "gama.core.kernel.simulation", "gama.core.kernel.model", "java.util", "gama.gaml.statements.draw", " gama.core.metamodel.shape", "gama.core.common.interfaces", "gama.core.runtime", "java.lang", "gama.core.metamodel.agent", "gama.gaml.types", "gama.gaml.compilation", "gama.gaml.factories", "gama.gaml.descriptions", "gama.core.util.tree", "gama.core.util.file", "gama.core.util.matrix", "gama.core.util.graph", "gama.core.util.path", "gama.core.util", "gama.core.runtime.exceptions", "gama.gaml.statements", "gama.gaml.skills", "gama.gaml.variables", "gama.core.kernel.experiment", "gama.gaml.operators", "gama.core.common.interfaces", "gama.core.messaging", "gama.core.metamodel.population").map(s -> s + ".").collect(Collectors.toSet());

    static {
        DocumentBuilder temp = null;
        try {
            temp = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        xmlBuilder = temp;
    }

    public ProcessorContext(ProcessingEnvironment pe) {
        this.delegate = pe;
    }

    public DocumentBuilder getBuilder() {
        return xmlBuilder;
    }

    public String nameOf(TypeElement e) {
        if (e.getNestingKind() == NestingKind.TOP_LEVEL) {
            return e.getQualifiedName().toString();
        }
        return this.nameOf((TypeElement)e.getEnclosingElement()) + "." + e.getSimpleName().toString();
    }

    public List<Element> sortElements(Class<? extends Annotation> annotationClass) {
        Set<? extends Element> elements = this.getElementsAnnotatedWith(annotationClass);
        ArrayList<Element> result = new ArrayList<Element>(elements);
        Collections.sort(result, Comparator.comparing(Object::toString));
        return result;
    }

    public final Map<String, List<Element>> groupElements(Class<? extends Annotation> annotationClass) {
        return this.getElementsAnnotatedWith(annotationClass).stream().collect(Collectors.groupingBy(this::getRootClassOf));
    }

    private String getRootClassOf(Element e) {
        ElementKind kind = e.getKind();
        Element enclosing = e.getEnclosingElement();
        ElementKind enclosingKind = enclosing.getKind();
        if ((kind == ElementKind.CLASS || kind == ElementKind.INTERFACE) && enclosingKind != ElementKind.CLASS && enclosingKind != ElementKind.INTERFACE) {
            return e.toString();
        }
        return this.getRootClassOf(enclosing);
    }

    public TypeMirror getISkill() {
        return this.getType("gama.core.common.interfaces.ISkill");
    }

    public TypeMirror getIScope() {
        return this.getType("gama.core.runtime.IScope");
    }

    public TypeMirror getString() {
        return this.getType("java.lang.String");
    }

    public TypeMirror getIExpression() {
        return this.getType("gama.gaml.expressions.IExpression");
    }

    public TypeMirror getIType() {
        return this.getType("gama.gaml.types.IType");
    }

    public TypeMirror getType(String qualifiedName) {
        TypeElement e = this.delegate.getElementUtils().getTypeElement(qualifiedName);
        if (e == null) {
            return null;
        }
        return e.asType();
    }

    public TypeMirror getIVarAndActionSupport() {
        return this.getType("gama.core.common.interfaces.IVarAndActionSupport");
    }

    TypeMirror getIAgent() {
        return this.getType("gama.core.metamodel.agent.IAgent");
    }

    @Override
    public Map<String, String> getOptions() {
        return this.delegate.getOptions();
    }

    @Override
    public Messager getMessager() {
        return this.delegate.getMessager();
    }

    @Override
    public Filer getFiler() {
        return this.delegate.getFiler();
    }

    @Override
    public Elements getElementUtils() {
        return this.delegate.getElementUtils();
    }

    @Override
    public Types getTypeUtils() {
        return this.delegate.getTypeUtils();
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.delegate.getSourceVersion();
    }

    @Override
    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public void emitWarning(String s) {
        this.emitWarning(s, (Element)null);
    }

    public void emitError(String s) {
        this.emitError(s, (Element)null);
    }

    public void emitWarning(String s, Element e) {
        this.emit(Diagnostic.Kind.WARNING, s, e);
    }

    public void emitError(String s, Element e) {
        this.emit(Diagnostic.Kind.ERROR, s, e);
    }

    public void emit(Diagnostic.Kind kind, String s, Element e) {
        if (e == null) {
            this.getMessager().printMessage(kind, "GAML: " + s);
        } else {
            this.getMessager().printMessage(kind, "GAML: " + s, e);
        }
    }

    public void emitError(String s, Exception e1) {
        this.emit(Diagnostic.Kind.ERROR, s, e1, null);
    }

    public void emitWarning(String s, Exception e1) {
        this.emit(Diagnostic.Kind.WARNING, s, e1, null);
    }

    public void emitError(String s, Exception e1, Element element) {
        this.emit(Diagnostic.Kind.ERROR, s, e1, element);
    }

    public void emitWarning(String s, Exception e1, Element element) {
        this.emit(Diagnostic.Kind.WARNING, s, e1, element);
    }

    public void emit(Diagnostic.Kind kind, String s, Exception e1, Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        sb.append(e1.getMessage());
        StackTraceElement[] stackTraceElementArray = e1.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement t = stackTraceElementArray[n2];
            sb.append("\n");
            sb.append(t);
            ++n2;
        }
        this.emit(kind, sb.toString(), element);
    }

    public void setRoundEnvironment(RoundEnvironment env) {
        this.round = env;
        this.roots = this.round.getRootElements().stream().map(Object::toString).toList();
    }

    @Override
    public boolean processingOver() {
        return this.round.processingOver();
    }

    @Override
    public boolean errorRaised() {
        return this.round.errorRaised();
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.round.getRootElements();
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        return this.round.getElementsAnnotatedWith(a);
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        return this.round.getElementsAnnotatedWith(a);
    }

    public Writer createWriter(String s) {
        try {
            OutputStream output = this.getFiler().createResource(OUT, "", s, null).openOutputStream();
            return new OutputStreamWriter(output, CHARSET);
        }
        catch (Exception e) {
            this.emitWarning("", e);
            return null;
        }
    }

    void initCurrentPlugin() {
        try {
            JavaFileObject temp = this.getFiler().createSourceFile("gaml.additions.package-info", null);
            this.emit(Diagnostic.Kind.NOTE, "GAML Processor: creating " + String.valueOf(temp.toUri()), null);
            String plugin2 = temp.toUri().toASCIIString().replace("/target/gaml/additions/package-info.java", "").replace("/gaml/gaml/additions/package-info.java", "");
            this.currentPlugin = plugin2.substring(plugin2.lastIndexOf(47) + 1);
            this.shortcut = this.currentPlugin.substring(this.currentPlugin.lastIndexOf(46) + 1);
        }
        catch (IOException e) {
            this.emitWarning("Exception raised while reading the current plugin name " + e.getMessage(), e);
        }
    }

    public FileObject createSource() {
        this.initCurrentPlugin();
        try {
            return this.getFiler().createSourceFile("gaml.additions." + this.shortcut + ".GamlAdditions", null);
        }
        catch (Exception e) {
            this.emitWarning("Exception raised while creating the source file: " + e.getMessage(), e);
            return null;
        }
    }

    public Writer createTestWriter() {
        return this.createTestWriter(this.getTestFileName());
    }

    public Writer createTestWriter(String fileName) {
        this.createTestsFolder();
        try {
            OutputStream output = this.getFiler().createResource(OUT, this.getTestFolderName() + ".models", fileName, null).openOutputStream();
            return new OutputStreamWriter(output, CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.emitWarning("Impossible to create test file " + fileName + ": ", e);
            return null;
        }
    }

    private String getTestFileName() {
        String title = this.currentPlugin.substring(this.currentPlugin.lastIndexOf(46) + 1);
        return Constants.capitalizeFirstLetter(title) + " Tests.experiment";
    }

    private String getTestFolderName() {
        String title = this.currentPlugin.substring(this.currentPlugin.lastIndexOf(46) + 1);
        return "tests.Generated From " + Constants.capitalizeFirstLetter(title);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTestsFolder() {
        FileObject obj = null;
        try {
            obj = this.getFiler().createResource(OUT, this.getTestFolderName(), ".project", null);
        }
        catch (FilerException filerException) {
            return;
        }
        catch (IOException e) {
            this.emitWarning("Cannot create tests folder: ", e);
            return;
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try {
                OutputStream output = obj.openOutputStream();
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter(output, CHARSET);){
                        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>Generated tests in " + this.currentPlugin + "</name>\n\t<comment>" + this.currentPlugin + "</comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.xtext.ui.shared.xtextBuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.xtext.ui.shared.xtextNature</nature>\n\t\t<nature>gama.ui.application.gamaNature</nature>\n\t\t<nature>gama.ui.application.testNature</nature>\n\t</natures>\n</projectDescription>\n");
                    }
                    if (output == null) return;
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    if (output == null) throw e;
                    output.close();
                    throw e;
                }
                output.close();
                return;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                    throw e;
                } else {
                    if (e == throwable) throw e;
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException t) {
            this.emitWarning("", t);
        }
    }

    public Writer createSourceWriter(FileObject file2) {
        try {
            OutputStream output = file2.openOutputStream();
            return new OutputStreamWriter(output, CHARSET);
        }
        catch (Exception e) {
            this.emitWarning("Error in creating source writer", e);
            return null;
        }
    }

    public boolean shouldProduceDoc() {
        "true".equals(this.getOptions().get("doc"));
        return true;
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getFiler().getResource(OUT, "", string).openInputStream();
    }

    public List<Annotation> getUsefulAnnotationsOn(Element e) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Class clazz : processors.keySet()) {
            Object a = e.getAnnotation(clazz);
            if (a == null) continue;
            result.add((Annotation)a);
        }
        return result;
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public boolean containsImport(String path) {
        return this.imports.contains(path);
    }

    public boolean isIType(TypeMirror type2) {
        return this.delegate.getTypeUtils().isSubtype(type2, this.getIType());
    }
}

