/*
 * Decompiled with CFR 0.152.
 */
package gama.processor.doc;

import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.IConcept;
import gama.annotations.precompiler.doc.utils.TypeConverter;
import gama.processor.Constants;
import gama.processor.ElementProcessor;
import gama.processor.ProcessorContext;
import gama.processor.doc.ElementTypeUtils;
import gama.processor.doc.Operand;
import gama.processor.doc.Operands;
import gama.processor.doc.Operator;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocProcessor
extends ElementProcessor<GamlAnnotations.doc> {
    public static final String CAST_METHOD = "cast";
    Messager mes;
    TypeConverter tc = new TypeConverter();
    public Document document;
    int nbrOperators = 0;
    int nbrSkills = 0;
    int nbrSymbols = 0;

    @Override
    public boolean outputToJava() {
        return false;
    }

    @Override
    public void createElement(StringBuilder sb, ProcessorContext context, javax.lang.model.element.Element e, GamlAnnotations.doc annotation) {
    }

    @Override
    protected Class<GamlAnnotations.doc> getAnnotationClass() {
        return GamlAnnotations.doc.class;
    }

    protected String getRootName() {
        return "doc";
    }

    protected Element getRootNode(Document doc2) {
        Element root = null;
        if (doc2.hasChildNodes()) {
            root = (Element)doc2.getElementsByTagName(this.getRootName()).item(0);
        }
        if (root == null) {
            root = doc2.createElement(this.getRootName());
            doc2.appendChild(root);
        }
        return root;
    }

    @Override
    public void process(ProcessorContext context) {
        if (!context.shouldProduceDoc()) {
            return;
        }
        this.document = context.getBuilder().newDocument();
        this.mes = context.getMessager();
        Element root = this.getRootNode(this.document);
        Set<? extends javax.lang.model.element.Element> setConstants = context.getElementsAnnotatedWith(GamlAnnotations.constant.class);
        root.appendChild(this.processDocXMLCategories(setConstants, "constantsCategories"));
        Field[] conceptArray = IConcept.class.getFields();
        root.appendChild(this.processDocXMLConcepts(conceptArray, "conceptList"));
        root.appendChild(this.processDocXMLConstants(setConstants));
        Set<? extends javax.lang.model.element.Element> setOperatorsCategories = context.getElementsAnnotatedWith(GamlAnnotations.operator.class);
        root.appendChild(this.processDocXMLCategories(setOperatorsCategories, "operatorsCategories"));
        Set<? extends javax.lang.model.element.Element> setOperators = context.getElementsAnnotatedWith(GamlAnnotations.operator.class);
        root.appendChild(this.processDocXMLOperators(setOperators));
        Set<? extends javax.lang.model.element.Element> setSkills = context.getElementsAnnotatedWith(GamlAnnotations.skill.class);
        root.appendChild(this.processDocXMLSkills(setSkills, context));
        Set<? extends javax.lang.model.element.Element> setArchitectures = context.getElementsAnnotatedWith(GamlAnnotations.skill.class);
        root.appendChild(this.processDocXMLArchitectures(setArchitectures, context));
        Set<? extends javax.lang.model.element.Element> setSpecies = context.getElementsAnnotatedWith(GamlAnnotations.species.class);
        root.appendChild(this.processDocXMLSpecies(setSpecies));
        Set<? extends javax.lang.model.element.Element> setStatements = context.getElementsAnnotatedWith(GamlAnnotations.symbol.class);
        root.appendChild(this.processDocXMLStatementsInsideKind(setStatements));
        root.appendChild(this.processDocXMLStatementsInsideSymbol(setStatements));
        root.appendChild(this.processDocXMLStatementsKinds(setStatements));
        root.appendChild(this.processDocXMLStatements(setStatements));
        Set<? extends javax.lang.model.element.Element> setOperatorsTypes = context.getElementsAnnotatedWith(GamlAnnotations.type.class);
        ArrayList<Element> listEltOperatorsFromTypes = this.processDocXMLOperatorsFromTypes(setOperatorsTypes);
        Element eltOperators = (Element)root.getElementsByTagName("operators").item(0);
        for (Element eltOp : listEltOperatorsFromTypes) {
            eltOperators.appendChild(eltOp);
        }
        Set<? extends javax.lang.model.element.Element> setFilesOperators = context.getElementsAnnotatedWith(GamlAnnotations.file.class);
        ArrayList<Element> listEltOperatorsFromFiles = this.processDocXMLOperatorsFromFiles(setFilesOperators);
        for (Element eltOp : listEltOperatorsFromFiles) {
            eltOperators.appendChild(eltOp);
        }
        Set<? extends javax.lang.model.element.Element> setFiles = context.getElementsAnnotatedWith(GamlAnnotations.file.class);
        root.appendChild(this.processDocXMLTypes(setFiles));
        Set<? extends javax.lang.model.element.Element> setTypes = context.getElementsAnnotatedWith(GamlAnnotations.type.class);
        root.appendChild(this.processDocXMLTypes(setTypes, context));
        try {
            Throwable throwable = null;
            Object var19_21 = null;
            try (PrintWriter out = new PrintWriter(context.createWriter("docGAMA.xml"));){
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(new DOMSource(this.document), new StreamResult(out));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TransformerException e) {
            context.emitError("XML Error when producing the documentation: " + e.getMessage(), e);
        }
    }

    private Element processDocXMLConstants(Set<? extends javax.lang.model.element.Element> set) {
        Element eltConstants = this.document.createElement("constants");
        for (javax.lang.model.element.Element element : set) {
            if (!element.getAnnotation(GamlAnnotations.constant.class).value().equals(element.getSimpleName().toString())) continue;
            Element eltConstant = this.getConstantElt(element.getAnnotation(GamlAnnotations.constant.class), this.document, element, this.mes, this.tc);
            Element conceptsElt = eltConstant.getElementsByTagName("concepts").getLength() == 0 ? this.getConcepts(element, this.document, this.document.createElement("concepts"), this.tc) : this.getConcepts(element, this.document, (Element)eltConstant.getElementsByTagName("concepts").item(0), this.tc);
            eltConstant.appendChild(conceptsElt);
            eltConstants.appendChild(eltConstant);
        }
        return eltConstants;
    }

    private ArrayList<Element> processDocXMLOperatorsFromTypes(Set<? extends javax.lang.model.element.Element> set) {
        ArrayList<Element> eltOpFromTypes = new ArrayList<Element>();
        for (javax.lang.model.element.Element element : set) {
            Operator op_type = new Operator(this.document, this.tc.getProperCategory("Types"), element.getAnnotation(GamlAnnotations.type.class).concept(), element.getAnnotation(GamlAnnotations.type.class).name(), "casts the operand in a " + element.getAnnotation(GamlAnnotations.type.class).name() + " object.");
            Element docElt = null;
            Operands ops = new Operands(this.document, ((TypeElement)element).getQualifiedName().toString(), "", element.getAnnotation(GamlAnnotations.type.class).name(), "");
            ops.addOperand(new Operand(this.document, "val", 0, "any"));
            op_type.addOperands(ops);
            for (javax.lang.model.element.Element element2 : ((TypeElement)element).getEnclosedElements()) {
                GamlAnnotations.doc docMethod;
                if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !CAST_METHOD.equals(element2.getSimpleName().toString()) || (docMethod = element2.getAnnotation(GamlAnnotations.doc.class)) == null) continue;
                docElt = this.getDocElt(docMethod, this.document, this.mes, "Operator " + ((TypeElement)element).getQualifiedName().toString(), this.tc, (ExecutableElement)element2, null);
            }
            Element element3 = op_type.getElementDOM();
            if (docElt != null) {
                element3.appendChild(docElt);
            }
            eltOpFromTypes.add(element3);
        }
        return eltOpFromTypes;
    }

    private Element processDocXMLTypes(Set<? extends javax.lang.model.element.Element> setFiles) {
        Element files = this.document.createElement("files");
        for (javax.lang.model.element.Element element : setFiles) {
            if (element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated())) continue;
            Element file2 = this.document.createElement("file");
            file2.setAttribute("name", element.getAnnotation(GamlAnnotations.file.class).name());
            file2.setAttribute("buffer_type", this.tc.getProperType("" + element.getAnnotation(GamlAnnotations.file.class).buffer_type()));
            file2.setAttribute("buffer_index", this.tc.getProperType("" + element.getAnnotation(GamlAnnotations.file.class).buffer_index()));
            file2.setAttribute("buffer_content", this.tc.getProperType("" + element.getAnnotation(GamlAnnotations.file.class).buffer_content()));
            Element extensions = this.document.createElement("extensions");
            String[] stringArray = element.getAnnotation(GamlAnnotations.file.class).extensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                Element extElt = this.document.createElement("extension");
                extElt.setAttribute("name", ext);
                extensions.appendChild(extElt);
                ++n2;
            }
            file2.appendChild(extensions);
            Element conceptsElt = file2.getElementsByTagName("concepts").getLength() == 0 ? this.getConcepts(element, this.document, this.document.createElement("concepts"), this.tc) : this.getConcepts(element, this.document, (Element)file2.getElementsByTagName("concepts").item(0), this.tc);
            file2.appendChild(conceptsElt);
            files.appendChild(file2);
        }
        return files;
    }

    private ArrayList<Element> processDocXMLOperatorsFromFiles(Set<? extends javax.lang.model.element.Element> set) {
        ArrayList<Element> eltOpFromTypes = new ArrayList<Element>();
        for (javax.lang.model.element.Element element : set) {
            Operator op_is = new Operator(this.document, this.tc.getProperCategory("Files"), element.getAnnotation(GamlAnnotations.file.class).concept(), "is_" + element.getAnnotation(GamlAnnotations.file.class).name(), "Tests whether the operand is a " + element.getAnnotation(GamlAnnotations.file.class).name() + " file.");
            Operands ops_is = new Operands(this.document, ((TypeElement)element).getQualifiedName().toString(), "", "bool", "");
            ops_is.addOperand(new Operand(this.document, "val", 0, "any"));
            op_is.addOperands(ops_is);
            Operator op_file = new Operator(this.document, this.tc.getProperCategory("Files"), element.getAnnotation(GamlAnnotations.file.class).concept(), element.getAnnotation(GamlAnnotations.file.class).name() + "_file");
            for (javax.lang.model.element.Element element2 : ((TypeElement)element).getEnclosedElements()) {
                if (!element2.getKind().equals((Object)ElementKind.CONSTRUCTOR)) continue;
                Operands ops_file = new Operands(this.document, ((TypeElement)element).getQualifiedName().toString(), "", "file", "");
                int arity = 0;
                StringBuilder str = new StringBuilder();
                str.append(element.getAnnotation(GamlAnnotations.file.class).name());
                str.append("_file(");
                for (VariableElement variableElement : ((ExecutableElement)element2).getParameters()) {
                    String operandName = variableElement.getSimpleName().toString();
                    String typeName = this.tc.getProperType(variableElement.asType().toString());
                    if (typeName.contains("IScope")) continue;
                    ops_file.addOperand(new Operand(this.document, operandName, arity, this.tc.getProperType(variableElement.asType().toString())));
                    ++arity;
                    str.append(this.tc.getProperType(variableElement.asType().toString()));
                    str.append(",");
                }
                op_file.addOperands(ops_file);
                String string = str.substring(0, str.length() - 1) + ")";
                GamlAnnotations.doc docConstructor = element2.getAnnotation(GamlAnnotations.doc.class);
                Element exElt = null;
                if (docConstructor != null) {
                    exElt = this.getExamplesElt(docConstructor.examples(), this.document, (ExecutableElement)element2, this.tc, null);
                }
                op_file.addUsage(string + ": " + (docConstructor != null ? docConstructor.value() : ""), exElt);
            }
            String[] stringArray = element.getAnnotation(GamlAnnotations.file.class).extensions();
            StringBuilder listExtensions = new StringBuilder();
            if (stringArray.length > 0) {
                listExtensions.append(stringArray[0]);
                if (stringArray.length > 1) {
                    int i = 1;
                    while (i < stringArray.length) {
                        listExtensions.append(", ");
                        listExtensions.append(stringArray[i]);
                        ++i;
                    }
                }
            }
            op_file.setDocumentation("Constructs a file of type " + element.getAnnotation(GamlAnnotations.file.class).name() + ". Allowed extensions are limited to " + listExtensions.toString());
            op_file.addSeeAlso("is_" + element.getAnnotation(GamlAnnotations.file.class).name());
            op_is.addSeeAlso(element.getAnnotation(GamlAnnotations.file.class).name() + "_file");
            eltOpFromTypes.add(op_is.getElementDOM());
            eltOpFromTypes.add(op_file.getElementDOM());
        }
        return eltOpFromTypes;
    }

    private Element processDocXMLCategories(Set<? extends javax.lang.model.element.Element> set, String typeElement) {
        Element categories = this.document.createElement(typeElement);
        if ("operatorsCategories".equals(typeElement)) {
            Element element = this.document.createElement("category");
            element.setAttribute("id", "Iterator operators");
            Element child = element;
            categories.appendChild(child);
        }
        for (javax.lang.model.element.Element element : set) {
            String[] categoryNames = new String[1];
            if (element.getAnnotation(GamlAnnotations.operator.class) != null && element.getAnnotation(GamlAnnotations.operator.class).category().length > 0) {
                categoryNames = element.getAnnotation(GamlAnnotations.operator.class).category();
            } else if (element.getAnnotation(GamlAnnotations.constant.class) != null && element.getAnnotation(GamlAnnotations.constant.class).category().length > 0) {
                categoryNames = element.getAnnotation(GamlAnnotations.constant.class).category();
            } else {
                categoryNames[0] = this.tc.getProperCategory(element.getEnclosingElement().getSimpleName().toString());
            }
            NodeList nL = categories.getElementsByTagName("category");
            String[] stringArray = categoryNames;
            int n = categoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String categoryName = stringArray[n2];
                if (!"DeprecatedOperators".equals(categoryName)) {
                    int i = 0;
                    boolean found = false;
                    while (!found && i < nL.getLength()) {
                        Element elt = (Element)nL.item(i);
                        if (categoryName.equals(this.tc.getProperCategory(elt.getAttribute("id")))) {
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        Element category = this.document.createElement("category");
                        category.setAttribute("id", categoryName);
                        Element child = category;
                        categories.appendChild(child);
                    }
                }
                ++n2;
            }
        }
        return categories;
    }

    private Element processDocXMLConcepts(Field[] conceptArray, String typeElement) {
        Element concepts = this.document.createElement(typeElement);
        Field[] fieldArray = conceptArray;
        int n = conceptArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Element conceptElem = this.document.createElement("concept");
            try {
                conceptElem.setAttribute("id", field.get(new Object()).toString());
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            concepts.appendChild(conceptElem);
            ++n2;
        }
        return concepts;
    }

    private Element processDocXMLOperators(Set<? extends ExecutableElement> set) {
        Element operators = this.document.createElement("operators");
        for (ExecutableElement executableElement : set) {
            if (executableElement.getAnnotation(GamlAnnotations.operator.class).internal() || executableElement.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(executableElement.getAnnotation(GamlAnnotations.doc.class).deprecated())) continue;
            ++this.nbrOperators;
            List<? extends VariableElement> args = executableElement.getParameters();
            Set<Modifier> m = executableElement.getModifiers();
            boolean isStatic = m.contains((Object)Modifier.STATIC);
            Element operator2 = this.getOperatorElement(operators, executableElement.getAnnotation(GamlAnnotations.operator.class).value()[0]);
            if (operator2 == null) {
                operator2 = this.document.createElement("operator");
                operator2.setAttribute("id", this.tc.getProperOperatorName(executableElement.getAnnotation(GamlAnnotations.operator.class).value()[0]));
                operator2.setAttribute("name", this.tc.getProperOperatorName(executableElement.getAnnotation(GamlAnnotations.operator.class).value()[0]));
                operator2.setAttribute("alphabetOrder", Constants.getAlphabetOrder(executableElement.getAnnotation(GamlAnnotations.operator.class).value()[0]));
            }
            String[] stringArray = executableElement.getAnnotation(GamlAnnotations.operator.class).value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element altElt;
                String name = stringArray[n2];
                if (!"".equals(name) && !name.equals(executableElement.getAnnotation(GamlAnnotations.operator.class).value()[0]) && (altElt = this.getOperatorElement(operators, name)) == null) {
                    altElt = this.document.createElement("operator");
                    altElt.setAttribute("id", name);
                    altElt.setAttribute("name", name);
                    altElt.setAttribute("alternativeNameOf", executableElement.getAnnotation(GamlAnnotations.operator.class).value()[0]);
                    altElt.setAttribute("alphabetOrder", Constants.getAlphabetOrder(name));
                    altElt.appendChild(this.getCategories(executableElement, this.document, this.tc));
                    operators.appendChild(altElt);
                }
                ++n2;
            }
            this.addCategories(operator2, executableElement);
            this.addConcepts(operator2, executableElement);
            this.addCombinationOperandsResult(operator2, executableElement, isStatic, args);
            this.addDocumentation(operator2, executableElement);
            operators.appendChild(operator2);
        }
        this.processSeeAlso(operators);
        return operators;
    }

    private void addDocumentation(Element operator2, ExecutableElement e) {
        Element docElt = operator2.getElementsByTagName("documentation").getLength() == 0 ? this.getDocElt(e.getAnnotation(GamlAnnotations.doc.class), this.document, this.mes, "Operator " + operator2.getAttribute("name"), this.tc, e, operator2) : this.getDocElt(e.getAnnotation(GamlAnnotations.doc.class), this.document, (Element)operator2.getElementsByTagName("documentation").item(0), this.mes, "Operator " + operator2.getAttribute("name"), this.tc, e, operator2);
        if (docElt != null) {
            operator2.appendChild(docElt);
        }
    }

    private void addCombinationOperandsResult(Element operator2, ExecutableElement e, boolean isStatic, List<? extends VariableElement> args) {
        int arity = 0;
        Element combinaisonOpResElt = operator2.getElementsByTagName("combinaisonIO").getLength() == 0 ? this.document.createElement("combinaisonIO") : (Element)operator2.getElementsByTagName("combinaisonIO").item(0);
        Element operands = this.document.createElement("operands");
        operands.setAttribute("returnType", this.tc.getProperType(e.getReturnType().toString()));
        operands.setAttribute("contentType", "" + e.getAnnotation(GamlAnnotations.operator.class).content_type());
        operands.setAttribute("type", "" + e.getAnnotation(GamlAnnotations.operator.class).type());
        Object pkgName = String.valueOf(((TypeElement)e.getEnclosingElement()).getQualifiedName());
        if (((String)pkgName).contains("Spatial")) {
            pkgName = ((String)pkgName).split("Spatial")[0] + "Spatial";
        }
        pkgName = ((String)pkgName).replace('.', '/');
        pkgName = (String)pkgName + ".java";
        operands.setAttribute("class", (String)pkgName);
        if (!isStatic) {
            Element operand = this.document.createElement("operand");
            operand.setAttribute("type", this.tc.getProperType(e.getEnclosingElement().asType().toString()));
            operand.setAttribute("position", "" + arity);
            ++arity;
            operand.setAttribute("name", e.getEnclosingElement().asType().toString().toLowerCase());
            operands.appendChild(operand);
        }
        if (args.size() > 0) {
            int first_index;
            int i = first_index = args.get(0).asType().toString().contains("IScope") ? 1 : 0;
            while (i <= args.size() - 1) {
                Element operand = this.document.createElement("operand");
                operand.setAttribute("type", this.tc.getProperType(args.get(i).asType().toString()));
                operand.setAttribute("position", "" + arity);
                ++arity;
                operand.setAttribute("name", args.get(i).getSimpleName().toString());
                operands.appendChild(operand);
                ++i;
            }
        }
        combinaisonOpResElt.appendChild(operands);
        operator2.appendChild(combinaisonOpResElt);
    }

    private void addConcepts(Element operator2, ExecutableElement e) {
        Element conceptsElt = operator2.getElementsByTagName("concepts").getLength() == 0 ? this.getConcepts(e, this.document, this.document.createElement("concepts"), this.tc) : this.getConcepts(e, this.document, (Element)operator2.getElementsByTagName("concepts").item(0), this.tc);
        operator2.appendChild(conceptsElt);
    }

    private void addCategories(Element operator2, ExecutableElement e) {
        Element categoriesElt = operator2.getElementsByTagName("operatorCategories").getLength() == 0 ? this.getCategories(e, this.document, this.document.createElement("operatorCategories"), this.tc) : this.getCategories(e, this.document, (Element)operator2.getElementsByTagName("operatorCategories").item(0), this.tc);
        operator2.appendChild(categoriesElt);
    }

    private void processSeeAlso(Element operators) {
        NodeList ops = operators.getElementsByTagName("operator");
        int i = 0;
        while (i < ops.getLength()) {
            Element eltOperator = (Element)ops.item(i);
            String eltName = eltOperator.getAttribute("name");
            NodeList sees = eltOperator.getElementsByTagName("see");
            int j = 0;
            while (j < sees.getLength()) {
                List<Node> l_elts = this.searchForElementOfInterest(operators, ((Element)sees.item(j)).getAttribute("id"));
                if (l_elts.size() > 0) {
                    NodeList seeAlsoList = ((Element)l_elts.get(0)).getElementsByTagName("seeAlso");
                    Element seeAlsoElt = seeAlsoList.getLength() > 0 ? (Element)seeAlsoList.item(0) : this.document.createElement("seeAlso");
                    DocProcessor.addIfNotExistSee(this.document, seeAlsoElt, eltName);
                }
                ++j;
            }
            ++i;
        }
    }

    public List<Node> searchForElementOfInterest(Element elt, String eltName) {
        NodeList nList = elt.getElementsByTagName("operator");
        Stream<Node> nodeStream = IntStream.range(0, nList.getLength()).mapToObj(nList::item);
        List<Node> l = ((Stream)nodeStream.parallel()).filter(x -> DocProcessor.isElementOfInterestWithName(x, eltName)).collect(Collectors.toList());
        return l;
    }

    private static boolean isElementOfInterestWithName(Node nNode, String n) {
        Element eElement;
        boolean bFound = false;
        if (nNode != null && nNode.getNodeType() == 1 && n.equals((eElement = (Element)nNode).getAttribute("name"))) {
            bFound = true;
        }
        return bFound;
    }

    /*
     * WARNING - void declaration
     */
    private Element processDocXMLArchitectures(Set<? extends javax.lang.model.element.Element> setArchis, RoundEnvironment env) {
        Element archis = this.document.createElement("architectures");
        for (javax.lang.model.element.Element element : setArchis) {
            void var10_10;
            Element varsElt;
            if (element.getAnnotation(GamlAnnotations.skill.class).internal() || element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated()) || !ElementTypeUtils.isArchitectureElement((TypeElement)element, this.mes)) continue;
            Element archiElt = this.document.createElement("architecture");
            archiElt.setAttribute("id", element.getAnnotation(GamlAnnotations.skill.class).name());
            archiElt.setAttribute("name", element.getAnnotation(GamlAnnotations.skill.class).name());
            Element docEltArchi = this.getDocElt(element.getAnnotation(GamlAnnotations.doc.class), this.document, this.mes, element.getSimpleName().toString(), this.tc, null, archiElt);
            if (docEltArchi != null) {
                archiElt.appendChild(docEltArchi);
            }
            if ((varsElt = this.getVarsElt(element.getAnnotation(GamlAnnotations.vars.class), this.document, this.mes, archiElt.getAttribute("name"), this.tc)) != null) {
                archiElt.appendChild(varsElt);
            }
            Element actionsElt = this.document.createElement("actions");
            for (javax.lang.model.element.Element element2 : element.getEnclosedElements()) {
                Element actionElt = this.getActionElt(element2.getAnnotation(GamlAnnotations.action.class), this.document, this.mes, element2, this.tc);
                if (actionElt == null) continue;
                actionsElt.appendChild(actionElt);
            }
            archiElt.appendChild(actionsElt);
            if (archiElt.getElementsByTagName("concepts").getLength() == 0) {
                Element element3 = this.getConcepts(element, this.document, this.document.createElement("concepts"), this.tc);
            } else {
                Element element4 = this.getConcepts(element, this.document, (Element)archiElt.getElementsByTagName("concepts").item(0), this.tc);
            }
            archiElt.appendChild((Node)var10_10);
            archis.appendChild(archiElt);
        }
        return archis;
    }

    /*
     * WARNING - void declaration
     */
    private Element processDocXMLSkills(Set<? extends javax.lang.model.element.Element> setSkills, RoundEnvironment env) {
        Element skills = this.document.createElement("skills");
        for (javax.lang.model.element.Element element : setSkills) {
            void var11_16;
            Element varsElt;
            boolean emptySkill = true;
            if (element.getAnnotation(GamlAnnotations.skill.class).internal() || element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated()) || ElementTypeUtils.isArchitectureElement((TypeElement)element, this.mes)) continue;
            ++this.nbrSkills;
            Element skillElt = this.document.createElement("skill");
            skillElt.setAttribute("id", element.getAnnotation(GamlAnnotations.skill.class).name());
            skillElt.setAttribute("name", element.getAnnotation(GamlAnnotations.skill.class).name());
            skillElt.setAttribute("class", ((TypeElement)element).getQualifiedName().toString());
            skillElt.setAttribute("extends", ((TypeElement)element).getSuperclass().toString());
            Element docEltSkill = this.getDocElt(element.getAnnotation(GamlAnnotations.doc.class), this.document, this.mes, element.getSimpleName().toString(), this.tc, null, skillElt);
            if (docEltSkill != null) {
                skillElt.appendChild(docEltSkill);
                emptySkill = false;
            }
            if ((varsElt = this.getVarsElt(element.getAnnotation(GamlAnnotations.vars.class), this.document, this.mes, skillElt.getAttribute("name"), this.tc)) != null) {
                skillElt.appendChild(varsElt);
                if (varsElt.getElementsByTagName("var").getLength() != 0) {
                    emptySkill = false;
                }
            }
            Element actionsElt = this.document.createElement("actions");
            for (javax.lang.model.element.Element element2 : element.getEnclosedElements()) {
                Element actionElt = this.getActionElt(element2.getAnnotation(GamlAnnotations.action.class), this.document, this.mes, element2, this.tc);
                if (actionElt == null) continue;
                actionsElt.appendChild(actionElt);
                emptySkill = false;
            }
            skillElt.appendChild(actionsElt);
            if (skillElt.getElementsByTagName("concepts").getLength() == 0) {
                Element element3 = this.getConcepts(element, this.document, this.document.createElement("concepts"), this.tc);
            } else {
                Element element4 = this.getConcepts(element, this.document, (Element)skillElt.getElementsByTagName("concepts").item(0), this.tc);
            }
            skillElt.appendChild((Node)var11_16);
            if (emptySkill) continue;
            skills.appendChild(skillElt);
        }
        NodeList nodeList = skills.getElementsByTagName("skill");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element elt = (Element)nodeList.item(i);
            if (elt.hasAttribute("extends")) {
                if ("gama.gaml.skills.Skill".equals(elt.getAttribute("extends"))) {
                    elt.setAttribute("extends", "");
                } else {
                    int j = 0;
                    while (j < nodeList.getLength()) {
                        Element testedElt = (Element)nodeList.item(j);
                        if (testedElt.getAttribute("class").equals(elt.getAttribute("extends"))) {
                            elt.setAttribute("extends", testedElt.getAttribute("name"));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return skills;
    }

    private Element processDocXMLSpecies(Set<? extends TypeElement> setSpecies) {
        Element species2 = this.document.createElement("speciess");
        for (TypeElement typeElement : setSpecies) {
            if (typeElement.getAnnotation(GamlAnnotations.species.class).internal() || typeElement.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(typeElement.getAnnotation(GamlAnnotations.doc.class).deprecated())) continue;
            Element spec = this.document.createElement("species");
            spec.setAttribute("id", typeElement.getAnnotation(GamlAnnotations.species.class).name());
            spec.setAttribute("name", typeElement.getAnnotation(GamlAnnotations.species.class).name());
            Element docEltSpecies = this.getDocElt(typeElement.getAnnotation(GamlAnnotations.doc.class), this.document, this.mes, typeElement.getSimpleName().toString(), this.tc, null, spec);
            if (docEltSpecies != null) {
                spec.appendChild(docEltSpecies);
            }
            Element actionsElt = this.document.createElement("actions");
            for (javax.lang.model.element.Element element : typeElement.getEnclosedElements()) {
                Element actionElt = this.getActionElt(element.getAnnotation(GamlAnnotations.action.class), this.document, this.mes, element, this.tc);
                if (actionElt == null) continue;
                actionsElt.appendChild(actionElt);
            }
            spec.appendChild(actionsElt);
            Element element = this.document.createElement("attached_skills");
            String[] stringArray = typeElement.getAnnotation(GamlAnnotations.species.class).skills();
            int n = stringArray.length;
            int actionElt = 0;
            while (actionElt < n) {
                String eltSkill = stringArray[actionElt];
                Element skillElt = this.document.createElement("attached_skill");
                skillElt.setAttribute("name", eltSkill);
                element.appendChild(skillElt);
                ++actionElt;
            }
            spec.appendChild(element);
            Element varsElt = this.getVarsElt(typeElement.getAnnotation(GamlAnnotations.vars.class), this.document, this.mes, spec.getAttribute("name"), this.tc);
            if (varsElt != null) {
                spec.appendChild(varsElt);
            } else {
                varsElt = this.getVarsElt(ElementTypeUtils.getFirstImplementingInterfacesWithVars(typeElement, this.mes).getAnnotation(GamlAnnotations.vars.class), this.document, this.mes, spec.getAttribute("name"), this.tc);
                if (varsElt != null) {
                    spec.appendChild(varsElt);
                } else {
                    this.mes.printMessage(Diagnostic.Kind.WARNING, "GAML Processor of @species: even parents do not have attributes...");
                }
            }
            Element conceptsElt = spec.getElementsByTagName("concepts").getLength() == 0 ? this.getConcepts(typeElement, this.document, this.document.createElement("concepts"), this.tc) : this.getConcepts(typeElement, this.document, (Element)spec.getElementsByTagName("concepts").item(0), this.tc);
            spec.appendChild(conceptsElt);
            species2.appendChild(spec);
        }
        return species2;
    }

    private Element processDocXMLStatementsInsideSymbol(Set<? extends javax.lang.model.element.Element> setStatement) {
        Element statementsInsideSymbolElt = this.document.createElement("insideStatementSymbols");
        ArrayList<String> insideStatementSymbol = new ArrayList<String>();
        for (javax.lang.model.element.Element element : setStatement) {
            GamlAnnotations.inside insideAnnot;
            if (element.getAnnotation(GamlAnnotations.symbol.class).internal() || element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated()) || (insideAnnot = element.getAnnotation(GamlAnnotations.inside.class)) == null) continue;
            String[] stringArray = insideAnnot.symbols();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sym = stringArray[n2];
                if (!insideStatementSymbol.contains(sym)) {
                    insideStatementSymbol.add(sym);
                }
                ++n2;
            }
        }
        for (String string : insideStatementSymbol) {
            Element insideStatElt = this.document.createElement("insideStatementSymbol");
            insideStatElt.setAttribute("symbol", string);
            statementsInsideSymbolElt.appendChild(insideStatElt);
        }
        return statementsInsideSymbolElt;
    }

    private Element processDocXMLStatementsInsideKind(Set<? extends javax.lang.model.element.Element> setStatement) {
        Element statementsInsideKindElt = this.document.createElement("insideStatementKinds");
        ArrayList<String> insideStatementKind = new ArrayList<String>();
        for (javax.lang.model.element.Element element : setStatement) {
            GamlAnnotations.inside insideAnnot;
            if (element.getAnnotation(GamlAnnotations.symbol.class).internal() || element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated()) || (insideAnnot = element.getAnnotation(GamlAnnotations.inside.class)) == null) continue;
            int[] nArray = insideAnnot.kinds();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int kind = nArray[n2];
                String kindStr = this.tc.getSymbolKindStringFromISymbolKind(Integer.valueOf(kind));
                if (!insideStatementKind.contains(kindStr)) {
                    insideStatementKind.add(kindStr);
                }
                ++n2;
            }
        }
        for (String string : insideStatementKind) {
            Element insideStatElt = this.document.createElement("insideStatementKind");
            insideStatElt.setAttribute("symbol", string);
            statementsInsideKindElt.appendChild(insideStatElt);
        }
        return statementsInsideKindElt;
    }

    private Node processDocXMLStatementsKinds(Set<? extends javax.lang.model.element.Element> setStatements) {
        Element statementsKindsElt = this.document.createElement("statementsKinds");
        ArrayList<String> statementKinds = new ArrayList<String>();
        for (javax.lang.model.element.Element element : setStatements) {
            int kindAnnot;
            String kindStr;
            if (element.getAnnotation(GamlAnnotations.symbol.class).internal() || element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated()) || statementKinds.contains(kindStr = this.tc.getSymbolKindStringFromISymbolKind(Integer.valueOf(kindAnnot = element.getAnnotation(GamlAnnotations.symbol.class).kind())))) continue;
            statementKinds.add(kindStr);
        }
        for (String string : statementKinds) {
            Element kindStatElt = this.document.createElement("kind");
            kindStatElt.setAttribute("symbol", string);
            statementsKindsElt.appendChild(kindStatElt);
        }
        return statementsKindsElt;
    }

    private Element processDocXMLTypes(Set<? extends javax.lang.model.element.Element> setTypes, RoundEnvironment env) {
        Element types = this.document.createElement("types");
        for (javax.lang.model.element.Element element : setTypes) {
            if (element.getAnnotation(GamlAnnotations.type.class).internal()) continue;
            Element typeElt = this.document.createElement("type");
            typeElt.setAttribute("name", element.getAnnotation(GamlAnnotations.type.class).name());
            typeElt.setAttribute("id", "" + element.getAnnotation(GamlAnnotations.type.class).id());
            typeElt.setAttribute("kind", "" + element.getAnnotation(GamlAnnotations.type.class).kind());
            if (element.getAnnotation(GamlAnnotations.type.class).doc().length != 0) {
                Element docElt = this.getDocElt(element.getAnnotation(GamlAnnotations.type.class).doc()[0], this.document, this.mes, element.getAnnotation(GamlAnnotations.type.class).name(), this.tc, null, typeElt);
                typeElt.appendChild(docElt);
            }
            Element conceptsElt = typeElt.getElementsByTagName("concepts").getLength() == 0 ? this.getConcepts(element, this.document, this.document.createElement("concepts"), this.tc) : this.getConcepts(element, this.document, (Element)typeElt.getElementsByTagName("concepts").item(0), this.tc);
            typeElt.appendChild(conceptsElt);
            types.appendChild(typeElt);
        }
        return types;
    }

    private Element processDocXMLStatements(Set<? extends javax.lang.model.element.Element> setStatement) {
        Element statementsElt = this.document.createElement("statements");
        for (javax.lang.model.element.Element element : setStatement) {
            Element insideElt;
            Element docstatElt;
            if (element.getAnnotation(GamlAnnotations.symbol.class).internal() || element.getAnnotation(GamlAnnotations.doc.class) != null && !"".equals(element.getAnnotation(GamlAnnotations.doc.class).deprecated())) continue;
            ++this.nbrSymbols;
            Element statElt = this.document.createElement("statement");
            if (element.getAnnotation(GamlAnnotations.symbol.class).name().length != 0) {
                statElt.setAttribute("id", element.getAnnotation(GamlAnnotations.symbol.class).name()[0]);
                statElt.setAttribute("name", element.getAnnotation(GamlAnnotations.symbol.class).name()[0]);
            } else {
                String kind = this.tc.getSymbolKindStringFromISymbolKind(Integer.valueOf(element.getAnnotation(GamlAnnotations.symbol.class).kind())).replace("(", "").replace(")", "").replace(" ", "_");
                statElt.setAttribute("id", kind);
                statElt.setAttribute("name", kind);
            }
            statElt.setAttribute("kind", this.tc.getSymbolKindStringFromISymbolKind(Integer.valueOf(element.getAnnotation(GamlAnnotations.symbol.class).kind())));
            Element facetsElt = this.getFacetsElt(element.getAnnotation(GamlAnnotations.facets.class), this.document, this.mes, statElt.getAttribute("name"), this.tc);
            if (facetsElt != null) {
                statElt.appendChild(facetsElt);
            }
            if ((docstatElt = this.getDocElt(element.getAnnotation(GamlAnnotations.doc.class), this.document, this.mes, "Statement " + statElt.getAttribute("name"), this.tc, null, statElt)) != null) {
                statElt.appendChild(docstatElt);
            }
            if ((insideElt = this.getInsideElt(element.getAnnotation(GamlAnnotations.inside.class), this.document, this.tc)) != null) {
                statElt.appendChild(insideElt);
            }
            Element conceptsElt = statElt.getElementsByTagName("concepts").getLength() == 0 ? this.getConcepts(element, this.document, this.document.createElement("concepts"), this.tc) : this.getConcepts(element, this.document, (Element)statElt.getElementsByTagName("concepts").item(0), this.tc);
            statElt.appendChild(conceptsElt);
            statementsElt.appendChild(statElt);
            if (element.getAnnotation(GamlAnnotations.symbol.class).name().length <= 1) continue;
            int i = 1;
            while (i < element.getAnnotation(GamlAnnotations.symbol.class).name().length) {
                Element alternateElt = this.document.createElement("statement");
                alternateElt.setAttribute("id", element.getAnnotation(GamlAnnotations.symbol.class).name()[i]);
                alternateElt.setAttribute("name", element.getAnnotation(GamlAnnotations.symbol.class).name()[i]);
                alternateElt.setAttribute("alt_name_of", element.getAnnotation(GamlAnnotations.symbol.class).name()[0]);
                alternateElt.setAttribute("kind", this.tc.getSymbolKindStringFromISymbolKind(Integer.valueOf(element.getAnnotation(GamlAnnotations.symbol.class).kind())));
                statementsElt.appendChild(alternateElt);
                ++i;
            }
        }
        return statementsElt;
    }

    public Element getDocElt(GamlAnnotations.doc docAnnot, Document doc2, Messager mes, String eltName, TypeConverter tc, ExecutableElement e, Element parentElement) {
        return this.getDocElt(docAnnot, doc2, null, mes, eltName, tc, e, parentElement);
    }

    public Element getDocElt(GamlAnnotations.doc docAnnot, Document doc2, Element docElement, Messager mes, String eltName, TypeConverter tc, ExecutableElement e, Element parentElement) {
        Element docElt = docElement;
        if (docAnnot != null) {
            String comment;
            String returns;
            if (docElt == null) {
                docElt = doc2.createElement("documentation");
            }
            String value = docAnnot.value();
            boolean masterDoc = docAnnot.masterDoc();
            if (!"".equals(value)) {
                if (docElt.getElementsByTagName("result").getLength() != 0) {
                    resultElt = (Element)docElt.getElementsByTagName("result").item(0);
                    if ("true".equals(resultElt.getAttribute("masterDoc")) && masterDoc || !"true".equals(resultElt.getAttribute("masterDoc")) && !masterDoc) {
                        resultElt.setTextContent(resultElt.getTextContent() + "\n" + value);
                    } else if (!resultElt.hasAttribute("masterDoc") && masterDoc) {
                        resultElt.setTextContent(value);
                        resultElt.setAttribute("masterDoc", "true");
                    }
                } else {
                    resultElt = doc2.createElement("result");
                    resultElt.setTextContent(value);
                    if (masterDoc) {
                        resultElt.setAttribute("masterDoc", "true");
                    }
                    docElt.appendChild(resultElt);
                }
            }
            if (!"".equals(returns = docAnnot.returns())) {
                if (docElt.getElementsByTagName("returns").getLength() != 0) {
                    returnstElt = (Element)docElt.getElementsByTagName("returns").item(0);
                    if ("true".equals(returnstElt.getAttribute("masterDoc")) && masterDoc || !"true".equals(returnstElt.getAttribute("masterDoc")) && !masterDoc) {
                        returnstElt.setTextContent(returnstElt.getTextContent() + "\n" + returns);
                    } else if (!returnstElt.hasAttribute("masterDoc") && masterDoc) {
                        returnstElt.setTextContent(returns);
                        returnstElt.setAttribute("masterDoc", "true");
                    }
                } else {
                    returnstElt = doc2.createElement("returns");
                    returnstElt.setTextContent(returns);
                    if (masterDoc) {
                        returnstElt.setAttribute("masterDoc", "true");
                    }
                    docElt.appendChild(returnstElt);
                }
            }
            if (!"".equals(comment = docAnnot.comment())) {
                if (docElt.getElementsByTagName("comment").getLength() != 0) {
                    docElt.getElementsByTagName("comment").item(0).setTextContent(docElt.getElementsByTagName("comment").item(0).getTextContent() + comment);
                } else {
                    Element commentElt = doc2.createElement("comment");
                    commentElt.setTextContent(comment);
                    docElt.appendChild(commentElt);
                }
            }
            Element seeAlsoElt = docElt.getElementsByTagName("seeAlso").getLength() != 0 ? (Element)docElt.getElementsByTagName("seeAlso").item(0) : doc2.createElement("seeAlso");
            String[] stringArray = docAnnot.see();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String see = stringArray[n2];
                DocProcessor.addIfNotExistSee(doc2, seeAlsoElt, see);
                ++n2;
            }
            if (docAnnot.see().length != 0) {
                docElt.appendChild(seeAlsoElt);
            }
            Element usagesElt = docElt.getElementsByTagName("usages").getLength() != 0 ? (Element)docElt.getElementsByTagName("usages").item(0) : doc2.createElement("usages");
            Element usagesExampleElt = docElt.getElementsByTagName("usagesExamples").getLength() != 0 ? (Element)docElt.getElementsByTagName("usagesExamples").item(0) : doc2.createElement("usagesExamples");
            Element usagesNoExampleElt = docElt.getElementsByTagName("usagesNoExample").getLength() != 0 ? (Element)docElt.getElementsByTagName("usagesNoExample").item(0) : doc2.createElement("usagesNoExample");
            int numberOfUsages = 0;
            int numberOfUsagesWithExamplesOnly = 0;
            int numberOfUsagesWithoutExample = 0;
            Object[] objectArray = docAnnot.usages();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GamlAnnotations.usage usage2 = objectArray[n4];
                Element usageElt = doc2.createElement("usage");
                if ("".equals(usage2.value())) {
                    ++numberOfUsagesWithExamplesOnly;
                    examplesUsageElt = this.getExamplesElt(usage2.examples(), doc2, e, tc, parentElement);
                    usageElt.appendChild(examplesUsageElt);
                    usagesExampleElt.appendChild(usageElt);
                } else if (usage2.examples().length == 0) {
                    ++numberOfUsagesWithoutExample;
                    usageElt.setAttribute("descUsageElt", usage2.value());
                    usagesNoExampleElt.appendChild(usageElt);
                } else {
                    ++numberOfUsages;
                    usageElt.setAttribute("descUsageElt", usage2.value());
                    examplesUsageElt = this.getExamplesElt(usage2.examples(), doc2, e, tc, parentElement);
                    usageElt.appendChild(examplesUsageElt);
                    usagesElt.appendChild(usageElt);
                }
                ++n4;
            }
            if (docAnnot.examples().length != 0) {
                Element usageExElt = doc2.createElement("usage");
                Element examplesElt = this.getExamplesElt(docAnnot.examples(), doc2, e, tc, parentElement);
                numberOfUsagesWithExamplesOnly += docAnnot.examples().length;
                usageExElt.appendChild(examplesElt);
                usagesExampleElt.appendChild(usageExElt);
            }
            objectArray = docAnnot.special_cases();
            n3 = objectArray.length;
            int n5 = 0;
            while (n5 < n3) {
                GamlAnnotations.usage cases = objectArray[n5];
                if (!"".equals(cases)) {
                    Element caseElt = doc2.createElement("usage");
                    caseElt.setAttribute("descUsageElt", (String)cases);
                    usagesNoExampleElt.appendChild(caseElt);
                    ++numberOfUsagesWithoutExample;
                }
                ++n5;
            }
            if (numberOfUsagesWithExamplesOnly != 0) {
                docElt.appendChild(usagesExampleElt);
            }
            if (numberOfUsagesWithoutExample != 0) {
                docElt.appendChild(usagesNoExampleElt);
            }
            if (numberOfUsages != 0) {
                docElt.appendChild(usagesElt);
            }
        }
        return docElt;
    }

    public static void addIfNotExistSee(Document doc2, Element seeAlsoElt, String opName) {
        NodeList nLSee = seeAlsoElt.getElementsByTagName("see");
        int i = 0;
        boolean seeAlreadyInserted = false;
        while (i < nLSee.getLength() && !seeAlreadyInserted) {
            if (((Element)nLSee.item(i)).getAttribute("id").equals(opName)) {
                seeAlreadyInserted = true;
            }
            ++i;
        }
        if (!seeAlreadyInserted) {
            Element seesElt = doc2.createElement("see");
            seesElt.setAttribute("id", opName);
            seeAlsoElt.appendChild(seesElt);
        }
    }

    public Element getDocElt(GamlAnnotations.doc[] docAnnotTab, Document doc2, Messager mes, String eltName, TypeConverter tc, ExecutableElement e, Element parentElement) {
        if (docAnnotTab == null || docAnnotTab.length == 0) {
            return this.getDocElt(null, doc2, null, mes, eltName, tc, e, parentElement);
        }
        return this.getDocElt(docAnnotTab[0], doc2, null, mes, eltName, tc, e, parentElement);
    }

    public Element getExamplesElt(GamlAnnotations.example[] examples, Document doc2, ExecutableElement e, TypeConverter tc, Element parentElement) {
        Element examplesElt = doc2.createElement("examples");
        GamlAnnotations.example[] exampleArray = examples;
        int n = examples.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.example example2 = exampleArray[n2];
            examplesElt.appendChild(this.getExampleElt(example2, doc2, e, tc, parentElement));
            ++n2;
        }
        return examplesElt;
    }

    public Element getExampleElt(GamlAnnotations.example example2, Document doc2, ExecutableElement e, TypeConverter tc, Element parentElement) {
        Element exampleElt = doc2.createElement("example");
        exampleElt.setAttribute("code", example2.value());
        if (!"".equals(example2.var())) {
            exampleElt.setAttribute("var", example2.var());
        }
        if (!"".equals(example2.equals())) {
            exampleElt.setAttribute("equals", example2.equals());
        }
        if (!"".equals(example2.isNot())) {
            exampleElt.setAttribute("isNot", example2.isNot());
        }
        if (!"".equals(example2.raises())) {
            exampleElt.setAttribute("raises", example2.raises());
        }
        exampleElt.setAttribute("isTestOnly", "" + example2.isTestOnly());
        exampleElt.setAttribute("isExecutable", "" + example2.isExecutable());
        if (!example2.isExecutable()) {
            exampleElt.setAttribute("test", "false");
        } else {
            exampleElt.setAttribute("test", "" + example2.test());
        }
        if (parentElement != null && example2.isExecutable() && example2.test()) {
            parentElement.setAttribute("HAS_TESTS", "true");
        }
        if (!"".equals(example2.returnType())) {
            exampleElt.setAttribute("type", example2.returnType());
        } else if (e != null) {
            exampleElt.setAttribute("type", tc.getProperType(e.getReturnType().toString()));
        }
        return exampleElt;
    }

    public Element getConstantElt(GamlAnnotations.constant constant2, Document doc2, javax.lang.model.element.Element e, Messager mes, TypeConverter tc) {
        Element constantElt = doc2.createElement("constant");
        constantElt.setAttribute("name", "#" + constant2.value());
        Object valCst = ((VariableElement)e).getConstantValue();
        String valCstStr = valCst == null ? "No Default Value" : valCst.toString();
        constantElt.setAttribute("value", valCstStr);
        StringBuilder str = new StringBuilder();
        boolean first = true;
        String[] stringArray = constant2.altNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (first) {
                first = false;
            } else {
                str.append(",");
            }
            str.append("#");
            str.append(n3);
            ++n2;
        }
        String names = str.toString();
        if (!"".equals(names)) {
            constantElt.setAttribute("altNames", names);
        }
        constantElt.appendChild(this.getCategories(e, doc2, doc2.createElement("categories"), tc));
        Element docConstantElt = this.getDocElt(constant2.doc(), doc2, mes, e.getSimpleName().toString(), null, null, constantElt);
        if (docConstantElt != null) {
            constantElt.appendChild(docConstantElt);
        }
        return constantElt;
    }

    public Element getVarsElt(GamlAnnotations.vars varsAnnot, Document doc2, Messager mes, String skillName, TypeConverter tc) {
        if (varsAnnot == null) {
            return null;
        }
        Element varsElt = doc2.createElement("vars");
        GamlAnnotations.variable[] variableArray = varsAnnot.value();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.variable v = variableArray[n2];
            Element varElt = doc2.createElement("var");
            varElt.setAttribute("name", v.name());
            varElt.setAttribute("type", tc.getTypeString(Integer.valueOf(v.type())));
            varElt.setAttribute("constant", "" + v.constant());
            Element docEltVar = this.getDocElt(v.doc(), doc2, mes, "Var " + v.name() + " from " + skillName, tc, null, varElt);
            if (docEltVar != null) {
                varElt.appendChild(docEltVar);
            }
            StringBuilder strBuilder = new StringBuilder();
            int i = 0;
            while (i < v.depends_on().length) {
                String dependElement = v.depends_on()[i];
                strBuilder.append(dependElement);
                if (i < v.depends_on().length - 1) {
                    strBuilder.append(",");
                }
                ++i;
            }
            String dependsOn = strBuilder.toString();
            varElt.setAttribute("depends_on", dependsOn);
            varsElt.appendChild(varElt);
            ++n2;
        }
        return varsElt;
    }

    public Element getActionElt(GamlAnnotations.action actionAnnot, Document doc2, Messager mes, javax.lang.model.element.Element e, TypeConverter tc) {
        if (!(e instanceof ExecutableElement) || actionAnnot == null) {
            return null;
        }
        ExecutableElement eltMethod = (ExecutableElement)e;
        Element actionElt = doc2.createElement("action");
        actionElt.setAttribute("name", actionAnnot.name());
        actionElt.setAttribute("returnType", tc.getProperType(eltMethod.getReturnType().toString()));
        Element argsElt = doc2.createElement("args");
        GamlAnnotations.arg[] argArray = actionAnnot.args();
        int n = argArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.arg eltArg = argArray[n2];
            Element argElt = doc2.createElement("arg");
            argElt.setAttribute("name", eltArg.name());
            String tabType = tc.getTypeString(Integer.valueOf(eltArg.type()));
            argElt.setAttribute("type", tabType);
            argElt.setAttribute("optional", "" + eltArg.optional());
            Element docEltArg = this.getDocElt(eltArg.doc(), doc2, mes, "Arg " + eltArg.name() + " from " + String.valueOf(eltMethod.getSimpleName()), tc, null, argElt);
            if (docEltArg != null) {
                argElt.appendChild(docEltArg);
            }
            argsElt.appendChild(argElt);
            ++n2;
        }
        actionElt.appendChild(argsElt);
        Element docEltAction = this.getDocElt(actionAnnot.doc(), doc2, mes, eltMethod.getSimpleName().toString(), tc, null, actionElt);
        if (docEltAction != null) {
            actionElt.appendChild(docEltAction);
        }
        return actionElt;
    }

    public Element getFacetsElt(GamlAnnotations.facets facetsAnnot, Document doc2, Messager mes, String statName, TypeConverter tc) {
        if (facetsAnnot == null) {
            return null;
        }
        Element facetsElt = doc2.createElement("facets");
        GamlAnnotations.facet[] facetArray = facetsAnnot.value();
        int n = facetArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.facet f = facetArray[n2];
            if (f.doc() == null || f.doc().length <= 0 || "".equals(f.doc()[0].deprecated())) {
                Element facetElt = doc2.createElement("facet");
                facetElt.setAttribute("name", f.name());
                facetElt.setAttribute("type", tc.getTypeString(f.type()));
                facetElt.setAttribute("optional", "" + f.optional());
                if (f.values().length != 0) {
                    StringBuilder valuesTaken = new StringBuilder();
                    valuesTaken.append(", takes values in: {");
                    valuesTaken.append(f.values()[0]);
                    int i = 1;
                    while (i < f.values().length) {
                        valuesTaken.append(", ");
                        valuesTaken.append(f.values()[i]);
                        ++i;
                    }
                    valuesTaken.append("}");
                    facetElt.setAttribute("values", valuesTaken.toString());
                }
                facetElt.setAttribute("omissible", f.name().equals(facetsAnnot.omissible()) ? "true" : "false");
                Element docFacetElt = this.getDocElt(f.doc(), doc2, mes, "Facet " + f.name() + " from Statement" + statName, tc, null, facetElt);
                if (docFacetElt != null) {
                    facetElt.appendChild(docFacetElt);
                }
                facetsElt.appendChild(facetElt);
            }
            ++n2;
        }
        return facetsElt;
    }

    public Element getInsideElt(GamlAnnotations.inside insideAnnot, Document doc2, TypeConverter tc) {
        if (insideAnnot == null) {
            return null;
        }
        Element insideElt = doc2.createElement("inside");
        Element symbolsElt = doc2.createElement("symbols");
        String[] stringArray = insideAnnot.symbols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String sym = stringArray[n2];
            Element symElt = doc2.createElement("symbol");
            symElt.setTextContent(sym);
            symbolsElt.appendChild(symElt);
            ++n2;
        }
        insideElt.appendChild(symbolsElt);
        Element kindsElt = doc2.createElement("kinds");
        int[] nArray = insideAnnot.kinds();
        int n3 = nArray.length;
        n = 0;
        while (n < n3) {
            int kind = nArray[n];
            Element kindElt = doc2.createElement("kind");
            kindElt.setTextContent(tc.getSymbolKindStringFromISymbolKind(Integer.valueOf(kind)));
            kindsElt.appendChild(kindElt);
            ++n;
        }
        insideElt.appendChild(kindsElt);
        return insideElt;
    }

    public Element getOperatorElement(Element operators, String eltName) {
        NodeList nL = operators.getElementsByTagName("operator");
        int i = 0;
        while (i < nL.getLength()) {
            Element elt = (Element)nL.item(i);
            if (eltName.equals(elt.getAttribute("id"))) {
                return elt;
            }
            ++i;
        }
        return null;
    }

    public Element getCategories(javax.lang.model.element.Element e, Document doc2, Element categoriesElt, TypeConverter tc) {
        ArrayList<String> categories = new ArrayList<String>();
        String[] categoriesTab = null;
        NodeList nL = categoriesElt.getElementsByTagName("category");
        int i = 0;
        while (i < nL.getLength()) {
            categories.add(((Element)nL.item(i)).getAttribute("id"));
            ++i;
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null) {
            categoriesTab = e.getAnnotation(GamlAnnotations.operator.class).category();
        } else if (e.getAnnotation(GamlAnnotations.constant.class) != null) {
            categoriesTab = e.getAnnotation(GamlAnnotations.constant.class).category();
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).category().length > 0 || e.getAnnotation(GamlAnnotations.constant.class) != null && e.getAnnotation(GamlAnnotations.constant.class).category().length > 0) {
            if (categoriesTab != null) {
                String[] stringArray = categoriesTab;
                int n = categoriesTab.length;
                int n2 = 0;
                while (n2 < n) {
                    String categoryName = stringArray[n2];
                    if (!categories.contains(categoryName)) {
                        categories.add(categoryName);
                        Element catElt = doc2.createElement("category");
                        catElt.setAttribute("id", categoryName);
                        categoriesElt.appendChild(catElt);
                    }
                    ++n2;
                }
            }
        } else if (!categories.contains(tc.getProperCategory(e.getEnclosingElement().getSimpleName().toString()))) {
            Element catElt = doc2.createElement("category");
            catElt.setAttribute("id", tc.getProperCategory(e.getEnclosingElement().getSimpleName().toString()));
            categoriesElt.appendChild(catElt);
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).iterator()) {
            Element catElt = doc2.createElement("category");
            catElt.setAttribute("id", "Iterator operators");
            categoriesElt.appendChild(catElt);
        }
        return categoriesElt;
    }

    public Element getCategories(javax.lang.model.element.Element e, Document doc2, TypeConverter tc) {
        Element categoriesElt = doc2.createElement("operatorsCategories");
        return this.getCategories(e, doc2, categoriesElt, tc);
    }

    public Element getConcepts(javax.lang.model.element.Element e, Document doc2, Element conceptElt, TypeConverter tc) {
        ArrayList<String> concepts = new ArrayList<String>();
        String[] conceptsTab = null;
        NodeList nL = conceptElt.getElementsByTagName("concept");
        int i = 0;
        while (i < nL.getLength()) {
            concepts.add(((Element)nL.item(i)).getAttribute("id"));
            ++i;
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.operator.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.constant.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.constant.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.type.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.type.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.species.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.species.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.symbol.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.symbol.class).concept();
        } else if (e.getAnnotation(GamlAnnotations.skill.class) != null) {
            conceptsTab = e.getAnnotation(GamlAnnotations.skill.class).concept();
        }
        if ((e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.constant.class) != null && e.getAnnotation(GamlAnnotations.constant.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.type.class) != null && e.getAnnotation(GamlAnnotations.type.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.skill.class) != null && e.getAnnotation(GamlAnnotations.skill.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.species.class) != null && e.getAnnotation(GamlAnnotations.species.class).concept().length > 0 || e.getAnnotation(GamlAnnotations.symbol.class) != null && e.getAnnotation(GamlAnnotations.symbol.class).concept().length > 0) && conceptsTab != null) {
            String[] stringArray = conceptsTab;
            int n = conceptsTab.length;
            int n2 = 0;
            while (n2 < n) {
                String conceptName = stringArray[n2];
                if (!concepts.contains(conceptName)) {
                    concepts.add(conceptName);
                    Element catElt = doc2.createElement("concept");
                    catElt.setAttribute("id", conceptName);
                    conceptElt.appendChild(catElt);
                }
                ++n2;
            }
        }
        if (e.getAnnotation(GamlAnnotations.operator.class) != null && e.getAnnotation(GamlAnnotations.operator.class).iterator()) {
            Element catElt = doc2.createElement("concept");
            catElt.setAttribute("id", "Iterator operators");
            conceptElt.appendChild(catElt);
        }
        return conceptElt;
    }
}

